/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.IPAcl;

import com.sun.jmx.snmp.IPAcl.AclEntryImpl;
import com.sun.jmx.snmp.IPAcl.AclImpl;
import com.sun.jmx.snmp.IPAcl.ParseException;
import com.sun.jmx.snmp.IPAcl.Parser;
import com.sun.jmx.snmp.IPAcl.PermissionImpl;
import com.sun.jmx.snmp.IPAcl.PrincipalImpl;
import com.sun.jmx.snmp.IPAcl.SimpleNode;
import com.sun.jmx.snmp.InetAddressAcl;
import com.sun.jmx.trace.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class SnmpAcl
implements InetAddressAcl,
Serializable {
    static final PermissionImpl READ = new PermissionImpl("READ");
    static final PermissionImpl WRITE = new PermissionImpl("WRITE");
    String dbgTag;
    private AclImpl acl;
    private boolean alwaysAuthorized;
    private String authorizedListFile;
    private Hashtable trapDestList;
    private Hashtable informDestList;
    private PrincipalImpl owner;

    public SnmpAcl(String string) throws UnknownHostException, IllegalArgumentException {
        this(string, null);
    }

    public SnmpAcl(String string, String string2) throws UnknownHostException, IllegalArgumentException {
        block4: {
            this.dbgTag = "SnmpAcl";
            this.acl = null;
            this.alwaysAuthorized = false;
            this.authorizedListFile = null;
            this.trapDestList = null;
            this.informDestList = null;
            this.owner = null;
            this.trapDestList = new Hashtable();
            this.informDestList = new Hashtable();
            this.owner = new PrincipalImpl();
            try {
                this.acl = new AclImpl(this.owner, string);
                AclEntryImpl aclEntryImpl = new AclEntryImpl(this.owner);
                aclEntryImpl.addPermission(READ);
                aclEntryImpl.addPermission(WRITE);
                this.acl.addEntry(this.owner, aclEntryImpl);
            }
            catch (NotOwnerException notOwnerException) {
                if (!this.isDebugOn()) break block4;
                this.debug("constructor", "Should never get NotOwnerException as the owner is built in this constructor");
            }
        }
        if (string2 == null) {
            this.setDefaultFileName();
        } else {
            this.setAuthorizedListFile(string2);
        }
        this.readAuthorizedListFile();
    }

    public Enumeration entries() {
        return this.acl.entries();
    }

    public Enumeration communities() {
        HashSet<String> hashSet = new HashSet<String>();
        Vector<Object> vector = new Vector<Object>();
        Object[] objectArray = this.acl.entries();
        while (objectArray.hasMoreElements()) {
            AclEntryImpl aclEntryImpl = (AclEntryImpl)objectArray.nextElement();
            Enumeration enumeration = aclEntryImpl.communities();
            while (enumeration.hasMoreElements()) {
                hashSet.add((String)enumeration.nextElement());
            }
        }
        objectArray = hashSet.toArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            vector.addElement(objectArray[i2]);
        }
        return vector.elements();
    }

    public String getName() {
        return this.acl.getName();
    }

    public static PermissionImpl getREAD() {
        return READ;
    }

    public static PermissionImpl getWRITE() {
        return WRITE;
    }

    public static String getDefaultAclFileName() {
        String string = System.getProperty("file.separator");
        StringBuffer stringBuffer = new StringBuffer(System.getProperty("java.home")).append(string).append("lib").append(string).append("snmp.acl");
        return stringBuffer.toString();
    }

    public void setAuthorizedListFile(String string) throws IllegalArgumentException {
        File file = new File(string);
        if (!file.isFile()) {
            if (this.isDebugOn()) {
                this.debug("setAuthorizedListFile", "ACL file not found: " + string);
            }
            throw new IllegalArgumentException("The specified file [" + file + "] " + "doesn't exist or is not a file, " + "no configuration loaded");
        }
        if (this.isTraceOn()) {
            this.trace("setAuthorizedListFile", "Default file set to " + string);
        }
        this.authorizedListFile = string;
    }

    public void rereadTheFile() throws NotOwnerException, UnknownHostException {
        this.alwaysAuthorized = false;
        this.acl.removeAll(this.owner);
        this.trapDestList.clear();
        this.informDestList.clear();
        AclEntryImpl aclEntryImpl = new AclEntryImpl(this.owner);
        aclEntryImpl.addPermission(READ);
        aclEntryImpl.addPermission(WRITE);
        this.acl.addEntry(this.owner, aclEntryImpl);
        this.readAuthorizedListFile();
    }

    public String getAuthorizedListFile() {
        return this.authorizedListFile;
    }

    public boolean checkReadPermission(InetAddress inetAddress) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(inetAddress);
        return this.acl.checkPermission(principalImpl, READ);
    }

    public boolean checkReadPermission(InetAddress inetAddress, String string) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(inetAddress);
        return this.acl.checkPermission(principalImpl, string, READ);
    }

    public boolean checkCommunity(String string) {
        return this.acl.checkCommunity(string);
    }

    public boolean checkWritePermission(InetAddress inetAddress) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(inetAddress);
        return this.acl.checkPermission(principalImpl, WRITE);
    }

    public boolean checkWritePermission(InetAddress inetAddress, String string) {
        if (this.alwaysAuthorized) {
            return true;
        }
        PrincipalImpl principalImpl = new PrincipalImpl(inetAddress);
        return this.acl.checkPermission(principalImpl, string, WRITE);
    }

    public Enumeration getTrapDestinations() {
        return this.trapDestList.keys();
    }

    public Enumeration getTrapCommunities(InetAddress inetAddress) {
        Vector vector = null;
        vector = (Vector)this.trapDestList.get(inetAddress);
        if (vector != null) {
            if (this.isTraceOn()) {
                this.trace("getTrapCommunities", "[" + inetAddress.toString() + "] is in list");
            }
            return vector.elements();
        }
        vector = new Vector();
        if (this.isTraceOn()) {
            this.trace("getTrapCommunities", "[" + inetAddress.toString() + "] is not in list");
        }
        return vector.elements();
    }

    public Enumeration getInformDestinations() {
        return this.informDestList.keys();
    }

    public Enumeration getInformCommunities(InetAddress inetAddress) {
        Vector vector = null;
        vector = (Vector)this.informDestList.get(inetAddress);
        if (vector != null) {
            if (this.isTraceOn()) {
                this.trace("getInformCommunities", "[" + inetAddress.toString() + "] is in list");
            }
            return vector.elements();
        }
        vector = new Vector();
        if (this.isTraceOn()) {
            this.trace("getInformCommunities", "[" + inetAddress.toString() + "] is not in list");
        }
        return vector.elements();
    }

    private void readAuthorizedListFile() {
        this.alwaysAuthorized = false;
        if (this.authorizedListFile == null) {
            if (this.isTraceOn()) {
                this.trace("readAuthorizedListFile", "alwaysAuthorized set to true");
            }
            this.alwaysAuthorized = true;
        } else {
            Object object;
            Parser parser2 = null;
            try {
                parser2 = new Parser(new FileInputStream(this.getAuthorizedListFile()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.isDebugOn()) {
                    this.debug("readAuthorizedListFile", "The specified file was not found, authorize everybody");
                }
                this.alwaysAuthorized = true;
                return;
            }
            try {
                object = parser2.SecurityDefs();
                ((SimpleNode)object).buildAclEntries(this.owner, this.acl);
                ((SimpleNode)object).buildTrapEntries(this.trapDestList);
                ((SimpleNode)object).buildInformEntries(this.informDestList);
            }
            catch (ParseException parseException) {
                if (this.isDebugOn()) {
                    this.debug("readAuthorizedListFile", "Parsing exception " + parseException);
                }
                throw new IllegalArgumentException(parseException.getMessage());
            }
            catch (Error error) {
                if (this.isDebugOn()) {
                    this.debug("readAuthorizedListFile", "Error exception");
                }
                throw new IllegalArgumentException(error.getMessage());
            }
            object = this.acl.entries();
            while (object.hasMoreElements()) {
                AclEntryImpl aclEntryImpl = (AclEntryImpl)object.nextElement();
                if (this.isTraceOn()) {
                    this.trace("readAuthorizedListFile", "===> " + ((Object)aclEntryImpl.getPrincipal()).toString());
                }
                Enumeration enumeration = aclEntryImpl.permissions();
                while (enumeration.hasMoreElements()) {
                    Permission permission = (Permission)enumeration.nextElement();
                    if (!this.isTraceOn()) continue;
                    this.trace("readAuthorizedListFile", "perm = " + permission);
                }
            }
        }
    }

    private void setDefaultFileName() {
        try {
            this.setAuthorizedListFile(SnmpAcl.getDefaultAclFileName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 512);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 512, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 512);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 512, string, string2, string3);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }
}

