/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.HtmlDocletWriter;
import com.sun.tools.doclets.formats.html.LinkInfoImpl;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class PackageFrameWriter
extends HtmlDocletWriter {
    private PackageDoc packageDoc;
    private Set documentedClasses;
    public static final String OUTPUT_FILE_NAME = "package-frame.html";

    public PackageFrameWriter(ConfigurationImpl configurationImpl, PackageDoc packageDoc) throws IOException {
        super(configurationImpl, DirectoryManager.getDirectoryPath(packageDoc), OUTPUT_FILE_NAME, DirectoryManager.getRelativePath(packageDoc));
        this.packageDoc = packageDoc;
        if (configurationImpl.root.specifiedPackages().length == 0) {
            this.documentedClasses = new HashSet<ClassDoc>(Arrays.asList(configurationImpl.root.classes()));
        }
    }

    public static void generate(ConfigurationImpl configurationImpl, PackageDoc packageDoc) {
        try {
            PackageFrameWriter packageFrameWriter = new PackageFrameWriter(configurationImpl, packageDoc);
            String string = Util.getPackageName(packageDoc);
            String[] stringArray = new String[]{string + " " + "package"};
            packageFrameWriter.printHtmlHeader(string, stringArray, false);
            packageFrameWriter.printPackageHeader(string);
            packageFrameWriter.generateClassListing();
            packageFrameWriter.printBodyHtmlEnd();
            packageFrameWriter.close();
        }
        catch (IOException iOException) {
            configurationImpl.standardmessage.error("doclet.exception_encountered", iOException.toString(), OUTPUT_FILE_NAME);
            throw new DocletAbortException();
        }
    }

    protected void generateClassListing() {
        Configuration configuration = this.configuration();
        if (this.packageDoc.isIncluded()) {
            this.generateClassKindListing(this.packageDoc.interfaces(), this.configuration.getText("doclet.Interfaces"));
            this.generateClassKindListing(this.packageDoc.ordinaryClasses(), this.configuration.getText("doclet.Classes"));
            this.generateClassKindListing(this.packageDoc.enums(), this.configuration.getText("doclet.Enums"));
            this.generateClassKindListing(this.packageDoc.exceptions(), this.configuration.getText("doclet.Exceptions"));
            this.generateClassKindListing(this.packageDoc.errors(), this.configuration.getText("doclet.Errors"));
            this.generateClassKindListing(this.packageDoc.annotationTypes(), this.configuration.getText("doclet.AnnotationTypes"));
        } else {
            String string = Util.getPackageName(this.packageDoc);
            this.generateClassKindListing(configuration.classDocCatalog.interfaces(string), this.configuration.getText("doclet.Interfaces"));
            this.generateClassKindListing(configuration.classDocCatalog.ordinaryClasses(string), this.configuration.getText("doclet.Classes"));
            this.generateClassKindListing(configuration.classDocCatalog.enums(string), this.configuration.getText("doclet.Enums"));
            this.generateClassKindListing(configuration.classDocCatalog.exceptions(string), this.configuration.getText("doclet.Exceptions"));
            this.generateClassKindListing(configuration.classDocCatalog.errors(string), this.configuration.getText("doclet.Errors"));
            this.generateClassKindListing(configuration.classDocCatalog.annotationTypes(string), this.configuration.getText("doclet.AnnotationTypes"));
        }
    }

    protected void generateClassKindListing(ClassDoc[] classDocArray, String string) {
        if (classDocArray.length > 0) {
            Arrays.sort(classDocArray);
            this.printPackageTableHeader();
            this.fontSizeStyle("+1", "FrameHeadingFont");
            boolean bl = false;
            for (int i = 0; i < classDocArray.length; ++i) {
                if (this.documentedClasses != null && !this.documentedClasses.contains(classDocArray[i]) || !Util.isCoreClass(classDocArray[i]) || !this.configuration.isGeneratedDoc(classDocArray[i])) continue;
                if (!bl) {
                    this.print(string);
                    this.fontEnd();
                    this.println("&nbsp;");
                    this.fontStyle("FrameItemFont");
                    bl = true;
                }
                this.br();
                this.printLink(new LinkInfoImpl(13, classDocArray[i], classDocArray[i].isInterface() ? this.italicsText(classDocArray[i].name()) : classDocArray[i].name(), "classFrame"));
            }
            this.fontEnd();
            this.printPackageTableFooter();
            this.println();
        }
    }

    protected void printPackageHeader(String string) {
        this.fontSizeStyle("+1", "FrameTitleFont");
        this.printTargetPackageLink(this.packageDoc, "classFrame", string);
        this.fontEnd();
    }

    protected void printPackageTableHeader() {
        this.table();
        this.tr();
        this.tdNowrap();
    }

    protected void printPackageTableFooter() {
        this.tdEnd();
        this.trEnd();
        this.tableEnd();
    }
}

