/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.Transport;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.connect.spi.TransportService;
import com.sun.tools.jdi.AbstractLauncher;
import com.sun.tools.jdi.SocketTransportService;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RawCommandLineLauncher
extends AbstractLauncher
implements LaunchingConnector {
    private static final String ARG_COMMAND = "command";
    private static final String ARG_ADDRESS = "address";
    private static final String ARG_QUOTE = "quote";
    TransportService transportService;
    Transport transport;

    public TransportService transportService() {
        return this.transportService;
    }

    @Override
    public Transport transport() {
        return this.transport;
    }

    public RawCommandLineLauncher() {
        try {
            Class<?> clazz = Class.forName("com.sun.tools.jdi.SharedMemoryTransportService");
            this.transportService = (TransportService)clazz.newInstance();
            this.transport = new Transport(){

                public String name() {
                    return "dt_shmem";
                }
            };
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (this.transportService == null) {
            this.transportService = new SocketTransportService();
            this.transport = new Transport(){

                public String name() {
                    return "dt_socket";
                }
            };
        }
        this.addStringArgument(ARG_COMMAND, this.getString("raw.command.label"), this.getString("raw.command"), "", true);
        this.addStringArgument(ARG_QUOTE, this.getString("raw.quote.label"), this.getString("raw.quote"), "\"", true);
        this.addStringArgument(ARG_ADDRESS, this.getString("raw.address.label"), this.getString("raw.address"), "", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachine launch(Map<String, ? extends Connector.Argument> map) throws IOException, IllegalConnectorArgumentsException, VMStartException {
        String string = this.argument(ARG_COMMAND, map).value();
        String string2 = this.argument(ARG_ADDRESS, map).value();
        String string3 = this.argument(ARG_QUOTE, map).value();
        if (string3.length() > 1) {
            throw new IllegalConnectorArgumentsException("Invalid length", ARG_QUOTE);
        }
        TransportService.ListenKey listenKey = this.transportService.startListening(string2);
        try {
            VirtualMachine virtualMachine = this.launch(this.tokenizeCommand(string, string3.charAt(0)), string2, listenKey, this.transportService);
            return virtualMachine;
        }
        finally {
            this.transportService.stopListening(listenKey);
        }
    }

    @Override
    public String name() {
        return "com.sun.jdi.RawCommandLineLaunch";
    }

    @Override
    public String description() {
        return this.getString("raw.description");
    }
}

