/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;

public class CertificateVersion
implements CertAttrSet {
    public static final int V1 = 0;
    public static final int V2 = 1;
    public static final int V3 = 2;
    public static final String IDENT = "x509.info.version";
    public static final String NAME = "version";
    public static final String VERSION = "number";
    int version = 0;

    private int getVersion() {
        return this.version;
    }

    private void construct(DerValue derValue) throws IOException {
        if (derValue.isConstructed() && derValue.isContextSpecific()) {
            derValue = derValue.data.getDerValue();
            this.version = derValue.getInteger();
            if (derValue.data.available() != 0) {
                throw new IOException("X.509 version, bad format");
            }
        }
    }

    public CertificateVersion() {
        this.version = 0;
    }

    public CertificateVersion(int n2) throws IOException {
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            throw new IOException("X.509 Certificate version " + n2 + " not supported.\n");
        }
        this.version = n2;
    }

    public CertificateVersion(DerInputStream derInputStream) throws IOException {
        this.version = 0;
        DerValue derValue = derInputStream.getDerValue();
        this.construct(derValue);
    }

    public CertificateVersion(InputStream inputStream) throws IOException {
        this.version = 0;
        DerValue derValue = new DerValue(inputStream);
        this.construct(derValue);
    }

    public CertificateVersion(DerValue derValue) throws IOException {
        this.version = 0;
        this.construct(derValue);
    }

    public String toString() {
        return "Version: V" + (this.version + 1);
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (this.version == 0) {
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putInteger(this.version);
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.write(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public void set(String string, Object object) throws IOException {
        if (!(object instanceof Integer)) {
            throw new IOException("Attribute must be of type Integer.");
        }
        if (!string.equalsIgnoreCase(VERSION)) {
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateVersion.");
        }
        this.version = (Integer)object;
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(VERSION)) {
            return new Integer(this.getVersion());
        }
        throw new IOException("Attribute name not recognized by CertAttrSet: CertificateVersion.");
    }

    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(VERSION)) {
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateVersion.");
        }
        this.version = 0;
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(VERSION);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }

    public int compare(int n2) {
        return this.version - n2;
    }
}

