/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import sun.misc.BASE64Decoder;
import sun.security.pkcs.PKCS7;
import sun.security.provider.certpath.X509CertPath;
import sun.security.provider.certpath.X509CertificatePair;
import sun.security.util.Cache;
import sun.security.util.DerValue;
import sun.security.x509.X509CRLImpl;
import sun.security.x509.X509CertImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509Factory
extends CertificateFactorySpi {
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT = "-----END CERTIFICATE-----";
    private static final int defaultExpectedLineLength = 80;
    private static final char[] endBoundary = "-----END".toCharArray();
    private static final int ENC_MAX_LENGTH = 0x400000;
    private static final Cache certCache = Cache.newSoftMemoryCache(750);
    private static final Cache crlCache = Cache.newSoftMemoryCache(750);

    @Override
    public Certificate engineGenerateCertificate(InputStream inputStream) throws CertificateException {
        if (inputStream == null) {
            certCache.clear();
            X509CertificatePair.clearCache();
            throw new CertificateException("Missing input stream");
        }
        try {
            X509CertImpl x509CertImpl;
            byte[] byArray;
            if (!inputStream.markSupported()) {
                byArray = this.getTotalBytes(new BufferedInputStream(inputStream));
                inputStream = new ByteArrayInputStream(byArray);
            }
            if ((byArray = X509Factory.readSequence(inputStream)) != null) {
                X509CertImpl x509CertImpl2 = (X509CertImpl)X509Factory.getFromCache(certCache, byArray);
                if (x509CertImpl2 != null) {
                    return x509CertImpl2;
                }
                x509CertImpl2 = new X509CertImpl(byArray);
                X509Factory.addToCache(certCache, x509CertImpl2.getEncodedInternal(), x509CertImpl2);
                return x509CertImpl2;
            }
            if (this.isBase64(inputStream)) {
                byte[] byArray2 = this.base64_to_binary(inputStream);
                x509CertImpl = new X509CertImpl(byArray2);
            } else {
                x509CertImpl = new X509CertImpl(new DerValue(inputStream));
            }
            return X509Factory.intern(x509CertImpl);
        }
        catch (IOException iOException) {
            throw (CertificateException)new CertificateException("Could not parse certificate: " + iOException.toString()).initCause(iOException);
        }
    }

    private static byte[] readSequence(InputStream inputStream) throws IOException {
        int n2;
        int n3;
        inputStream.mark(0x400000);
        byte[] byArray = new byte[4];
        int n4 = X509Factory.readFully(inputStream, byArray, 0, byArray.length);
        if (n4 != byArray.length || byArray[0] != 48) {
            inputStream.reset();
            return null;
        }
        n4 = byArray[1] & 0xFF;
        if (n4 < 128) {
            n3 = n4;
            n2 = n3 + 2;
        } else if (n4 == 129) {
            n3 = byArray[2] & 0xFF;
            n2 = n3 + 3;
        } else if (n4 == 130) {
            n3 = (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
            n2 = n3 + 4;
        } else {
            inputStream.reset();
            return null;
        }
        if (n2 > 0x400000) {
            inputStream.reset();
            return null;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        int n5 = n2 - byArray.length;
        n4 = X509Factory.readFully(inputStream, byArray2, byArray.length, n5);
        if (n4 != n5) {
            inputStream.reset();
            return null;
        }
        return byArray2;
    }

    private static int readFully(InputStream inputStream, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5 = 0;
        while (n3 > 0 && (n4 = inputStream.read(byArray, n2, n3)) > 0) {
            n5 += n4;
            n3 -= n4;
            n2 += n4;
        }
        return n5;
    }

    public static synchronized X509CertImpl intern(X509Certificate x509Certificate) throws CertificateException {
        if (x509Certificate == null) {
            return null;
        }
        boolean bl2 = x509Certificate instanceof X509CertImpl;
        byte[] byArray = bl2 ? ((X509CertImpl)x509Certificate).getEncodedInternal() : x509Certificate.getEncoded();
        X509CertImpl x509CertImpl = (X509CertImpl)X509Factory.getFromCache(certCache, byArray);
        if (x509CertImpl != null) {
            return x509CertImpl;
        }
        if (bl2) {
            x509CertImpl = (X509CertImpl)x509Certificate;
        } else {
            x509CertImpl = new X509CertImpl(byArray);
            byArray = x509CertImpl.getEncodedInternal();
        }
        X509Factory.addToCache(certCache, byArray, x509CertImpl);
        return x509CertImpl;
    }

    public static synchronized X509CRLImpl intern(X509CRL x509CRL) throws CRLException {
        if (x509CRL == null) {
            return null;
        }
        boolean bl2 = x509CRL instanceof X509CRLImpl;
        byte[] byArray = bl2 ? ((X509CRLImpl)x509CRL).getEncodedInternal() : x509CRL.getEncoded();
        X509CRLImpl x509CRLImpl = (X509CRLImpl)X509Factory.getFromCache(crlCache, byArray);
        if (x509CRLImpl != null) {
            return x509CRLImpl;
        }
        if (bl2) {
            x509CRLImpl = (X509CRLImpl)x509CRL;
        } else {
            x509CRLImpl = new X509CRLImpl(byArray);
            byArray = x509CRLImpl.getEncodedInternal();
        }
        X509Factory.addToCache(crlCache, byArray, x509CRLImpl);
        return x509CRLImpl;
    }

    private static synchronized Object getFromCache(Cache cache, byte[] byArray) {
        Cache.EqualByteArray equalByteArray = new Cache.EqualByteArray(byArray);
        Object object = cache.get(equalByteArray);
        return object;
    }

    private static synchronized void addToCache(Cache cache, byte[] byArray, Object object) {
        if (byArray.length > 0x400000) {
            return;
        }
        Cache.EqualByteArray equalByteArray = new Cache.EqualByteArray(byArray);
        cache.put(equalByteArray, object);
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inputStream) throws CertificateException {
        if (inputStream == null) {
            throw new CertificateException("Missing input stream");
        }
        try {
            byte[] byArray;
            if (!inputStream.markSupported()) {
                byArray = this.getTotalBytes(new BufferedInputStream(inputStream));
                inputStream = new ByteArrayInputStream(byArray);
            }
            if (this.isBase64(inputStream)) {
                byArray = this.base64_to_binary(inputStream);
                return new X509CertPath(new ByteArrayInputStream(byArray));
            }
            return new X509CertPath(inputStream);
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException.getMessage());
        }
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inputStream, String string) throws CertificateException {
        if (inputStream == null) {
            throw new CertificateException("Missing input stream");
        }
        try {
            byte[] byArray;
            if (!inputStream.markSupported()) {
                byArray = this.getTotalBytes(new BufferedInputStream(inputStream));
                inputStream = new ByteArrayInputStream(byArray);
            }
            if (this.isBase64(inputStream)) {
                byArray = this.base64_to_binary(inputStream);
                return new X509CertPath(new ByteArrayInputStream(byArray), string);
            }
            return new X509CertPath(inputStream, string);
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException.getMessage());
        }
    }

    @Override
    public CertPath engineGenerateCertPath(List<? extends Certificate> list) throws CertificateException {
        return new X509CertPath(list);
    }

    @Override
    public Iterator<String> engineGetCertPathEncodings() {
        return X509CertPath.getEncodingsStatic();
    }

    @Override
    public Collection<? extends Certificate> engineGenerateCertificates(InputStream inputStream) throws CertificateException {
        if (inputStream == null) {
            throw new CertificateException("Missing input stream");
        }
        try {
            if (!inputStream.markSupported()) {
                inputStream = new ByteArrayInputStream(this.getTotalBytes(new BufferedInputStream(inputStream)));
            }
            return this.parseX509orPKCS7Cert(inputStream);
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException);
        }
    }

    @Override
    public CRL engineGenerateCRL(InputStream inputStream) throws CRLException {
        if (inputStream == null) {
            crlCache.clear();
            throw new CRLException("Missing input stream");
        }
        try {
            X509CRLImpl x509CRLImpl;
            byte[] byArray;
            if (!inputStream.markSupported()) {
                byArray = this.getTotalBytes(new BufferedInputStream(inputStream));
                inputStream = new ByteArrayInputStream(byArray);
            }
            if ((byArray = X509Factory.readSequence(inputStream)) != null) {
                X509CRLImpl x509CRLImpl2 = (X509CRLImpl)X509Factory.getFromCache(crlCache, byArray);
                if (x509CRLImpl2 != null) {
                    return x509CRLImpl2;
                }
                x509CRLImpl2 = new X509CRLImpl(byArray);
                X509Factory.addToCache(crlCache, x509CRLImpl2.getEncodedInternal(), x509CRLImpl2);
                return x509CRLImpl2;
            }
            if (this.isBase64(inputStream)) {
                byte[] byArray2 = this.base64_to_binary(inputStream);
                x509CRLImpl = new X509CRLImpl(byArray2);
            } else {
                x509CRLImpl = new X509CRLImpl(new DerValue(inputStream));
            }
            return X509Factory.intern(x509CRLImpl);
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.getMessage());
        }
    }

    @Override
    public Collection<? extends CRL> engineGenerateCRLs(InputStream inputStream) throws CRLException {
        if (inputStream == null) {
            throw new CRLException("Missing input stream");
        }
        try {
            if (!inputStream.markSupported()) {
                inputStream = new ByteArrayInputStream(this.getTotalBytes(new BufferedInputStream(inputStream)));
            }
            return this.parseX509orPKCS7CRL(inputStream);
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.getMessage());
        }
    }

    private Collection parseX509orPKCS7Cert(InputStream inputStream) throws CertificateException, IOException {
        ArrayList<X509CertImpl> arrayList = new ArrayList<X509CertImpl>();
        boolean bl2 = true;
        while (inputStream.available() != 0) {
            InputStream inputStream2 = inputStream;
            if (this.isBase64(inputStream2)) {
                inputStream2 = new ByteArrayInputStream(this.base64_to_binary(inputStream2));
            }
            if (bl2) {
                inputStream2.mark(inputStream2.available());
            }
            try {
                arrayList.add(X509Factory.intern(new X509CertImpl(new DerValue(inputStream2))));
            }
            catch (CertificateException certificateException) {
                Throwable throwable = certificateException.getCause();
                if (bl2 && throwable != null && throwable instanceof IOException) {
                    inputStream2.reset();
                    PKCS7 pKCS7 = new PKCS7(inputStream2);
                    X509Certificate[] x509CertificateArray = pKCS7.getCertificates();
                    if (x509CertificateArray != null) {
                        return Arrays.asList(x509CertificateArray);
                    }
                    return new ArrayList(0);
                }
                throw certificateException;
            }
            bl2 = false;
        }
        return arrayList;
    }

    private Collection parseX509orPKCS7CRL(InputStream inputStream) throws CRLException, IOException {
        ArrayList<X509CRLImpl> arrayList = new ArrayList<X509CRLImpl>();
        boolean bl2 = true;
        while (inputStream.available() != 0) {
            block6: {
                InputStream inputStream2 = inputStream;
                if (this.isBase64(inputStream)) {
                    inputStream2 = new ByteArrayInputStream(this.base64_to_binary(inputStream2));
                }
                if (bl2) {
                    inputStream2.mark(inputStream2.available());
                }
                try {
                    arrayList.add(new X509CRLImpl(inputStream2));
                }
                catch (CRLException cRLException) {
                    if (!bl2) break block6;
                    inputStream2.reset();
                    PKCS7 pKCS7 = new PKCS7(inputStream2);
                    X509CRL[] x509CRLArray = pKCS7.getCRLs();
                    if (x509CRLArray != null) {
                        return Arrays.asList(x509CRLArray);
                    }
                    return new ArrayList(0);
                }
            }
            bl2 = false;
        }
        return arrayList;
    }

    private byte[] base64_to_binary(InputStream inputStream) throws IOException {
        long l2 = 0L;
        inputStream.mark(inputStream.available());
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)bufferedInputStream, "ASCII"));
        String string = this.readLine(bufferedReader);
        if (string == null || !string.startsWith("-----BEGIN")) {
            throw new IOException("Unsupported encoding");
        }
        l2 += (long)string.length();
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = this.readLine(bufferedReader)) != null && !string.startsWith("-----END")) {
            stringBuffer.append(string);
        }
        if (string == null) {
            throw new IOException("Unsupported encoding");
        }
        l2 += (long)string.length();
        inputStream.reset();
        inputStream.skip(l2 += (long)stringBuffer.length());
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        return bASE64Decoder.decodeBuffer(stringBuffer.toString());
    }

    private byte[] getTotalBytes(InputStream inputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[8192];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
        byteArrayOutputStream.reset();
        while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private boolean isBase64(InputStream inputStream) throws IOException {
        if (inputStream.available() >= 10) {
            inputStream.mark(10);
            int n2 = inputStream.read();
            int n3 = inputStream.read();
            int n4 = inputStream.read();
            int n5 = inputStream.read();
            int n6 = inputStream.read();
            int n7 = inputStream.read();
            int n8 = inputStream.read();
            int n9 = inputStream.read();
            int n10 = inputStream.read();
            int n11 = inputStream.read();
            inputStream.reset();
            return n2 == 45 && n3 == 45 && n4 == 45 && n5 == 45 && n6 == 45 && n7 == 66 && n8 == 69 && n9 == 71 && n10 == 73 && n11 == 78;
        }
        return false;
    }

    private String readLine(BufferedReader bufferedReader) throws IOException {
        int n2;
        int n3 = 0;
        boolean bl2 = true;
        boolean bl3 = false;
        StringBuffer stringBuffer = new StringBuffer(80);
        do {
            n2 = bufferedReader.read();
            if (bl2 && n3 < endBoundary.length) {
                boolean bl4 = bl2 = (char)n2 == endBoundary[n3++];
            }
            if (!bl3) {
                bl3 = bl2 && n3 == endBoundary.length;
            }
            stringBuffer.append((char)n2);
        } while (n2 != -1 && n2 != 10 && n2 != 13);
        if (!bl3 && n2 == -1) {
            return null;
        }
        if (n2 == 13) {
            bufferedReader.mark(1);
            int n4 = bufferedReader.read();
            if (n4 == 10) {
                stringBuffer.append((char)n2);
            } else {
                bufferedReader.reset();
            }
        }
        return stringBuffer.toString();
    }
}

