/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSExceptionImpl;
import sun.security.jgss.GSSManagerImpl;
import sun.security.jgss.ProviderList;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.ObjectIdentifier;

class GSSNameImpl
implements GSSName {
    private GSSManagerImpl gssManager = null;
    private String appNameStr = null;
    private byte[] appNameBytes = null;
    private Oid appNameType = null;
    private String printableName = null;
    private Oid printableNameType = null;
    private HashMap elements = null;
    private GSSNameSpi mechElement = null;
    static Oid NT_KRB5_PRINCIPAL = null;

    GSSNameImpl(GSSManagerImpl gSSManagerImpl, GSSNameSpi gSSNameSpi) throws GSSException {
        this(gSSManagerImpl, ((Object)gSSNameSpi).toString(), gSSNameSpi.getStringNameType(), gSSNameSpi.getMechanism());
    }

    GSSNameImpl(GSSManagerImpl gSSManagerImpl, Object object, Oid oid) throws GSSException {
        this(gSSManagerImpl, object, oid, null);
    }

    GSSNameImpl(GSSManagerImpl gSSManagerImpl, Object object, Oid oid, Oid oid2) throws GSSException {
        if (object == null) {
            throw new GSSExceptionImpl(3, "Cannot import null name");
        }
        if (oid != null && oid.equals(NT_EXPORT_NAME)) {
            this.importName(gSSManagerImpl, object);
        } else {
            this.init(gSSManagerImpl, object, oid, oid2);
        }
    }

    private void init(GSSManagerImpl gSSManagerImpl, Object object, Oid oid, Oid oid2) throws GSSException {
        this.gssManager = gSSManagerImpl;
        this.elements = new HashMap(gSSManagerImpl.getMechs().length);
        if (object instanceof String) {
            this.appNameStr = (String)object;
            if (oid != null) {
                this.printableName = this.appNameStr;
                this.printableNameType = oid;
            }
        } else {
            this.appNameBytes = (byte[])object;
        }
        this.appNameType = oid;
        this.mechElement = this.getElement(oid2);
        if (this.printableName == null) {
            this.printableName = ((Object)this.mechElement).toString();
            this.printableNameType = this.mechElement.getStringNameType();
        }
    }

    private void importName(GSSManagerImpl gSSManagerImpl, Object object) throws GSSException {
        Object object2;
        int n2 = 0;
        byte[] byArray = null;
        if (object instanceof String) {
            try {
                byArray = ((String)object).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            byArray = (byte[])object;
        }
        if (byArray[n2++] != 4 || byArray[n2++] != 1) {
            throw new GSSExceptionImpl(3, "Exported name token id is corrupted!");
        }
        int n3 = (0xFF & byArray[n2++]) << 8 | 0xFF & byArray[n2++];
        ObjectIdentifier objectIdentifier = null;
        try {
            object2 = new DerInputStream(byArray, n2, n3);
            objectIdentifier = new ObjectIdentifier((DerInputStream)object2);
        }
        catch (IOException iOException) {
            throw new GSSExceptionImpl(3, "Exported name Object identifier is corrupted!");
        }
        object2 = new Oid(objectIdentifier.toString());
        n2 += n3;
        int n4 = (0xFF & byArray[n2++]) << 24 | (0xFF & byArray[n2++]) << 16 | (0xFF & byArray[n2++]) << 8 | 0xFF & byArray[n2++];
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, n2, byArray2, 0, n4);
        this.init(gSSManagerImpl, byArray2, null, (Oid)object2);
    }

    public GSSName canonicalize(Oid oid) throws GSSException {
        if (oid == null) {
            oid = this.gssManager.getDefaultMechanism();
        }
        Object object = null;
        object = this.appNameStr != null ? this.appNameStr : (Object)this.appNameBytes;
        return new GSSNameImpl(this.gssManager, object, this.appNameType, oid);
    }

    public boolean equals(GSSName gSSName) throws GSSException {
        if (this.isAnonymous() || gSSName.isAnonymous()) {
            return false;
        }
        if (gSSName == this) {
            return true;
        }
        if (!(gSSName instanceof GSSNameImpl)) {
            return this.equals(this.gssManager.createName(((Object)gSSName).toString(), gSSName.getStringNameType()));
        }
        GSSNameImpl gSSNameImpl = (GSSNameImpl)gSSName;
        GSSNameSpi gSSNameSpi = this.mechElement;
        GSSNameSpi gSSNameSpi2 = gSSNameImpl.mechElement;
        if (gSSNameSpi == null && gSSNameSpi2 != null) {
            gSSNameSpi = this.getElement(gSSNameSpi2.getMechanism());
        } else if (gSSNameSpi != null && gSSNameSpi2 == null) {
            gSSNameSpi2 = gSSNameImpl.getElement(gSSNameSpi.getMechanism());
        }
        if (gSSNameSpi != null && gSSNameSpi2 != null) {
            return gSSNameSpi.equals(gSSNameSpi2);
        }
        if (this.appNameType != null && gSSNameImpl.appNameType != null) {
            if (!this.appNameType.equals(gSSNameImpl.appNameType)) {
                return false;
            }
            byte[] byArray = null;
            byte[] byArray2 = null;
            try {
                byArray = this.appNameStr != null ? this.appNameStr.getBytes("UTF-8") : this.appNameBytes;
                byArray2 = gSSNameImpl.appNameStr != null ? gSSNameImpl.appNameStr.getBytes("UTF-8") : gSSNameImpl.appNameBytes;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return GSSManagerImpl.compareBytes(byArray, byArray2);
        }
        return false;
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object object) {
        try {
            if (object instanceof GSSName) {
                return this.equals((GSSName)object);
            }
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
        return false;
    }

    public byte[] export() throws GSSException {
        if (this.mechElement == null) {
            this.mechElement = this.getElement(null);
        }
        byte[] byArray = this.mechElement.export();
        byte[] byArray2 = null;
        ObjectIdentifier objectIdentifier = null;
        try {
            objectIdentifier = new ObjectIdentifier(this.mechElement.getMechanism().toString());
        }
        catch (IOException iOException) {
            throw new GSSExceptionImpl(11, "Invalid OID String ");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            derOutputStream.putOID(objectIdentifier);
        }
        catch (IOException iOException) {
            throw new GSSExceptionImpl(11, "Could not ASN.1 Encode " + objectIdentifier.toString());
        }
        byArray2 = derOutputStream.toByteArray();
        byte[] byArray3 = new byte[4 + byArray2.length + 4 + byArray.length];
        int n2 = 0;
        byArray3[n2++] = 4;
        byArray3[n2++] = 1;
        byArray3[n2++] = (byte)(byArray2.length >>> 8);
        byArray3[n2++] = (byte)byArray2.length;
        System.arraycopy(byArray2, 0, byArray3, n2, byArray2.length);
        n2 += byArray2.length;
        byArray3[n2++] = (byte)(byArray.length >>> 24);
        byArray3[n2++] = (byte)(byArray.length >>> 16);
        byArray3[n2++] = (byte)(byArray.length >>> 8);
        byArray3[n2++] = (byte)byArray.length;
        System.arraycopy(byArray, 0, byArray3, n2, byArray.length);
        return byArray3;
    }

    public String toString() {
        return this.printableName;
    }

    public Oid getStringNameType() throws GSSException {
        return this.printableNameType;
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isMN() {
        return true;
    }

    synchronized GSSNameSpi getElement(Oid oid) throws GSSException {
        GSSNameSpi gSSNameSpi = (GSSNameSpi)this.elements.get(oid);
        if (gSSNameSpi == null) {
            Object object = null;
            object = this.appNameStr != null ? this.appNameStr : (Object)this.appNameBytes;
            gSSNameSpi = this.gssManager.getNameElement(object, this.appNameType, oid);
            this.elements.put(oid, gSSNameSpi);
        }
        return gSSNameSpi;
    }

    Set getElements() {
        return new HashSet(this.elements.values());
    }

    public static final String getHexBytes(byte[] byArray) {
        return GSSNameImpl.getHexBytes(byArray, 0, byArray.length);
    }

    public static final String getHexBytes(byte[] byArray, int n2) {
        return GSSNameImpl.getHexBytes(byArray, 0, n2);
    }

    public static final String getHexBytes(byte[] byArray, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = byArray[i2] >> 4 & 0xF;
            int n5 = byArray[i2] & 0xF;
            stringBuffer.append(Integer.toHexString(n4));
            stringBuffer.append(Integer.toHexString(n5));
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        Oid oid = new Oid("1.2.840.113554.1.2.2");
        NT_KRB5_PRINCIPAL = new Oid("1.2.840.113554.1.2.2.1");
        GSSManager gSSManager = GSSManager.getInstance();
        String string = "mdu";
        String string2 = "mdu@KRBNT-JSN.ENG.SUN.COM";
        String string3 = "nfs@vishwas.eng.sun.com";
        String string4 = "nfs/vishwas.eng.sun.com@KRBNT-JSN.ENG.SUN.COM";
        GSSName gSSName = gSSManager.createName(string, NT_USER_NAME);
        System.out.println(GSSNameImpl.getNameTypeStr(gSSName.getStringNameType()) + " " + "mduUserName=" + gSSName);
        System.out.println("");
        GSSName gSSName2 = gSSManager.createName(string3, NT_HOSTBASED_SERVICE);
        System.out.println(GSSNameImpl.getNameTypeStr(gSSName2.getStringNameType()) + " " + "nfsHostBasedName=" + gSSName2);
        System.out.println("");
        GSSName gSSName3 = gSSManager.createName(string2, NT_KRB5_PRINCIPAL);
        System.out.println(GSSNameImpl.getNameTypeStr(gSSName3.getStringNameType()) + " " + "mduPrincipalName=" + gSSName3);
        System.out.println("");
        GSSName gSSName4 = gSSManager.createName(string4, NT_KRB5_PRINCIPAL);
        System.out.println(GSSNameImpl.getNameTypeStr(gSSName4.getStringNameType()) + " " + "nfsPrincipalName=" + gSSName4);
        System.out.println("");
        GSSNameImpl.test2();
    }

    private static String getNameTypeStr(Oid oid) {
        if (oid == null) {
            return "(NT is null)";
        }
        if (oid.equals(NT_USER_NAME)) {
            return "NT_USER_NAME";
        }
        if (oid.equals(NT_HOSTBASED_SERVICE)) {
            return "NT_HOSTBASED_SERVICE";
        }
        if (oid.equals(NT_EXPORT_NAME)) {
            return "NT_EXPORT_NAME";
        }
        if (oid.equals(NT_KRB5_PRINCIPAL)) {
            return "NT_KRB5_PRINCIPAL";
        }
        return "Unknown";
    }

    private static void test2() throws GSSException {
        Oid oid = new ProviderList().getDefaultMechanism();
        GSSManager gSSManager = GSSManager.getInstance();
        GSSName gSSName = gSSManager.createName("mdu", NT_USER_NAME);
        System.out.println("name1: " + gSSName);
        System.out.println(gSSName.getStringNameType());
        System.out.println("---");
        GSSName gSSName2 = gSSName.canonicalize(oid);
        System.out.println("name5: " + gSSName2);
        System.out.println(gSSName2.getStringNameType());
        System.out.println("---");
        System.out.println("---");
        GSSName gSSName3 = gSSManager.createName("nfs@vishwas.eng.sun.com", NT_HOSTBASED_SERVICE);
        System.out.println("name2: " + gSSName3);
        System.out.println(gSSName3.getStringNameType());
        System.out.println("---");
        GSSName gSSName4 = gSSName3.canonicalize(oid);
        System.out.println("name6: " + gSSName4);
        System.out.println(gSSName4.getStringNameType());
        System.out.println("---");
        System.out.println("---");
        GSSName gSSName5 = gSSManager.createName("mdu", NT_USER_NAME, oid);
        System.out.println("name3: " + gSSName5);
        System.out.println(gSSName5.getStringNameType());
        System.out.println("---");
        GSSName gSSName6 = gSSName5.canonicalize(oid);
        System.out.println("name7: " + gSSName6);
        System.out.println(gSSName6.getStringNameType());
        System.out.println("---");
        System.out.println("---");
        GSSName gSSName7 = gSSManager.createName("nfs@vishwas.eng.sun.com", NT_HOSTBASED_SERVICE, oid);
        System.out.println(gSSName7);
        System.out.println(gSSName7.getStringNameType());
        System.out.println("---");
        GSSName gSSName8 = gSSName7.canonicalize(oid);
        System.out.println(gSSName8);
        System.out.println(gSSName8.getStringNameType());
        System.out.println("---");
        System.out.println("---");
        System.out.println("Comparing name1 to name5: " + gSSName.equals(gSSName2));
        System.out.println("Comparing name2 to name6: " + gSSName3.equals(gSSName4));
        System.out.println("Comparing name3 to name7: " + gSSName5.equals(gSSName6));
        System.out.println("Comparing name4 to name8: " + gSSName7.equals(gSSName8));
        System.out.println("Comparing name1 to name3: " + gSSName.equals(gSSName5));
        System.out.println("Comparing name5 to name7: " + gSSName2.equals(gSSName6));
        System.out.println("Comparing name2 to name8: " + gSSName3.equals(gSSName8));
        System.out.println("Comparing name4 to name6: " + gSSName7.equals(gSSName4));
        byte[] byArray = gSSName.export();
        System.out.println(GSSNameImpl.getHexBytes(byArray));
        GSSName gSSName9 = gSSManager.createName(byArray, NT_EXPORT_NAME);
        System.out.println(gSSName9);
        System.out.println(gSSName.equals(gSSName9));
    }
}

