/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilePermission;
import java.io.Serializable;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.ServiceUIFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobPriority;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterInfo;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterMakeAndModel;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.NumberFormatter;
import sun.print.SunAlternateMedia;
import sun.print.SunPageSelection;

public class ServiceDialog
extends JDialog
implements ActionListener {
    public static final int WAITING = 0;
    public static final int APPROVE = 1;
    public static final int CANCEL = 2;
    private static final String strBundle = "sun.print.resources.serviceui";
    private static final Insets panelInsets = new Insets(6, 6, 6, 6);
    private static final Insets compInsets = new Insets(3, 6, 3, 6);
    private static ResourceBundle messageRB;
    private JTabbedPane tpTabs;
    private JButton btnCancel;
    private JButton btnApprove;
    private PrintService[] services;
    private int defaultServiceIndex;
    private PrintRequestAttributeSet asOriginal;
    private HashPrintRequestAttributeSet asCurrent;
    private PrintService psCurrent;
    private DocFlavor docFlavor;
    private int status;
    private ValidatingFileChooser jfc;
    private GeneralPanel pnlGeneral;
    private PageSetupPanel pnlPageSetup;
    private AppearancePanel pnlAppearance;
    private boolean isAWT = false;

    public ServiceDialog(GraphicsConfiguration graphicsConfiguration, int n2, int n3, PrintService[] printServiceArray, int n4, DocFlavor docFlavor, PrintRequestAttributeSet printRequestAttributeSet, Dialog dialog) {
        super(dialog, ServiceDialog.getMsg("dialog.printtitle"), true, graphicsConfiguration);
        this.initPrintDialog(n2, n3, printServiceArray, n4, docFlavor, printRequestAttributeSet);
    }

    public ServiceDialog(GraphicsConfiguration graphicsConfiguration, int n2, int n3, PrintService[] printServiceArray, int n4, DocFlavor docFlavor, PrintRequestAttributeSet printRequestAttributeSet, Frame frame) {
        super(frame, ServiceDialog.getMsg("dialog.printtitle"), true, graphicsConfiguration);
        this.initPrintDialog(n2, n3, printServiceArray, n4, docFlavor, printRequestAttributeSet);
    }

    void initPrintDialog(int n2, int n3, PrintService[] printServiceArray, int n4, DocFlavor docFlavor, PrintRequestAttributeSet printRequestAttributeSet) {
        this.services = printServiceArray;
        this.defaultServiceIndex = n4;
        this.asOriginal = printRequestAttributeSet;
        this.asCurrent = new HashPrintRequestAttributeSet(printRequestAttributeSet);
        this.psCurrent = printServiceArray[n4];
        this.docFlavor = docFlavor;
        SunPageSelection sunPageSelection = (SunPageSelection)printRequestAttributeSet.get(SunPageSelection.class);
        if (sunPageSelection != null) {
            this.isAWT = true;
        }
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.tpTabs = new JTabbedPane();
        this.tpTabs.setBorder(new EmptyBorder(5, 5, 5, 5));
        String string = ServiceDialog.getMsg("tab.general");
        int n5 = ServiceDialog.getVKMnemonic("tab.general");
        this.pnlGeneral = new GeneralPanel();
        this.tpTabs.add(string, this.pnlGeneral);
        this.tpTabs.setMnemonicAt(0, n5);
        String string2 = ServiceDialog.getMsg("tab.pagesetup");
        int n6 = ServiceDialog.getVKMnemonic("tab.pagesetup");
        this.pnlPageSetup = new PageSetupPanel();
        this.tpTabs.add(string2, this.pnlPageSetup);
        this.tpTabs.setMnemonicAt(1, n6);
        String string3 = ServiceDialog.getMsg("tab.appearance");
        int n7 = ServiceDialog.getVKMnemonic("tab.appearance");
        this.pnlAppearance = new AppearancePanel();
        this.tpTabs.add(string3, this.pnlAppearance);
        this.tpTabs.setMnemonicAt(2, n7);
        container.add((Component)this.tpTabs, "Center");
        this.updatePanels();
        JPanel jPanel = new JPanel(new FlowLayout(4));
        this.btnApprove = ServiceDialog.createExitButton("button.print", this);
        jPanel.add(this.btnApprove);
        this.getRootPane().setDefaultButton(this.btnApprove);
        this.btnCancel = ServiceDialog.createExitButton("button.cancel", this);
        this.handleEscKey(this.btnCancel);
        jPanel.add(this.btnCancel);
        container.add((Component)jPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ServiceDialog.this.dispose(2);
            }
        });
        this.getAccessibleContext().setAccessibleDescription(ServiceDialog.getMsg("dialog.printtitle"));
        this.setResizable(false);
        this.setLocation(n2, n3);
        this.pack();
    }

    public ServiceDialog(GraphicsConfiguration graphicsConfiguration, int n2, int n3, PrintService printService, DocFlavor docFlavor, PrintRequestAttributeSet printRequestAttributeSet, Dialog dialog) {
        super(dialog, ServiceDialog.getMsg("dialog.pstitle"), true, graphicsConfiguration);
        this.initPageDialog(n2, n3, printService, docFlavor, printRequestAttributeSet);
    }

    public ServiceDialog(GraphicsConfiguration graphicsConfiguration, int n2, int n3, PrintService printService, DocFlavor docFlavor, PrintRequestAttributeSet printRequestAttributeSet, Frame frame) {
        super(frame, ServiceDialog.getMsg("dialog.pstitle"), true, graphicsConfiguration);
        this.initPageDialog(n2, n3, printService, docFlavor, printRequestAttributeSet);
    }

    void initPageDialog(int n2, int n3, PrintService printService, DocFlavor docFlavor, PrintRequestAttributeSet printRequestAttributeSet) {
        this.psCurrent = printService;
        this.docFlavor = docFlavor;
        this.asOriginal = printRequestAttributeSet;
        this.asCurrent = new HashPrintRequestAttributeSet(printRequestAttributeSet);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.pnlPageSetup = new PageSetupPanel();
        container.add((Component)this.pnlPageSetup, "Center");
        this.pnlPageSetup.updateInfo();
        JPanel jPanel = new JPanel(new FlowLayout(4));
        this.btnApprove = ServiceDialog.createExitButton("button.ok", this);
        jPanel.add(this.btnApprove);
        this.getRootPane().setDefaultButton(this.btnApprove);
        this.btnCancel = ServiceDialog.createExitButton("button.cancel", this);
        this.handleEscKey(this.btnCancel);
        jPanel.add(this.btnCancel);
        container.add((Component)jPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ServiceDialog.this.dispose(2);
            }
        });
        this.getAccessibleContext().setAccessibleDescription(ServiceDialog.getMsg("dialog.pstitle"));
        this.setResizable(false);
        this.setLocation(n2, n3);
        this.pack();
    }

    private void handleEscKey(JButton jButton) {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ServiceDialog.this.dispose(2);
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke('\u001b', false);
        InputMap inputMap = jButton.getInputMap(2);
        ActionMap actionMap = jButton.getActionMap();
        if (inputMap != null && actionMap != null) {
            inputMap.put(keyStroke, "cancel");
            actionMap.put("cancel", abstractAction);
        }
    }

    public int getStatus() {
        return this.status;
    }

    public PrintRequestAttributeSet getAttributes() {
        if (this.status == 1) {
            return this.asCurrent;
        }
        return this.asOriginal;
    }

    public PrintService getPrintService() {
        if (this.status == 1) {
            return this.psCurrent;
        }
        return null;
    }

    public void dispose(int n2) {
        this.status = n2;
        super.dispose();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        boolean bl2 = false;
        if (object == this.btnApprove) {
            bl2 = true;
            if (this.pnlGeneral != null) {
                if (this.pnlGeneral.isPrintToFileSelected()) {
                    bl2 = this.showFileChooser();
                } else {
                    this.asCurrent.remove(Destination.class);
                }
            }
        }
        this.dispose(bl2 ? 1 : 2);
    }

    private boolean showFileChooser() {
        File file;
        Class<Destination> clazz = Destination.class;
        Destination destination = (Destination)this.asCurrent.get(clazz);
        if (destination == null && (destination = (Destination)this.asOriginal.get(clazz)) == null && (destination = (Destination)this.psCurrent.getDefaultAttributeValue(clazz)) == null) {
            destination = new Destination(new File("out.prn").toURI());
        }
        if (destination != null) {
            try {
                file = new File(destination.getURI());
            }
            catch (Exception exception) {
                file = new File("out.prn");
            }
        } else {
            file = new File("out.prn");
        }
        ValidatingFileChooser validatingFileChooser = new ValidatingFileChooser();
        validatingFileChooser.setApproveButtonText(ServiceDialog.getMsg("button.ok"));
        validatingFileChooser.setDialogTitle(ServiceDialog.getMsg("dialog.printtofile"));
        validatingFileChooser.setSelectedFile(file);
        int n2 = validatingFileChooser.showDialog(this, null);
        if (n2 == 0) {
            file = validatingFileChooser.getSelectedFile();
            try {
                this.asCurrent.add(new Destination(file.toURI()));
            }
            catch (Exception exception) {
                this.asCurrent.remove(clazz);
            }
        } else {
            this.asCurrent.remove(clazz);
        }
        return n2 == 0;
    }

    private void updatePanels() {
        this.pnlGeneral.updateInfo();
        this.pnlPageSetup.updateInfo();
        this.pnlAppearance.updateInfo();
    }

    private static void initResource() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    messageRB = ResourceBundle.getBundle(ServiceDialog.strBundle);
                    return null;
                }
                catch (MissingResourceException missingResourceException) {
                    throw new Error("Fatal: Resource for ServiceUI is missing");
                }
            }
        });
    }

    private static String getMsg(String string) {
        try {
            return messageRB.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for ServiceUI is broken; there is no " + string + " key in resource");
        }
    }

    private static char getMnemonic(String string) {
        String string2 = ServiceDialog.getMsg(string + ".mnemonic");
        if (string2 != null && string2.length() > 0) {
            return string2.charAt(0);
        }
        return '\u0000';
    }

    private static int getVKMnemonic(String string) {
        String string2 = ServiceDialog.getMsg(string + ".vkMnemonic");
        if (string2 != null && string2.length() > 0) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    private static URL getImageResource(final String string) {
        URL uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                URL uRL = ServiceDialog.class.getResource("resources/" + string);
                return uRL;
            }
        });
        if (uRL == null) {
            throw new Error("Fatal: Resource for ServiceUI is broken; there is no " + string + " key in resource");
        }
        return uRL;
    }

    private static JButton createButton(String string, ActionListener actionListener) {
        JButton jButton = new JButton(ServiceDialog.getMsg(string));
        jButton.setMnemonic(ServiceDialog.getMnemonic(string));
        jButton.addActionListener(actionListener);
        return jButton;
    }

    private static JButton createExitButton(String string, ActionListener actionListener) {
        String string2 = ServiceDialog.getMsg(string);
        JButton jButton = new JButton(string2);
        jButton.addActionListener(actionListener);
        jButton.getAccessibleContext().setAccessibleDescription(string2);
        return jButton;
    }

    private static JCheckBox createCheckBox(String string, ActionListener actionListener) {
        JCheckBox jCheckBox = new JCheckBox(ServiceDialog.getMsg(string));
        jCheckBox.setMnemonic(ServiceDialog.getMnemonic(string));
        jCheckBox.addActionListener(actionListener);
        return jCheckBox;
    }

    private static JRadioButton createRadioButton(String string, ActionListener actionListener) {
        JRadioButton jRadioButton = new JRadioButton(ServiceDialog.getMsg(string));
        jRadioButton.setMnemonic(ServiceDialog.getMnemonic(string));
        jRadioButton.addActionListener(actionListener);
        return jRadioButton;
    }

    public static void showNoPrintService(GraphicsConfiguration graphicsConfiguration) {
        Frame frame = new Frame(graphicsConfiguration);
        JOptionPane.showMessageDialog(frame, ServiceDialog.getMsg("dialog.noprintermsg"));
        frame.dispose();
    }

    private static void addToGB(Component component, Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    private static void addToBG(AbstractButton abstractButton, Container container, ButtonGroup buttonGroup) {
        buttonGroup.add(abstractButton);
        container.add(abstractButton);
    }

    static {
        ServiceDialog.initResource();
    }

    private class AppearancePanel
    extends JPanel {
        private ChromaticityPanel pnlChromaticity;
        private QualityPanel pnlQuality;
        private JobAttributesPanel pnlJobAttributes;
        private SidesPanel pnlSides;

        public AppearancePanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = panelInsets;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = -1;
            this.pnlChromaticity = new ChromaticityPanel();
            ServiceDialog.addToGB(this.pnlChromaticity, this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            this.pnlQuality = new QualityPanel();
            ServiceDialog.addToGB(this.pnlQuality, this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.gridwidth = 1;
            this.pnlSides = new SidesPanel();
            ServiceDialog.addToGB(this.pnlSides, this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            this.pnlJobAttributes = new JobAttributesPanel();
            ServiceDialog.addToGB(this.pnlJobAttributes, this, gridBagLayout, gridBagConstraints);
        }

        public void updateInfo() {
            this.pnlChromaticity.updateInfo();
            this.pnlQuality.updateInfo();
            this.pnlSides.updateInfo();
            this.pnlJobAttributes.updateInfo();
        }
    }

    private class ChromaticityPanel
    extends JPanel
    implements ActionListener {
        private final String strTitle = ServiceDialog.access$400("border.chromaticity");
        private JRadioButton rbMonochrome;
        private JRadioButton rbColor;

        public ChromaticityPanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weighty = 1.0;
            ButtonGroup buttonGroup = new ButtonGroup();
            this.rbMonochrome = ServiceDialog.createRadioButton("radiobutton.monochrome", this);
            this.rbMonochrome.setSelected(true);
            buttonGroup.add(this.rbMonochrome);
            ServiceDialog.addToGB(this.rbMonochrome, this, gridBagLayout, gridBagConstraints);
            this.rbColor = ServiceDialog.createRadioButton("radiobutton.color", this);
            buttonGroup.add(this.rbColor);
            ServiceDialog.addToGB(this.rbColor, this, gridBagLayout, gridBagConstraints);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.rbMonochrome) {
                ServiceDialog.this.asCurrent.add(Chromaticity.MONOCHROME);
            } else if (object == this.rbColor) {
                ServiceDialog.this.asCurrent.add(Chromaticity.COLOR);
            }
        }

        public void updateInfo() {
            Object object;
            Class<Chromaticity> clazz = Chromaticity.class;
            boolean bl2 = false;
            boolean bl3 = false;
            if (ServiceDialog.this.isAWT) {
                bl2 = true;
                bl3 = true;
            } else if (ServiceDialog.this.psCurrent.isAttributeCategorySupported(clazz) && (object = ServiceDialog.this.psCurrent.getSupportedAttributeValues(clazz, ServiceDialog.this.docFlavor, ServiceDialog.this.asCurrent)) instanceof Chromaticity[]) {
                Chromaticity[] chromaticityArray = (Chromaticity[])object;
                for (int i2 = 0; i2 < chromaticityArray.length; ++i2) {
                    Chromaticity chromaticity = chromaticityArray[i2];
                    if (chromaticity == Chromaticity.MONOCHROME) {
                        bl2 = true;
                        continue;
                    }
                    if (chromaticity != Chromaticity.COLOR) continue;
                    bl3 = true;
                }
            }
            this.rbMonochrome.setEnabled(bl2);
            this.rbColor.setEnabled(bl3);
            object = (Chromaticity)ServiceDialog.this.asCurrent.get(clazz);
            if (object == null && (object = (Chromaticity)ServiceDialog.this.psCurrent.getDefaultAttributeValue(clazz)) == null) {
                object = Chromaticity.MONOCHROME;
            }
            if (object == Chromaticity.MONOCHROME) {
                this.rbMonochrome.setSelected(true);
            } else {
                this.rbColor.setSelected(true);
            }
        }
    }

    private class CopiesPanel
    extends JPanel
    implements ActionListener,
    ChangeListener {
        private final String strTitle = ServiceDialog.access$400("border.copies");
        private SpinnerNumberModel snModel;
        private JSpinner spinCopies;
        private JLabel lblCopies;
        private JCheckBox cbCollate;
        private boolean scSupported;

        public CopiesPanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = compInsets;
            this.lblCopies = new JLabel(ServiceDialog.getMsg("label.numcopies"), 11);
            this.lblCopies.setDisplayedMnemonic(ServiceDialog.getMnemonic("label.numcopies"));
            this.lblCopies.getAccessibleContext().setAccessibleName(ServiceDialog.getMsg("label.numcopies"));
            ServiceDialog.addToGB(this.lblCopies, this, gridBagLayout, gridBagConstraints);
            this.snModel = new SpinnerNumberModel(1, 1, 999, 1);
            this.spinCopies = new JSpinner(this.snModel);
            this.lblCopies.setLabelFor(this.spinCopies);
            ((JSpinner.NumberEditor)this.spinCopies.getEditor()).getTextField().setColumns(3);
            this.spinCopies.addChangeListener(this);
            gridBagConstraints.gridwidth = 0;
            ServiceDialog.addToGB(this.spinCopies, this, gridBagLayout, gridBagConstraints);
            this.cbCollate = ServiceDialog.createCheckBox("checkbox.collate", this);
            this.cbCollate.setEnabled(false);
            ServiceDialog.addToGB(this.cbCollate, this, gridBagLayout, gridBagConstraints);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.cbCollate.isSelected()) {
                ServiceDialog.this.asCurrent.add(SheetCollate.COLLATED);
            } else {
                ServiceDialog.this.asCurrent.add(SheetCollate.UNCOLLATED);
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.updateCollateCB();
            ServiceDialog.this.asCurrent.add(new Copies(this.snModel.getNumber().intValue()));
        }

        private void updateCollateCB() {
            int n2 = this.snModel.getNumber().intValue();
            if (ServiceDialog.this.isAWT) {
                this.cbCollate.setEnabled(true);
            } else {
                this.cbCollate.setEnabled(n2 > 1 && this.scSupported);
            }
        }

        public void updateInfo() {
            SheetCollate sheetCollate;
            int n2;
            int n3;
            Copies copies;
            CopiesSupported copiesSupported;
            Class<Copies> clazz = Copies.class;
            Class<CopiesSupported> clazz2 = CopiesSupported.class;
            Class<SheetCollate> clazz3 = SheetCollate.class;
            boolean bl2 = false;
            this.scSupported = false;
            if (ServiceDialog.this.psCurrent.isAttributeCategorySupported(clazz)) {
                bl2 = true;
            }
            if ((copiesSupported = (CopiesSupported)ServiceDialog.this.psCurrent.getSupportedAttributeValues(clazz, null, null)) == null) {
                copiesSupported = new CopiesSupported(1, 999);
            }
            if ((copies = (Copies)ServiceDialog.this.asCurrent.get(clazz)) == null && (copies = (Copies)ServiceDialog.this.psCurrent.getDefaultAttributeValue(clazz)) == null) {
                copies = new Copies(1);
            }
            this.spinCopies.setEnabled(bl2);
            this.lblCopies.setEnabled(bl2);
            int[][] nArray = copiesSupported.getMembers();
            if (nArray.length > 0 && nArray[0].length > 0) {
                n3 = nArray[0][0];
                n2 = nArray[0][1];
            } else {
                n3 = 1;
                n2 = Integer.MAX_VALUE;
            }
            this.snModel.setMinimum(new Integer(n3));
            this.snModel.setMaximum(new Integer(n2));
            int n4 = copies.getValue();
            if (n4 < n3 || n4 > n2) {
                n4 = n3;
            }
            this.snModel.setValue(new Integer(n4));
            if (ServiceDialog.this.psCurrent.isAttributeCategorySupported(clazz3)) {
                this.scSupported = true;
            }
            if ((sheetCollate = (SheetCollate)ServiceDialog.this.asCurrent.get(clazz3)) == null && (sheetCollate = (SheetCollate)ServiceDialog.this.psCurrent.getDefaultAttributeValue(clazz3)) == null) {
                sheetCollate = SheetCollate.UNCOLLATED;
            }
            this.cbCollate.setSelected(sheetCollate == SheetCollate.COLLATED);
            this.updateCollateCB();
        }
    }

    private class GeneralPanel
    extends JPanel {
        private PrintServicePanel pnlPrintService;
        private PrintRangePanel pnlPrintRange;
        private CopiesPanel pnlCopies;

        public GeneralPanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = panelInsets;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 0;
            this.pnlPrintService = new PrintServicePanel();
            ServiceDialog.addToGB(this.pnlPrintService, this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.gridwidth = -1;
            this.pnlPrintRange = new PrintRangePanel();
            ServiceDialog.addToGB(this.pnlPrintRange, this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            this.pnlCopies = new CopiesPanel();
            ServiceDialog.addToGB(this.pnlCopies, this, gridBagLayout, gridBagConstraints);
        }

        public boolean isPrintToFileSelected() {
            return this.pnlPrintService.isPrintToFileSelected();
        }

        public void updateInfo() {
            this.pnlPrintService.updateInfo();
            this.pnlPrintRange.updateInfo();
            this.pnlCopies.updateInfo();
        }
    }

    private class IconRadioButton
    extends JPanel {
        private JRadioButton rb;
        private JLabel lbl;

        public IconRadioButton(String string, String string2, boolean bl2, ButtonGroup buttonGroup, ActionListener actionListener) {
            super(new FlowLayout(3));
            final URL uRL = ServiceDialog.getImageResource(string2);
            Icon icon = (Icon)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ImageIcon imageIcon = new ImageIcon(uRL);
                    return imageIcon;
                }
            });
            this.lbl = new JLabel(icon);
            this.add(this.lbl);
            this.rb = ServiceDialog.createRadioButton(string, actionListener);
            this.rb.setSelected(bl2);
            ServiceDialog.addToBG(this.rb, this, buttonGroup);
        }

        public void addActionListener(ActionListener actionListener) {
            this.rb.addActionListener(actionListener);
        }

        public boolean isSameAs(Object object) {
            return this.rb == object;
        }

        public void setEnabled(boolean bl2) {
            this.rb.setEnabled(bl2);
            this.lbl.setEnabled(bl2);
        }

        public boolean isSelected() {
            return this.rb.isSelected();
        }

        public void setSelected(boolean bl2) {
            this.rb.setSelected(bl2);
        }
    }

    private class JobAttributesPanel
    extends JPanel
    implements ActionListener,
    ChangeListener,
    FocusListener {
        private final String strTitle = ServiceDialog.access$400("border.jobattributes");
        private JLabel lblPriority;
        private JLabel lblJobName;
        private JLabel lblUserName;
        private JSpinner spinPriority;
        private SpinnerNumberModel snModel;
        private JCheckBox cbJobSheets;
        private JTextField tfJobName;
        private JTextField tfUserName;

        public JobAttributesPanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = compInsets;
            gridBagConstraints.weighty = 1.0;
            this.cbJobSheets = ServiceDialog.createCheckBox("checkbox.jobsheets", this);
            gridBagConstraints.anchor = 21;
            ServiceDialog.addToGB(this.cbJobSheets, this, gridBagLayout, gridBagConstraints);
            JPanel jPanel = new JPanel();
            this.lblPriority = new JLabel(ServiceDialog.getMsg("label.priority"), 11);
            this.lblPriority.setDisplayedMnemonic(ServiceDialog.getMnemonic("label.priority"));
            jPanel.add(this.lblPriority);
            this.snModel = new SpinnerNumberModel(1, 1, 100, 1);
            this.spinPriority = new JSpinner(this.snModel);
            this.lblPriority.setLabelFor(this.spinPriority);
            ((JSpinner.NumberEditor)this.spinPriority.getEditor()).getTextField().setColumns(3);
            this.spinPriority.addChangeListener(this);
            jPanel.add(this.spinPriority);
            gridBagConstraints.anchor = 22;
            gridBagConstraints.gridwidth = 0;
            jPanel.getAccessibleContext().setAccessibleName(ServiceDialog.getMsg("label.priority"));
            ServiceDialog.addToGB(jPanel, this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 1;
            char c2 = ServiceDialog.getMnemonic("label.jobname");
            this.lblJobName = new JLabel(ServiceDialog.getMsg("label.jobname"), 11);
            this.lblJobName.setDisplayedMnemonic(c2);
            ServiceDialog.addToGB(this.lblJobName, this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            this.tfJobName = new JTextField();
            this.lblJobName.setLabelFor(this.tfJobName);
            this.tfJobName.addFocusListener(this);
            this.tfJobName.setFocusAccelerator(c2);
            this.tfJobName.getAccessibleContext().setAccessibleName(ServiceDialog.getMsg("label.jobname"));
            ServiceDialog.addToGB(this.tfJobName, this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 1;
            char c3 = ServiceDialog.getMnemonic("label.username");
            this.lblUserName = new JLabel(ServiceDialog.getMsg("label.username"), 11);
            this.lblUserName.setDisplayedMnemonic(c3);
            ServiceDialog.addToGB(this.lblUserName, this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            this.tfUserName = new JTextField();
            this.lblUserName.setLabelFor(this.tfUserName);
            this.tfUserName.addFocusListener(this);
            this.tfUserName.setFocusAccelerator(c3);
            this.tfUserName.getAccessibleContext().setAccessibleName(ServiceDialog.getMsg("label.username"));
            ServiceDialog.addToGB(this.tfUserName, this, gridBagLayout, gridBagConstraints);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.cbJobSheets.isSelected()) {
                ServiceDialog.this.asCurrent.add(JobSheets.STANDARD);
            } else {
                ServiceDialog.this.asCurrent.add(JobSheets.NONE);
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ServiceDialog.this.asCurrent.add(new JobPriority(this.snModel.getNumber().intValue()));
        }

        public void focusLost(FocusEvent focusEvent) {
            Object object = focusEvent.getSource();
            if (object == this.tfJobName) {
                ServiceDialog.this.asCurrent.add(new JobName(this.tfJobName.getText(), Locale.getDefault()));
            } else if (object == this.tfUserName) {
                ServiceDialog.this.asCurrent.add(new RequestingUserName(this.tfUserName.getText(), Locale.getDefault()));
            }
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void updateInfo() {
            RequestingUserName requestingUserName;
            JobName jobName;
            int n2;
            JobPriority jobPriority;
            JobSheets jobSheets;
            Class<JobSheets> clazz = JobSheets.class;
            Class<JobPriority> clazz2 = JobPriority.class;
            Class<JobName> clazz3 = JobName.class;
            Class<RequestingUserName> clazz4 = RequestingUserName.class;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            if (ServiceDialog.this.psCurrent.isAttributeCategorySupported(clazz)) {
                bl2 = true;
            }
            if ((jobSheets = (JobSheets)ServiceDialog.this.asCurrent.get(clazz)) == null && (jobSheets = (JobSheets)ServiceDialog.this.psCurrent.getDefaultAttributeValue(clazz)) == null) {
                jobSheets = JobSheets.NONE;
            }
            this.cbJobSheets.setSelected(jobSheets != JobSheets.NONE);
            this.cbJobSheets.setEnabled(bl2);
            if (!ServiceDialog.this.isAWT && ServiceDialog.this.psCurrent.isAttributeCategorySupported(clazz2)) {
                bl3 = true;
            }
            if ((jobPriority = (JobPriority)ServiceDialog.this.asCurrent.get(clazz2)) == null && (jobPriority = (JobPriority)ServiceDialog.this.psCurrent.getDefaultAttributeValue(clazz2)) == null) {
                jobPriority = new JobPriority(1);
            }
            if ((n2 = jobPriority.getValue()) < 1 || n2 > 100) {
                n2 = 1;
            }
            this.snModel.setValue(new Integer(n2));
            this.lblPriority.setEnabled(bl3);
            this.spinPriority.setEnabled(bl3);
            if (ServiceDialog.this.psCurrent.isAttributeCategorySupported(clazz3)) {
                bl4 = true;
            }
            if ((jobName = (JobName)ServiceDialog.this.asCurrent.get(clazz3)) == null && (jobName = (JobName)ServiceDialog.this.psCurrent.getDefaultAttributeValue(clazz3)) == null) {
                jobName = new JobName("", Locale.getDefault());
            }
            this.tfJobName.setText(jobName.getValue());
            this.tfJobName.setEnabled(bl4);
            this.lblJobName.setEnabled(bl4);
            if (!ServiceDialog.this.isAWT && ServiceDialog.this.psCurrent.isAttributeCategorySupported(clazz4)) {
                bl5 = true;
            }
            if ((requestingUserName = (RequestingUserName)ServiceDialog.this.asCurrent.get(clazz4)) == null && (requestingUserName = (RequestingUserName)ServiceDialog.this.psCurrent.getDefaultAttributeValue(clazz4)) == null) {
                requestingUserName = new RequestingUserName("", Locale.getDefault());
            }
            this.tfUserName.setText(requestingUserName.getValue());
            this.tfUserName.setEnabled(bl5);
            this.lblUserName.setEnabled(bl5);
        }
    }

    private class MarginsPanel
    extends JPanel
    implements ActionListener,
    FocusListener {
        private final String strTitle = ServiceDialog.access$400("border.margins");
        private JFormattedTextField leftMargin;
        private JFormattedTextField rightMargin;
        private JFormattedTextField topMargin;
        private JFormattedTextField bottomMargin;
        private JLabel lblLeft;
        private JLabel lblRight;
        private JLabel lblTop;
        private JLabel lblBottom;
        private int units = 1000;
        private float lmVal = -1.0f;
        private float rmVal = -1.0f;
        private float tmVal = -1.0f;
        private float bmVal = -1.0f;
        private Float lmObj;
        private Float rmObj;
        private Float tmObj;
        private Float bmObj;

        public MarginsPanel() {
            DecimalFormat decimalFormat;
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = compInsets;
            this.setLayout(gridBagLayout);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            String string = "label.millimetres";
            String string2 = Locale.getDefault().getCountry();
            if (string2 != null && (string2.equals("") || string2.equals(Locale.US.getCountry()) || string2.equals(Locale.CANADA.getCountry()))) {
                string = "label.inches";
                this.units = 25400;
            }
            String string3 = ServiceDialog.getMsg(string);
            if (this.units == 1000) {
                decimalFormat = new DecimalFormat("###.##");
                decimalFormat.setMaximumIntegerDigits(3);
            } else {
                decimalFormat = new DecimalFormat("##.##");
                decimalFormat.setMaximumIntegerDigits(2);
            }
            decimalFormat.setMinimumFractionDigits(1);
            decimalFormat.setMaximumFractionDigits(2);
            decimalFormat.setMinimumIntegerDigits(1);
            decimalFormat.setParseIntegerOnly(false);
            decimalFormat.setDecimalSeparatorAlwaysShown(true);
            NumberFormatter numberFormatter = new NumberFormatter(decimalFormat);
            numberFormatter.setMinimum(new Float(0.0f));
            numberFormatter.setMaximum(new Float(999.0f));
            numberFormatter.setAllowsInvalid(true);
            numberFormatter.setCommitsOnValidEdit(true);
            this.leftMargin = new JFormattedTextField(numberFormatter);
            this.leftMargin.addFocusListener(this);
            this.leftMargin.addActionListener(this);
            this.leftMargin.getAccessibleContext().setAccessibleName(ServiceDialog.getMsg("label.leftmargin"));
            this.rightMargin = new JFormattedTextField(numberFormatter);
            this.rightMargin.addFocusListener(this);
            this.rightMargin.addActionListener(this);
            this.rightMargin.getAccessibleContext().setAccessibleName(ServiceDialog.getMsg("label.rightmargin"));
            this.topMargin = new JFormattedTextField(numberFormatter);
            this.topMargin.addFocusListener(this);
            this.topMargin.addActionListener(this);
            this.topMargin.getAccessibleContext().setAccessibleName(ServiceDialog.getMsg("label.topmargin"));
            this.topMargin = new JFormattedTextField(numberFormatter);
            this.bottomMargin = new JFormattedTextField(numberFormatter);
            this.bottomMargin.addFocusListener(this);
            this.bottomMargin.addActionListener(this);
            this.bottomMargin.getAccessibleContext().setAccessibleName(ServiceDialog.getMsg("label.bottommargin"));
            this.topMargin = new JFormattedTextField(numberFormatter);
            gridBagConstraints.gridwidth = -1;
            this.lblLeft = new JLabel(ServiceDialog.getMsg("label.leftmargin") + " " + string3, 10);
            this.lblLeft.setDisplayedMnemonic(ServiceDialog.getMnemonic("label.leftmargin"));
            this.lblLeft.setLabelFor(this.leftMargin);
            ServiceDialog.addToGB(this.lblLeft, this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            this.lblRight = new JLabel(ServiceDialog.getMsg("label.rightmargin") + " " + string3, 10);
            this.lblRight.setDisplayedMnemonic(ServiceDialog.getMnemonic("label.rightmargin"));
            this.lblRight.setLabelFor(this.rightMargin);
            ServiceDialog.addToGB(this.lblRight, this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.gridwidth = -1;
            ServiceDialog.addToGB(this.leftMargin, this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            ServiceDialog.addToGB(this.rightMargin, this, gridBagLayout, gridBagConstraints);
            ServiceDialog.addToGB(new JPanel(), this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.gridwidth = -1;
            this.lblTop = new JLabel(ServiceDialog.getMsg("label.topmargin") + " " + string3, 10);
            this.lblTop.setDisplayedMnemonic(ServiceDialog.getMnemonic("label.topmargin"));
            this.lblTop.setLabelFor(this.topMargin);
            ServiceDialog.addToGB(this.lblTop, this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            this.lblBottom = new JLabel(ServiceDialog.getMsg("label.bottommargin") + " " + string3, 10);
            this.lblBottom.setDisplayedMnemonic(ServiceDialog.getMnemonic("label.bottommargin"));
            this.lblBottom.setLabelFor(this.bottomMargin);
            ServiceDialog.addToGB(this.lblBottom, this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.gridwidth = -1;
            ServiceDialog.addToGB(this.topMargin, this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            ServiceDialog.addToGB(this.bottomMargin, this, gridBagLayout, gridBagConstraints);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            this.updateMargins(object);
        }

        public void focusLost(FocusEvent focusEvent) {
            Object object = focusEvent.getSource();
            this.updateMargins(object);
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void updateMargins(Object object) {
            if (!(object instanceof JFormattedTextField)) {
                return;
            }
            Serializable serializable = (JFormattedTextField)object;
            Float f2 = (Float)((JFormattedTextField)serializable).getValue();
            if (f2 == null) {
                return;
            }
            if (serializable == this.leftMargin && f2.equals(this.lmObj)) {
                return;
            }
            if (serializable == this.rightMargin && f2.equals(this.rmObj)) {
                return;
            }
            if (serializable == this.topMargin && f2.equals(this.tmObj)) {
                return;
            }
            if (serializable == this.bottomMargin && f2.equals(this.bmObj)) {
                return;
            }
            serializable = (Float)this.leftMargin.getValue();
            f2 = (Float)this.rightMargin.getValue();
            Float f3 = (Float)this.topMargin.getValue();
            Float f4 = (Float)this.bottomMargin.getValue();
            float f5 = ((Float)serializable).floatValue();
            float f6 = f2.floatValue();
            float f7 = f3.floatValue();
            float f8 = f4.floatValue();
            Class<OrientationRequested> clazz = OrientationRequested.class;
            OrientationRequested orientationRequested = (OrientationRequested)ServiceDialog.this.asCurrent.get(clazz);
            if (orientationRequested == null) {
                orientationRequested = (OrientationRequested)ServiceDialog.this.psCurrent.getDefaultAttributeValue(clazz);
            }
            if (orientationRequested == OrientationRequested.REVERSE_PORTRAIT) {
                float f9 = f5;
                f5 = f6;
                f6 = f9;
                f9 = f7;
                f7 = f8;
                f8 = f9;
            } else if (orientationRequested == OrientationRequested.LANDSCAPE) {
                float f10 = f5;
                f5 = f7;
                f7 = f6;
                f6 = f8;
                f8 = f10;
            } else if (orientationRequested == OrientationRequested.REVERSE_LANDSCAPE) {
                float f11 = f5;
                f5 = f8;
                f8 = f6;
                f6 = f7;
                f7 = f11;
            }
            MediaPrintableArea mediaPrintableArea = this.validateMargins(f5, f6, f7, f8);
            if (mediaPrintableArea != null) {
                ServiceDialog.this.asCurrent.add(mediaPrintableArea);
                this.lmVal = f5;
                this.rmVal = f6;
                this.tmVal = f7;
                this.bmVal = f8;
                this.lmObj = serializable;
                this.rmObj = f2;
                this.tmObj = f3;
                this.bmObj = f4;
            } else {
                if (this.lmObj == null || this.rmObj == null || this.tmObj == null || this.rmObj == null) {
                    return;
                }
                this.leftMargin.setValue(this.lmObj);
                this.rightMargin.setValue(this.rmObj);
                this.topMargin.setValue(this.tmObj);
                this.bottomMargin.setValue(this.bmObj);
            }
        }

        private MediaPrintableArea validateMargins(float f2, float f3, float f4, float f5) {
            Serializable serializable;
            Class<MediaPrintableArea> clazz = MediaPrintableArea.class;
            MediaPrintableArea mediaPrintableArea = null;
            MediaSize mediaSize = null;
            Media media = (Media)ServiceDialog.this.asCurrent.get(Media.class);
            if (media == null || !(media instanceof MediaSizeName)) {
                media = (Media)ServiceDialog.this.psCurrent.getDefaultAttributeValue(Media.class);
            }
            if (media != null && media instanceof MediaSizeName) {
                serializable = (MediaSizeName)media;
                mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)serializable);
            }
            if (mediaSize == null) {
                mediaSize = new MediaSize(8.5f, 11.0f, 25400);
            }
            if (media != null) {
                serializable = new HashPrintRequestAttributeSet(ServiceDialog.this.asCurrent);
                serializable.add(media);
                Object object = ServiceDialog.this.psCurrent.getSupportedAttributeValues(clazz, ServiceDialog.this.docFlavor, (AttributeSet)((Object)serializable));
                if (object instanceof MediaPrintableArea[] && ((MediaPrintableArea[])object).length > 0) {
                    mediaPrintableArea = ((MediaPrintableArea[])object)[0];
                }
            }
            if (mediaPrintableArea == null) {
                mediaPrintableArea = new MediaPrintableArea(0.0f, 0.0f, mediaSize.getX(this.units), mediaSize.getY(this.units), this.units);
            }
            float f6 = mediaSize.getX(this.units);
            float f7 = mediaSize.getY(this.units);
            float f8 = f2;
            float f9 = f4;
            float f10 = f6 - f2 - f3;
            float f11 = f7 - f4 - f5;
            if (f10 <= 0.0f || f11 <= 0.0f || f8 < 0.0f || f9 < 0.0f || f8 < mediaPrintableArea.getX(this.units) || f10 > mediaPrintableArea.getWidth(this.units) || f9 < mediaPrintableArea.getY(this.units) || f11 > mediaPrintableArea.getHeight(this.units)) {
                return null;
            }
            return new MediaPrintableArea(f2, f4, f10, f11, this.units);
        }

        public void updateInfo() {
            Serializable serializable;
            if (ServiceDialog.this.isAWT) {
                this.leftMargin.setEnabled(false);
                this.rightMargin.setEnabled(false);
                this.topMargin.setEnabled(false);
                this.bottomMargin.setEnabled(false);
                this.lblLeft.setEnabled(false);
                this.lblRight.setEnabled(false);
                this.lblTop.setEnabled(false);
                this.lblBottom.setEnabled(false);
                return;
            }
            Class<MediaPrintableArea> clazz = MediaPrintableArea.class;
            MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)ServiceDialog.this.asCurrent.get(clazz);
            MediaPrintableArea mediaPrintableArea2 = null;
            MediaSize mediaSize = null;
            Media media = (Media)ServiceDialog.this.asCurrent.get(Media.class);
            if (media == null || !(media instanceof MediaSizeName)) {
                media = (Media)ServiceDialog.this.psCurrent.getDefaultAttributeValue(Media.class);
            }
            if (media != null && media instanceof MediaSizeName) {
                serializable = (MediaSizeName)media;
                mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)serializable);
            }
            if (mediaSize == null) {
                mediaSize = new MediaSize(8.5f, 11.0f, 25400);
            }
            if (media != null) {
                serializable = new HashPrintRequestAttributeSet(ServiceDialog.this.asCurrent);
                serializable.add(media);
                Object object = ServiceDialog.this.psCurrent.getSupportedAttributeValues(clazz, ServiceDialog.this.docFlavor, (AttributeSet)((Object)serializable));
                if (object instanceof MediaPrintableArea[] && ((MediaPrintableArea[])object).length > 0) {
                    mediaPrintableArea2 = ((MediaPrintableArea[])object)[0];
                } else if (object instanceof MediaPrintableArea) {
                    mediaPrintableArea2 = (MediaPrintableArea)object;
                }
            }
            if (mediaPrintableArea2 == null) {
                mediaPrintableArea2 = new MediaPrintableArea(0.0f, 0.0f, mediaSize.getX(this.units), mediaSize.getY(this.units), this.units);
            }
            float f2 = mediaSize.getX(25400);
            float f3 = mediaSize.getY(25400);
            float f4 = 5.0f;
            float f5 = f2 > f4 ? 1.0f : f2 / f4;
            float f6 = f3 > f4 ? 1.0f : f3 / f4;
            if (mediaPrintableArea == null) {
                mediaPrintableArea = new MediaPrintableArea(f5, f6, f2 - 2.0f * f5, f3 - 2.0f * f6, 25400);
                ServiceDialog.this.asCurrent.add(mediaPrintableArea);
            }
            float f7 = mediaPrintableArea.getX(this.units);
            float f8 = mediaPrintableArea.getY(this.units);
            float f9 = mediaPrintableArea.getWidth(this.units);
            float f10 = mediaPrintableArea.getHeight(this.units);
            float f11 = mediaPrintableArea2.getX(this.units);
            float f12 = mediaPrintableArea2.getY(this.units);
            float f13 = mediaPrintableArea2.getWidth(this.units);
            float f14 = mediaPrintableArea2.getHeight(this.units);
            boolean bl2 = false;
            f2 = mediaSize.getX(this.units);
            f3 = mediaSize.getY(this.units);
            if (this.lmVal >= 0.0f) {
                bl2 = true;
                if (this.lmVal + this.rmVal > f2) {
                    if (f9 > f13) {
                        f9 = f13;
                    }
                    f7 = (f2 - f9) / 2.0f;
                } else {
                    f7 = this.lmVal >= f11 ? this.lmVal : f11;
                    f9 = f2 - f7 - this.rmVal;
                }
                if (this.tmVal + this.bmVal > f3) {
                    if (f10 > f14) {
                        f10 = f14;
                    }
                    f8 = (f3 - f10) / 2.0f;
                } else {
                    f8 = this.tmVal >= f12 ? this.tmVal : f12;
                    f10 = f3 - f8 - this.bmVal;
                }
            }
            if (f7 < f11) {
                bl2 = true;
                f7 = f11;
            }
            if (f8 < f12) {
                bl2 = true;
                f8 = f12;
            }
            if (f9 > f13) {
                bl2 = true;
                f9 = f13;
            }
            if (f10 > f14) {
                bl2 = true;
                f10 = f14;
            }
            if (f7 + f9 > f11 + f13 || f9 <= 0.0f) {
                bl2 = true;
                f7 = f11;
                f9 = f13;
            }
            if (f8 + f10 > f12 + f14 || f10 <= 0.0f) {
                bl2 = true;
                f8 = f12;
                f10 = f14;
            }
            if (bl2) {
                mediaPrintableArea = new MediaPrintableArea(f7, f8, f9, f10, this.units);
                ServiceDialog.this.asCurrent.add(mediaPrintableArea);
            }
            this.lmVal = f7;
            this.tmVal = f8;
            this.rmVal = mediaSize.getX(this.units) - f7 - f9;
            this.bmVal = mediaSize.getY(this.units) - f8 - f10;
            this.lmObj = new Float(this.lmVal);
            this.rmObj = new Float(this.rmVal);
            this.tmObj = new Float(this.tmVal);
            this.bmObj = new Float(this.bmVal);
            Class<OrientationRequested> clazz2 = OrientationRequested.class;
            OrientationRequested orientationRequested = (OrientationRequested)ServiceDialog.this.asCurrent.get(clazz2);
            if (orientationRequested == null) {
                orientationRequested = (OrientationRequested)ServiceDialog.this.psCurrent.getDefaultAttributeValue(clazz2);
            }
            if (orientationRequested == OrientationRequested.REVERSE_PORTRAIT) {
                Float f15 = this.lmObj;
                this.lmObj = this.rmObj;
                this.rmObj = f15;
                f15 = this.tmObj;
                this.tmObj = this.bmObj;
                this.bmObj = f15;
            } else if (orientationRequested == OrientationRequested.LANDSCAPE) {
                Float f16 = this.lmObj;
                this.lmObj = this.bmObj;
                this.bmObj = this.rmObj;
                this.rmObj = this.tmObj;
                this.tmObj = f16;
            } else if (orientationRequested == OrientationRequested.REVERSE_LANDSCAPE) {
                Float f17 = this.lmObj;
                this.lmObj = this.tmObj;
                this.tmObj = this.rmObj;
                this.rmObj = this.bmObj;
                this.bmObj = f17;
            }
            this.leftMargin.setValue(this.lmObj);
            this.rightMargin.setValue(this.rmObj);
            this.topMargin.setValue(this.tmObj);
            this.bottomMargin.setValue(this.bmObj);
        }
    }

    private class MediaPanel
    extends JPanel
    implements ItemListener {
        private final String strTitle = ServiceDialog.access$400("border.media");
        private JLabel lblSize;
        private JLabel lblSource;
        private JComboBox cbSize;
        private JComboBox cbSource;
        private Vector sizes = new Vector();
        private Vector sources = new Vector();
        private MarginsPanel pnlMargins = null;

        public MediaPanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            this.cbSize = new JComboBox();
            this.cbSource = new JComboBox();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = compInsets;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 0.0;
            this.lblSize = new JLabel(ServiceDialog.getMsg("label.size"), 11);
            this.lblSize.setDisplayedMnemonic(ServiceDialog.getMnemonic("label.size"));
            this.lblSize.setLabelFor(this.cbSize);
            ServiceDialog.addToGB(this.lblSize, this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            ServiceDialog.addToGB(this.cbSize, this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 1;
            this.lblSource = new JLabel(ServiceDialog.getMsg("label.source"), 11);
            this.lblSource.setDisplayedMnemonic(ServiceDialog.getMnemonic("label.source"));
            this.lblSource.setLabelFor(this.cbSource);
            ServiceDialog.addToGB(this.lblSource, this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            ServiceDialog.addToGB(this.cbSource, this, gridBagLayout, gridBagConstraints);
        }

        private String getMediaName(String string) {
            try {
                String string2 = string.replace(' ', '-');
                string2 = string2.replace('#', 'n');
                return messageRB.getString(string2);
            }
            catch (MissingResourceException missingResourceException) {
                return string;
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (itemEvent.getStateChange() == 1) {
                if (object == this.cbSize) {
                    int n2 = this.cbSize.getSelectedIndex();
                    if (n2 >= 0 && n2 < this.sizes.size()) {
                        if (this.cbSource.getItemCount() > 1 && this.cbSource.getSelectedIndex() >= 1) {
                            int n3 = this.cbSource.getSelectedIndex() - 1;
                            MediaTray mediaTray = (MediaTray)this.sources.get(n3);
                            ServiceDialog.this.asCurrent.add(new SunAlternateMedia(mediaTray));
                        }
                        ServiceDialog.this.asCurrent.add((MediaSizeName)this.sizes.get(n2));
                    }
                } else if (object == this.cbSource) {
                    int n4 = this.cbSource.getSelectedIndex();
                    if (n4 >= 1 && n4 < this.sources.size() + 1) {
                        ServiceDialog.this.asCurrent.remove(SunAlternateMedia.class);
                        ServiceDialog.this.asCurrent.add((MediaTray)this.sources.get(n4 - 1));
                    } else if (n4 == 0) {
                        ServiceDialog.this.asCurrent.remove(SunAlternateMedia.class);
                        if (this.cbSize.getItemCount() > 0) {
                            int n5 = this.cbSize.getSelectedIndex();
                            ServiceDialog.this.asCurrent.add((MediaSizeName)this.sizes.get(n5));
                        }
                    }
                }
                if (this.pnlMargins != null) {
                    this.pnlMargins.updateInfo();
                }
            }
        }

        public void addMediaListener(MarginsPanel marginsPanel) {
            this.pnlMargins = marginsPanel;
        }

        public void updateInfo() {
            Media media;
            Object object;
            Class<Media> clazz = Media.class;
            Class<SunAlternateMedia> clazz2 = SunAlternateMedia.class;
            boolean bl2 = false;
            this.cbSize.removeItemListener(this);
            this.cbSize.removeAllItems();
            this.cbSource.removeItemListener(this);
            this.cbSource.removeAllItems();
            this.cbSource.addItem(this.getMediaName("auto-select"));
            this.sizes.clear();
            this.sources.clear();
            if (ServiceDialog.this.psCurrent.isAttributeCategorySupported(clazz)) {
                bl2 = true;
                Object object2 = ServiceDialog.this.psCurrent.getSupportedAttributeValues(clazz, ServiceDialog.this.docFlavor, ServiceDialog.this.asCurrent);
                if (object2 instanceof Media[]) {
                    object = (Media[])object2;
                    for (int i2 = 0; i2 < ((Media[])object).length; ++i2) {
                        media = object[i2];
                        if (media instanceof MediaSizeName) {
                            this.sizes.add(media);
                            this.cbSize.addItem(this.getMediaName(media.toString()));
                            continue;
                        }
                        if (!(media instanceof MediaTray)) continue;
                        this.sources.add(media);
                        this.cbSource.addItem(this.getMediaName(media.toString()));
                    }
                }
            }
            boolean bl3 = bl2 && this.sizes.size() > 0;
            this.lblSize.setEnabled(bl3);
            this.cbSize.setEnabled(bl3);
            if (ServiceDialog.this.isAWT) {
                this.cbSource.setEnabled(false);
                this.lblSource.setEnabled(false);
            } else {
                this.cbSource.setEnabled(bl2);
            }
            if (bl2) {
                int n2;
                object = (Media)ServiceDialog.this.asCurrent.get(clazz);
                if (object == null || !ServiceDialog.this.psCurrent.isAttributeValueSupported((Attribute)object, ServiceDialog.this.docFlavor, ServiceDialog.this.asCurrent)) {
                    object = (Media)ServiceDialog.this.psCurrent.getDefaultAttributeValue(clazz);
                    if (object == null && this.sizes.size() > 0) {
                        object = (Media)this.sizes.get(0);
                    }
                    if (object != null) {
                        ServiceDialog.this.asCurrent.add((Attribute)object);
                    }
                }
                if (object != null) {
                    if (object instanceof MediaSizeName) {
                        MediaSizeName mediaSizeName = (MediaSizeName)object;
                        this.cbSize.setSelectedIndex(this.sizes.indexOf(mediaSizeName));
                    } else if (object instanceof MediaTray) {
                        MediaTray mediaTray = (MediaTray)object;
                        this.cbSource.setSelectedIndex(this.sources.indexOf(mediaTray) + 1);
                    }
                } else {
                    this.cbSize.setSelectedIndex(this.sizes.size() > 0 ? 0 : -1);
                    this.cbSource.setSelectedIndex(0);
                }
                SunAlternateMedia sunAlternateMedia = (SunAlternateMedia)ServiceDialog.this.asCurrent.get(clazz2);
                if (sunAlternateMedia != null && (media = sunAlternateMedia.getMedia()) instanceof MediaTray) {
                    MediaTray mediaTray = (MediaTray)media;
                    this.cbSource.setSelectedIndex(this.sources.indexOf(mediaTray) + 1);
                }
                if ((n2 = this.cbSize.getSelectedIndex()) >= 0 && n2 < this.sizes.size()) {
                    ServiceDialog.this.asCurrent.add((MediaSizeName)this.sizes.get(n2));
                }
                if ((n2 = this.cbSource.getSelectedIndex()) >= 1 && n2 < this.sources.size() + 1) {
                    ServiceDialog.this.asCurrent.add((MediaTray)this.sources.get(n2 - 1));
                }
            }
            this.cbSize.addItemListener(this);
            this.cbSource.addItemListener(this);
        }
    }

    private class OrientationPanel
    extends JPanel
    implements ActionListener {
        private final String strTitle = ServiceDialog.access$400("border.orientation");
        private IconRadioButton rbPortrait;
        private IconRadioButton rbLandscape;
        private IconRadioButton rbRevPortrait;
        private IconRadioButton rbRevLandscape;
        private MarginsPanel pnlMargins = null;

        public OrientationPanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = compInsets;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 0;
            ButtonGroup buttonGroup = new ButtonGroup();
            this.rbPortrait = new IconRadioButton("radiobutton.portrait", "orientPortrait.gif", true, buttonGroup, this);
            this.rbPortrait.addActionListener(this);
            ServiceDialog.addToGB(this.rbPortrait, this, gridBagLayout, gridBagConstraints);
            this.rbLandscape = new IconRadioButton("radiobutton.landscape", "orientLandscape.gif", false, buttonGroup, this);
            this.rbLandscape.addActionListener(this);
            ServiceDialog.addToGB(this.rbLandscape, this, gridBagLayout, gridBagConstraints);
            this.rbRevPortrait = new IconRadioButton("radiobutton.revportrait", "orientRevPortrait.gif", false, buttonGroup, this);
            this.rbRevPortrait.addActionListener(this);
            ServiceDialog.addToGB(this.rbRevPortrait, this, gridBagLayout, gridBagConstraints);
            this.rbRevLandscape = new IconRadioButton("radiobutton.revlandscape", "orientRevLandscape.gif", false, buttonGroup, this);
            this.rbRevLandscape.addActionListener(this);
            ServiceDialog.addToGB(this.rbRevLandscape, this, gridBagLayout, gridBagConstraints);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (this.rbPortrait.isSameAs(object)) {
                ServiceDialog.this.asCurrent.add(OrientationRequested.PORTRAIT);
            } else if (this.rbLandscape.isSameAs(object)) {
                ServiceDialog.this.asCurrent.add(OrientationRequested.LANDSCAPE);
            } else if (this.rbRevPortrait.isSameAs(object)) {
                ServiceDialog.this.asCurrent.add(OrientationRequested.REVERSE_PORTRAIT);
            } else if (this.rbRevLandscape.isSameAs(object)) {
                ServiceDialog.this.asCurrent.add(OrientationRequested.REVERSE_LANDSCAPE);
            }
            if (this.pnlMargins != null) {
                this.pnlMargins.updateInfo();
            }
        }

        void addOrientationListener(MarginsPanel marginsPanel) {
            this.pnlMargins = marginsPanel;
        }

        public void updateInfo() {
            Object object;
            Object object2;
            Class<OrientationRequested> clazz = OrientationRequested.class;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            if (ServiceDialog.this.isAWT) {
                bl2 = true;
                bl3 = true;
            } else if (ServiceDialog.this.psCurrent.isAttributeCategorySupported(clazz) && (object2 = ServiceDialog.this.psCurrent.getSupportedAttributeValues(clazz, ServiceDialog.this.docFlavor, ServiceDialog.this.asCurrent)) instanceof OrientationRequested[]) {
                object = (OrientationRequested[])object2;
                for (int i2 = 0; i2 < ((OrientationRequested[])object).length; ++i2) {
                    OrientationRequested orientationRequested = object[i2];
                    if (orientationRequested == OrientationRequested.PORTRAIT) {
                        bl2 = true;
                        continue;
                    }
                    if (orientationRequested == OrientationRequested.LANDSCAPE) {
                        bl3 = true;
                        continue;
                    }
                    if (orientationRequested == OrientationRequested.REVERSE_PORTRAIT) {
                        bl4 = true;
                        continue;
                    }
                    if (orientationRequested != OrientationRequested.REVERSE_LANDSCAPE) continue;
                    bl5 = true;
                }
            }
            this.rbPortrait.setEnabled(bl2);
            this.rbLandscape.setEnabled(bl3);
            this.rbRevPortrait.setEnabled(bl4);
            this.rbRevLandscape.setEnabled(bl5);
            object2 = (OrientationRequested)ServiceDialog.this.asCurrent.get(clazz);
            if (object2 == null || !ServiceDialog.this.psCurrent.isAttributeValueSupported((Attribute)object2, ServiceDialog.this.docFlavor, ServiceDialog.this.asCurrent)) {
                object2 = (OrientationRequested)ServiceDialog.this.psCurrent.getDefaultAttributeValue(clazz);
                if (!ServiceDialog.this.psCurrent.isAttributeValueSupported((Attribute)object2, ServiceDialog.this.docFlavor, ServiceDialog.this.asCurrent)) {
                    Object object3;
                    object2 = null;
                    object = ServiceDialog.this.psCurrent.getSupportedAttributeValues(clazz, ServiceDialog.this.docFlavor, ServiceDialog.this.asCurrent);
                    if (object instanceof OrientationRequested[] && ((OrientationRequested[])(object3 = object)).length > 1) {
                        object2 = object3[0];
                    }
                }
                if (object2 == null) {
                    object2 = OrientationRequested.PORTRAIT;
                }
                ServiceDialog.this.asCurrent.add((Attribute)object2);
            }
            if (object2 == OrientationRequested.PORTRAIT) {
                this.rbPortrait.setSelected(true);
            } else if (object2 == OrientationRequested.LANDSCAPE) {
                this.rbLandscape.setSelected(true);
            } else if (object2 == OrientationRequested.REVERSE_PORTRAIT) {
                this.rbRevPortrait.setSelected(true);
            } else {
                this.rbRevLandscape.setSelected(true);
            }
        }
    }

    private class PageSetupPanel
    extends JPanel {
        private MediaPanel pnlMedia;
        private OrientationPanel pnlOrientation;
        private MarginsPanel pnlMargins;

        public PageSetupPanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = panelInsets;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 0;
            this.pnlMedia = new MediaPanel();
            ServiceDialog.addToGB(this.pnlMedia, this, gridBagLayout, gridBagConstraints);
            this.pnlOrientation = new OrientationPanel();
            gridBagConstraints.gridwidth = -1;
            ServiceDialog.addToGB(this.pnlOrientation, this, gridBagLayout, gridBagConstraints);
            this.pnlMargins = new MarginsPanel();
            this.pnlOrientation.addOrientationListener(this.pnlMargins);
            this.pnlMedia.addMediaListener(this.pnlMargins);
            gridBagConstraints.gridwidth = 0;
            ServiceDialog.addToGB(this.pnlMargins, this, gridBagLayout, gridBagConstraints);
        }

        public void updateInfo() {
            this.pnlMedia.updateInfo();
            this.pnlOrientation.updateInfo();
            this.pnlMargins.updateInfo();
        }
    }

    private class PrintRangePanel
    extends JPanel
    implements ActionListener,
    FocusListener {
        private final String strTitle = ServiceDialog.access$400("border.printrange");
        private final PageRanges prAll = new PageRanges(1, Integer.MAX_VALUE);
        private JRadioButton rbAll;
        private JRadioButton rbPages;
        private JRadioButton rbSelect;
        private JFormattedTextField tfRangeFrom;
        private JFormattedTextField tfRangeTo;
        private JLabel lblRangeTo;
        private boolean prSupported;

        public PrintRangePanel() {
            NumberFormatter numberFormatter;
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = compInsets;
            gridBagConstraints.gridwidth = 0;
            ButtonGroup buttonGroup = new ButtonGroup();
            JPanel jPanel = new JPanel(new FlowLayout(3));
            this.rbAll = ServiceDialog.createRadioButton("radiobutton.rangeall", this);
            this.rbAll.setSelected(true);
            buttonGroup.add(this.rbAll);
            jPanel.add(this.rbAll);
            ServiceDialog.addToGB(jPanel, this, gridBagLayout, gridBagConstraints);
            JPanel jPanel2 = new JPanel(new FlowLayout(3));
            this.rbPages = ServiceDialog.createRadioButton("radiobutton.rangepages", this);
            buttonGroup.add(this.rbPages);
            jPanel2.add(this.rbPages);
            DecimalFormat decimalFormat = new DecimalFormat("####0");
            decimalFormat.setMinimumFractionDigits(0);
            decimalFormat.setMaximumFractionDigits(0);
            decimalFormat.setMinimumIntegerDigits(0);
            decimalFormat.setMaximumIntegerDigits(5);
            decimalFormat.setParseIntegerOnly(true);
            decimalFormat.setDecimalSeparatorAlwaysShown(false);
            NumberFormatter numberFormatter2 = new NumberFormatter(decimalFormat);
            numberFormatter2.setMinimum(new Integer(1));
            numberFormatter2.setMaximum(new Integer(Integer.MAX_VALUE));
            numberFormatter2.setAllowsInvalid(true);
            numberFormatter2.setCommitsOnValidEdit(true);
            this.tfRangeFrom = new JFormattedTextField(numberFormatter2);
            this.tfRangeFrom.setColumns(4);
            this.tfRangeFrom.setEnabled(false);
            this.tfRangeFrom.addActionListener(this);
            this.tfRangeFrom.addFocusListener(this);
            this.tfRangeFrom.setFocusLostBehavior(3);
            this.tfRangeFrom.getAccessibleContext().setAccessibleName(ServiceDialog.getMsg("radiobutton.rangepages"));
            jPanel2.add(this.tfRangeFrom);
            this.lblRangeTo = new JLabel(ServiceDialog.getMsg("label.rangeto"));
            this.lblRangeTo.setEnabled(false);
            jPanel2.add(this.lblRangeTo);
            try {
                numberFormatter = (NumberFormatter)numberFormatter2.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                numberFormatter = new NumberFormatter();
            }
            this.tfRangeTo = new JFormattedTextField(numberFormatter);
            this.tfRangeTo.setColumns(4);
            this.tfRangeTo.setEnabled(false);
            this.tfRangeTo.addFocusListener(this);
            this.tfRangeTo.getAccessibleContext().setAccessibleName(ServiceDialog.getMsg("label.rangeto"));
            jPanel2.add(this.tfRangeTo);
            ServiceDialog.addToGB(jPanel2, this, gridBagLayout, gridBagConstraints);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            SunPageSelection sunPageSelection = SunPageSelection.ALL;
            this.setupRangeWidgets();
            if (object == this.rbAll) {
                ServiceDialog.this.asCurrent.add(this.prAll);
            } else if (object == this.rbSelect) {
                sunPageSelection = SunPageSelection.SELECTION;
            } else if (object == this.rbPages || object == this.tfRangeFrom || object == this.tfRangeTo) {
                this.updateRangeAttribute();
                sunPageSelection = SunPageSelection.RANGE;
            }
            if (ServiceDialog.this.isAWT) {
                ServiceDialog.this.asCurrent.add(sunPageSelection);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            Object object = focusEvent.getSource();
            if (object == this.tfRangeFrom || object == this.tfRangeTo) {
                this.updateRangeAttribute();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        private void setupRangeWidgets() {
            boolean bl2 = this.rbPages.isSelected() && this.prSupported;
            this.tfRangeFrom.setEnabled(bl2);
            this.tfRangeTo.setEnabled(bl2);
            this.lblRangeTo.setEnabled(bl2);
        }

        private void updateRangeAttribute() {
            int n2;
            int n3;
            String string = this.tfRangeFrom.getText();
            String string2 = this.tfRangeTo.getText();
            try {
                n3 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n3 = 1;
            }
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = n3;
            }
            if (n3 < 1) {
                n3 = 1;
                this.tfRangeFrom.setValue(new Integer(1));
            }
            if (n2 < n3) {
                n2 = n3;
                this.tfRangeTo.setValue(new Integer(n3));
            }
            PageRanges pageRanges = new PageRanges(n3, n2);
            ServiceDialog.this.asCurrent.add(pageRanges);
        }

        public void updateInfo() {
            Class<PageRanges> clazz = PageRanges.class;
            this.prSupported = false;
            if (ServiceDialog.this.psCurrent.isAttributeCategorySupported(clazz) || ServiceDialog.this.isAWT) {
                this.prSupported = true;
            }
            SunPageSelection sunPageSelection = SunPageSelection.ALL;
            int n2 = 1;
            int n3 = 1;
            PageRanges pageRanges = (PageRanges)ServiceDialog.this.asCurrent.get(clazz);
            if (pageRanges != null && !pageRanges.equals(this.prAll)) {
                sunPageSelection = SunPageSelection.RANGE;
                int[][] nArray = pageRanges.getMembers();
                if (nArray.length > 0 && nArray[0].length > 1) {
                    n2 = nArray[0][0];
                    n3 = nArray[0][1];
                }
            }
            if (ServiceDialog.this.isAWT) {
                sunPageSelection = (SunPageSelection)ServiceDialog.this.asCurrent.get(SunPageSelection.class);
            }
            if (sunPageSelection == SunPageSelection.ALL) {
                this.rbAll.setSelected(true);
            } else if (sunPageSelection != SunPageSelection.SELECTION) {
                this.rbPages.setSelected(true);
            }
            this.tfRangeFrom.setValue(new Integer(n2));
            this.tfRangeTo.setValue(new Integer(n3));
            this.rbAll.setEnabled(this.prSupported);
            this.rbPages.setEnabled(this.prSupported);
            this.setupRangeWidgets();
        }
    }

    private class PrintServicePanel
    extends JPanel
    implements ActionListener,
    ItemListener,
    PopupMenuListener {
        private final String strTitle = ServiceDialog.access$400("border.printservice");
        private FilePermission printToFilePermission;
        private JButton btnProperties;
        private JCheckBox cbPrintToFile;
        private JComboBox cbName;
        private JLabel lblType;
        private JLabel lblStatus;
        private JLabel lblInfo;
        private ServiceUIFactory uiFactory;
        private boolean changedService = false;

        public PrintServicePanel() {
            this.uiFactory = ServiceDialog.this.psCurrent.getServiceUIFactory();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            Object[] objectArray = new String[ServiceDialog.this.services.length];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                objectArray[i2] = ServiceDialog.this.services[i2].getName();
            }
            this.cbName = new JComboBox(objectArray);
            this.cbName.setSelectedIndex(ServiceDialog.this.defaultServiceIndex);
            this.cbName.addItemListener(this);
            this.cbName.addPopupMenuListener(this);
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = compInsets;
            gridBagConstraints.weightx = 0.0;
            JLabel jLabel = new JLabel(ServiceDialog.getMsg("label.psname"), 11);
            jLabel.setDisplayedMnemonic(ServiceDialog.getMnemonic("label.psname"));
            jLabel.setLabelFor(this.cbName);
            ServiceDialog.addToGB(jLabel, this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = -1;
            ServiceDialog.addToGB(this.cbName, this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 0;
            this.btnProperties = ServiceDialog.createButton("button.properties", this);
            ServiceDialog.addToGB(this.btnProperties, this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.weighty = 1.0;
            this.lblStatus = this.addLabel(ServiceDialog.getMsg("label.status"), gridBagLayout, gridBagConstraints);
            this.lblStatus.setLabelFor(null);
            this.lblType = this.addLabel(ServiceDialog.getMsg("label.pstype"), gridBagLayout, gridBagConstraints);
            this.lblType.setLabelFor(null);
            gridBagConstraints.gridwidth = 1;
            ServiceDialog.addToGB(new JLabel(ServiceDialog.getMsg("label.info"), 11), this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.gridwidth = -1;
            this.lblInfo = new JLabel();
            this.lblInfo.setForeground(Color.black);
            this.lblInfo.setLabelFor(null);
            ServiceDialog.addToGB(this.lblInfo, this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            this.cbPrintToFile = ServiceDialog.createCheckBox("checkbox.printtofile", this);
            ServiceDialog.addToGB(this.cbPrintToFile, this, gridBagLayout, gridBagConstraints);
        }

        public boolean isPrintToFileSelected() {
            return this.cbPrintToFile.isSelected();
        }

        private JLabel addLabel(String string, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
            gridBagConstraints.gridwidth = 1;
            ServiceDialog.addToGB(new JLabel(string, 11), this, gridBagLayout, gridBagConstraints);
            gridBagConstraints.gridwidth = 0;
            JLabel jLabel = new JLabel();
            jLabel.setForeground(Color.black);
            ServiceDialog.addToGB(jLabel, this, gridBagLayout, gridBagConstraints);
            return jLabel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.btnProperties && this.uiFactory != null) {
                JDialog jDialog = (JDialog)this.uiFactory.getUI(3, "javax.swing.JDialog");
                if (jDialog != null) {
                    jDialog.show();
                } else {
                    this.btnProperties.setEnabled(false);
                }
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            int n2;
            if (itemEvent.getStateChange() == 1 && (n2 = this.cbName.getSelectedIndex()) >= 0 && n2 < ServiceDialog.this.services.length && !((Object)ServiceDialog.this.services[n2]).equals(ServiceDialog.this.psCurrent)) {
                ServiceDialog.this.psCurrent = ServiceDialog.this.services[n2];
                this.uiFactory = ServiceDialog.this.psCurrent.getServiceUIFactory();
                this.changedService = true;
                if (this.isPrintToFileSelected() && ServiceDialog.this.psCurrent.isAttributeCategorySupported(Destination.class)) {
                    Destination destination = (Destination)ServiceDialog.this.asOriginal.get(Destination.class);
                    if (destination != null) {
                        ServiceDialog.this.asCurrent.add(destination);
                    } else {
                        ServiceDialog.this.asCurrent.add(new Destination(new File("out.prn").toURI()));
                    }
                } else {
                    ServiceDialog.this.asCurrent.remove(Destination.class);
                }
            }
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            this.changedService = false;
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            if (this.changedService) {
                this.changedService = false;
                ServiceDialog.this.updatePanels();
            }
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        private boolean allowedToPrintToFile() {
            try {
                this.throwPrintToFile();
                return true;
            }
            catch (SecurityException securityException) {
                return false;
            }
        }

        private void throwPrintToFile() {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                if (this.printToFilePermission == null) {
                    this.printToFilePermission = new FilePermission("<<ALL FILES>>", "read,write");
                }
                securityManager.checkPermission(this.printToFilePermission);
            }
        }

        public void updateInfo() {
            PrinterInfo printerInfo;
            PrinterIsAcceptingJobs printerIsAcceptingJobs;
            Destination destination;
            Class<Destination> clazz = Destination.class;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = this.allowedToPrintToFile();
            if (ServiceDialog.this.psCurrent.isAttributeCategorySupported(clazz)) {
                bl2 = true;
            }
            if ((destination = (Destination)ServiceDialog.this.asCurrent.get(clazz)) != null) {
                bl3 = true;
            }
            this.cbPrintToFile.setEnabled(bl2 && bl4);
            this.cbPrintToFile.setSelected(bl3 && bl4);
            PrinterMakeAndModel printerMakeAndModel = ServiceDialog.this.psCurrent.getAttribute(PrinterMakeAndModel.class);
            if (printerMakeAndModel != null) {
                this.lblType.setText(((Object)printerMakeAndModel).toString());
            }
            if ((printerIsAcceptingJobs = ServiceDialog.this.psCurrent.getAttribute(PrinterIsAcceptingJobs.class)) != null) {
                this.lblStatus.setText(ServiceDialog.getMsg(((Object)printerIsAcceptingJobs).toString()));
            }
            if ((printerInfo = ServiceDialog.this.psCurrent.getAttribute(PrinterInfo.class)) != null) {
                this.lblInfo.setText(((Object)printerInfo).toString());
            }
            this.btnProperties.setEnabled(this.uiFactory != null);
        }
    }

    private class QualityPanel
    extends JPanel
    implements ActionListener {
        private final String strTitle = ServiceDialog.access$400("border.quality");
        private JRadioButton rbDraft;
        private JRadioButton rbNormal;
        private JRadioButton rbHigh;

        public QualityPanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weighty = 1.0;
            ButtonGroup buttonGroup = new ButtonGroup();
            this.rbDraft = ServiceDialog.createRadioButton("radiobutton.draftq", this);
            buttonGroup.add(this.rbDraft);
            ServiceDialog.addToGB(this.rbDraft, this, gridBagLayout, gridBagConstraints);
            this.rbNormal = ServiceDialog.createRadioButton("radiobutton.normalq", this);
            this.rbNormal.setSelected(true);
            buttonGroup.add(this.rbNormal);
            ServiceDialog.addToGB(this.rbNormal, this, gridBagLayout, gridBagConstraints);
            this.rbHigh = ServiceDialog.createRadioButton("radiobutton.highq", this);
            buttonGroup.add(this.rbHigh);
            ServiceDialog.addToGB(this.rbHigh, this, gridBagLayout, gridBagConstraints);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.rbDraft) {
                ServiceDialog.this.asCurrent.add(PrintQuality.DRAFT);
            } else if (object == this.rbNormal) {
                ServiceDialog.this.asCurrent.add(PrintQuality.NORMAL);
            } else if (object == this.rbHigh) {
                ServiceDialog.this.asCurrent.add(PrintQuality.HIGH);
            }
        }

        public void updateInfo() {
            Object object;
            Class<PrintQuality> clazz = PrintQuality.class;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            if (ServiceDialog.this.isAWT) {
                bl2 = true;
                bl3 = true;
                bl4 = true;
            } else if (ServiceDialog.this.psCurrent.isAttributeCategorySupported(clazz) && (object = ServiceDialog.this.psCurrent.getSupportedAttributeValues(clazz, ServiceDialog.this.docFlavor, ServiceDialog.this.asCurrent)) instanceof PrintQuality[]) {
                PrintQuality[] printQualityArray = (PrintQuality[])object;
                for (int i2 = 0; i2 < printQualityArray.length; ++i2) {
                    PrintQuality printQuality = printQualityArray[i2];
                    if (printQuality == PrintQuality.DRAFT) {
                        bl2 = true;
                        continue;
                    }
                    if (printQuality == PrintQuality.NORMAL) {
                        bl3 = true;
                        continue;
                    }
                    if (printQuality != PrintQuality.HIGH) continue;
                    bl4 = true;
                }
            }
            this.rbDraft.setEnabled(bl2);
            this.rbNormal.setEnabled(bl3);
            this.rbHigh.setEnabled(bl4);
            object = (PrintQuality)ServiceDialog.this.asCurrent.get(clazz);
            if (object == null && (object = (PrintQuality)ServiceDialog.this.psCurrent.getDefaultAttributeValue(clazz)) == null) {
                object = PrintQuality.NORMAL;
            }
            if (object == PrintQuality.DRAFT) {
                this.rbDraft.setSelected(true);
            } else if (object == PrintQuality.NORMAL) {
                this.rbNormal.setSelected(true);
            } else {
                this.rbHigh.setSelected(true);
            }
        }
    }

    private class SidesPanel
    extends JPanel
    implements ActionListener {
        private final String strTitle = ServiceDialog.access$400("border.sides");
        private IconRadioButton rbOneSide;
        private IconRadioButton rbTumble;
        private IconRadioButton rbDuplex;

        public SidesPanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = compInsets;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 0;
            ButtonGroup buttonGroup = new ButtonGroup();
            this.rbOneSide = new IconRadioButton("radiobutton.oneside", "oneside.gif", true, buttonGroup, this);
            this.rbOneSide.addActionListener(this);
            ServiceDialog.addToGB(this.rbOneSide, this, gridBagLayout, gridBagConstraints);
            this.rbTumble = new IconRadioButton("radiobutton.tumble", "tumble.gif", false, buttonGroup, this);
            this.rbTumble.addActionListener(this);
            ServiceDialog.addToGB(this.rbTumble, this, gridBagLayout, gridBagConstraints);
            this.rbDuplex = new IconRadioButton("radiobutton.duplex", "duplex.gif", false, buttonGroup, this);
            this.rbDuplex.addActionListener(this);
            gridBagConstraints.gridwidth = 0;
            ServiceDialog.addToGB(this.rbDuplex, this, gridBagLayout, gridBagConstraints);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (this.rbOneSide.isSameAs(object)) {
                ServiceDialog.this.asCurrent.add(Sides.ONE_SIDED);
            } else if (this.rbTumble.isSameAs(object)) {
                ServiceDialog.this.asCurrent.add(Sides.TUMBLE);
            } else if (this.rbDuplex.isSameAs(object)) {
                ServiceDialog.this.asCurrent.add(Sides.DUPLEX);
            }
        }

        public void updateInfo() {
            Object object;
            Class<Sides> clazz = Sides.class;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            if (ServiceDialog.this.psCurrent.isAttributeCategorySupported(clazz) && (object = ServiceDialog.this.psCurrent.getSupportedAttributeValues(clazz, ServiceDialog.this.docFlavor, ServiceDialog.this.asCurrent)) instanceof Sides[]) {
                Sides[] sidesArray = (Sides[])object;
                for (int i2 = 0; i2 < sidesArray.length; ++i2) {
                    Sides sides = sidesArray[i2];
                    if (sides == Sides.ONE_SIDED) {
                        bl2 = true;
                        continue;
                    }
                    if (sides == Sides.TUMBLE) {
                        bl3 = true;
                        continue;
                    }
                    if (sides != Sides.DUPLEX) continue;
                    bl4 = true;
                }
            }
            this.rbOneSide.setEnabled(bl2);
            this.rbTumble.setEnabled(bl3);
            this.rbDuplex.setEnabled(bl4);
            object = (Sides)ServiceDialog.this.asCurrent.get(clazz);
            if (object == null && (object = (Sides)ServiceDialog.this.psCurrent.getDefaultAttributeValue(clazz)) == null) {
                object = Sides.ONE_SIDED;
            }
            if (object == Sides.ONE_SIDED) {
                this.rbOneSide.setSelected(true);
            } else if (object == Sides.TUMBLE) {
                this.rbTumble.setSelected(true);
            } else {
                this.rbDuplex.setSelected(true);
            }
        }
    }

    private class ValidatingFileChooser
    extends JFileChooser {
        private ValidatingFileChooser() {
        }

        public void approveSelection() {
            boolean bl2;
            File file = this.getSelectedFile();
            try {
                bl2 = file.exists();
            }
            catch (SecurityException securityException) {
                bl2 = false;
            }
            if (bl2) {
                int n2 = JOptionPane.showConfirmDialog(this, ServiceDialog.getMsg("dialog.overwrite"), ServiceDialog.getMsg("dialog.owtitle"), 0);
                if (n2 == 0) {
                    super.approveSelection();
                }
            } else {
                super.approveSelection();
            }
        }
    }
}

