/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Color;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class XSettings {
    private long serial = -1L;

    public Map update(byte[] byArray) {
        return new Update(byArray).update();
    }

    class Update {
        private static final int LITTLE_ENDIAN = 0;
        private static final int BIG_ENDIAN = 1;
        private static final int TYPE_INTEGER = 0;
        private static final int TYPE_STRING = 1;
        private static final int TYPE_COLOR = 2;
        private byte[] data;
        private int dlen;
        private int idx;
        private boolean isLittle;
        private long serial = -1L;
        private int nsettings = 0;
        private boolean isValid;
        private HashMap updatedSettings;

        Update(byte[] byArray) {
            this.data = byArray;
            this.dlen = byArray.length;
            if (this.dlen < 12) {
                return;
            }
            this.idx = 0;
            this.isLittle = this.getCARD8() == 0;
            this.idx = 4;
            this.serial = this.getCARD32();
            this.idx = 8;
            this.nsettings = this.getINT32();
            this.updatedSettings = new HashMap();
            this.isValid = true;
        }

        private void needBytes(int n2) throws IndexOutOfBoundsException {
            if (this.idx + n2 <= this.dlen) {
                return;
            }
            throw new IndexOutOfBoundsException("at " + this.idx + " need " + n2 + " length " + this.dlen);
        }

        private int getCARD8() throws IndexOutOfBoundsException {
            this.needBytes(1);
            int n2 = this.data[this.idx] & 0xFF;
            ++this.idx;
            return n2;
        }

        private int getCARD16() throws IndexOutOfBoundsException {
            this.needBytes(2);
            int n2 = this.isLittle ? this.data[this.idx + 0] & 0xFF | (this.data[this.idx + 1] & 0xFF) << 8 : (this.data[this.idx + 0] & 0xFF) << 8 | this.data[this.idx + 1] & 0xFF;
            this.idx += 2;
            return n2;
        }

        private int getINT32() throws IndexOutOfBoundsException {
            this.needBytes(4);
            int n2 = this.isLittle ? this.data[this.idx + 0] & 0xFF | (this.data[this.idx + 1] & 0xFF) << 8 | (this.data[this.idx + 2] & 0xFF) << 16 | (this.data[this.idx + 3] & 0xFF) << 24 : (this.data[this.idx + 0] & 0xFF) << 24 | (this.data[this.idx + 1] & 0xFF) << 16 | (this.data[this.idx + 2] & 0xFF) << 8 | (this.data[this.idx + 3] & 0xFF) << 0;
            this.idx += 4;
            return n2;
        }

        private long getCARD32() throws IndexOutOfBoundsException {
            return (long)this.getINT32() & 0xFFFFFFFFL;
        }

        private String getString(int n2) throws IndexOutOfBoundsException {
            this.needBytes(n2);
            String string = null;
            try {
                string = new String(this.data, this.idx, n2, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.idx = this.idx + n2 + 3 & 0xFFFFFFFC;
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map update() {
            if (!this.isValid) {
                return null;
            }
            XSettings xSettings = XSettings.this;
            synchronized (xSettings) {
                long l2 = XSettings.this.serial;
                if (this.serial <= l2) {
                    return null;
                }
                for (int i2 = 0; i2 < this.nsettings && this.idx < this.dlen; ++i2) {
                    this.updateOne(l2);
                }
                XSettings.this.serial = this.serial;
            }
            return this.updatedSettings;
        }

        private void updateOne(long l2) throws IndexOutOfBoundsException, IllegalArgumentException {
            int n2 = this.getCARD8();
            ++this.idx;
            int n3 = this.getCARD16();
            int n4 = this.idx;
            this.idx = this.idx + n3 + 3 & 0xFFFFFFFC;
            long l3 = this.getCARD32();
            if (l3 <= l2) {
                if (n2 == 0) {
                    this.idx += 4;
                } else if (n2 == 1) {
                    int n5 = this.getINT32();
                    this.idx = this.idx + n5 + 3 & 0xFFFFFFFC;
                } else if (n2 == 2) {
                    this.idx += 8;
                } else {
                    throw new IllegalArgumentException("Unknown type: " + n2);
                }
                return;
            }
            this.idx = n4;
            String string = this.getString(n3);
            this.idx += 4;
            Object object = null;
            if (n2 == 0) {
                object = new Integer(this.getINT32());
            } else if (n2 == 1) {
                object = this.getString(this.getINT32());
            } else if (n2 == 2) {
                int n6 = this.getCARD16();
                int n7 = this.getCARD16();
                int n8 = this.getCARD16();
                int n9 = this.getCARD16();
                object = new Color((float)n6 / 65535.0f, (float)n7 / 65535.0f, (float)n8 / 65535.0f, (float)n9 / 65535.0f);
            } else {
                throw new IllegalArgumentException("Unknown type: " + n2);
            }
            if (string == null) {
                return;
            }
            this.updatedSettings.put(string, object);
        }
    }
}

