/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.SunToolkit;
import sun.awt.X11.MotifColorUtilities;
import sun.awt.X11.XScrollRepeater;
import sun.awt.X11.XScrollbarClient;
import sun.awt.X11GraphicsConfig;

abstract class XScrollbar {
    private static Logger log = Logger.getLogger("sun.awt.X11.XScrollbar");
    private static XScrollRepeater scroller = new XScrollRepeater(null);
    private static final int MIN_THUMB_H = 5;
    private static final int ARROW_IND = 1;
    XScrollbarClient sb;
    private int val;
    private int min;
    private int max;
    private int vis;
    private int line;
    private int page;
    private boolean needsRepaint = true;
    private boolean pressed = false;
    private boolean dragging = false;
    Polygon firstArrow;
    Polygon secondArrow;
    int width;
    int height;
    int barWidth;
    int barLength;
    int arrowArea;
    int alignment;
    public static final int ALIGNMENT_VERTICAL = 1;
    public static final int ALIGNMENT_HORIZONTAL = 2;
    int mode;
    Point thumbOffset;
    private Rectangle prevThumb;

    public XScrollbar(int n2, XScrollbarClient xScrollbarClient) {
        this.sb = xScrollbarClient;
        this.alignment = n2;
    }

    public boolean needsRepaint() {
        return this.needsRepaint;
    }

    void notifyValue(int n2) {
        this.notifyValue(n2, false);
    }

    void notifyValue(int n2, final boolean bl2) {
        if (n2 < this.min) {
            n2 = this.min;
        } else if (n2 > this.max - this.vis) {
            n2 = this.max - this.vis;
        }
        final int n3 = n2;
        final int n4 = this.mode;
        if (!(this.sb == null || n3 == this.val && this.pressed)) {
            SunToolkit.executeOnEventHandlerThread(this.sb.getEventSource(), new Runnable(){

                public void run() {
                    XScrollbar.this.sb.notifyValue(XScrollbar.this, n4, n3, bl2);
                }
            });
        }
    }

    protected abstract void rebuildArrows();

    public void setSize(int n2, int n3) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Setting scroll bar " + this + " size to " + n2 + "x" + n3);
        }
        this.width = n2;
        this.height = n3;
    }

    protected Polygon createArrowShape(boolean bl2, boolean bl3) {
        Polygon polygon = new Polygon();
        if (bl2) {
            int n2 = this.width / 2 - this.getArrowWidth() / 2;
            int n3 = bl3 ? 1 : this.barLength - 1;
            int n4 = bl3 ? this.getArrowWidth() : this.barLength - this.getArrowWidth() - 1;
            polygon.addPoint(n2 + this.getArrowWidth() / 2, n3);
            polygon.addPoint(n2 + this.getArrowWidth(), n4);
            polygon.addPoint(n2, n4);
            polygon.addPoint(n2 + this.getArrowWidth() / 2, n3);
        } else {
            int n5 = this.height / 2 - this.getArrowWidth() / 2;
            int n6 = bl3 ? 1 : this.barLength - 1;
            int n7 = bl3 ? this.getArrowWidth() : this.barLength - this.getArrowWidth() - 1;
            polygon.addPoint(n6, n5 + this.getArrowWidth() / 2);
            polygon.addPoint(n7, n5 + this.getArrowWidth());
            polygon.addPoint(n7, n5);
            polygon.addPoint(n6, n5 + this.getArrowWidth() / 2);
        }
        return polygon;
    }

    protected abstract Rectangle getThumbArea();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paint(Graphics graphics, Color[] colorArray, boolean bl2) {
        Object object;
        if (log.isLoggable(Level.FINER)) {
            log.finer("Painting scrollbar " + this);
        }
        boolean bl3 = false;
        Graphics2D graphics2D = null;
        BufferedImage bufferedImage = null;
        if (!(graphics instanceof Graphics2D)) {
            object = (X11GraphicsConfig)this.sb.getEventSource().getGraphicsConfiguration();
            bufferedImage = ((X11GraphicsConfig)object).createCompatibleImage(this.width, this.height);
            graphics2D = bufferedImage.createGraphics();
            bl3 = true;
        } else {
            graphics2D = (Graphics2D)graphics;
        }
        try {
            this.prevThumb = object = this.calculateThumbRect();
            Color color = colorArray[0];
            Color color2 = new Color(MotifColorUtilities.calculateSelectFromBackground(color.getRed(), color.getGreen(), color.getBlue()));
            Color color3 = new Color(MotifColorUtilities.calculateBottomShadowFromBackground(color.getRed(), color.getGreen(), color.getBlue()));
            Color color4 = new Color(MotifColorUtilities.calculateTopShadowFromBackground(color.getRed(), color.getGreen(), color.getBlue()));
            if (bl2) {
                graphics2D.setColor(color2);
                graphics2D.fillRect(0, 0, this.width, this.height);
                graphics2D.setColor(color3);
                graphics2D.drawLine(0, 0, this.width - 1, 0);
                graphics2D.drawLine(0, 0, 0, this.height - 1);
                graphics2D.setColor(color4);
                graphics2D.drawLine(1, this.height - 1, this.width - 1, this.height - 1);
                graphics2D.drawLine(this.width - 1, 1, this.width - 1, this.height - 1);
            } else {
                graphics2D.setColor(color2);
                Rectangle rectangle = this.getThumbArea();
                graphics2D.fill(rectangle);
            }
            if (bl2) {
                this.paintArrows(graphics2D, colorArray[0], color3, color4);
            }
            graphics2D.setColor(colorArray[0]);
            graphics2D.fillRect(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
            graphics2D.setColor(color4);
            graphics2D.drawLine(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).x + ((Rectangle)object).width, ((Rectangle)object).y);
            graphics2D.drawLine(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).x, ((Rectangle)object).y + ((Rectangle)object).height);
            graphics2D.setColor(color3);
            graphics2D.drawLine(((Rectangle)object).x + 1, ((Rectangle)object).y + ((Rectangle)object).height, ((Rectangle)object).x + ((Rectangle)object).width, ((Rectangle)object).y + ((Rectangle)object).height);
            graphics2D.drawLine(((Rectangle)object).x + ((Rectangle)object).width, ((Rectangle)object).y + 1, ((Rectangle)object).x + ((Rectangle)object).width, ((Rectangle)object).y + ((Rectangle)object).height);
        }
        finally {
            if (bl3) {
                graphics2D.dispose();
            }
        }
        if (bl3) {
            graphics.drawImage(bufferedImage, 0, 0, null);
        }
    }

    void paintArrows(Graphics2D graphics2D, Color color, Color color2, Color color3) {
        graphics2D.setColor(color);
        if (this.pressed && this.mode == 2) {
            graphics2D.fill(this.firstArrow);
            graphics2D.setColor(color3);
            graphics2D.drawLine(this.firstArrow.xpoints[0], this.firstArrow.ypoints[0], this.firstArrow.xpoints[1], this.firstArrow.ypoints[1]);
            graphics2D.drawLine(this.firstArrow.xpoints[1], this.firstArrow.ypoints[1], this.firstArrow.xpoints[2], this.firstArrow.ypoints[2]);
            graphics2D.setColor(color2);
            graphics2D.drawLine(this.firstArrow.xpoints[2], this.firstArrow.ypoints[2], this.firstArrow.xpoints[0], this.firstArrow.ypoints[0]);
        } else {
            graphics2D.fill(this.firstArrow);
            graphics2D.setColor(color2);
            graphics2D.drawLine(this.firstArrow.xpoints[0], this.firstArrow.ypoints[0], this.firstArrow.xpoints[1], this.firstArrow.ypoints[1]);
            graphics2D.drawLine(this.firstArrow.xpoints[1], this.firstArrow.ypoints[1], this.firstArrow.xpoints[2], this.firstArrow.ypoints[2]);
            graphics2D.setColor(color3);
            graphics2D.drawLine(this.firstArrow.xpoints[2], this.firstArrow.ypoints[2], this.firstArrow.xpoints[0], this.firstArrow.ypoints[0]);
        }
        graphics2D.setColor(color);
        if (this.pressed && this.mode == 1) {
            graphics2D.fill(this.secondArrow);
            graphics2D.setColor(color3);
            graphics2D.drawLine(this.secondArrow.xpoints[0], this.secondArrow.ypoints[0], this.secondArrow.xpoints[1], this.secondArrow.ypoints[1]);
            graphics2D.setColor(color2);
            graphics2D.drawLine(this.secondArrow.xpoints[1], this.secondArrow.ypoints[1], this.secondArrow.xpoints[2], this.secondArrow.ypoints[2]);
            graphics2D.drawLine(this.secondArrow.xpoints[2], this.secondArrow.ypoints[2], this.secondArrow.xpoints[0], this.secondArrow.ypoints[0]);
        } else {
            graphics2D.fill(this.secondArrow);
            graphics2D.setColor(color2);
            graphics2D.drawLine(this.secondArrow.xpoints[0], this.secondArrow.ypoints[0], this.secondArrow.xpoints[1], this.secondArrow.ypoints[1]);
            graphics2D.setColor(color3);
            graphics2D.drawLine(this.secondArrow.xpoints[1], this.secondArrow.ypoints[1], this.secondArrow.xpoints[2], this.secondArrow.ypoints[2]);
            graphics2D.drawLine(this.secondArrow.xpoints[2], this.secondArrow.ypoints[2], this.secondArrow.xpoints[0], this.secondArrow.ypoints[0]);
        }
    }

    void startScrolling() {
        log.finer("Start scrolling on " + this);
        this.scroll();
        if (scroller == null) {
            scroller = new XScrollRepeater(this);
        } else {
            scroller.setScrollbar(this);
        }
        scroller.start();
    }

    void scroll() {
        switch (this.mode) {
            case 2: {
                this.notifyValue(this.val - this.line);
                return;
            }
            case 1: {
                this.notifyValue(this.val + this.line);
                return;
            }
            case 3: {
                this.notifyValue(this.val - this.page);
                return;
            }
            case 4: {
                this.notifyValue(this.val + this.page);
                return;
            }
        }
    }

    boolean isInArrow(int n2, int n3) {
        int n4;
        int n5 = this.alignment == 2 ? n2 : n3;
        return n5 < (n4 = this.getArrowAreaWidth()) || n5 > this.barLength - n4 + 1;
    }

    boolean isInThumb(int n2, int n3) {
        Rectangle rectangle = this.calculateThumbRect();
        --rectangle.x;
        rectangle.width += 3;
        ++rectangle.height;
        return rectangle.contains(n2, n3);
    }

    abstract boolean beforeThumb(int var1, int var2);

    public void handleMouseEvent(int n2, int n3, int n4, int n5) {
        Object object;
        if ((n3 & 0x10) == 0) {
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            switch (n2) {
                case 501: {
                    object = new String("press");
                    break;
                }
                case 502: {
                    object = new String("release");
                    break;
                }
                case 506: {
                    object = new String("drag");
                    break;
                }
                default: {
                    object = new String("other");
                }
            }
            log.finer("Mouse " + (String)object + " event in scroll bar " + this + "x = " + n4 + ", y = " + n5 + ", on arrow: " + this.isInArrow(n4, n5) + ", on thumb: " + this.isInThumb(n4, n5) + ", before thumb: " + this.beforeThumb(n4, n5) + ", thumb rect" + this.calculateThumbRect());
        }
        switch (n2) {
            case 501: {
                if (this.isInArrow(n4, n5)) {
                    this.pressed = true;
                    this.mode = this.beforeThumb(n4, n5) ? 2 : 1;
                    this.sb.repaintScrollbarRequest(this);
                    this.startScrolling();
                    break;
                }
                if (this.isInThumb(n4, n5)) {
                    this.mode = 5;
                } else {
                    this.mode = this.beforeThumb(n4, n5) ? 3 : 4;
                    this.startScrolling();
                }
                object = this.calculateThumbRect();
                this.thumbOffset = new Point(n4 - ((Rectangle)object).x, n5 - ((Rectangle)object).y);
                break;
            }
            case 502: {
                this.pressed = false;
                this.sb.repaintScrollbarRequest(this);
                scroller.stop();
                if (!this.dragging) break;
                this.handleTrackEvent(n4, n5, false);
                this.dragging = false;
                break;
            }
            case 506: {
                this.dragging = true;
                this.handleTrackEvent(n4, n5, true);
            }
        }
    }

    private void handleTrackEvent(int n2, int n3, boolean bl2) {
        if (this.mode == 5) {
            this.notifyValue(this.calculateCursorOffset(n2, n3), bl2);
        }
    }

    private int calculateCursorOffset(int n2, int n3) {
        if (this.alignment == 2) {
            if (this.dragging) {
                return Math.max(0, (int)((double)(n2 - (this.thumbOffset.x + this.getArrowAreaWidth())) / this.getScaleFactor())) + this.min;
            }
            return Math.max(0, (int)((double)(n2 - this.getArrowAreaWidth()) / this.getScaleFactor())) + this.min;
        }
        if (this.dragging) {
            return Math.max(0, (int)((double)(n3 - (this.thumbOffset.y + this.getArrowAreaWidth())) / this.getScaleFactor())) + this.min;
        }
        return Math.max(0, (int)((double)(n3 - this.getArrowAreaWidth()) / this.getScaleFactor())) + this.min;
    }

    synchronized void setValues(int n2, int n3, int n4, int n5) {
        if (n5 <= n4) {
            n5 = n4 + 1;
        }
        if (n3 > n5 - n4) {
            n3 = n5 - n4;
        }
        if (n3 < 1) {
            n3 = 1;
        }
        if (n2 < n4) {
            n2 = n4;
        }
        if (n2 > n5 - n3) {
            n2 = n5 - n3;
        }
        this.val = n2;
        this.vis = n3;
        this.min = n4;
        this.max = n5;
    }

    synchronized void setValues(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.setValues(n2, n3, n4, n5);
        this.setUnitIncrement(n6);
        this.setBlockIncrement(n7);
    }

    int getValue() {
        return this.val;
    }

    synchronized void setValue(int n2) {
        this.setValues(n2, this.vis, this.min, this.max);
    }

    int getMinimum() {
        return this.min;
    }

    synchronized void setMinimum(int n2) {
        this.setValues(this.val, this.vis, n2, this.max);
    }

    int getMaximum() {
        return this.max;
    }

    synchronized void setMaximum(int n2) {
        this.setValues(this.val, this.vis, this.min, n2);
    }

    int getVisibleAmount() {
        return this.vis;
    }

    synchronized void setVisibleAmount(int n2) {
        this.setValues(this.val, n2, this.min, this.max);
    }

    synchronized void setUnitIncrement(int n2) {
        this.line = n2;
    }

    int getUnitIncrement() {
        return this.line;
    }

    synchronized void setBlockIncrement(int n2) {
        this.page = n2;
    }

    int getBlockIncrement() {
        return this.page;
    }

    int getArrowWidth() {
        return this.getArrowAreaWidth() - 2;
    }

    int getArrowAreaWidth() {
        return this.arrowArea;
    }

    void calculateArrowWidth() {
        this.arrowArea = this.barLength < 2 * this.barWidth + 5 + 2 ? (this.barLength - 5 + 2) / 2 - 1 : this.barWidth - 1;
    }

    private double getScaleFactor() {
        double d2 = (double)(this.barLength - 2 * this.getArrowAreaWidth()) / (double)Math.max(1, this.max - this.min);
        return d2;
    }

    private boolean paintThumb(int n2) {
        return this.barLength >= 2 * n2 + 5;
    }

    protected Rectangle calculateThumbRect() {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = this.getArrowAreaWidth();
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        float f2 = this.barLength - 2 * n5 - 1;
        if (this.alignment == 2) {
            n3 = 5;
            n2 = this.height - 3;
        } else {
            n3 = this.width - 3;
            n2 = 5;
        }
        float f3 = this.max - this.min;
        float f4 = f2 / f3;
        float f5 = (float)this.vis * f4;
        if (this.alignment == 2) {
            int n6 = (int)((double)f5 + 0.5);
            int n7 = n3;
            if (n6 > n7) {
                rectangle.width = n6;
            } else {
                rectangle.width = n7;
                n4 = n7;
            }
            rectangle.height = n2;
        } else {
            rectangle.width = n3;
            int n8 = (int)((double)f5 + 0.5);
            int n9 = n2;
            if (n8 > n9) {
                rectangle.height = n8;
            } else {
                rectangle.height = n9;
                n4 = n9;
            }
        }
        if (n4 != 0) {
            f4 = (f2 -= (float)n4) / (f3 -= (float)this.vis);
        }
        if (this.alignment == 2) {
            rectangle.x = (int)((double)(((float)this.val - (float)this.min) * f4) + 0.5) + n5;
            rectangle.y = 1;
        } else {
            rectangle.x = 1;
            rectangle.y = (int)((double)(((float)this.val - (float)this.min) * f4) + 0.5) + n5;
        }
        return rectangle;
    }

    public String toString() {
        return this.getClass() + "[" + this.width + "x" + this.height + "," + this.barWidth + "x" + this.barLength + "]";
    }
}

