/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.List;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Area;
import java.awt.image.VolatileImage;
import java.awt.peer.ListPeer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.ListHelper;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XHorizontalScrollbar;
import sun.awt.X11.XScrollbar;
import sun.awt.X11.XScrollbarClient;
import sun.awt.X11.XVerticalScrollbar;

class XListPeer
extends XComponentPeer
implements ListPeer,
XScrollbarClient {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XListPeer");
    public static final int MARGIN = 2;
    public static final int SPACE = 1;
    public static final int SCROLLBAR_AREA = 17;
    public static final int SCROLLBAR_WIDTH = 13;
    public static final int NONE = -1;
    public static final int WINDOW = 0;
    public static final int VERSCROLLBAR = 1;
    public static final int HORSCROLLBAR = 2;
    public static final int DEFAULT_VISIBLE_ROWS = 4;
    public static final int HORIZ_SCROLL_AMT = 10;
    static final int PAINT_VSCROLL = 2;
    static final int PAINT_HSCROLL = 4;
    static final int PAINT_ITEMS = 8;
    static final int PAINT_FOCUS = 16;
    static final int PAINT_BACKGROUND = 32;
    static final int PAINT_HIDEFOCUS = 64;
    static final int PAINT_ALL = 62;
    XVerticalScrollbar vsb;
    XHorizontalScrollbar hsb;
    ListPainter painter;
    Vector items;
    boolean multipleSelections;
    int active = -1;
    int[] selected;
    int fontHeight;
    int fontAscent;
    int fontLeading;
    int currentIndex = -1;
    int eventIndex = -1;
    int eventType = -1;
    int focusIndex;
    int maxLength;
    boolean vsbVis;
    boolean hsbVis;
    int listWidth;
    int listHeight;
    private int firstTimeVisibleIndex = 0;
    boolean bgColorSet = false;
    boolean fgColorSet = false;

    XListPeer(List list) {
        super(list);
    }

    public void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        this.items = new Vector();
        this.createVerScrollbar();
        this.createHorScrollbar();
        this.painter = new ListPainter();
    }

    public void postInit(XCreateWindowParams xCreateWindowParams) {
        int n2;
        super.postInit(xCreateWindowParams);
        this.initFontMetrics();
        List list = (List)this.target;
        int n3 = list.getItemCount();
        for (n2 = 0; n2 < n3; ++n2) {
            this.items.addElement(list.getItem(n2));
        }
        n2 = list.getVisibleIndex();
        if (n2 >= 0) {
            this.vsb.setValues(n2, 0, 0, this.items.size());
        }
        this.maxLength = this.maxLength();
        int[] nArray = list.getSelectedIndexes();
        this.selected = new int[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.selected[i2] = nArray[i2];
        }
        if (nArray.length > 0) {
            this.setFocusIndex(nArray[nArray.length - 1]);
        } else {
            this.setFocusIndex(0);
        }
        this.multipleSelections = list.isMultipleMode();
    }

    void createVerScrollbar() {
        this.vsb = new XVerticalScrollbar(this);
        this.vsb.setValues(0, 0, 0, 0, 1, 1);
    }

    void createHorScrollbar() {
        this.hsb = new XHorizontalScrollbar(this);
        this.hsb.setValues(0, 0, 0, 0, 10, 10);
    }

    public void add(String string, int n2) {
        this.addItem(string, n2);
    }

    public void removeAll() {
        this.clear();
        this.maxLength = 0;
    }

    public void setMultipleMode(boolean bl2) {
        this.setMultipleSelections(bl2);
    }

    public Dimension getPreferredSize(int n2) {
        return this.preferredSize(n2);
    }

    public Dimension getMinimumSize(int n2) {
        return this.minimumSize(n2);
    }

    public Dimension minimumSize() {
        return this.minimumSize(4);
    }

    public Dimension preferredSize(int n2) {
        return this.minimumSize(n2);
    }

    public Dimension minimumSize(int n2) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.initFontMetrics();
        return new Dimension(20 + fontMetrics.stringWidth("0123456789abcde"), this.getItemHeight() * n2 + 4);
    }

    void initFontMetrics() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.fontHeight = fontMetrics.getHeight();
        this.fontAscent = fontMetrics.getAscent();
        this.fontLeading = fontMetrics.getLeading();
    }

    int maxLength() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n2 = 0;
        int n3 = this.items.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = fontMetrics.stringWidth((String)this.items.elementAt(i2));
            n2 = Math.max(n2, n4);
        }
        return n2;
    }

    int getItemWidth(int n2) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        return fontMetrics.stringWidth((String)this.items.elementAt(n2));
    }

    int stringLength(String string) {
        FontMetrics fontMetrics = this.getFontMetrics(this.target.getFont());
        return fontMetrics.stringWidth(string);
    }

    public void setForeground(Color color) {
        this.fgColorSet = true;
        super.setForeground(color);
    }

    public void setBackground(Color color) {
        this.bgColorSet = true;
        super.setBackground(color);
    }

    private Color getListBackground(Color[] colorArray) {
        if (this.bgColorSet) {
            return colorArray[0];
        }
        return SystemColor.text;
    }

    private Color getListForeground(Color[] colorArray) {
        if (this.fgColorSet) {
            return colorArray[3];
        }
        return SystemColor.textText;
    }

    Rectangle getVScrollBarRec() {
        return new Rectangle(this.width - 13, 0, 14, this.height);
    }

    Rectangle getHScrollBarRec() {
        return new Rectangle(0, this.height - 13, this.width, 13);
    }

    int getFirstVisibleItem() {
        if (this.vsbVis) {
            return this.vsb.getValue();
        }
        return 0;
    }

    int getLastVisibleItem() {
        if (this.vsbVis) {
            return Math.min(this.items.size() - 1, this.vsb.getValue() + this.itemsInWindow() - 1);
        }
        return Math.min(this.items.size() - 1, this.itemsInWindow() - 1);
    }

    Area getItemsArea(int n2, int n3) {
        n2 = Math.max(this.getFirstVisibleItem(), n2);
        if ((n3 = Math.min(n3, this.getLastVisibleItem())) < this.getFirstVisibleItem()) {
            return new Area();
        }
        if (n2 <= n3) {
            int n4 = this.getItemY(n2);
            int n5 = this.getItemY(n3) + this.getItemHeight();
            return new Area(new Rectangle(0, n4 -= 2, this.getItemWidth() + 3, (n5 += 2) - n4 + 1));
        }
        return new Area();
    }

    Rectangle getItemRect(int n2) {
        return new Rectangle(2, this.getItemY(n2), this.getItemWidth(), this.getItemHeight());
    }

    Area getItemArea(int n2) {
        return new Area(this.getItemRect(n2));
    }

    public void repaintScrollbarRequest(XScrollbar xScrollbar) {
        Graphics graphics = this.getGraphics();
        if (xScrollbar == this.hsb) {
            this.repaint(4);
        } else if (xScrollbar == this.vsb) {
            this.repaint(2);
        }
    }

    public void repaint() {
        this.repaint(this.getFirstVisibleItem(), this.getLastVisibleItem(), 62);
    }

    public void repaint(int n2) {
        this.repaint(this.getFirstVisibleItem(), this.getLastVisibleItem(), n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint(int n2, int n3, int n4) {
        Graphics graphics = this.getGraphics();
        try {
            this.painter.paint(graphics, n2, n3, n4);
        }
        finally {
            graphics.dispose();
        }
    }

    public void paint(Graphics graphics) {
        this.painter.paint(graphics, this.getFirstVisibleItem(), this.getLastVisibleItem(), 62);
    }

    public boolean isFocusable() {
        return true;
    }

    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        this.repaint(16);
    }

    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        this.repaint(16);
    }

    public void layout() {
        boolean bl2;
        assert (this.target != null);
        int n2 = this.vsb.getValue();
        int n3 = this.itemsInWindow(false);
        int n4 = this.items.size() < n3 ? n3 : this.items.size();
        this.vsb.setValues(this.vsb.getValue(), n3, this.vsb.getMinimum(), n4);
        this.vsbVis = bl2 = this.vsbIsVisible(false);
        this.listHeight = this.height;
        this.listWidth = this.getListWidth();
        n3 = this.listWidth - 6;
        n4 = this.maxLength < n3 ? n3 : this.maxLength;
        this.hsb.setValues(this.hsb.getValue(), n3, this.hsb.getMinimum(), n4);
        this.hsbVis = this.hsbIsVisible(this.vsbVis);
        if (this.hsbVis) {
            this.listHeight = this.height - 17;
            n3 = this.itemsInWindow(true);
            n4 = this.items.size() < n3 ? n3 : this.items.size();
            this.vsb.setValues(n2, n3, this.vsb.getMinimum(), n4);
            this.vsbVis = this.vsbIsVisible(true);
        }
        if (bl2 != this.vsbVis) {
            this.listWidth = this.getListWidth();
            n3 = this.listWidth - 6;
            n4 = this.maxLength < n3 ? 0 : this.maxLength;
            this.hsb.setValues(this.hsb.getValue(), n3, this.hsb.getMinimum(), n4);
            this.hsbVis = this.hsbIsVisible(this.vsbVis);
        }
        this.vsb.setSize(13, this.listHeight);
        this.hsb.setSize(this.listWidth, 13);
        this.vsb.setBlockIncrement(this.itemsInWindow());
        this.hsb.setBlockIncrement(this.width - (6 + (this.vsbVis ? 17 : 0)));
    }

    int getItemWidth() {
        return this.width - (4 + (this.vsbVis ? 17 : 0));
    }

    int getItemHeight() {
        return this.fontHeight - this.fontLeading + 2;
    }

    int getItemX() {
        return 3;
    }

    int getItemY(int n2) {
        return this.index2y(n2);
    }

    int getFocusIndex() {
        return this.focusIndex;
    }

    void setFocusIndex(int n2) {
        this.focusIndex = n2;
    }

    Rectangle getFocusRect() {
        Rectangle rectangle = new Rectangle();
        rectangle.x = 1;
        rectangle.width = this.getListWidth() - 3;
        if (this.isIndexDisplayed(this.getFocusIndex())) {
            rectangle.y = this.index2y(this.getFocusIndex()) - 2;
            rectangle.height = this.getItemHeight() + 1;
        } else {
            rectangle.y = 1;
            rectangle.height = this.hsbVis ? this.height - 17 : this.height;
            rectangle.height -= 3;
        }
        return rectangle;
    }

    public void handleConfigureNotifyEvent(long l2) {
        super.handleConfigureNotifyEvent(l2);
        this.painter.invalidate();
    }

    public boolean handlesWheelScrolling() {
        return true;
    }

    void handleJavaMouseEvent(MouseEvent mouseEvent) {
        super.handleJavaMouseEvent(mouseEvent);
        int n2 = mouseEvent.getID();
        switch (n2) {
            case 501: {
                this.mousePressed(mouseEvent);
                break;
            }
            case 502: {
                this.mouseReleased(mouseEvent);
                break;
            }
            case 506: {
                this.mouseDragged(mouseEvent);
            }
        }
    }

    void handleJavaMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        if (ListHelper.doWheelScroll(this.vsbVis ? this.vsb : null, this.hsbVis ? this.hsb : null, mouseWheelEvent)) {
            this.repaint();
        }
    }

    void mousePressed(MouseEvent mouseEvent) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(mouseEvent.toString() + ", hsb " + this.hsbVis + ", vsb " + this.vsbVis);
        }
        if (this.isEnabled() && mouseEvent.getButton() == 1) {
            if (this.inWindow(mouseEvent.getX(), mouseEvent.getY())) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Mouse press in items area");
                }
                this.active = 0;
                int n2 = this.y2index(mouseEvent.getY());
                if (n2 >= 0) {
                    if (this.multipleSelections) {
                        if (this.isSelected(n2)) {
                            this.eventIndex = n2;
                            this.eventType = 2;
                        } else {
                            this.selectItem(n2);
                            this.eventIndex = n2;
                            this.eventType = 1;
                        }
                    } else {
                        this.selectItem(n2);
                        this.eventIndex = n2;
                        this.eventType = 1;
                    }
                }
            } else if (this.inVerticalScrollbar(mouseEvent.getX(), mouseEvent.getY())) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Mouse press in vertical scrollbar");
                }
                this.active = 1;
                this.vsb.handleMouseEvent(mouseEvent.getID(), mouseEvent.getModifiers(), mouseEvent.getX() - (this.width - 13), mouseEvent.getY());
            } else if (this.inHorizontalScrollbar(mouseEvent.getX(), mouseEvent.getY())) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Mouse press in horizontal scrollbar");
                }
                this.active = 2;
                this.hsb.handleMouseEvent(mouseEvent.getID(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY() - (this.height - 13));
            }
        }
    }

    void mouseReleased(MouseEvent mouseEvent) {
        if (this.isEnabled() && mouseEvent.getButton() == 1) {
            if (this.active == 1) {
                this.vsb.handleMouseEvent(mouseEvent.getID(), mouseEvent.getModifiers(), mouseEvent.getX() - (this.width - 13), mouseEvent.getY());
            } else if (this.active == 2) {
                this.hsb.handleMouseEvent(mouseEvent.getID(), mouseEvent.getModifiers(), mouseEvent.getX() - (this.height - 13), mouseEvent.getY());
            } else if (this.currentIndex >= 0 && mouseEvent.getClickCount() == 2) {
                this.postEvent(new ActionEvent(this.target, 1001, (String)this.items.elementAt(this.currentIndex), mouseEvent.getWhen(), mouseEvent.getModifiers()));
            } else if (this.active == 0) {
                if (this.eventType == 2) {
                    assert (this.multipleSelections) : "Shouldn't get a deselect for a single-select List";
                    this.deselectItem(this.eventIndex);
                }
                if (this.eventType != -1) {
                    this.postEvent(new ItemEvent((List)this.target, 701, new Integer(this.eventIndex), this.eventType));
                    this.setFocusIndex(this.eventIndex);
                }
                this.repaint(16);
            }
            this.active = -1;
            this.eventIndex = -1;
            this.eventType = -1;
        }
    }

    void mouseDragged(MouseEvent mouseEvent) {
        if (this.isEnabled() && (mouseEvent.getModifiersEx() & 0x400) != 0) {
            if (this.active == 1) {
                this.vsb.handleMouseEvent(mouseEvent.getID(), mouseEvent.getModifiers(), mouseEvent.getX() - (this.width - 13), mouseEvent.getY());
            } else if (this.active == 2) {
                this.hsb.handleMouseEvent(mouseEvent.getID(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY() - (this.height - 13));
            } else if (this.active == 0) {
                int n2;
                if (this.multipleSelections) {
                    int n3;
                    if (this.eventType == 2 && (n3 = this.y2index(mouseEvent.getY())) != this.eventIndex) {
                        this.eventType = -1;
                        this.eventIndex = -1;
                    }
                } else if (this.eventType == 1 && (n2 = this.y2index(mouseEvent.getY())) >= 0 && !this.isSelected(n2)) {
                    int n4 = this.eventIndex;
                    this.selectItem(n2);
                    this.eventIndex = n2;
                    this.repaint(n4, this.eventIndex, 8);
                }
            }
        }
    }

    void handleJavaKeyEvent(KeyEvent keyEvent) {
        switch (keyEvent.getID()) {
            case 401: {
                this.keyPressed(keyEvent);
            }
        }
    }

    void keyPressed(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        if (log.isLoggable(Level.FINE)) {
            log.fine(keyEvent.toString());
        }
        switch (n2) {
            case 38: 
            case 224: {
                if (this.getFocusIndex() <= 0) break;
                this.setFocusIndex(this.getFocusIndex() - 1);
                this.repaint(64);
                if (!this.multipleSelections) {
                    this.selectItem(this.getFocusIndex());
                    this.postEvent(new ItemEvent((List)this.target, 701, new Integer(this.getFocusIndex()), 1));
                }
                if (this.isItemHidden(this.getFocusIndex())) {
                    this.makeVisible(this.getFocusIndex());
                    break;
                }
                this.repaint(16);
                break;
            }
            case 40: 
            case 225: {
                if (this.getFocusIndex() >= this.items.size() - 1) break;
                this.setFocusIndex(this.getFocusIndex() + 1);
                this.repaint(64);
                if (!this.multipleSelections) {
                    this.selectItem(this.getFocusIndex());
                    this.postEvent(new ItemEvent((List)this.target, 701, new Integer(this.getFocusIndex()), 1));
                }
                if (this.isItemHidden(this.getFocusIndex())) {
                    this.makeVisible(this.getFocusIndex());
                    break;
                }
                this.repaint(16);
                break;
            }
            case 33: {
                this.vsb.setValue(this.vsb.getValue() - this.vsb.getBlockIncrement());
                this.setFocusIndex(Math.max(this.getFocusIndex() - this.itemsInWindow(), 0));
                this.selectItem(this.getFocusIndex());
                this.repaint();
                break;
            }
            case 34: {
                this.vsb.setValue(this.vsb.getValue() + this.vsb.getBlockIncrement());
                this.setFocusIndex(Math.min(this.getFocusIndex() + this.itemsInWindow(), this.items.size() - 1));
                this.selectItem(this.getFocusIndex());
                this.repaint();
                break;
            }
            case 37: 
            case 226: {
                if (!(this.hsbVis & this.hsb.getValue() > 0)) break;
                this.hsb.setValue(this.hsb.getValue() - 10);
                this.repaint();
                break;
            }
            case 39: 
            case 227: {
                if (!this.hsbVis) break;
                this.hsb.setValue(this.hsb.getValue() + 10);
                this.repaint();
                break;
            }
            case 36: {
                if (!(this.hsbVis & this.hsb.getValue() > 0)) break;
                this.hsb.setValue(0);
                this.repaint();
                break;
            }
            case 35: {
                if (this.vsbVis) {
                    this.vsb.setValue(this.vsb.getMaximum());
                }
                this.setFocusIndex(this.items.size() - 1);
                this.selectItem(this.getFocusIndex());
                this.repaint();
                break;
            }
            case 32: {
                boolean bl2 = this.isSelected(this.getFocusIndex());
                if (this.multipleSelections && bl2) {
                    this.deselectItem(this.getFocusIndex());
                    this.postEvent(new ItemEvent((List)this.target, 701, new Integer(this.getFocusIndex()), 2));
                    break;
                }
                if (bl2) break;
                this.selectItem(this.getFocusIndex());
                this.postEvent(new ItemEvent((List)this.target, 701, new Integer(this.getFocusIndex()), 1));
                break;
            }
            case 10: {
                if (this.selected.length <= 0) break;
                this.postEvent(new ActionEvent((List)this.target, 1001, (String)this.items.elementAt(this.getFocusIndex()), keyEvent.getWhen(), keyEvent.getModifiers()));
            }
        }
    }

    public void notifyValue(XScrollbar xScrollbar, int n2, int n3, boolean bl2) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Notify value changed on " + xScrollbar + " to " + n3);
        }
        int n4 = xScrollbar.getValue();
        if (xScrollbar == this.vsb) {
            this.scrollVertical(n3 - n4);
        } else if ((XHorizontalScrollbar)xScrollbar == this.hsb) {
            this.scrollHorizontal(n3 - n4);
        }
    }

    private void deselectAllItems() {
        this.selected = new int[0];
        this.repaint(8);
    }

    public void setMultipleSelections(boolean bl2) {
        if (this.multipleSelections != bl2) {
            if (!bl2) {
                int n2 = this.isSelected(this.focusIndex) ? this.focusIndex : -1;
                this.deselectAllItems();
                if (n2 != -1) {
                    this.selectItem(n2);
                }
            }
            this.multipleSelections = bl2;
        }
    }

    public void addItem(String string, int n2) {
        boolean bl2;
        int n3 = this.maxLength;
        boolean bl3 = this.hsbVis;
        boolean bl4 = this.vsbVis;
        int n4 = 0;
        if (n2 < 0 || n2 >= this.items.size()) {
            n2 = -1;
        }
        this.currentIndex = -1;
        if (n2 == -1) {
            this.items.addElement(string);
            n2 = 0;
            n4 = this.items.size() - 1;
        } else {
            this.items.insertElementAt(string, n2);
            n4 = n2;
            for (bl2 = false; bl2 < this.selected.length; bl2 += 1) {
                if (this.selected[bl2] < n2) continue;
                boolean bl5 = bl2;
                this.selected[bl5] = this.selected[bl5] + 1;
            }
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Adding item '" + string + "' to " + n4);
        }
        bl2 = !this.isItemHidden(n4);
        this.maxLength = Math.max(this.maxLength, this.getItemWidth(n4));
        this.layout();
        int n5 = 0;
        n5 = this.vsbVis != bl4 || this.hsbVis != bl3 ? 62 : (bl2 ? 8 : 0) | (this.maxLength != n3 || bl3 ^ this.hsbVis ? 4 : 0) | (this.vsb.needsRepaint() ? 2 : 0);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Last visible: " + this.getLastVisibleItem() + ", hsb changed : " + (bl3 ^ this.hsbVis) + ", items changed " + bl2);
        }
        this.repaint(n4, this.getLastVisibleItem(), n5);
    }

    public void delItems(int n2, int n3) {
        int n4;
        int n5;
        int n6;
        boolean bl2 = this.hsbVis;
        boolean bl3 = this.vsbVis;
        int n7 = this.lastItemDisplayed();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Deleting from " + n2 + " to " + n3);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Last displayed item: " + n7 + ", items in window " + this.itemsInWindow() + ", size " + this.items.size());
        }
        if (this.items.size() == 0) {
            return;
        }
        if (n2 > n3) {
            n6 = n2;
            n2 = n3;
            n3 = n6;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 >= this.items.size()) {
            n3 = this.items.size() - 1;
        }
        n6 = n2 >= this.getFirstVisibleItem() && n2 <= this.getLastVisibleItem() ? 1 : 0;
        for (n5 = n2; n5 <= n3; ++n5) {
            this.items.removeElementAt(n2);
            n4 = this.posInSel(n5);
            if (n4 == -1) continue;
            int[] nArray = new int[this.selected.length - 1];
            System.arraycopy(this.selected, 0, nArray, 0, n4);
            System.arraycopy(this.selected, n4 + 1, nArray, n4, this.selected.length - (n4 + 1));
            this.selected = nArray;
        }
        n5 = n3 - n2 + 1;
        for (n4 = 0; n4 < this.selected.length; ++n4) {
            if (this.selected[n4] <= n3) continue;
            int n8 = n4;
            this.selected[n8] = this.selected[n8] - n5;
        }
        n4 = 2;
        if (this.getFocusIndex() >= this.items.size()) {
            this.setFocusIndex(this.items.size() - 1);
            n4 |= 0x10;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Multiple selections: " + this.multipleSelections);
        }
        if (this.vsb.getValue() >= n2) {
            if (this.vsb.getValue() <= n3) {
                this.vsb.setValue(n3 + 1 - n5);
            } else {
                this.vsb.setValue(this.vsb.getValue() - n5);
            }
        }
        int n9 = this.maxLength;
        this.maxLength = this.maxLength();
        if (this.maxLength != n9) {
            n4 |= 4;
        }
        this.layout();
        if ((n6 |= bl3 ^ this.vsbVis || bl2 ^ this.hsbVis ? 1 : 0) != 0) {
            n4 |= 0x3E;
        }
        this.repaint(n2, n7, n4);
    }

    public void select(int n2) {
        this.setFocusIndex(n2);
        this.selectItem(n2);
    }

    void selectItem(int n2) {
        if (this.isSelected(n2)) {
            return;
        }
        if (!this.multipleSelections) {
            if (this.selected.length == 0) {
                this.selected = new int[1];
                this.selected[0] = n2;
            } else {
                int n3 = this.selected[0];
                this.selected[0] = n2;
                if (!this.isItemHidden(n3)) {
                    this.repaint(n3, n3, 8);
                }
            }
            this.currentIndex = n2;
        } else {
            int n4;
            int[] nArray = new int[this.selected.length + 1];
            for (n4 = 0; n4 < this.selected.length && n2 > this.selected[n4]; ++n4) {
                nArray[n4] = this.selected[n4];
            }
            nArray[n4] = n2;
            System.arraycopy(this.selected, n4, nArray, n4 + 1, this.selected.length - n4);
            this.selected = nArray;
            this.currentIndex = n2;
        }
        if (!this.isItemHidden(n2)) {
            this.repaint(n2, n2, 8);
        }
    }

    public void deselect(int n2) {
        this.deselectItem(n2);
    }

    void deselectItem(int n2) {
        if (!this.isSelected(n2)) {
            return;
        }
        if (!this.multipleSelections) {
            this.selected = new int[0];
        } else {
            int n3 = this.posInSel(n2);
            int[] nArray = new int[this.selected.length - 1];
            System.arraycopy(this.selected, 0, nArray, 0, n3);
            System.arraycopy(this.selected, n3 + 1, nArray, n3, this.selected.length - (n3 + 1));
            this.selected = nArray;
        }
        this.currentIndex = n2;
        if (!this.isItemHidden(n2)) {
            this.repaint(n2, n2, 8);
        }
    }

    public void makeVisible(int n2) {
        if (n2 < 0 || n2 >= this.items.size()) {
            return;
        }
        if (this.isItemHidden(n2)) {
            if (n2 < this.vsb.getValue()) {
                this.scrollVertical(n2 - this.vsb.getValue());
            } else if (n2 > this.lastItemDisplayed()) {
                int n3 = n2 - this.lastItemDisplayed();
                this.scrollVertical(n3);
            }
        }
    }

    public void clear() {
        this.selected = new int[0];
        this.items = new Vector();
        this.currentIndex = -1;
        this.vsb.setValue(0);
        this.maxLength = 0;
        this.layout();
        this.repaint();
    }

    public int[] getSelectedIndexes() {
        return this.selected;
    }

    int index2y(int n2) {
        int n3 = this.getItemHeight();
        return 2 + (n2 - this.vsb.getValue()) * n3 + 1;
    }

    boolean validY(int n2) {
        int n3 = this.itemsDisplayed();
        int n4 = n3 * this.getItemHeight() + 2;
        if (n3 == this.itemsInWindow()) {
            n4 += 2;
        }
        return n2 >= 0 && n2 < n4;
    }

    int posInSel(int n2) {
        for (int i2 = 0; i2 < this.selected.length; ++i2) {
            if (n2 != this.selected[i2]) continue;
            return i2;
        }
        return -1;
    }

    boolean isIndexDisplayed(int n2) {
        int n3 = this.lastItemDisplayed();
        return n2 <= n3 && n2 > n3 - this.itemsInWindow();
    }

    int lastItemDisplayed() {
        int n2 = this.itemsInWindow();
        return Math.min(this.items.size() - 1, this.vsb.getValue() + n2 - 1);
    }

    boolean isItemHidden(int n2) {
        return n2 < this.vsb.getValue() || n2 >= this.vsb.getValue() + this.itemsInWindow();
    }

    int getListWidth() {
        return this.vsbVis ? this.width - 17 : this.width;
    }

    int itemsDisplayed() {
        return Math.min(this.items.size() - this.vsb.getValue(), this.itemsInWindow());
    }

    void scrollVertical(int n2) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Scrolling vertically by " + n2);
        }
        int n3 = this.itemsInWindow();
        int n4 = this.getItemHeight();
        int n5 = n2 * n4;
        if (this.vsb.getValue() < -n2) {
            n2 = -this.vsb.getValue();
        }
        this.vsb.setValue(this.vsb.getValue() + n2);
        if (n2 > 0) {
            if (n2 < n3) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Copying 2," + (2 + n5) + "," + (this.width - 17) + "," + (n4 * (n3 - n2) - 1) + "," + 0 + "," + -n5);
                }
                this.repaint(64);
                this.painter.copyArea(2, 2 + n5, this.width - 17, n4 * (n3 - n2 - 1) - 1, 0, -n5);
            }
            this.repaint(this.vsb.getValue() + (n3 - n2) - 1, this.vsb.getValue() + n3 - 1, 26);
        } else if (n2 < 0) {
            if (n2 + this.itemsInWindow() > 0) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Copying 2,2," + (this.width - 17) + "," + n4 * (n3 + n2) + "," + "0" + "," + -n5);
                }
                this.repaint(64);
                this.painter.copyArea(2, 2, this.width - 17, n4 * (n3 + n2), 0, -n5);
            }
            int n6 = Math.min(this.getLastVisibleItem(), this.vsb.getValue() + -n2);
            this.repaint(this.vsb.getValue(), n6, 26);
        }
    }

    void scrollHorizontal(int n2) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Scrolling horizontally by " + this.y);
        }
        int n3 = this.getListWidth();
        n3 -= 6;
        int n4 = this.height - 21;
        this.hsb.setValue(this.hsb.getValue() + n2);
        if (n2 < 0) {
            this.painter.copyArea(3, 2, n3 + n2, n4, -n2, 0);
        } else if (n2 > 0) {
            this.painter.copyArea(3 + n2, 2, n3 - n2, n4, -n2, 0);
        }
        this.repaint(this.vsb.getValue(), this.lastItemDisplayed(), 12);
    }

    int y2index(int n2) {
        int n3;
        if (!this.validY(n2)) {
            return -1;
        }
        int n4 = (n2 - 2) / this.getItemHeight() + this.vsb.getValue();
        if (n4 > (n3 = this.lastItemDisplayed())) {
            n4 = n3;
        }
        return n4;
    }

    boolean isSelected(int n2) {
        if (this.eventType == 1 && n2 == this.eventIndex) {
            return true;
        }
        for (int i2 = 0; i2 < this.selected.length; ++i2) {
            if (this.selected[i2] != n2) continue;
            return true;
        }
        return false;
    }

    int itemsInWindow(boolean bl2) {
        int n2 = bl2 ? this.height - 21 : this.height - 4;
        return n2 / this.getItemHeight();
    }

    int itemsInWindow() {
        return this.itemsInWindow(this.hsbVis);
    }

    boolean inHorizontalScrollbar(int n2, int n3) {
        int n4 = this.getListWidth();
        int n5 = this.height - 13;
        return this.hsbVis && n2 >= 0 && n2 <= n4 && n3 > n5;
    }

    boolean inVerticalScrollbar(int n2, int n3) {
        int n4 = this.width - 13;
        int n5 = this.hsbVis ? this.height - 17 : this.height;
        return this.vsbVis && n2 > n4 && n3 >= 0 && n3 <= n5;
    }

    boolean inWindow(int n2, int n3) {
        int n4 = this.getListWidth();
        int n5 = this.hsbVis ? this.height - 17 : this.height;
        return n2 >= 0 && n2 <= n4 && n3 >= 0 && n3 <= n5;
    }

    boolean vsbIsVisible(boolean bl2) {
        return this.items.size() > this.itemsInWindow(bl2);
    }

    boolean hsbIsVisible(boolean bl2) {
        int n2 = this.width - (6 + (bl2 ? 17 : 0));
        return this.maxLength > n2;
    }

    class ListPainter {
        VolatileImage buffer;
        Color[] colors;
        private Object BUFFER_LOCK = XBaseWindow.getAWTLock();
        private Rectangle prevFocusRect;

        ListPainter() {
        }

        private Color getListForeground() {
            if (XListPeer.this.fgColorSet) {
                return this.colors[3];
            }
            return SystemColor.textText;
        }

        private Color getListBackground() {
            if (XListPeer.this.bgColorSet) {
                return this.colors[0];
            }
            return SystemColor.text;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean createBuffer() {
            VolatileImage volatileImage = this.buffer;
            if (volatileImage == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Creating buffer " + XListPeer.this.width + "x" + XListPeer.this.height);
                }
                volatileImage = XListPeer.this.graphicsConfig.createCompatibleVolatileImage(XListPeer.this.width + 1, XListPeer.this.height + 1);
            }
            Object object = this.BUFFER_LOCK;
            synchronized (object) {
                if (this.buffer == null) {
                    this.buffer = volatileImage;
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidate() {
            Object object = this.BUFFER_LOCK;
            synchronized (object) {
                if (this.buffer != null) {
                    this.buffer.flush();
                }
                this.buffer = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paint(Graphics graphics, int n2, int n3, int n4) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Repaint from " + n2 + " to " + n3 + " options " + n4);
            }
            if (n2 > n3) {
                int n5 = n3;
                n3 = n2;
                n2 = n5;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            this.colors = XListPeer.this.getGUIcolors();
            VolatileImage volatileImage = null;
            block9: do {
                Object object = this.BUFFER_LOCK;
                synchronized (object) {
                    if (this.createBuffer()) {
                        n4 = 62;
                    }
                    volatileImage = this.buffer;
                }
                switch (volatileImage.validate(XListPeer.this.getGraphicsConfiguration())) {
                    case 2: {
                        this.invalidate();
                        n4 = 62;
                        break;
                    }
                    default: {
                        object = volatileImage.createGraphics();
                        try {
                            ((Graphics)object).setFont(XListPeer.this.getFont());
                            if ((n4 & 0x20) != 0) {
                                ((Graphics)object).setColor(SystemColor.window);
                                ((Graphics)object).fillRect(0, 0, XListPeer.this.width, XListPeer.this.height);
                                ((Graphics)object).setColor(this.getListBackground());
                                ((Graphics)object).fillRect(0, 0, XListPeer.this.listWidth, XListPeer.this.listHeight);
                                XListPeer.this.draw3DRect((Graphics)object, XComponentPeer.getSystemColors(), 0, 0, XListPeer.this.listWidth - 1, XListPeer.this.listHeight - 1, false);
                                n2 = XListPeer.this.getFirstVisibleItem();
                                n3 = XListPeer.this.getLastVisibleItem();
                            }
                            if ((n4 & 8) != 0) {
                                this.paintItems((Graphics)object, n2, n3, n4);
                            }
                            if ((n4 & 2) != 0 && XListPeer.this.vsbVis) {
                                ((Graphics)object).setClip(XListPeer.this.getVScrollBarRec());
                                this.paintVerScrollbar((Graphics)object, true);
                            }
                            if ((n4 & 4) != 0 && XListPeer.this.hsbVis) {
                                ((Graphics)object).setClip(XListPeer.this.getHScrollBarRec());
                                this.paintHorScrollbar((Graphics)object, true);
                            }
                            if ((n4 & 0x50) == 0) continue block9;
                            this.paintFocus((Graphics)object, n4);
                            continue block9;
                        }
                        finally {
                            ((Graphics)object).dispose();
                        }
                    }
                }
            } while (volatileImage.contentsLost());
            graphics.drawImage(volatileImage, 0, 0, null);
        }

        private void paintItems(Graphics graphics, int n2, int n3, int n4) {
            int n5;
            if (log.isLoggable(Level.FINER)) {
                log.finer("Painting items from " + n2 + " to " + n3 + ", focused " + XListPeer.this.focusIndex + ", first " + XListPeer.this.getFirstVisibleItem() + ", last " + XListPeer.this.getLastVisibleItem());
            }
            if ((n2 = Math.max(XListPeer.this.getFirstVisibleItem(), n2)) > n3) {
                n5 = n3;
                n3 = n2;
                n2 = n5;
            }
            n2 = Math.max(XListPeer.this.getFirstVisibleItem(), n2);
            n3 = Math.min(n3, XListPeer.this.items.size() - 1);
            if (log.isLoggable(Level.FINER)) {
                log.finer("Actually painting items from " + n2 + " to " + n3 + ", items in window " + XListPeer.this.itemsInWindow());
            }
            for (n5 = n2; n5 <= n3; ++n5) {
                this.paintItem(graphics, n5);
            }
        }

        private void paintItem(Graphics graphics, int n2) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Painting item " + n2);
            }
            if (!XListPeer.this.isItemHidden(n2)) {
                Shape shape = graphics.getClip();
                int n3 = XListPeer.this.getItemWidth();
                int n4 = XListPeer.this.getItemHeight();
                int n5 = XListPeer.this.getItemY(n2);
                int n6 = XListPeer.this.getItemX();
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Setting clip " + new Rectangle(n6, n5, n3 - 2, n4 - 2));
                }
                graphics.setClip(n6, n5, n3 - 2, n4 - 2);
                if (XListPeer.this.isSelected(n2)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Painted item is selected");
                    }
                    graphics.setColor(this.getListForeground());
                } else {
                    graphics.setColor(this.getListBackground());
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Filling " + new Rectangle(n6, n5, n3, n4));
                }
                graphics.fillRect(n6, n5, n3, n4);
                if (n2 <= XListPeer.this.getLastVisibleItem() && n2 < XListPeer.this.items.size()) {
                    if (XListPeer.this.isSelected(n2)) {
                        graphics.setColor(this.getListBackground());
                    } else {
                        graphics.setColor(this.getListForeground());
                    }
                    String string = (String)XListPeer.this.items.elementAt(n2);
                    graphics.drawString(string, n6 - XListPeer.this.hsb.getValue(), n5 + XListPeer.this.fontAscent);
                } else {
                    graphics.setClip(n6, n5, XListPeer.this.listWidth, n4);
                    graphics.setColor(this.getListBackground());
                    graphics.fillRect(n6, n5, XListPeer.this.listWidth, n4);
                }
                graphics.setClip(shape);
            }
        }

        void paintScrollBar(XScrollbar xScrollbar, Graphics graphics, int n2, int n3, int n4, int n5, boolean bl2) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Painting scrollbar " + xScrollbar + " width " + n4 + " height " + n5 + ", paintAll " + bl2);
            }
            graphics.translate(n2, n3);
            xScrollbar.paint(graphics, XComponentPeer.getSystemColors(), bl2);
            graphics.translate(-n2, -n3);
        }

        void paintHorScrollbar(Graphics graphics, boolean bl2) {
            int n2 = XListPeer.this.getListWidth();
            this.paintScrollBar(XListPeer.this.hsb, graphics, 0, XListPeer.this.height - 13, n2, 13, bl2);
        }

        void paintVerScrollbar(Graphics graphics, boolean bl2) {
            int n2 = XListPeer.this.height - (XListPeer.this.hsbVis ? 15 : 0);
            this.paintScrollBar(XListPeer.this.vsb, graphics, XListPeer.this.width - 13, 0, 11, n2, bl2);
        }

        private void paintFocus(Graphics graphics, int n2) {
            boolean bl2;
            boolean bl3 = bl2 = (n2 & 0x10) != 0;
            if (bl2 && !XListPeer.this.hasFocus()) {
                bl2 = false;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Painting focus, focus index " + XListPeer.this.getFocusIndex() + ", focus is " + (XListPeer.this.isItemHidden(XListPeer.this.getFocusIndex()) ? "invisible" : "visible") + ", paint focus is " + bl2);
            }
            Shape shape = graphics.getClip();
            graphics.setClip(0, 0, XListPeer.this.listWidth, XListPeer.this.listHeight);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Setting focus clip " + new Rectangle(0, 0, XListPeer.this.listWidth, XListPeer.this.listHeight));
            }
            Rectangle rectangle = XListPeer.this.getFocusRect();
            if (this.prevFocusRect != null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Erasing previous focus rect " + this.prevFocusRect);
                }
                graphics.setColor(this.getListBackground());
                graphics.drawRect(this.prevFocusRect.x, this.prevFocusRect.y, this.prevFocusRect.width, this.prevFocusRect.height);
                this.prevFocusRect = null;
            }
            if (bl2) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Painting focus rect " + rectangle);
                }
                graphics.setColor(this.getListForeground());
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.prevFocusRect = rectangle;
            }
            graphics.setClip(shape);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7) {
            Object object;
            if (log.isLoggable(Level.FINER)) {
                log.finer("Copying area " + n2 + ", " + n3 + " " + n4 + "x" + n5 + ", (" + n6 + "," + n7 + ")");
            }
            VolatileImage volatileImage = null;
            do {
                object = this.BUFFER_LOCK;
                synchronized (object) {
                    if (this.createBuffer()) {
                        XListPeer.this.repaint(62);
                        return;
                    }
                    volatileImage = this.buffer;
                }
                switch (volatileImage.validate(XListPeer.this.getGraphicsConfiguration())) {
                    case 2: {
                        this.invalidate();
                    }
                    case 1: {
                        XListPeer.this.repaint(62);
                        return;
                    }
                }
                object = volatileImage.createGraphics();
                try {
                    ((Graphics)object).copyArea(n2, n3, n4, n5, n6, n7);
                }
                finally {
                    ((Graphics)object).dispose();
                }
            } while (volatileImage.contentsLost());
            object = XListPeer.this.getGraphics();
            ((Graphics)object).setClip(n2, n3, n4, n5);
            ((Graphics)object).drawImage(volatileImage, 0, 0, null);
            ((Graphics)object).dispose();
        }
    }
}

