/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.peer.DropTargetPeer;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.PaintEvent;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.awt.peer.LightweightPeer;
import java.awt.peer.WindowPeer;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.KeyboardFocusManagerPeerImpl;
import sun.awt.X11.ComponentAccessor;
import sun.awt.X11.IXAnyEvent;
import sun.awt.X11.MotifColorUtilities;
import sun.awt.X11.Native;
import sun.awt.X11.XConstants;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XGlobalCursorManager;
import sun.awt.X11.XKeyboardFocusManagerPeer;
import sun.awt.X11.XQueryTree;
import sun.awt.X11.XSetWindowAttributes;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributesData;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibWrapper;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.ToolkitImage;
import sun.font.FontManager;

public class XComponentPeer
extends XWindow
implements ComponentPeer,
DropTargetPeer,
XConstants {
    static final int SNFH_FAILURE = 0;
    static final int SNFH_SUCCESS_HANDLED = 1;
    static final int SNFH_SUCCESS_PROCEED = 2;
    private static final Logger log = Logger.getLogger("sun.awt.X11.XComponentPeer");
    private static final Logger buffersLog = Logger.getLogger("sun.awt.X11.XComponentPeer.multibuffer");
    private static final Logger focusLog = Logger.getLogger("sun.awt.X11.focus.XComponentPeer");
    private static final Logger fontLog = Logger.getLogger("sun.awt.X11.font.XComponentPeer");
    private static final Logger enableLog = Logger.getLogger("sun.awt.X11.enable.XComponentPeer");
    boolean paintPending = false;
    boolean isLayouting = false;
    boolean enabled;
    protected int boundsOperation;
    Color foreground;
    Color background;
    Color darkShadow;
    Color lightShadow;
    Color selectColor;
    Font font;
    private long backBuffer = 0L;
    private VolatileImage xBackBuffer = null;
    static Color[] systemColors;
    boolean bHasFocus = false;
    private static Class seClass;
    private static Constructor seCtor;
    static Method processSynchronousLightweightTransferMethod;
    static Hashtable metrics;
    static final int BACKGROUND_COLOR = 0;
    static final int HIGHLIGHT_COLOR = 1;
    static final int SHADOW_COLOR = 2;
    static final int FOREGROUND_COLOR = 3;

    XComponentPeer() {
    }

    XComponentPeer(XCreateWindowParams xCreateWindowParams) {
        super(xCreateWindowParams);
    }

    XComponentPeer(Component component, long l2, Rectangle rectangle) {
        super(component, l2, rectangle);
    }

    void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        this.boundsOperation = 3;
    }

    void postInit(XCreateWindowParams xCreateWindowParams) {
        Serializable serializable;
        super.postInit(xCreateWindowParams);
        this.pSetCursor(this.target.getCursor());
        this.foreground = this.target.getForeground();
        this.background = this.target.getBackground();
        this.font = this.target.getFont();
        if (this.isInitialReshape()) {
            serializable = this.target.getBounds();
            this.reshape(((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width, ((Rectangle)serializable).height);
        }
        this.enabled = this.target.isEnabled();
        serializable = this.target;
        while (serializable != null && !(serializable instanceof Window)) {
            if ((serializable = ((Component)serializable).getParent()) == null || ((Component)serializable).isEnabled()) continue;
            this.setEnabled(false);
            break;
        }
        enableLog.log(Level.FINE, "Initial enable state: {0}", new Object[]{this.enabled});
        if (this.target.isVisible()) {
            this.show();
        }
    }

    XComponentPeer(Component component) {
        super(component);
    }

    protected boolean isInitialReshape() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reparent(ContainerPeer containerPeer) {
        XComponentPeer xComponentPeer = (XComponentPeer)((Object)containerPeer);
        Object object = XComponentPeer.getAWTLock();
        synchronized (object) {
            XlibWrapper.XReparentWindow(XToolkit.getDisplay(), this.getWindow(), xComponentPeer.getContentWindow(), this.x, this.y);
        }
    }

    public boolean isReparentSupported() {
        return System.getProperty("sun.awt.X11.XComponentPeer.reparentNotSupported", "false").equals("false");
    }

    public boolean isObscured() {
        XWindowPeer xWindowPeer;
        Container container;
        Container container2;
        Container container3 = container2 = this.target instanceof Container ? (Container)this.target : this.target.getParent();
        if (container2 == null) {
            return true;
        }
        while ((container = container2.getParent()) != null) {
            container2 = container;
        }
        if (container2 instanceof Window && (xWindowPeer = (XWindowPeer)container2.getPeer()) != null) {
            XWindowAttributesData cfr_ignored_0 = xWindowPeer.winAttr;
            return xWindowPeer.winAttr.visibilityState != XWindowAttributesData.AWT_UNOBSCURED;
        }
        return true;
    }

    public boolean canDetermineObscurity() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XComponentPeer getNativeContainer(Component component) {
        if (component == null) {
            return null;
        }
        Object object = component.getTreeLock();
        synchronized (object) {
            ComponentPeer componentPeer;
            while (component != null && ComponentAccessor.getPeer(component) instanceof LightweightPeer) {
                component = ComponentAccessor.getParent_NoClientCode(component);
            }
            if (component != null && (componentPeer = ComponentAccessor.getPeer(component)) != null && componentPeer instanceof XComponentPeer) {
                return (XComponentPeer)componentPeer;
            }
        }
        return null;
    }

    public final boolean hasFocus() {
        return this.bHasFocus;
    }

    public void focusGained(FocusEvent focusEvent) {
        focusLog.log(Level.FINE, "{0}", new Object[]{focusEvent});
        XKeyboardFocusManagerPeer.setCurrentNativeFocusOwner(this.target);
        this.bHasFocus = true;
    }

    public void focusLost(FocusEvent focusEvent) {
        focusLog.log(Level.FINE, "{0}", new Object[]{focusEvent});
        XKeyboardFocusManagerPeer.setCurrentNativeFocusOwner(null);
        this.bHasFocus = false;
    }

    public boolean isFocusable() {
        return false;
    }

    static final AWTEvent wrapInSequenced(AWTEvent aWTEvent) {
        block10: {
            try {
                if (seClass == null) {
                    seClass = Class.forName("java.awt.SequencedEvent");
                }
                if (seCtor == null) {
                    seCtor = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            Constructor constructor = seClass.getConstructor(AWTEvent.class);
                            constructor.setAccessible(true);
                            return constructor;
                        }
                    });
                }
                return (AWTEvent)seCtor.newInstance(aWTEvent);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError("java.awt.SequencedEvent.");
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new NoClassDefFoundError("java.awt.SequencedEvent.");
            }
            catch (InstantiationException instantiationException) {
                assert (false);
            }
            catch (IllegalAccessException illegalAccessException) {
                assert (false);
            }
            catch (InvocationTargetException invocationTargetException) {
                if ($assertionsDisabled) break block10;
                throw new AssertionError();
            }
        }
        return null;
    }

    protected boolean shouldFocusOnClick() {
        return this.isFocusable();
    }

    static boolean canBeFocusedByClick(Component component) {
        if (component == null) {
            return false;
        }
        return component.isDisplayable() && component.isVisible() && component.isEnabled() && component.isFocusable();
    }

    static Window getContainingWindow(Component component) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        return (Window)component;
    }

    static boolean processSynchronousLightweightTransfer(Component component, Component component2, boolean bl2, boolean bl3, long l2) {
        try {
            if (processSynchronousLightweightTransferMethod == null) {
                processSynchronousLightweightTransferMethod = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IllegalAccessException, NoSuchMethodException {
                        Method method = KeyboardFocusManager.class.getDeclaredMethod("processSynchronousLightweightTransfer", Component.class, Component.class, Boolean.TYPE, Boolean.TYPE, Long.TYPE);
                        method.setAccessible(true);
                        return method;
                    }
                });
            }
            Object[] objectArray = new Object[]{component, component2, bl2, bl3, new Long(l2)};
            return (Boolean)processSynchronousLightweightTransferMethod.invoke(null, objectArray);
        }
        catch (PrivilegedActionException privilegedActionException) {
            privilegedActionException.printStackTrace();
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            return false;
        }
    }

    public final boolean requestFocus(Component component, boolean bl2, boolean bl3, long l2) {
        if (XComponentPeer.processSynchronousLightweightTransfer(this.target, component, bl2, bl3, l2)) {
            return true;
        }
        int n2 = XKeyboardFocusManagerPeer.shouldNativelyFocusHeavyweight(this.target, component, bl2, bl3, l2);
        switch (n2) {
            case 0: {
                return false;
            }
            case 2: {
                Window window;
                if (focusLog.isLoggable(Level.FINER)) {
                    focusLog.finer("Proceeding with request to " + component + " in " + this.target);
                }
                if ((window = XComponentPeer.getContainingWindow(this.target)) != null) {
                    if (!window.isFocused()) {
                        WindowPeer windowPeer = (WindowPeer)window.getPeer();
                        boolean bl4 = windowPeer.requestWindowFocus();
                        if (focusLog.isLoggable(Level.FINER)) {
                            focusLog.finer("Requested window focus: " + bl4);
                        }
                        if (!bl4 || !window.isFocused()) {
                            focusLog.finer("Waiting for asynchronous processing of window focus request");
                            KeyboardFocusManagerPeerImpl.removeLastFocusRequest(this.target);
                            return false;
                        }
                    }
                } else {
                    if (focusLog.isLoggable(Level.FINER)) {
                        focusLog.finer("WARNING: Parent window is null");
                    }
                    return false;
                }
                return XKeyboardFocusManagerPeer.simulateMotifRequestFocus(component, this.target, bl2, bl3, l2);
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    void handleJavaFocusEvent(AWTEvent aWTEvent) {
        if (focusLog.isLoggable(Level.FINER)) {
            focusLog.finer(aWTEvent.toString());
        }
        if (aWTEvent.getID() == 1004) {
            this.focusGained((FocusEvent)aWTEvent);
        } else {
            this.focusLost((FocusEvent)aWTEvent);
        }
    }

    void handleJavaWindowFocusEvent(AWTEvent aWTEvent) {
    }

    public void setVisible(boolean bl2) {
        this.xSetVisible(bl2);
    }

    public void show() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public void setEnabled(boolean bl2) {
        enableLog.log(Level.FINE, "{0}ing {1}", new Object[]{bl2 ? "Enabl" : "Disabl", this});
        boolean bl3 = this.enabled != bl2;
        this.enabled = bl2;
        if (this.target instanceof Container) {
            Component[] componentArray = ((Container)this.target).getComponents();
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                boolean bl4 = componentArray[i2].isEnabled();
                ComponentPeer componentPeer = componentArray[i2].getPeer();
                if (componentPeer == null) continue;
                componentPeer.setEnabled(bl2 && bl4);
            }
        }
        if (bl3) {
            this.repaint();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void paint(Graphics graphics) {
    }

    public void repaint(long l2, int n2, int n3, int n4, int n5) {
        this.repaint();
    }

    public Graphics getGraphics() {
        return this.getGraphics(this.surfaceData, this.getPeerForeground(), this.getPeerBackground(), this.getPeerFont());
    }

    public void print(Graphics graphics) {
        graphics.setColor(this.target.getBackground());
        graphics.fillRect(0, 0, this.target.getWidth(), this.target.getHeight());
        graphics.setColor(this.target.getForeground());
        this.paint(graphics);
        this.target.print(graphics);
    }

    public void setBounds(int n2, int n3, int n4, int n5, int n6) {
        this.x = n2;
        this.y = n3;
        this.width = n4;
        this.height = n5;
        this.xSetBounds(n2, n3, n4, n5);
        this.validateSurface();
        this.layout();
    }

    public void reshape(int n2, int n3, int n4, int n5) {
        this.setBounds(n2, n3, n4, n5, 3);
    }

    public void coalescePaintEvent(PaintEvent paintEvent) {
        Rectangle rectangle = paintEvent.getUpdateRect();
        this.paintArea.add(rectangle, paintEvent.getID());
        switch (paintEvent.getID()) {
            case 801: {
                log.finer("XCP coalescePaintEvent : UPDATE : add : x = " + rectangle.x + ", y = " + rectangle.y + ", width = " + rectangle.width + ",height = " + rectangle.height);
                return;
            }
            case 800: {
                log.finer("XCP coalescePaintEvent : PAINT : add : x = " + rectangle.x + ", y = " + rectangle.y + ", width = " + rectangle.width + ",height = " + rectangle.height);
                return;
            }
        }
    }

    XWindowPeer getParentWindow() {
        Container container;
        Container container2 = container = this.target instanceof Container ? (Container)this.target : ComponentAccessor.getParent_NoClientCode(this.target);
        while (container != null && !(container instanceof Window)) {
            container = ComponentAccessor.getParent_NoClientCode(container);
        }
        if (container != null) {
            return (XWindowPeer)((Window)container).getPeer();
        }
        return null;
    }

    void handleJavaMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                if (this.target != mouseEvent.getSource() || !this.shouldFocusOnClick() || this.target.isFocusOwner() || !XComponentPeer.canBeFocusedByClick(this.target)) break;
                XWindowPeer xWindowPeer = this.getParentWindow();
                Window window = (Window)xWindowPeer.getTarget();
                this.target.requestFocus();
            }
        }
    }

    void handleJavaKeyEvent(KeyEvent keyEvent) {
    }

    void handleJavaMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
    }

    void handleJavaInputMethodEvent(InputMethodEvent inputMethodEvent) {
    }

    public void handleEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof InputEvent && !((InputEvent)aWTEvent).isConsumed() && this.target.isEnabled()) {
            if (aWTEvent instanceof MouseEvent) {
                if (aWTEvent instanceof MouseWheelEvent) {
                    this.handleJavaMouseWheelEvent((MouseWheelEvent)aWTEvent);
                } else {
                    this.handleJavaMouseEvent((MouseEvent)aWTEvent);
                }
            } else if (aWTEvent instanceof KeyEvent) {
                this.handleJavaKeyEvent((KeyEvent)aWTEvent);
            }
        } else if (aWTEvent instanceof InputMethodEvent) {
            this.handleJavaInputMethodEvent((InputMethodEvent)aWTEvent);
        }
        int n2 = aWTEvent.getID();
        switch (n2) {
            case 800: {
                this.paintPending = false;
            }
            case 801: {
                if (!this.isLayouting && !this.paintPending) {
                    this.paintArea.paint(this.target, false);
                }
                return;
            }
            case 1004: 
            case 1005: {
                this.handleJavaFocusEvent(aWTEvent);
                break;
            }
            case 207: 
            case 208: {
                this.handleJavaWindowFocusEvent(aWTEvent);
                break;
            }
        }
    }

    public Dimension getMinimumSize() {
        return this.target.getSize();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void layout() {
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    void updateMotifColors(Color color) {
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        this.darkShadow = new Color(MotifColorUtilities.calculateBottomShadowFromBackground(n2, n3, n4));
        this.lightShadow = new Color(MotifColorUtilities.calculateTopShadowFromBackground(n2, n3, n4));
        this.selectColor = new Color(MotifColorUtilities.calculateSelectFromBackground(n2, n3, n4));
    }

    public void drawMotif3DRect(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl2) {
        graphics.setColor(bl2 ? this.darkShadow : this.lightShadow);
        graphics.drawLine(n2, n3, n2 + n4, n3);
        graphics.drawLine(n2, n3 + n5, n2, n3);
        graphics.setColor(bl2 ? this.lightShadow : this.darkShadow);
        graphics.drawLine(n2 + 1, n3 + n5, n2 + n4, n3 + n5);
        graphics.drawLine(n2 + n4, n3 + n5, n2 + n4, n3 + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackground(Color color) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Set background to " + color);
        }
        Object object = this.getStateLock();
        synchronized (object) {
            this.background = color;
        }
        super.setBackground(color);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForeground(Color color) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Set foreground to " + color);
        }
        Object object = this.getStateLock();
        synchronized (object) {
            this.foreground = color;
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontMetrics getFontMetrics(Font font) {
        Graphics graphics;
        FontMetrics fontMetrics;
        if (fontLog.isLoggable(Level.FINE)) {
            fontLog.fine("Getting font metrics for " + font);
        }
        if ((fontMetrics = (FontMetrics)metrics.get(font)) != null) {
            return fontMetrics;
        }
        if (FontManager.usePlatformFontMetrics()) {
            fontMetrics = super.getFontMetrics(font);
            metrics.put(font, fontMetrics);
            return fontMetrics;
        }
        if (this.parent != null && (graphics = this.parent.getGraphics()) != null) {
            try {
                fontMetrics = graphics.getFontMetrics(font);
                metrics.put(font, fontMetrics);
                FontMetrics fontMetrics2 = fontMetrics;
                return fontMetrics2;
            }
            finally {
                graphics.dispose();
            }
        }
        fontMetrics = this.getToolkit().getFontMetrics(font);
        metrics.put(font, fontMetrics);
        return fontMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFont(Font font) {
        Object object = this.getStateLock();
        synchronized (object) {
            if (font == null) {
                font = defaultFont;
            }
            this.font = font;
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void updateCursorImmediately() {
        XGlobalCursorManager.getCursorManager().updateCursorImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pSetCursor(Cursor cursor) {
        Object object = XComponentPeer.getAWTLock();
        synchronized (object) {
            long l2 = XGlobalCursorManager.getCursor(cursor);
            XSetWindowAttributes xSetWindowAttributes = new XSetWindowAttributes();
            xSetWindowAttributes.set_cursor(l2);
            long l3 = 16384L;
            XlibWrapper.XChangeWindowAttributes(XToolkit.getDisplay(), this.getWindow(), l3, xSetWindowAttributes.pData);
            XlibWrapper.XFlush(XToolkit.getDisplay());
            xSetWindowAttributes.dispose();
        }
    }

    public Image createImage(ImageProducer imageProducer) {
        return new ToolkitImage(imageProducer);
    }

    public Image createImage(int n2, int n3) {
        return this.graphicsConfig.createAcceleratedImage(this.target, n2, n3);
    }

    public VolatileImage createVolatileImage(int n2, int n3) {
        return new SunVolatileImage(this.target, n2, n3);
    }

    public boolean prepareImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        return this.getToolkit().prepareImage(image, n2, n3, imageObserver);
    }

    public int checkImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        return this.getToolkit().checkImage(image, n2, n3, imageObserver);
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public void beginValidate() {
    }

    public void endValidate() {
    }

    public Insets insets() {
        return this.getInsets();
    }

    public boolean isPaintPending() {
        return this.paintPending && this.isLayouting;
    }

    public void cancelPendingPaint(int n2, int n3, int n4, int n5) {
        if (this.target instanceof Container) {
            Insets insets = ((Container)this.target).getInsets();
            this.paintArea.constrain(insets.left, insets.top, this.target.getWidth() - insets.left - insets.right, this.target.getHeight() - insets.top - insets.bottom);
        }
        this.paintArea.subtract(n2, n3, n4, n5);
    }

    public boolean handlesWheelScrolling() {
        return false;
    }

    public void beginLayout() {
        this.isLayouting = true;
    }

    public void endLayout() {
        if (!(this.paintPending || this.paintArea.isEmpty() || ComponentAccessor.getIgnoreRepaint(this.target))) {
            this.postEvent(new PaintEvent(this.target, 800, new Rectangle()));
        }
        this.isLayouting = false;
    }

    public Color getWinBackground() {
        return this.getPeerBackground();
    }

    static int[] getRGBvals(Color color) {
        int[] nArray = new int[]{color.getRed(), color.getGreen(), color.getBlue()};
        return nArray;
    }

    public Color[] getGUIcolors() {
        Color[] colorArray = new Color[4];
        colorArray[0] = this.getWinBackground();
        if (colorArray[0] == null) {
            colorArray[0] = super.getWinBackground();
        }
        if (colorArray[0] == null) {
            colorArray[0] = Color.lightGray;
        }
        int[] nArray = XComponentPeer.getRGBvals(colorArray[0]);
        float[] fArray = Color.RGBtoHSB(nArray[0], nArray[1], nArray[2], null);
        float f2 = fArray[0];
        float f3 = fArray[1];
        float f4 = fArray[2];
        float f5 = f4 + 0.2f;
        float f6 = f4 - 0.4f;
        if ((double)f5 > 1.0) {
            f5 = 1.0 - (double)f4 < 0.05 ? f6 + 0.25f : 1.0f;
        } else if ((double)f6 < 0.0) {
            if ((double)f4 - 0.0 < 0.25) {
                f5 = f4 + 0.75f;
                f6 = f5 - 0.2f;
            } else {
                f6 = 0.0f;
            }
        }
        colorArray[1] = Color.getHSBColor(f2, f3, f5);
        colorArray[2] = Color.getHSBColor(f2, f3, f6);
        colorArray[3] = this.getPeerForeground();
        if (colorArray[3] == null) {
            colorArray[3] = Color.black;
        }
        if (!this.isEnabled()) {
            Color color = colorArray[0];
            int n2 = color.getRed() * 30 + color.getGreen() * 59 + color.getBlue() * 11;
            color = colorArray[3];
            int n3 = color.getRed() * 30 + color.getGreen() * 59 + color.getBlue() * 11;
            float f7 = (float)((double)(n3 + n2) / 51000.0);
            Color color2 = new Color((int)((float)color.getRed() * f7), (int)((float)color.getGreen() * f7), (int)((float)color.getBlue() * f7));
            if (color2.equals(colorArray[3])) {
                color2 = new Color(f7, f7, f7);
            }
            colorArray[3] = color2;
        }
        return colorArray;
    }

    static Color[] getSystemColors() {
        if (systemColors == null) {
            systemColors = new Color[4];
            XComponentPeer.systemColors[0] = SystemColor.window;
            XComponentPeer.systemColors[1] = SystemColor.controlLtHighlight;
            XComponentPeer.systemColors[2] = SystemColor.controlShadow;
            XComponentPeer.systemColors[3] = SystemColor.windowText;
        }
        return systemColors;
    }

    public void draw3DOval(Graphics graphics, Color[] colorArray, int n2, int n3, int n4, int n5, boolean bl2) {
        Color color = graphics.getColor();
        graphics.setColor(bl2 ? colorArray[1] : colorArray[2]);
        graphics.drawArc(n2, n3, n4, n5, 45, 180);
        graphics.setColor(bl2 ? colorArray[2] : colorArray[1]);
        graphics.drawArc(n2, n3, n4, n5, 225, 180);
        graphics.setColor(color);
    }

    public void draw3DRect(Graphics graphics, Color[] colorArray, int n2, int n3, int n4, int n5, boolean bl2) {
        Color color = graphics.getColor();
        graphics.setColor(bl2 ? colorArray[1] : colorArray[2]);
        graphics.drawLine(n2, n3, n2, n3 + n5);
        graphics.drawLine(n2 + 1, n3, n2 + n4 - 1, n3);
        graphics.setColor(bl2 ? colorArray[2] : colorArray[1]);
        graphics.drawLine(n2 + 1, n3 + n5, n2 + n4, n3 + n5);
        graphics.drawLine(n2 + n4, n3, n2 + n4, n3 + n5 - 1);
        graphics.setColor(color);
    }

    void draw3DOval(Graphics graphics, Color color, int n2, int n3, int n4, int n5, boolean bl2) {
        Color color2 = graphics.getColor();
        Color color3 = color.darker();
        Color color4 = color.brighter();
        graphics.setColor(bl2 ? color4 : color3);
        graphics.drawArc(n2, n3, n4, n5, 45, 180);
        graphics.setColor(bl2 ? color3 : color4);
        graphics.drawArc(n2, n3, n4, n5, 225, 180);
        graphics.setColor(color2);
    }

    void draw3DRect(Graphics graphics, Color color, int n2, int n3, int n4, int n5, boolean bl2) {
        Color color2 = graphics.getColor();
        Color color3 = color.darker();
        Color color4 = color.brighter();
        graphics.setColor(bl2 ? color4 : color3);
        graphics.drawLine(n2, n3, n2, n3 + n5);
        graphics.drawLine(n2 + 1, n3, n2 + n4 - 1, n3);
        graphics.setColor(bl2 ? color3 : color4);
        graphics.drawLine(n2 + 1, n3 + n5, n2 + n4, n3 + n5);
        graphics.drawLine(n2 + n4, n3, n2 + n4, n3 + n5 - 1);
        graphics.setColor(color2);
    }

    void drawScrollbar(Graphics graphics, Color color, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        Color color2 = graphics.getColor();
        double d2 = (double)(n3 - 2 * (n2 - 1)) / (double)Math.max(1, n5 - n4 + n7);
        int n8 = n2 + (int)(d2 * (double)(n6 - n4));
        int n9 = (int)(d2 * (double)n7);
        int n10 = n2 - 4;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        if (n3 < 3 * n10) {
            n9 = 0;
            n8 = 0;
            if (n3 < 2 * n10 + 2) {
                n10 = (n3 - 2) / 2;
            }
        } else if (n9 < 7) {
            n8 = Math.max(0, n8 - (7 - n9 >> 1));
            n9 = 7;
        }
        int n11 = n2 / 2;
        int n12 = n11 - n10 / 2;
        int n13 = n11 + n10 / 2;
        Color color3 = new Color((int)((double)color.getRed() * 0.85), (int)((double)color.getGreen() * 0.85), (int)((double)color.getBlue() * 0.85));
        graphics.setColor(color3);
        if (bl2) {
            graphics.fillRect(0, 0, n3, n2);
        } else {
            graphics.fillRect(0, 0, n2, n3);
        }
        graphics.setColor(color);
        if (n8 > 0) {
            if (bl2) {
                graphics.fillRect(n8, 3, n9, n2 - 3);
            } else {
                graphics.fillRect(3, n8, n2 - 3, n9);
            }
        }
        nArray[0] = n11;
        nArray2[0] = 2;
        nArray[1] = n12;
        nArray2[1] = n10;
        nArray[2] = n13;
        nArray2[2] = n10;
        if (bl2) {
            graphics.fillPolygon(nArray2, nArray, 3);
        } else {
            graphics.fillPolygon(nArray, nArray2, 3);
        }
        nArray2[0] = n3 - 2;
        nArray2[1] = n3 - n10;
        nArray2[2] = n3 - n10;
        if (bl2) {
            graphics.fillPolygon(nArray2, nArray, 3);
        } else {
            graphics.fillPolygon(nArray, nArray2, 3);
        }
        color3 = color.brighter();
        graphics.setColor(color3);
        if (bl2) {
            graphics.drawLine(1, n2, n3 - 1, n2);
            graphics.drawLine(n3 - 1, 1, n3 - 1, n2);
            graphics.drawLine(1, n11, n10, n12);
            graphics.drawLine(n3 - n10, n12, n3 - n10, n13);
            graphics.drawLine(n3 - n10, n12, n3 - 2, n11);
        } else {
            graphics.drawLine(n2, 1, n2, n3 - 1);
            graphics.drawLine(1, n3 - 1, n2, n3 - 1);
            graphics.drawLine(n11, 1, n12, n10);
            graphics.drawLine(n12, n3 - n10, n13, n3 - n10);
            graphics.drawLine(n12, n3 - n10, n11, n3 - 2);
        }
        if (n8 > 0) {
            if (bl2) {
                graphics.drawLine(n8, 2, n8 + n9, 2);
                graphics.drawLine(n8, 2, n8, n2 - 3);
            } else {
                graphics.drawLine(2, n8, 2, n8 + n9);
                graphics.drawLine(2, n8, n2 - 3, n8);
            }
        }
        Color color4 = color.darker();
        graphics.setColor(color4);
        if (bl2) {
            graphics.drawLine(0, 0, 0, n2);
            graphics.drawLine(0, 0, n3 - 1, 0);
            graphics.drawLine(n10, n12, n10, n13);
            graphics.drawLine(n10, n13, 1, n11);
            graphics.drawLine(n3 - 2, n11, n3 - n10, n13);
        } else {
            graphics.drawLine(0, 0, n2, 0);
            graphics.drawLine(0, 0, 0, n3 - 1);
            graphics.drawLine(n12, n10, n13, n10);
            graphics.drawLine(n13, n10, n11, 1);
            graphics.drawLine(n11, n3 - 2, n13, n3 - n10);
        }
        if (n8 > 0) {
            if (bl2) {
                graphics.drawLine(n8 + n9, 2, n8 + n9, n2 - 2);
                graphics.drawLine(n8, n2 - 2, n8 + n9, n2 - 2);
            } else {
                graphics.drawLine(2, n8 + n9, n2 - 2, n8 + n9);
                graphics.drawLine(n2 - 2, n8, n2 - 2, n8 + n9);
            }
        }
        graphics.setColor(color2);
    }

    public void createBuffers(int n2, BufferCapabilities bufferCapabilities) throws AWTException {
        if (buffersLog.isLoggable(Level.FINE)) {
            buffersLog.fine("createBuffers(" + n2 + ", " + bufferCapabilities + ")");
        }
        this.backBuffer = this.graphicsConfig.createBackBuffer(this, n2, bufferCapabilities);
        this.xBackBuffer = this.graphicsConfig.createBackBufferImage(this.target, this.backBuffer);
    }

    public void flip(BufferCapabilities.FlipContents flipContents) {
        if (buffersLog.isLoggable(Level.FINE)) {
            buffersLog.fine("flip(" + flipContents + ")");
        }
        if (this.backBuffer == 0L) {
            throw new IllegalStateException("Buffers have not been created");
        }
        this.graphicsConfig.flip(this, this.target, this.xBackBuffer, flipContents);
    }

    public Image getBackBuffer() {
        if (buffersLog.isLoggable(Level.FINE)) {
            buffersLog.fine("getBackBuffer()");
        }
        if (this.backBuffer == 0L) {
            throw new IllegalStateException("Buffers have not been created");
        }
        return this.xBackBuffer;
    }

    public void destroyBuffers() {
        if (buffersLog.isLoggable(Level.FINE)) {
            buffersLog.fine("destroyBuffers()");
        }
        this.graphicsConfig.destroyBackBuffer(this.backBuffer);
        this.backBuffer = 0L;
        this.xBackBuffer = null;
    }

    public void notifyTextComponentChange(boolean bl2) {
        Container container = ComponentAccessor.getParent_NoClientCode(this.target);
        while (container != null && !(container instanceof Frame) && !(container instanceof Dialog)) {
            container = ComponentAccessor.getParent_NoClientCode(container);
        }
    }

    protected boolean isEventDisabled(IXAnyEvent iXAnyEvent) {
        enableLog.log(Level.FINEST, "Component is {1}, checking for disabled event {0}", new Object[]{iXAnyEvent, this.isEnabled() ? "enabled" : "disable"});
        if (!this.isEnabled()) {
            switch (iXAnyEvent.get_type()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    enableLog.log(Level.FINER, "Event {0} is disable", new Object[]{iXAnyEvent});
                    return true;
                }
            }
        }
        switch (iXAnyEvent.get_type()) {
            case 18: 
            case 19: {
                return true;
            }
        }
        return super.isEventDisabled(iXAnyEvent);
    }

    Color getPeerBackground() {
        return this.background;
    }

    Color getPeerForeground() {
        return this.foreground;
    }

    Font getPeerFont() {
        return this.font;
    }

    Dimension getPeerSize() {
        return new Dimension(this.width, this.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBoundsOperation(int n2) {
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.boundsOperation == 3) {
                this.boundsOperation = n2;
            } else if (n2 == 5) {
                this.boundsOperation = 3;
            }
        }
    }

    static String operationToString(int n2) {
        switch (n2) {
            case 1: {
                return "SET_LOCATION";
            }
            case 2: {
                return "SET_SIZE";
            }
            case 4: {
                return "SET_CLIENT_SIZE";
            }
        }
        return "SET_BOUNDS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restack() {
        Object object = this.target.getTreeLock();
        synchronized (object) {
            Container container = (Container)this.target;
            Vector<Long> vector = new Vector<Long>(container.getComponentCount());
            HashSet<Long> hashSet = new HashSet<Long>();
            this.addTree(vector, hashSet, container);
            Object object2 = XComponentPeer.getAWTLock();
            synchronized (object2) {
                XQueryTree xQueryTree = new XQueryTree(this.getContentWindow());
                try {
                    long l2;
                    if (xQueryTree.execute() != 0 && xQueryTree.get_nchildren() != 0) {
                        l2 = xQueryTree.get_children();
                        int n2 = 0;
                        for (int i2 = 0; i2 < xQueryTree.get_nchildren(); ++i2) {
                            Long l3 = new Long(Native.getLong(l2, i2));
                            if (hashSet.contains(l3)) continue;
                            hashSet.add(l3);
                            vector.add(n2++, l3);
                        }
                    }
                    if (vector.size() != 0) {
                        l2 = Native.allocateLongArray(vector.size());
                        Native.putLong(l2, vector);
                        XlibWrapper.XRestackWindows(XToolkit.getDisplay(), l2, vector.size());
                        XlibWrapper.unsafe.freeMemory(l2);
                    }
                }
                finally {
                    xQueryTree.dispose();
                }
            }
        }
    }

    public boolean isRestackSupported() {
        return true;
    }

    private void addTree(Collection collection, Set set, Container container) {
        for (int i2 = 0; i2 < container.getComponentCount(); ++i2) {
            Component component = container.getComponent(i2);
            ComponentPeer componentPeer = component.getPeer();
            if (componentPeer instanceof XComponentPeer) {
                Long l2 = new Long(((XComponentPeer)componentPeer).getWindow());
                if (set.contains(l2)) continue;
                set.add(l2);
                collection.add(l2);
                continue;
            }
            if (!(component instanceof Container)) continue;
            this.addTree(collection, set, (Container)component);
        }
    }

    public void addDropTarget(DropTarget dropTarget) {
        XWindowPeer xWindowPeer;
        Component component;
        for (component = this.target; component != null && !(component instanceof Window); component = component.getParent()) {
        }
        if (component instanceof Window && (xWindowPeer = (XWindowPeer)component.getPeer()) != null) {
            xWindowPeer.addDropTarget();
        }
    }

    public void removeDropTarget(DropTarget dropTarget) {
        XWindowPeer xWindowPeer;
        Component component;
        for (component = this.target; component != null && !(component instanceof Window); component = component.getParent()) {
        }
        if (component instanceof Window && (xWindowPeer = (XWindowPeer)component.getPeer()) != null) {
            xWindowPeer.removeDropTarget();
        }
    }

    static {
        metrics = ComponentAccessor.getMetrics();
    }
}

