/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;

class KeyboardManager {
    static KeyboardManager currentManager = new KeyboardManager();
    Hashtable containerMap = new Hashtable();
    Hashtable componentKeyStrokeMap = new Hashtable();

    KeyboardManager() {
    }

    public static KeyboardManager getCurrentManager() {
        return currentManager;
    }

    public static void setCurrentManager(KeyboardManager keyboardManager) {
        currentManager = keyboardManager;
    }

    public void registerKeyStroke(KeyStroke keyStroke, JComponent jComponent) {
        Object v2;
        Container container = KeyboardManager.getTopAncestor(jComponent);
        if (container == null) {
            return;
        }
        Hashtable hashtable = (Hashtable)this.containerMap.get(container);
        if (hashtable == null) {
            hashtable = this.registerNewTopContainer(container);
        }
        if ((v2 = hashtable.get(keyStroke)) == null) {
            hashtable.put(keyStroke, jComponent);
        } else if (v2 instanceof Vector) {
            Vector vector = (Vector)v2;
            if (!vector.contains(jComponent)) {
                vector.addElement(jComponent);
            }
        } else if (v2 instanceof JComponent) {
            if (v2 != jComponent) {
                Vector<Object> vector = new Vector<Object>();
                vector.addElement(v2);
                vector.addElement(jComponent);
                hashtable.put(keyStroke, vector);
            }
        } else {
            System.out.println("Unexpected condition in registerKeyStroke");
            Thread.dumpStack();
        }
        this.componentKeyStrokeMap.put(new ComponentKeyStrokePair(jComponent, keyStroke), container);
    }

    private static Container getTopAncestor(JComponent jComponent) {
        for (Container container = jComponent.getParent(); container != null; container = container.getParent()) {
            if ((!(container instanceof Window) || !((Window)container).isFocusableWindow()) && !(container instanceof Applet) && !(container instanceof JInternalFrame)) continue;
            return container;
        }
        return null;
    }

    public void unregisterKeyStroke(KeyStroke keyStroke, JComponent jComponent) {
        ComponentKeyStrokePair componentKeyStrokePair = new ComponentKeyStrokePair(jComponent, keyStroke);
        Object v2 = this.componentKeyStrokeMap.get(componentKeyStrokePair);
        if (v2 == null) {
            return;
        }
        Hashtable hashtable = (Hashtable)this.containerMap.get(v2);
        if (hashtable == null) {
            Thread.dumpStack();
            return;
        }
        Object v3 = hashtable.get(keyStroke);
        if (v3 == null) {
            Thread.dumpStack();
            return;
        }
        if (v3 instanceof JComponent && v3 == jComponent) {
            hashtable.remove(keyStroke);
        } else if (v3 instanceof Vector) {
            Vector vector = (Vector)v3;
            vector.removeElement(jComponent);
            if (vector.isEmpty()) {
                hashtable.remove(keyStroke);
            }
        }
        if (hashtable.isEmpty()) {
            this.containerMap.remove(v2);
        }
        this.componentKeyStrokeMap.remove(componentKeyStrokePair);
    }

    public boolean fireKeyboardAction(KeyEvent keyEvent, boolean bl2, Container container) {
        Object object;
        Object object2;
        if (keyEvent.isConsumed()) {
            System.out.println("Aquired pre-used event!");
            Thread.dumpStack();
        }
        KeyStroke keyStroke = keyEvent.getID() == 400 ? KeyStroke.getKeyStroke(keyEvent.getKeyChar()) : KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers(), !bl2);
        Hashtable hashtable = (Hashtable)this.containerMap.get(container);
        if (hashtable != null && (object2 = hashtable.get(keyStroke)) != null) {
            if (object2 instanceof JComponent) {
                object = (JComponent)object2;
                if (((Component)object).isShowing() && ((Component)object).isEnabled()) {
                    this.fireBinding((JComponent)object, keyStroke, keyEvent, bl2);
                }
            } else if (object2 instanceof Vector) {
                object = (Vector)object2;
                for (int i2 = ((Vector)object).size() - 1; i2 >= 0; --i2) {
                    JComponent jComponent = (JComponent)((Vector)object).elementAt(i2);
                    if (!jComponent.isShowing() || !jComponent.isEnabled()) continue;
                    this.fireBinding(jComponent, keyStroke, keyEvent, bl2);
                    if (!keyEvent.isConsumed()) continue;
                    return true;
                }
            } else {
                System.out.println("Unexpected condition in fireKeyboardAction " + object2);
                Thread.dumpStack();
            }
        }
        if (keyEvent.isConsumed()) {
            return true;
        }
        if (hashtable != null && (object2 = (Vector)hashtable.get(JMenuBar.class)) != null) {
            object = ((Vector)object2).elements();
            while (object.hasMoreElements()) {
                JMenuBar jMenuBar = (JMenuBar)object.nextElement();
                if (!jMenuBar.isShowing() || !jMenuBar.isEnabled()) continue;
                this.fireBinding(jMenuBar, keyStroke, keyEvent, bl2);
                if (!keyEvent.isConsumed()) continue;
                return true;
            }
        }
        return keyEvent.isConsumed();
    }

    void fireBinding(JComponent jComponent, KeyStroke keyStroke, KeyEvent keyEvent, boolean bl2) {
        if (jComponent.processKeyBinding(keyStroke, keyEvent, 2, bl2)) {
            keyEvent.consume();
        }
    }

    public void registerMenuBar(JMenuBar jMenuBar) {
        Vector<JMenuBar> vector;
        Container container = KeyboardManager.getTopAncestor(jMenuBar);
        Hashtable hashtable = (Hashtable)this.containerMap.get(container);
        if (hashtable == null) {
            hashtable = this.registerNewTopContainer(container);
        }
        if ((vector = (Vector<JMenuBar>)hashtable.get(JMenuBar.class)) == null) {
            vector = new Vector<JMenuBar>();
            hashtable.put(JMenuBar.class, vector);
        }
        if (!vector.contains(jMenuBar)) {
            vector.addElement(jMenuBar);
        }
    }

    public void unregisterMenuBar(JMenuBar jMenuBar) {
        Vector vector;
        Container container = KeyboardManager.getTopAncestor(jMenuBar);
        Hashtable hashtable = (Hashtable)this.containerMap.get(container);
        if (hashtable != null && (vector = (Vector)hashtable.get(JMenuBar.class)) != null) {
            vector.removeElement(jMenuBar);
            if (vector.isEmpty()) {
                hashtable.remove(JMenuBar.class);
                if (hashtable.isEmpty()) {
                    this.containerMap.remove(container);
                }
            }
        }
    }

    protected Hashtable registerNewTopContainer(Container container) {
        Hashtable hashtable = new Hashtable();
        this.containerMap.put(container, hashtable);
        return hashtable;
    }

    class ComponentKeyStrokePair {
        Object component;
        Object keyStroke;

        public ComponentKeyStrokePair(Object object, Object object2) {
            this.component = object;
            this.keyStroke = object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ComponentKeyStrokePair)) {
                return false;
            }
            ComponentKeyStrokePair componentKeyStrokePair = (ComponentKeyStrokePair)object;
            return this.component.equals(componentKeyStrokePair.component) && this.keyStroke.equals(componentKeyStrokePair.keyStroke);
        }

        public int hashCode() {
            return this.component.hashCode() * this.keyStroke.hashCode();
        }
    }
}

