/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.TargetDataLine;

public class AudioInputStream
extends InputStream {
    private InputStream stream;
    protected AudioFormat format;
    protected long frameLength;
    protected int frameSize;
    protected long framePos;
    private long markpos;
    private byte[] pushBackBuffer = null;
    private int pushBackLen = 0;
    private byte[] markPushBackBuffer = null;
    private int markPushBackLen = 0;

    public AudioInputStream(InputStream inputStream, AudioFormat audioFormat, long l2) {
        this.format = audioFormat;
        this.frameLength = l2;
        this.frameSize = audioFormat.getFrameSize();
        if (this.frameSize == -1 || this.frameSize <= 0) {
            this.frameSize = 1;
        }
        this.stream = inputStream;
        this.framePos = 0L;
        this.markpos = 0L;
    }

    public AudioInputStream(TargetDataLine targetDataLine) {
        TargetDataLineInputStream targetDataLineInputStream = new TargetDataLineInputStream(targetDataLine);
        this.format = targetDataLine.getFormat();
        this.frameLength = -1L;
        this.frameSize = this.format.getFrameSize();
        if (this.frameSize == -1 || this.frameSize <= 0) {
            this.frameSize = 1;
        }
        this.stream = targetDataLineInputStream;
        this.framePos = 0L;
        this.markpos = 0L;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public long getFrameLength() {
        return this.frameLength;
    }

    public int read() throws IOException {
        if (this.frameSize != 1) {
            throw new IOException("cannot read a single byte if frame size > 1");
        }
        byte[] byArray = new byte[1];
        int n2 = this.read(byArray);
        if (n2 <= 0) {
            return -1;
        }
        return n2 & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (n3 % this.frameSize != 0 && (n3 -= n3 % this.frameSize) == 0) {
            return 0;
        }
        if (this.frameLength != -1L) {
            if (this.framePos >= this.frameLength) {
                return -1;
            }
            if ((long)(n3 / this.frameSize) > this.frameLength - this.framePos) {
                n3 = (int)(this.frameLength - this.framePos) * this.frameSize;
            }
        }
        int n5 = 0;
        int n6 = n2;
        if (this.pushBackLen > 0 && n3 >= this.pushBackLen) {
            System.arraycopy(this.pushBackBuffer, 0, byArray, n2, this.pushBackLen);
            n6 += this.pushBackLen;
            n3 -= this.pushBackLen;
            n5 += this.pushBackLen;
            this.pushBackLen = 0;
        }
        if ((n4 = this.stream.read(byArray, n6, n3)) == -1) {
            return -1;
        }
        if (n4 > 0) {
            n5 += n4;
        }
        if (n5 > 0) {
            this.pushBackLen = n5 % this.frameSize;
            if (this.pushBackLen > 0) {
                if (this.pushBackBuffer == null) {
                    this.pushBackBuffer = new byte[this.frameSize];
                }
                System.arraycopy(byArray, n2 + n5 - this.pushBackLen, this.pushBackBuffer, 0, this.pushBackLen);
                n5 -= this.pushBackLen;
            }
            this.framePos += (long)(n5 / this.frameSize);
        }
        return n5;
    }

    public long skip(long l2) throws IOException {
        long l3;
        if (l2 % (long)this.frameSize != 0L) {
            l2 -= l2 % (long)this.frameSize;
        }
        if (this.frameLength != -1L && l2 / (long)this.frameSize > this.frameLength - this.framePos) {
            l2 = (this.frameLength - this.framePos) * (long)this.frameSize;
        }
        if ((l3 = this.stream.skip(l2)) % (long)this.frameSize != 0L) {
            throw new IOException("Could not skip an integer number of frames.");
        }
        if (l3 >= 0L) {
            this.framePos += l3 / (long)this.frameSize;
        }
        return l3;
    }

    public int available() throws IOException {
        int n2 = this.stream.available();
        if (this.frameLength != -1L && (long)(n2 / this.frameSize) > this.frameLength - this.framePos) {
            return (int)(this.frameLength - this.framePos) * this.frameSize;
        }
        return n2;
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public void mark(int n2) {
        this.stream.mark(n2);
        if (this.markSupported()) {
            this.markpos = this.framePos;
            this.markPushBackLen = this.pushBackLen;
            if (this.markPushBackLen > 0) {
                if (this.markPushBackBuffer == null) {
                    this.markPushBackBuffer = new byte[this.frameSize];
                }
                System.arraycopy(this.pushBackBuffer, 0, this.markPushBackBuffer, 0, this.markPushBackLen);
            }
        }
    }

    public void reset() throws IOException {
        this.stream.reset();
        this.framePos = this.markpos;
        this.pushBackLen = this.markPushBackLen;
        if (this.pushBackLen > 0) {
            if (this.pushBackBuffer == null) {
                this.pushBackBuffer = new byte[this.frameSize - 1];
            }
            System.arraycopy(this.markPushBackBuffer, 0, this.pushBackBuffer, 0, this.pushBackLen);
        }
    }

    public boolean markSupported() {
        return this.stream.markSupported();
    }

    private class TargetDataLineInputStream
    extends InputStream {
        TargetDataLine line;

        TargetDataLineInputStream(TargetDataLine targetDataLine) {
            this.line = targetDataLine;
        }

        public int available() throws IOException {
            return this.line.available();
        }

        public void close() throws IOException {
            if (this.line.isActive()) {
                this.line.flush();
                this.line.stop();
            }
            this.line.close();
        }

        public int read() throws IOException {
            byte[] byArray = new byte[1];
            int n2 = this.read(byArray, 0, 1);
            if (n2 == -1) {
                return -1;
            }
            n2 = byArray[0];
            if (this.line.getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
                n2 += 128;
            }
            return n2;
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            try {
                return this.line.read(byArray, n2, n3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException(illegalArgumentException.getMessage());
            }
        }
    }
}

