/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import sun.misc.FloatingDecimal;
import sun.misc.FpUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Double
extends Number
implements Comparable<Double> {
    public static final double POSITIVE_INFINITY = 1.0 / 0.0;
    public static final double NEGATIVE_INFINITY = -1.0 / 0.0;
    public static final double NaN = 0.0 / 0.0;
    public static final double MAX_VALUE = 1.7976931348623157E308;
    public static final double MIN_VALUE = 4.9E-324;
    public static final int SIZE = 64;
    public static final Class<Double> TYPE = Class.getPrimitiveClass("double");
    private final double value;
    private static final long serialVersionUID = -9172774392245257468L;

    public static String toString(double d2) {
        return new FloatingDecimal(d2).toJavaFormatString();
    }

    public static String toHexString(double d2) {
        if (!FpUtils.isFinite(d2)) {
            return Double.toString(d2);
        }
        StringBuffer stringBuffer = new StringBuffer(24);
        if (FpUtils.rawCopySign(1.0, d2) == -1.0) {
            stringBuffer.append("-");
        }
        stringBuffer.append("0x");
        d2 = Math.abs(d2);
        if (d2 == 0.0) {
            stringBuffer.append("0.0p0");
        } else {
            boolean bl2 = d2 < Double.MIN_NORMAL;
            long l2 = Double.doubleToLongBits(d2) & 0xFFFFFFFFFFFFFL | 0x1000000000000000L;
            stringBuffer.append(bl2 ? "0." : "1.");
            String string = Long.toHexString(l2).substring(3, 16);
            stringBuffer.append(string.equals("0000000000000") ? "0" : string.replaceFirst("0{1,12}$", ""));
            stringBuffer.append("p" + (bl2 ? -1022 : FpUtils.getExponent(d2)));
        }
        return stringBuffer.toString();
    }

    public static Double valueOf(String string) throws NumberFormatException {
        return new Double(FloatingDecimal.readJavaFormatString(string).doubleValue());
    }

    public static Double valueOf(double d2) {
        return new Double(d2);
    }

    public static double parseDouble(String string) throws NumberFormatException {
        return FloatingDecimal.readJavaFormatString(string).doubleValue();
    }

    public static boolean isNaN(double d2) {
        return d2 != d2;
    }

    public static boolean isInfinite(double d2) {
        return d2 == Double.POSITIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY;
    }

    public Double(double d2) {
        this.value = d2;
    }

    public Double(String string) throws NumberFormatException {
        this(Double.valueOf(string));
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.value);
        return (int)(l2 ^ l2 >>> 32);
    }

    public boolean equals(Object object) {
        return object instanceof Double && Double.doubleToLongBits(((Double)object).value) == Double.doubleToLongBits(this.value);
    }

    public static native long doubleToLongBits(double var0);

    public static native long doubleToRawLongBits(double var0);

    public static native double longBitsToDouble(long var0);

    @Override
    public int compareTo(Double d2) {
        return Double.compare(this.value, d2.value);
    }

    public static int compare(double d2, double d3) {
        long l2;
        if (d2 < d3) {
            return -1;
        }
        if (d2 > d3) {
            return 1;
        }
        long l3 = Double.doubleToLongBits(d2);
        return l3 == (l2 = Double.doubleToLongBits(d3)) ? 0 : (l3 < l2 ? -1 : 1);
    }
}

