/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs.util;

import com.sun.org.apache.xerces.internal.util.SymbolHash;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xs.XSNamedMap;
import com.sun.org.apache.xerces.internal.xs.XSObject;

public class XSNamedMapImpl
implements XSNamedMap {
    String[] fNamespaces;
    int fNSNum;
    SymbolHash[] fMaps;
    XSObject[] fArray = null;
    int fLength = -1;
    QName fName = new QName();

    public XSNamedMapImpl(String string, SymbolHash symbolHash) {
        this.fNamespaces = new String[]{string};
        this.fMaps = new SymbolHash[]{symbolHash};
        this.fNSNum = 1;
    }

    public XSNamedMapImpl(String[] stringArray, SymbolHash[] symbolHashArray, int n2) {
        this.fNamespaces = stringArray;
        this.fMaps = symbolHashArray;
        this.fNSNum = n2;
    }

    public XSNamedMapImpl(XSObject[] xSObjectArray, int n2) {
        if (n2 == 0) {
            this.fNSNum = 0;
            this.fLength = 0;
            return;
        }
        this.fNamespaces = new String[]{xSObjectArray[0].getNamespace()};
        this.fMaps = null;
        this.fNSNum = 1;
        this.fArray = xSObjectArray;
        this.fLength = n2;
    }

    public synchronized int getLength() {
        if (this.fLength == -1) {
            this.fLength = 0;
            for (int i2 = 0; i2 < this.fNSNum; ++i2) {
                this.fLength += this.fMaps[i2].getLength();
            }
        }
        return this.fLength;
    }

    public XSObject itemByName(String string, String string2) {
        if (string != null) {
            string = string.intern();
        }
        for (int i2 = 0; i2 < this.fNSNum; ++i2) {
            if (string != this.fNamespaces[i2]) continue;
            if (this.fMaps != null) {
                return (XSObject)this.fMaps[i2].get(string2);
            }
            for (int i3 = 0; i3 < this.fLength; ++i3) {
                XSObject xSObject = this.fArray[i3];
                if (!xSObject.getName().equals(string2)) continue;
                return xSObject;
            }
            return null;
        }
        return null;
    }

    public synchronized XSObject item(int n2) {
        if (this.fArray == null) {
            this.getLength();
            this.fArray = new XSObject[this.fLength];
            int n3 = 0;
            for (int i2 = 0; i2 < this.fNSNum; ++i2) {
                n3 += this.fMaps[i2].getValues(this.fArray, n3);
            }
        }
        if (n2 < 0 || n2 >= this.fLength) {
            return null;
        }
        return this.fArray[n2];
    }
}

