/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.dv.xs;

import com.sun.org.apache.xerces.internal.impl.dv.InvalidDatatypeValueException;
import com.sun.org.apache.xerces.internal.impl.dv.ValidationContext;
import com.sun.org.apache.xerces.internal.impl.dv.xs.TypeValidator;

public class FloatDV
extends TypeValidator {
    public short getAllowedFacets() {
        return 2552;
    }

    public Object getActualValue(String string, ValidationContext validationContext) throws InvalidDatatypeValueException {
        try {
            return new XFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string, "float"});
        }
    }

    public int compare(Object object, Object object2) {
        return ((XFloat)object).compareTo((XFloat)object2);
    }

    private static final class XFloat {
        private float value;
        private String canonical;

        public XFloat(String string) throws NumberFormatException {
            try {
                this.value = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (string.equals("INF")) {
                    this.value = Float.POSITIVE_INFINITY;
                }
                if (string.equals("-INF")) {
                    this.value = Float.NEGATIVE_INFINITY;
                }
                if (string.equals("NaN")) {
                    this.value = Float.NaN;
                }
                throw numberFormatException;
            }
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof XFloat)) {
                return false;
            }
            XFloat xFloat = (XFloat)object;
            if (this.value == xFloat.value) {
                return true;
            }
            return this.value != this.value && xFloat.value != xFloat.value;
        }

        private int compareTo(XFloat xFloat) {
            float f2 = xFloat.value;
            if (this.value < f2) {
                return -1;
            }
            if (this.value > f2) {
                return 1;
            }
            if (this.value == f2) {
                return 0;
            }
            if (this.value != this.value) {
                if (f2 != f2) {
                    return 0;
                }
                return 2;
            }
            return 2;
        }

        public synchronized String toString() {
            if (this.canonical == null) {
                if (this.value == Float.POSITIVE_INFINITY) {
                    this.canonical = "INF";
                } else if (this.value == Float.NEGATIVE_INFINITY) {
                    this.canonical = "-INF";
                } else if (this.value != this.value) {
                    this.canonical = "NaN";
                } else if (this.value == 0.0f) {
                    this.canonical = "0.0E1";
                } else {
                    this.canonical = Float.toString(this.value);
                    if (this.canonical.indexOf(69) == -1) {
                        int n2;
                        int n3 = this.canonical.length();
                        char[] cArray = new char[n3 + 3];
                        this.canonical.getChars(0, n3, cArray, 0);
                        int n4 = n2 = cArray[0] == '-' ? 2 : 1;
                        if (this.value >= 1.0f || this.value <= -1.0f) {
                            int n5;
                            int n6;
                            for (n6 = n5 = this.canonical.indexOf(46); n6 > n2; --n6) {
                                cArray[n6] = cArray[n6 - 1];
                            }
                            cArray[n2] = 46;
                            while (cArray[n3 - 1] == '0') {
                                --n3;
                            }
                            if (cArray[n3 - 1] == '.') {
                                // empty if block
                            }
                            int n7 = ++n3;
                            cArray[n7] = 69;
                            n6 = n5 - n2;
                            int n8 = ++n3;
                            ++n3;
                            cArray[n8] = (char)(n6 + 48);
                        } else {
                            int n9 = n2 + 1;
                            while (cArray[n9] == '0') {
                                ++n9;
                            }
                            cArray[n2 - 1] = cArray[n9];
                            cArray[n2] = 46;
                            int n10 = n9 + 1;
                            int n11 = n2 + 1;
                            while (n10 < n3) {
                                cArray[n11] = cArray[n10];
                                ++n10;
                                ++n11;
                            }
                            if ((n3 -= n9 - n2) == n2 + 1) {
                                cArray[n3++] = 48;
                            }
                            cArray[n3++] = 69;
                            cArray[n3++] = 45;
                            n10 = n9 - n2;
                            cArray[n3++] = (char)(n10 + 48);
                        }
                        this.canonical = new String(cArray, 0, n3);
                    }
                }
            }
            return this.canonical;
        }
    }
}

