/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.Constants;
import com.sun.org.apache.bcel.internal.classfile.Code;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.ConstantValue;
import com.sun.org.apache.bcel.internal.classfile.Deprecated;
import com.sun.org.apache.bcel.internal.classfile.ExceptionTable;
import com.sun.org.apache.bcel.internal.classfile.InnerClasses;
import com.sun.org.apache.bcel.internal.classfile.LineNumberTable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTable;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.PMGClass;
import com.sun.org.apache.bcel.internal.classfile.Signature;
import com.sun.org.apache.bcel.internal.classfile.SourceFile;
import com.sun.org.apache.bcel.internal.classfile.StackMap;
import com.sun.org.apache.bcel.internal.classfile.Synthetic;
import com.sun.org.apache.bcel.internal.classfile.Unknown;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class Attribute
implements Cloneable,
Node {
    protected int name_index;
    protected int length;
    protected byte tag;
    protected ConstantPool constant_pool;

    Attribute(byte by, int n2, int n3, ConstantPool constantPool) {
        this.tag = by;
        this.name_index = n2;
        this.length = n3;
        this.constant_pool = constantPool;
    }

    public abstract void accept(Visitor var1);

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.name_index);
        dataOutputStream.writeInt(this.length);
    }

    static final Attribute readAttribute(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException, ClassFormatError, InternalError {
        int n2 = -1;
        int n3 = dataInputStream.readUnsignedShort();
        ConstantUtf8 constantUtf8 = (ConstantUtf8)constantPool.getConstant(n3, (byte)1);
        String string = constantUtf8.getBytes();
        int n4 = dataInputStream.readInt();
        for (int n5 = 0; n5 < 12; n5 = (int)((byte)(n5 + 1))) {
            if (!string.equals(Constants.ATTRIBUTE_NAMES[n5])) continue;
            n2 = n5;
            break;
        }
        switch (n2) {
            case -1: {
                return new Unknown(n3, n4, dataInputStream, constantPool);
            }
            case 1: {
                return new ConstantValue(n3, n4, dataInputStream, constantPool);
            }
            case 0: {
                return new SourceFile(n3, n4, dataInputStream, constantPool);
            }
            case 2: {
                return new Code(n3, n4, dataInputStream, constantPool);
            }
            case 3: {
                return new ExceptionTable(n3, n4, dataInputStream, constantPool);
            }
            case 4: {
                return new LineNumberTable(n3, n4, dataInputStream, constantPool);
            }
            case 5: {
                return new LocalVariableTable(n3, n4, dataInputStream, constantPool);
            }
            case 6: {
                return new InnerClasses(n3, n4, dataInputStream, constantPool);
            }
            case 7: {
                return new Synthetic(n3, n4, dataInputStream, constantPool);
            }
            case 8: {
                return new Deprecated(n3, n4, dataInputStream, constantPool);
            }
            case 9: {
                return new PMGClass(n3, n4, dataInputStream, constantPool);
            }
            case 10: {
                return new Signature(n3, n4, dataInputStream, constantPool);
            }
            case 11: {
                return new StackMap(n3, n4, dataInputStream, constantPool);
            }
        }
        throw new InternalError("Ooops! default case reached.");
    }

    public final int getLength() {
        return this.length;
    }

    public final void setLength(int n2) {
        this.length = n2;
    }

    public final void setNameIndex(int n2) {
        this.name_index = n2;
    }

    public final int getNameIndex() {
        return this.name_index;
    }

    public final byte getTag() {
        return this.tag;
    }

    public final ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final void setConstantPool(ConstantPool constantPool) {
        this.constant_pool = constantPool;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return object;
    }

    public abstract Attribute copy(ConstantPool var1);

    public String toString() {
        return Constants.ATTRIBUTE_NAMES[this.tag];
    }
}

