/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.corba;

import java.applet.Applet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.ConfigurationException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class CorbaUtils {
    private static Method toStubMethod = null;
    private static Method connectMethod = null;
    private static Class corbaStubClass = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object remoteToCorba(Remote remote, ORB oRB) throws ClassNotFoundException, ConfigurationException {
        java.lang.Object object = CorbaUtils.class;
        synchronized (CorbaUtils.class) {
            if (toStubMethod == null) {
                CorbaUtils.initMethodHandles();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                object = toStubMethod.invoke(null, remote);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                ConfigurationException configurationException = new ConfigurationException("Problem with PortableRemoteObject.toStub(); object not exported or stub not found");
                configurationException.setRootCause(throwable);
                throw configurationException;
            }
            catch (IllegalAccessException illegalAccessException) {
                ConfigurationException configurationException = new ConfigurationException("Cannot invoke javax.rmi.PortableRemoteObject.toStub(java.rmi.Remote)");
                configurationException.setRootCause(illegalAccessException);
                throw configurationException;
            }
            if (!corbaStubClass.isInstance(object)) {
                return null;
            }
            try {
                connectMethod.invoke(object, oRB);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (!(throwable instanceof RemoteException)) {
                    ConfigurationException configurationException = new ConfigurationException("Problem invoking javax.rmi.CORBA.Stub.connect()");
                    configurationException.setRootCause(throwable);
                    throw configurationException;
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                ConfigurationException configurationException = new ConfigurationException("Cannot invoke javax.rmi.CORBA.Stub.connect()");
                configurationException.setRootCause(illegalAccessException);
                throw configurationException;
            }
            return (Object)object;
        }
    }

    public static ORB getOrb(String string, int n2, Hashtable hashtable) {
        java.lang.Object object;
        Properties properties;
        if (hashtable != null) {
            if (hashtable instanceof Properties) {
                properties = (Properties)hashtable.clone();
            } else {
                properties = new Properties();
                object = hashtable.keys();
                while (object.hasMoreElements()) {
                    String string2 = (String)object.nextElement();
                    java.lang.Object v2 = hashtable.get(string2);
                    if (!(v2 instanceof String)) continue;
                    properties.put(string2, v2);
                }
            }
        } else {
            properties = new Properties();
        }
        if (string != null) {
            properties.put("org.omg.CORBA.ORBInitialHost", string);
        }
        if (n2 >= 0) {
            properties.put("org.omg.CORBA.ORBInitialPort", "" + n2);
        }
        object = null;
        if (hashtable != null) {
            object = (Applet)hashtable.get("java.naming.applet");
        }
        if (object != null) {
            return ORB.init(object, properties);
        }
        return ORB.init(new String[0], properties);
    }

    private static void initMethodHandles() throws ClassNotFoundException {
        corbaStubClass = Class.forName("javax.rmi.CORBA.Stub");
        try {
            connectMethod = corbaStubClass.getMethod("connect", ORB.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException("No method definition for javax.rmi.CORBA.Stub.connect(org.omg.CORBA.ORB)");
        }
        Class<?> clazz = Class.forName("javax.rmi.PortableRemoteObject");
        try {
            toStubMethod = clazz.getMethod("toStub", Remote.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException("No method definition for javax.rmi.PortableRemoteObject.toStub(java.rmi.Remote)");
        }
    }
}

