/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.DialogFactory;
import com.sun.deploy.util.TraceLevel;
import com.sun.deploy.util.TraceListener;
import com.sun.deploy.util.TraceMessage;
import com.sun.deploy.util.TracePrintStream;
import java.awt.Component;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;

public class Trace {
    private static boolean _bAutomationOn = false;
    private static ArrayList queue = new ArrayList();
    private static ArrayList listenersList = new ArrayList();
    private static HashSet traceLevelList = new HashSet();
    private static PrintStream psOut = new PrintStream(new TracePrintStream());
    private static PrintStream psErr = new PrintStream(new TracePrintStream());

    private Trace() {
    }

    public static void redirectStdioStderr() {
        System.setOut(psOut);
        System.setErr(psErr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flush() {
        while (true) {
            ArrayList arrayList = queue;
            synchronized (arrayList) {
                if (queue.isEmpty()) {
                    return;
                }
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public static boolean isEnabled() {
        return traceLevelList.size() > 1;
    }

    public static void setInitialTraceLevel() {
        String string = Config.getProperty("deployment.trace.level");
        if (string != null && !string.equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equalsIgnoreCase("all")) {
                    Trace.setBasicTrace(true);
                    Trace.setCacheTrace(true);
                    Trace.setNetTrace(true);
                    Trace.setTempTrace(true);
                    Trace.setSecurityTrace(true);
                    Trace.setExtTrace(true);
                    Trace.setLiveConnectTrace(true);
                    break;
                }
                if (string2.equalsIgnoreCase("basic")) {
                    Trace.setBasicTrace(true);
                    continue;
                }
                if (string2.equalsIgnoreCase("cache")) {
                    Trace.setCacheTrace(true);
                    continue;
                }
                if (string2.equalsIgnoreCase("net")) {
                    Trace.setNetTrace(true);
                    continue;
                }
                if (string2.equalsIgnoreCase("temp")) {
                    Trace.setTempTrace(true);
                    continue;
                }
                if (string2.equalsIgnoreCase("security")) {
                    Trace.setSecurityTrace(true);
                    continue;
                }
                if (string2.equalsIgnoreCase("ext")) {
                    Trace.setExtTrace(true);
                    continue;
                }
                if (!string2.equalsIgnoreCase("liveconnect")) continue;
                Trace.setLiveConnectTrace(true);
            }
        }
    }

    public static void setBasicTrace(boolean bl) {
        if (bl) {
            traceLevelList.add(TraceLevel.BASIC);
        } else {
            traceLevelList.remove(TraceLevel.BASIC);
        }
    }

    public static void setNetTrace(boolean bl) {
        if (bl) {
            traceLevelList.add(TraceLevel.NETWORK);
        } else {
            traceLevelList.remove(TraceLevel.NETWORK);
        }
    }

    public static void setCacheTrace(boolean bl) {
        if (bl) {
            traceLevelList.add(TraceLevel.CACHE);
        } else {
            traceLevelList.remove(TraceLevel.CACHE);
        }
    }

    public static void setTempTrace(boolean bl) {
        if (bl) {
            traceLevelList.add(TraceLevel.TEMP);
        } else {
            traceLevelList.remove(TraceLevel.TEMP);
        }
    }

    public static void setSecurityTrace(boolean bl) {
        if (bl) {
            traceLevelList.add(TraceLevel.SECURITY);
        } else {
            traceLevelList.remove(TraceLevel.SECURITY);
        }
    }

    public static void setExtTrace(boolean bl) {
        if (bl) {
            traceLevelList.add(TraceLevel.EXTENSIONS);
        } else {
            traceLevelList.remove(TraceLevel.EXTENSIONS);
        }
    }

    public static void setLiveConnectTrace(boolean bl) {
        if (bl) {
            traceLevelList.add(TraceLevel.LIVECONNECT);
        } else {
            traceLevelList.remove(TraceLevel.LIVECONNECT);
        }
    }

    public static boolean isAutomationEnabled() {
        return _bAutomationOn;
    }

    public static void enableAutomation(boolean bl) {
        _bAutomationOn = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enQueue(TraceMessage traceMessage) {
        ArrayList arrayList = queue;
        synchronized (arrayList) {
            queue.add(traceMessage);
            queue.notifyAll();
        }
    }

    public static void print(String string, TraceLevel traceLevel) {
        if (traceLevelList.contains(traceLevel)) {
            TraceMessage traceMessage = new TraceMessage(traceLevel, string);
            Trace.enQueue(traceMessage);
        }
    }

    public static void println(String string, TraceLevel traceLevel) {
        if (traceLevelList.contains(traceLevel)) {
            TraceMessage traceMessage = new TraceMessage(traceLevel, string, true);
            Trace.enQueue(traceMessage);
        }
    }

    public static void println(String string) {
        Trace.println(string, TraceLevel.DEFAULT);
    }

    public static void print(String string) {
        Trace.print(string, TraceLevel.DEFAULT);
    }

    public static void msgPrintln(String string, Object[] objectArray, TraceLevel traceLevel) {
        if (traceLevelList.contains(traceLevel)) {
            String string2 = ResourceManager.getMessage(string);
            MessageFormat messageFormat = new MessageFormat(string2);
            String string3 = MessageFormat.format(string2, objectArray);
            TraceMessage traceMessage = new TraceMessage(traceLevel, string3, true);
            Trace.enQueue(traceMessage);
        }
    }

    public static void msgPrintln(String string, Object[] objectArray) {
        Trace.msgPrintln(string, objectArray, TraceLevel.DEFAULT);
    }

    public static void addTraceListener(TraceListener traceListener) {
        if (!listenersList.contains(traceListener)) {
            listenersList.add(traceListener);
        }
    }

    public static void removeTraceListener(TraceListener traceListener) {
        int n = listenersList.indexOf(traceListener);
        if (n != -1) {
            listenersList.remove(n);
        }
    }

    public static void resetTraceLevel() {
        traceLevelList.clear();
        traceLevelList.add(TraceLevel.DEFAULT);
    }

    public static void firePrintlnEvent(TraceMessage traceMessage) {
        TraceListener traceListener = null;
        for (int i = 0; i < listenersList.size(); ++i) {
            traceListener = (TraceListener)listenersList.get(i);
            traceListener.print(traceMessage.getMessage());
        }
    }

    public static void ignoredException(Exception exception) {
        if (traceLevelList.size() > 1) {
            exception.printStackTrace();
        }
    }

    public static void printException(Throwable throwable) {
        Trace.printException(null, throwable);
    }

    public static void printException(Component component, Throwable throwable) {
        Trace.printException(component, throwable, null, null);
    }

    public static void printException(Throwable throwable, String string, String string2) {
        Trace.printException(null, throwable, string, string2);
    }

    public static void printException(Component component, Throwable throwable, String string, String string2) {
        Trace.printException(component, throwable, string, string2, true);
    }

    public static void printException(Component component, Throwable throwable, String string, String string2, boolean bl) {
        Trace.println("Ignored exception: " + throwable);
        if (bl && !Trace.isAutomationEnabled()) {
            if (string == null) {
                string = ResourceManager.getMessage("dialogfactory.general_error");
            }
            DialogFactory.showExceptionDialog(component, throwable, string, string2);
        }
    }

    public static void netPrintln(String string) {
        Trace.println(string, TraceLevel.NETWORK);
    }

    public static void msgNetPrintln(String string) {
        Trace.msgPrintln(string, null, TraceLevel.NETWORK);
    }

    public static void msgNetPrintln(String string, Object[] objectArray) {
        Trace.msgPrintln(string, objectArray, TraceLevel.NETWORK);
    }

    public static void netPrintException(Throwable throwable) {
        Trace.printException(null, throwable, ResourceManager.getMessage("dialogfactory.net_error"), null, false);
    }

    public static void netPrintException(Throwable throwable, String string, String string2) {
        Trace.printException(null, throwable, string, string2, false);
    }

    public static void securityPrintln(String string) {
        Trace.println(string, TraceLevel.SECURITY);
    }

    public static void msgSecurityPrintln(String string) {
        Trace.msgPrintln(string, null, TraceLevel.SECURITY);
    }

    public static void msgSecurityPrintln(String string, Object[] objectArray) {
        Trace.msgPrintln(string, objectArray, TraceLevel.SECURITY);
    }

    public static void securityPrintException(Throwable throwable) {
        Trace.printException(null, throwable, ResourceManager.getMessage("dialogfactory.security_error"), null, true);
    }

    public static void securityPrintException(Throwable throwable, String string, String string2) {
        Trace.printException(null, throwable, string, string2, true);
    }

    public static void extPrintln(String string) {
        Trace.println(string, TraceLevel.EXTENSIONS);
    }

    public static void msgExtPrintln(String string) {
        Trace.msgPrintln(string, null, TraceLevel.EXTENSIONS);
    }

    public static void msgExtPrintln(String string, Object[] objectArray) {
        Trace.msgPrintln(string, objectArray, TraceLevel.EXTENSIONS);
    }

    public static void extPrintException(Throwable throwable) {
        Trace.printException(null, throwable, ResourceManager.getMessage("dialogfactory.ext_error"), null, true);
    }

    public static void extPrintException(Throwable throwable, String string, String string2) {
        Trace.printException(null, throwable, string, string2, true);
    }

    public static void liveConnectPrintln(String string) {
        Trace.println(string, TraceLevel.LIVECONNECT);
    }

    public static void msgLiveConnectPrintln(String string) {
        Trace.msgPrintln(string, null, TraceLevel.LIVECONNECT);
    }

    public static void msgLiveConnectPrintln(String string, Object[] objectArray) {
        Trace.msgPrintln(string, objectArray, TraceLevel.LIVECONNECT);
    }

    public static void liveConnectPrintException(Throwable throwable) {
        Trace.printException(null, throwable, null, null, false);
    }

    static {
        traceLevelList.add(TraceLevel.DEFAULT);
        Thread thread = new Thread((Runnable)new TraceMsgQueueChecker(), "traceMsgQueueThread");
        thread.setDaemon(true);
        thread.start();
    }

    private static class TraceMsgQueueChecker
    implements Runnable {
        private TraceMsgQueueChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (true) {
                TraceMessage traceMessage = null;
                ArrayList arrayList = queue;
                synchronized (arrayList) {
                    if (queue.isEmpty()) {
                        try {
                            queue.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    } else {
                        traceMessage = (TraceMessage)queue.remove(0);
                    }
                }
                if (traceMessage == null) continue;
                Trace.firePrintlnEvent(traceMessage);
            }
        }
    }
}

