/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.tools;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.AddressException;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.JavaVFrame;
import sun.jvm.hotspot.runtime.Threads;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.tools.Tool;

public class StackTrace
extends Tool {
    private boolean verbose;

    public StackTrace(boolean v) {
        this.verbose = v;
    }

    public StackTrace() {
        this(true);
    }

    public void run() {
        try {
            Threads threads = VM.getVM().getThreads();
            int i = 1;
            JavaThread cur = threads.first();
            while (cur != null) {
                if (cur.isJavaThread()) {
                    Address sp = cur.getLastJavaSP();
                    System.out.print("Thread ");
                    cur.printThreadIDOn(System.out);
                    System.out.print(": (state = " + cur.getThreadState());
                    if (this.verbose) {
                        System.out.println(", current Java SP = " + sp);
                    }
                    System.out.println(')');
                    try {
                        for (JavaVFrame vf = cur.getLastJavaVFrameDbg(); vf != null; vf = vf.javaSender()) {
                            Method method = vf.getMethod();
                            System.out.print(" - " + method.externalNameAndSignature());
                            if (!method.isNative()) {
                                System.out.print(" @bci=" + vf.getBCI());
                            }
                            int lineNumber = -1;
                            if (!method.isNative()) {
                                lineNumber = method.getLineNumberFromBCI(vf.getBCI());
                            }
                            if (lineNumber != -1) {
                                System.out.print(", line=" + lineNumber);
                            }
                            if (this.verbose) {
                                Address pc = vf.getFrame().getPC();
                                if (pc != null) {
                                    System.out.print(", pc=" + pc);
                                }
                                System.out.print(", methodOop=" + method.getHandle());
                            }
                            if (vf.isCompiledFrame()) {
                                System.out.print(" (Compiled frame");
                            }
                            if (vf.isInterpretedFrame()) {
                                System.out.print(" (Interpreted frame");
                            }
                            if (vf.mayBeImpreciseDbg()) {
                                System.out.print("; information may be imprecise");
                            }
                            System.out.println(")");
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Error occurred during stack walking:");
                        e.printStackTrace();
                    }
                    System.out.println();
                    System.out.println();
                }
                cur = cur.next();
                ++i;
            }
        }
        catch (AddressException e) {
            System.err.println("Error accessing address 0x" + Long.toHexString(e.getAddress()));
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        StackTrace st = new StackTrace();
        st.start(args);
        st.stop();
    }
}

