/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.io.UnsupportedEncodingException;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.runtime.BasicType;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.JByteField;
import sun.jvm.hotspot.types.JIntField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.CStringUtilities;

public class PerfDataEntry
extends VMObject {
    private static JIntField entryLengthField;
    private static JIntField nameOffsetField;
    private static JIntField vectorLengthField;
    private static JByteField dataTypeField;
    private static JByteField flagsField;
    private static JByteField dataUnitsField;
    private static JByteField dataVariabilityField;
    private static JIntField dataOffsetField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("PerfDataEntry");
        entryLengthField = type.getJIntField("entry_length");
        nameOffsetField = type.getJIntField("name_offset");
        vectorLengthField = type.getJIntField("vector_length");
        dataTypeField = type.getJByteField("data_type");
        flagsField = type.getJByteField("flags");
        dataUnitsField = type.getJByteField("data_units");
        dataVariabilityField = type.getJByteField("data_variability");
        dataOffsetField = type.getJIntField("data_offset");
    }

    public PerfDataEntry(Address addr) {
        super(addr);
    }

    public int entryLength() {
        return entryLengthField.getValue(this.addr);
    }

    public int nameOffset() {
        return nameOffsetField.getValue(this.addr);
    }

    public int vectorLength() {
        return vectorLengthField.getValue(this.addr);
    }

    public int dataType() {
        char ch = (char)dataTypeField.getValue(this.addr);
        return BasicType.charToType(ch);
    }

    public byte flags() {
        return flagsField.getValue(this.addr);
    }

    public boolean supported() {
        return (this.flags() & 1) != 0;
    }

    public int dataUnits() {
        return dataUnitsField.getValue(this.addr);
    }

    public int dataVariability() {
        return dataVariabilityField.getValue(this.addr);
    }

    public int dataOffset() {
        return dataOffsetField.getValue(this.addr);
    }

    public String name() {
        int off = this.nameOffset();
        return CStringUtilities.getString(this.addr.addOffsetTo(off));
    }

    public boolean booleanValue() {
        Assert.that(this.vectorLength() == 0 && this.dataType() == 4, "not a boolean");
        return this.addr.getJBooleanAt(this.dataOffset());
    }

    public char charValue() {
        Assert.that(this.vectorLength() == 0 && this.dataType() == 5, "not a char");
        return this.addr.getJCharAt(this.dataOffset());
    }

    public byte byteValue() {
        Assert.that(this.vectorLength() == 0 && this.dataType() == 8, "not a byte");
        return this.addr.getJByteAt(this.dataOffset());
    }

    public short shortValue() {
        Assert.that(this.vectorLength() == 0 && this.dataType() == 9, "not a short");
        return this.addr.getJShortAt(this.dataOffset());
    }

    public int intValue() {
        Assert.that(this.vectorLength() == 0 && this.dataType() == 10, "not an int");
        return this.addr.getJIntAt(this.dataOffset());
    }

    public long longValue() {
        Assert.that(this.vectorLength() == 0 && this.dataType() == 11, "not a long");
        return this.addr.getJLongAt(this.dataOffset());
    }

    public float floatValue() {
        Assert.that(this.vectorLength() == 0 && this.dataType() == 6, "not a float");
        return this.addr.getJFloatAt(this.dataOffset());
    }

    public double doubleValue() {
        Assert.that(this.vectorLength() == 0 && this.dataType() == 7, "not a double");
        return this.addr.getJDoubleAt(this.dataOffset());
    }

    public boolean[] booleanArrayValue() {
        int len = this.vectorLength();
        Assert.that(len > 0 && this.dataType() == 4, "not a boolean vector");
        boolean[] res = new boolean[len];
        int off = this.dataOffset();
        long size = this.getHeap().getBooleanSize();
        for (int i = 0; i < len; ++i) {
            res[i] = this.addr.getJBooleanAt((long)off + (long)i * size);
        }
        return res;
    }

    public char[] charArrayValue() {
        int len = this.vectorLength();
        Assert.that(len > 0 && this.dataType() == 5, "not a char vector");
        char[] res = new char[len];
        int off = this.dataOffset();
        long size = this.getHeap().getCharSize();
        for (int i = 0; i < len; ++i) {
            res[i] = this.addr.getJCharAt((long)off + (long)i * size);
        }
        return res;
    }

    public byte[] byteArrayValue() {
        int len = this.vectorLength();
        Assert.that(len > 0 && this.dataType() == 8, "not a byte vector");
        byte[] res = new byte[len];
        int off = this.dataOffset();
        long size = this.getHeap().getByteSize();
        for (int i = 0; i < len; ++i) {
            res[i] = this.addr.getJByteAt((long)off + (long)i * size);
        }
        return res;
    }

    public short[] shortArrayValue() {
        int len = this.vectorLength();
        Assert.that(len > 0 && this.dataType() == 9, "not a short vector");
        short[] res = new short[len];
        int off = this.dataOffset();
        long size = this.getHeap().getShortSize();
        for (int i = 0; i < len; ++i) {
            res[i] = this.addr.getJShortAt((long)off + (long)i * size);
        }
        return res;
    }

    public int[] intArrayValue() {
        int len = this.vectorLength();
        Assert.that(len > 0 && this.dataType() == 10, "not an int vector");
        int[] res = new int[len];
        int off = this.dataOffset();
        long size = this.getHeap().getIntSize();
        for (int i = 0; i < len; ++i) {
            res[i] = this.addr.getJIntAt((long)off + (long)i * size);
        }
        return res;
    }

    public long[] longArrayValue() {
        int len = this.vectorLength();
        Assert.that(len > 0 && this.dataType() == 11, "not a long vector");
        long[] res = new long[len];
        int off = this.dataOffset();
        long size = this.getHeap().getLongSize();
        for (int i = 0; i < len; ++i) {
            res[i] = this.addr.getJLongAt((long)off + (long)i * size);
        }
        return res;
    }

    public float[] floatArrayValue() {
        int len = this.vectorLength();
        Assert.that(len > 0 && this.dataType() == 6, "not a float vector");
        float[] res = new float[len];
        int off = this.dataOffset();
        long size = this.getHeap().getFloatSize();
        for (int i = 0; i < len; ++i) {
            res[i] = this.addr.getJFloatAt((long)off + (long)i * size);
        }
        return res;
    }

    public double[] doubleArrayValue() {
        int len = this.vectorLength();
        Assert.that(len > 0 && this.dataType() == 7, "not a double vector");
        double[] res = new double[len];
        int off = this.dataOffset();
        long size = this.getHeap().getDoubleSize();
        for (int i = 0; i < len; ++i) {
            res[i] = this.addr.getJDoubleAt((long)off + (long)i * size);
        }
        return res;
    }

    public String valueAsString() {
        int dataType = this.dataType();
        int len = this.vectorLength();
        String str = null;
        if (len == 0) {
            switch (dataType) {
                case 4: {
                    str = Boolean.toString(this.booleanValue());
                    break;
                }
                case 5: {
                    str = "'" + Character.toString(this.charValue()) + "'";
                    break;
                }
                case 8: {
                    str = Byte.toString(this.byteValue());
                    break;
                }
                case 9: {
                    str = Short.toString(this.shortValue());
                    break;
                }
                case 10: {
                    str = Integer.toString(this.intValue());
                    break;
                }
                case 11: {
                    str = Long.toString(this.longValue());
                    break;
                }
                case 6: {
                    str = Float.toString(this.floatValue());
                    break;
                }
                case 7: {
                    str = Double.toString(this.doubleValue());
                    break;
                }
                default: {
                    str = "<unknown scalar value>";
                    break;
                }
            }
        } else {
            switch (dataType) {
                case 4: {
                    boolean[] res = this.booleanArrayValue();
                    StringBuffer buf = new StringBuffer();
                    buf.append('[');
                    for (int i = 0; i < res.length; ++i) {
                        buf.append(Boolean.toString(res[i]));
                        buf.append(", ");
                    }
                    buf.append(']');
                    str = buf.toString();
                    break;
                }
                case 5: {
                    str = new String(this.charArrayValue());
                    break;
                }
                case 8: {
                    try {
                        str = new String(this.byteArrayValue(), "US-ASCII");
                    }
                    catch (UnsupportedEncodingException e) {
                        str = "can't decode string : " + e.getMessage();
                    }
                    break;
                }
                case 9: {
                    short[] res = this.shortArrayValue();
                    StringBuffer buf = new StringBuffer();
                    buf.append('[');
                    for (int i = 0; i < res.length; ++i) {
                        buf.append(Short.toString(res[i]));
                        buf.append(", ");
                    }
                    buf.append(']');
                    str = buf.toString();
                    break;
                }
                case 10: {
                    int[] res = this.intArrayValue();
                    StringBuffer buf = new StringBuffer();
                    buf.append('[');
                    for (int i = 0; i < res.length; ++i) {
                        buf.append(Integer.toString(res[i]));
                        buf.append(", ");
                    }
                    buf.append(']');
                    str = buf.toString();
                    break;
                }
                case 11: {
                    long[] res = this.longArrayValue();
                    StringBuffer buf = new StringBuffer();
                    buf.append('[');
                    for (int i = 0; i < res.length; ++i) {
                        buf.append(Long.toString(res[i]));
                        buf.append(", ");
                    }
                    buf.append(']');
                    str = buf.toString();
                    break;
                }
                case 6: {
                    float[] res = this.floatArrayValue();
                    StringBuffer buf = new StringBuffer();
                    buf.append('[');
                    for (int i = 0; i < res.length; ++i) {
                        buf.append(Float.toString(res[i]));
                        buf.append(", ");
                    }
                    buf.append(']');
                    str = buf.toString();
                    break;
                }
                case 7: {
                    double[] res = this.doubleArrayValue();
                    StringBuffer buf = new StringBuffer();
                    buf.append('[');
                    for (int i = 0; i < res.length; ++i) {
                        buf.append(Double.toString(res[i]));
                        buf.append(", ");
                    }
                    buf.append(']');
                    str = buf.toString();
                    break;
                }
                default: {
                    str = "<unknown vector value>";
                }
            }
        }
        switch (this.dataUnits()) {
            case 1: {
                break;
            }
            case 2: {
                str = str + " byte(s)";
                break;
            }
            case 3: {
                str = str + " tick(s)";
                break;
            }
            case 4: {
                str = str + " event(s)";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                str = str + " Hz";
            }
        }
        return str;
    }

    private ObjectHeap getHeap() {
        return VM.getVM().getObjectHeap();
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                PerfDataEntry.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }

    public static interface PerfDataVariability {
        public static final int V_Constant = 1;
        public static final int V_Monotonic = 2;
        public static final int V_Variable = 3;
    }

    public static interface PerfDataUnits {
        public static final int U_None = 1;
        public static final int U_Bytes = 2;
        public static final int U_Ticks = 3;
        public static final int U_Events = 4;
        public static final int U_String = 5;
        public static final int U_Hertz = 6;
    }
}

