/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.io.PrintStream;
import java.util.List;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.runtime.BasicType;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.StackValueCollection;
import sun.jvm.hotspot.runtime.VFrame;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.Assert;

public abstract class JavaVFrame
extends VFrame {
    public abstract Method getMethod();

    public abstract int getBCI();

    public abstract StackValueCollection getLocals();

    public abstract StackValueCollection getExpressions();

    public abstract List getMonitors();

    public boolean isJavaFrame() {
        return true;
    }

    JavaVFrame(Frame fr, RegisterMap regMap, JavaThread thread) {
        super(fr, regMap, thread);
    }

    public void print() {
        this.printOn(System.out);
    }

    public void printOn(PrintStream tty) {
        super.printOn(tty);
        tty.print("\t");
        this.getMethod().printValueOn(tty);
        tty.println();
        tty.println("\tbci:\t" + this.getBCI());
        this.printStackValuesOn(tty, "locals", this.getLocals());
        this.printStackValuesOn(tty, "expressions", this.getExpressions());
    }

    public void printActivation(int index) {
        this.printActivationOn(System.out, index);
    }

    public void printActivationOn(PrintStream tty, int index) {
        tty.print(index + " - ");
        this.printValueOn(tty);
        tty.println();
        if (VM.getVM().wizardMode()) {
            this.printOn(tty);
            tty.println();
        }
    }

    public void verify() {
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof JavaVFrame)) {
            return false;
        }
        JavaVFrame other = (JavaVFrame)o;
        if (!this.getMethod().equals(other.getMethod())) {
            return false;
        }
        if (this.getBCI() != other.getBCI()) {
            return false;
        }
        return ((Object)this.getFrame().getFP()).equals(other.getFrame().getFP());
    }

    public int hashCode() {
        return this.getMethod().hashCode() ^ this.getBCI() ^ ((Object)this.getFrame().getFP()).hashCode();
    }

    public boolean structuralCompare(JavaVFrame other) {
        if (!this.getMethod().equals(other.getMethod())) {
            return false;
        }
        if (this.getBCI() != other.getBCI()) {
            return false;
        }
        StackValueCollection locs = this.getLocals();
        StackValueCollection otherLocs = other.getLocals();
        Assert.that(locs.size() == otherLocs.size(), "sanity check");
        for (int i = 0; i < locs.size(); ++i) {
            if (this.isCompiledFrame() && locs.get(i).getType() == BasicType.getTConflict() || other.isCompiledFrame() && otherLocs.get(i).getType() == BasicType.getTConflict() || locs.get(i).equals(otherLocs.get(i))) continue;
            return false;
        }
        StackValueCollection exprs = this.getExpressions();
        StackValueCollection otherExprs = other.getExpressions();
        Assert.that(exprs.size() == otherExprs.size(), "sanity check");
        for (int i = 0; i < exprs.size(); ++i) {
            if (exprs.get(i).equals(otherExprs.get(i))) continue;
            return false;
        }
        return true;
    }

    private void printStackValuesOn(PrintStream tty, String title, StackValueCollection values) {
        if (values.isEmpty()) {
            return;
        }
        tty.println("\t" + title + ":");
        for (int index = 0; index < values.size(); ++index) {
            tty.print("\t" + index + "\t");
            values.get(index).printOn(tty);
            tty.println();
        }
    }
}

