/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.AddressException;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.gc_implementation.parallelScavenge.PSOldGen;
import sun.jvm.hotspot.gc_implementation.parallelScavenge.PSPermGen;
import sun.jvm.hotspot.gc_implementation.parallelScavenge.PSYoungGen;
import sun.jvm.hotspot.gc_implementation.parallelScavenge.ParallelScavengeHeap;
import sun.jvm.hotspot.gc_interface.CollectedHeap;
import sun.jvm.hotspot.memory.GenCollectedHeap;
import sun.jvm.hotspot.memory.Generation;
import sun.jvm.hotspot.memory.MemRegion;
import sun.jvm.hotspot.memory.Space;
import sun.jvm.hotspot.memory.SpaceClosure;
import sun.jvm.hotspot.oops.ArrayKlassKlass;
import sun.jvm.hotspot.oops.CompiledICHolder;
import sun.jvm.hotspot.oops.CompiledICHolderKlass;
import sun.jvm.hotspot.oops.ConstMethod;
import sun.jvm.hotspot.oops.ConstMethodKlass;
import sun.jvm.hotspot.oops.ConstantPool;
import sun.jvm.hotspot.oops.ConstantPoolCache;
import sun.jvm.hotspot.oops.ConstantPoolCacheKlass;
import sun.jvm.hotspot.oops.ConstantPoolKlass;
import sun.jvm.hotspot.oops.HeapPrinter;
import sun.jvm.hotspot.oops.HeapVisitor;
import sun.jvm.hotspot.oops.Instance;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.InstanceKlassKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.KlassKlass;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.oops.MethodData;
import sun.jvm.hotspot.oops.MethodDataKlass;
import sun.jvm.hotspot.oops.MethodKlass;
import sun.jvm.hotspot.oops.ObjArray;
import sun.jvm.hotspot.oops.ObjArrayKlass;
import sun.jvm.hotspot.oops.ObjArrayKlassKlass;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.RawHeapVisitor;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.oops.SymbolKlass;
import sun.jvm.hotspot.oops.TypeArray;
import sun.jvm.hotspot.oops.TypeArrayKlass;
import sun.jvm.hotspot.oops.TypeArrayKlassKlass;
import sun.jvm.hotspot.oops.UnknownOopException;
import sun.jvm.hotspot.runtime.BasicType;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.ThreadLocalAllocBuffer;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.AddressOps;
import sun.jvm.hotspot.utilities.Assert;

public class ObjectHeap {
    private OopHandle symbolKlassHandle;
    private OopHandle methodKlassHandle;
    private OopHandle constMethodKlassHandle;
    private OopHandle methodDataKlassHandle;
    private OopHandle constantPoolKlassHandle;
    private OopHandle constantPoolCacheKlassHandle;
    private OopHandle klassKlassHandle;
    private OopHandle instanceKlassKlassHandle;
    private OopHandle typeArrayKlassKlassHandle;
    private OopHandle objArrayKlassKlassHandle;
    private OopHandle boolArrayKlassHandle;
    private OopHandle byteArrayKlassHandle;
    private OopHandle charArrayKlassHandle;
    private OopHandle intArrayKlassHandle;
    private OopHandle shortArrayKlassHandle;
    private OopHandle longArrayKlassHandle;
    private OopHandle singleArrayKlassHandle;
    private OopHandle doubleArrayKlassHandle;
    private OopHandle arrayKlassKlassHandle;
    private OopHandle compiledICHolderKlassHandle;
    private SymbolKlass symbolKlassObj;
    private MethodKlass methodKlassObj;
    private ConstMethodKlass constMethodKlassObj;
    private MethodDataKlass methodDataKlassObj;
    private ConstantPoolKlass constantPoolKlassObj;
    private ConstantPoolCacheKlass constantPoolCacheKlassObj;
    private KlassKlass klassKlassObj;
    private InstanceKlassKlass instanceKlassKlassObj;
    private TypeArrayKlassKlass typeArrayKlassKlassObj;
    private ObjArrayKlassKlass objArrayKlassKlassObj;
    private TypeArrayKlass boolArrayKlassObj;
    private TypeArrayKlass byteArrayKlassObj;
    private TypeArrayKlass charArrayKlassObj;
    private TypeArrayKlass intArrayKlassObj;
    private TypeArrayKlass shortArrayKlassObj;
    private TypeArrayKlass longArrayKlassObj;
    private TypeArrayKlass singleArrayKlassObj;
    private TypeArrayKlass doubleArrayKlassObj;
    private ArrayKlassKlass arrayKlassKlassObj;
    private CompiledICHolderKlass compiledICHolderKlassObj;
    private Method finalizerRegisterMethod;
    private long oopSize;
    private long byteSize;
    private long charSize;
    private long booleanSize;
    private long intSize;
    private long shortSize;
    private long longSize;
    private long floatSize;
    private long doubleSize;

    public void initialize(TypeDataBase db) throws WrongTypeException {
        Type universeType = db.lookupType("Universe");
        this.symbolKlassHandle = universeType.getOopField("_symbolKlassObj").getValue();
        this.symbolKlassObj = new SymbolKlass(this.symbolKlassHandle, this);
        this.methodKlassHandle = universeType.getOopField("_methodKlassObj").getValue();
        this.methodKlassObj = new MethodKlass(this.methodKlassHandle, this);
        this.constMethodKlassHandle = universeType.getOopField("_constMethodKlassObj").getValue();
        this.constMethodKlassObj = new ConstMethodKlass(this.constMethodKlassHandle, this);
        this.constantPoolKlassHandle = universeType.getOopField("_constantPoolKlassObj").getValue();
        this.constantPoolKlassObj = new ConstantPoolKlass(this.constantPoolKlassHandle, this);
        this.constantPoolCacheKlassHandle = universeType.getOopField("_constantPoolCacheKlassObj").getValue();
        this.constantPoolCacheKlassObj = new ConstantPoolCacheKlass(this.constantPoolCacheKlassHandle, this);
        this.klassKlassHandle = universeType.getOopField("_klassKlassObj").getValue();
        this.klassKlassObj = new KlassKlass(this.klassKlassHandle, this);
        this.arrayKlassKlassHandle = universeType.getOopField("_arrayKlassKlassObj").getValue();
        this.arrayKlassKlassObj = new ArrayKlassKlass(this.arrayKlassKlassHandle, this);
        this.instanceKlassKlassHandle = universeType.getOopField("_instanceKlassKlassObj").getValue();
        this.instanceKlassKlassObj = new InstanceKlassKlass(this.instanceKlassKlassHandle, this);
        this.typeArrayKlassKlassHandle = universeType.getOopField("_typeArrayKlassKlassObj").getValue();
        this.typeArrayKlassKlassObj = new TypeArrayKlassKlass(this.typeArrayKlassKlassHandle, this);
        this.objArrayKlassKlassHandle = universeType.getOopField("_objArrayKlassKlassObj").getValue();
        this.objArrayKlassKlassObj = new ObjArrayKlassKlass(this.objArrayKlassKlassHandle, this);
        this.boolArrayKlassHandle = universeType.getOopField("_boolArrayKlassObj").getValue();
        this.boolArrayKlassObj = new TypeArrayKlass(this.boolArrayKlassHandle, this);
        this.byteArrayKlassHandle = universeType.getOopField("_byteArrayKlassObj").getValue();
        this.byteArrayKlassObj = new TypeArrayKlass(this.byteArrayKlassHandle, this);
        this.charArrayKlassHandle = universeType.getOopField("_charArrayKlassObj").getValue();
        this.charArrayKlassObj = new TypeArrayKlass(this.charArrayKlassHandle, this);
        this.intArrayKlassHandle = universeType.getOopField("_intArrayKlassObj").getValue();
        this.intArrayKlassObj = new TypeArrayKlass(this.intArrayKlassHandle, this);
        this.shortArrayKlassHandle = universeType.getOopField("_shortArrayKlassObj").getValue();
        this.shortArrayKlassObj = new TypeArrayKlass(this.shortArrayKlassHandle, this);
        this.longArrayKlassHandle = universeType.getOopField("_longArrayKlassObj").getValue();
        this.longArrayKlassObj = new TypeArrayKlass(this.longArrayKlassHandle, this);
        this.singleArrayKlassHandle = universeType.getOopField("_singleArrayKlassObj").getValue();
        this.singleArrayKlassObj = new TypeArrayKlass(this.singleArrayKlassHandle, this);
        this.doubleArrayKlassHandle = universeType.getOopField("_doubleArrayKlassObj").getValue();
        this.doubleArrayKlassObj = new TypeArrayKlass(this.doubleArrayKlassHandle, this);
        if (!VM.getVM().isCore()) {
            this.methodDataKlassHandle = universeType.getOopField("_methodDataKlassObj").getValue();
            this.methodDataKlassObj = new MethodDataKlass(this.methodDataKlassHandle, this);
            this.compiledICHolderKlassHandle = universeType.getOopField("_compiledICHolderKlassObj").getValue();
            this.compiledICHolderKlassObj = new CompiledICHolderKlass(this.compiledICHolderKlassHandle, this);
        }
        OopHandle handle = universeType.getOopField("_finalizer_register_method").getValue();
        this.finalizerRegisterMethod = new Method(handle, this);
    }

    public ObjectHeap(TypeDataBase db) throws WrongTypeException {
        this.oopSize = db.getOopSize();
        this.byteSize = db.getJByteType().getSize();
        this.charSize = db.getJCharType().getSize();
        this.booleanSize = db.getJBooleanType().getSize();
        this.intSize = db.getJIntType().getSize();
        this.shortSize = db.getJShortType().getSize();
        this.longSize = db.getJLongType().getSize();
        this.floatSize = db.getJFloatType().getSize();
        this.doubleSize = db.getJDoubleType().getSize();
        this.initialize(db);
    }

    public boolean equal(Oop o1, Oop o2) {
        if (o1 != null) {
            return o1.equals(o2);
        }
        return o2 == null;
    }

    public long getOopSize() {
        return this.oopSize;
    }

    public long getByteSize() {
        return this.byteSize;
    }

    public long getCharSize() {
        return this.charSize;
    }

    public long getBooleanSize() {
        return this.booleanSize;
    }

    public long getIntSize() {
        return this.intSize;
    }

    public long getShortSize() {
        return this.shortSize;
    }

    public long getLongSize() {
        return this.longSize;
    }

    public long getFloatSize() {
        return this.floatSize;
    }

    public long getDoubleSize() {
        return this.doubleSize;
    }

    public SymbolKlass getSymbolKlassObj() {
        return this.symbolKlassObj;
    }

    public MethodKlass getMethodKlassObj() {
        return this.methodKlassObj;
    }

    public ConstMethodKlass getConstMethodKlassObj() {
        return this.constMethodKlassObj;
    }

    public MethodDataKlass getMethodDataKlassObj() {
        return this.methodDataKlassObj;
    }

    public ConstantPoolKlass getConstantPoolKlassObj() {
        return this.constantPoolKlassObj;
    }

    public ConstantPoolCacheKlass getConstantPoolCacheKlassObj() {
        return this.constantPoolCacheKlassObj;
    }

    public KlassKlass getKlassKlassObj() {
        return this.klassKlassObj;
    }

    public ArrayKlassKlass getArrayKlassKlassObj() {
        return this.arrayKlassKlassObj;
    }

    public InstanceKlassKlass getInstanceKlassKlassObj() {
        return this.instanceKlassKlassObj;
    }

    public ObjArrayKlassKlass getObjArrayKlassKlassObj() {
        return this.objArrayKlassKlassObj;
    }

    public TypeArrayKlassKlass getTypeArrayKlassKlassObj() {
        return this.typeArrayKlassKlassObj;
    }

    public TypeArrayKlass getBoolArrayKlassObj() {
        return this.boolArrayKlassObj;
    }

    public TypeArrayKlass getByteArrayKlassObj() {
        return this.byteArrayKlassObj;
    }

    public TypeArrayKlass getCharArrayKlassObj() {
        return this.charArrayKlassObj;
    }

    public TypeArrayKlass getIntArrayKlassObj() {
        return this.intArrayKlassObj;
    }

    public TypeArrayKlass getShortArrayKlassObj() {
        return this.shortArrayKlassObj;
    }

    public TypeArrayKlass getLongArrayKlassObj() {
        return this.longArrayKlassObj;
    }

    public TypeArrayKlass getSingleArrayKlassObj() {
        return this.singleArrayKlassObj;
    }

    public TypeArrayKlass getDoubleArrayKlassObj() {
        return this.doubleArrayKlassObj;
    }

    public CompiledICHolderKlass getCompiledICHolderKlassObj() {
        Assert.that(!VM.getVM().isCore(), "must not be called for core build");
        return this.compiledICHolderKlassObj;
    }

    public Method getFinalizerRegisterMethod() {
        return this.finalizerRegisterMethod;
    }

    public Klass typeArrayKlassObj(int t) {
        if (t == BasicType.getTBoolean()) {
            return this.getBoolArrayKlassObj();
        }
        if (t == BasicType.getTChar()) {
            return this.getCharArrayKlassObj();
        }
        if (t == BasicType.getTFloat()) {
            return this.getSingleArrayKlassObj();
        }
        if (t == BasicType.getTDouble()) {
            return this.getDoubleArrayKlassObj();
        }
        if (t == BasicType.getTByte()) {
            return this.getByteArrayKlassObj();
        }
        if (t == BasicType.getTShort()) {
            return this.getShortArrayKlassObj();
        }
        if (t == BasicType.getTInt()) {
            return this.getIntArrayKlassObj();
        }
        if (t == BasicType.getTLong()) {
            return this.getLongArrayKlassObj();
        }
        throw new RuntimeException("Illegal basic type " + t);
    }

    public void iterate(HeapVisitor visitor) {
        this.iterateLiveRegions(this.collectLiveRegions(), visitor, null);
    }

    public void iterate(HeapVisitor visitor, ObjectFilter of) {
        this.iterateLiveRegions(this.collectLiveRegions(), visitor, of);
    }

    public void iterateObjectsOfKlass(HeapVisitor visitor, Klass k, boolean includeSubtypes) {
        if (includeSubtypes) {
            if (k.isFinal()) {
                this.iterateExact(visitor, k);
            } else {
                this.iterateSubtypes(visitor, k);
            }
        } else if (!k.isAbstract() && !k.isInterface()) {
            this.iterateExact(visitor, k);
        }
    }

    public void iterateObjectsOfKlass(HeapVisitor visitor, Klass k) {
        this.iterateObjectsOfKlass(visitor, k, true);
    }

    public void iterateRaw(RawHeapVisitor visitor) {
        Address top;
        Address bottom;
        int i;
        List liveRegions = this.collectLiveRegions();
        long totalSize = 0L;
        for (i = 0; i < liveRegions.size(); i += 2) {
            bottom = (Address)liveRegions.get(i);
            top = (Address)liveRegions.get(i + 1);
            totalSize += top.minus(bottom);
        }
        visitor.prologue(totalSize);
        for (i = 0; i < liveRegions.size(); i += 2) {
            bottom = (Address)liveRegions.get(i);
            top = (Address)liveRegions.get(i + 1);
            while (bottom.lessThan(top)) {
                visitor.visitAddress(bottom);
                bottom = bottom.addOffsetTo(VM.getVM().getAddressSize());
            }
        }
        visitor.epilogue();
    }

    public void iteratePerm(HeapVisitor visitor) {
        CollectedHeap heap = VM.getVM().getUniverse().heap();
        ArrayList liveRegions = new ArrayList();
        this.addPermGenLiveRegions(liveRegions, heap);
        this.iterateLiveRegions(liveRegions, visitor, null);
    }

    public Oop newOop(OopHandle handle) {
        OopHandle klass;
        if (handle == null) {
            return null;
        }
        if (handle.equals(this.methodKlassHandle)) {
            return this.getMethodKlassObj();
        }
        if (handle.equals(this.constMethodKlassHandle)) {
            return this.getConstMethodKlassObj();
        }
        if (handle.equals(this.symbolKlassHandle)) {
            return this.getSymbolKlassObj();
        }
        if (handle.equals(this.constantPoolKlassHandle)) {
            return this.getConstantPoolKlassObj();
        }
        if (handle.equals(this.constantPoolCacheKlassHandle)) {
            return this.getConstantPoolCacheKlassObj();
        }
        if (handle.equals(this.instanceKlassKlassHandle)) {
            return this.getInstanceKlassKlassObj();
        }
        if (handle.equals(this.objArrayKlassKlassHandle)) {
            return this.getObjArrayKlassKlassObj();
        }
        if (handle.equals(this.klassKlassHandle)) {
            return this.getKlassKlassObj();
        }
        if (handle.equals(this.arrayKlassKlassHandle)) {
            return this.getArrayKlassKlassObj();
        }
        if (handle.equals(this.typeArrayKlassKlassHandle)) {
            return this.getTypeArrayKlassKlassObj();
        }
        if (handle.equals(this.boolArrayKlassHandle)) {
            return this.getBoolArrayKlassObj();
        }
        if (handle.equals(this.byteArrayKlassHandle)) {
            return this.getByteArrayKlassObj();
        }
        if (handle.equals(this.charArrayKlassHandle)) {
            return this.getCharArrayKlassObj();
        }
        if (handle.equals(this.intArrayKlassHandle)) {
            return this.getIntArrayKlassObj();
        }
        if (handle.equals(this.shortArrayKlassHandle)) {
            return this.getShortArrayKlassObj();
        }
        if (handle.equals(this.longArrayKlassHandle)) {
            return this.getLongArrayKlassObj();
        }
        if (handle.equals(this.singleArrayKlassHandle)) {
            return this.getSingleArrayKlassObj();
        }
        if (handle.equals(this.doubleArrayKlassHandle)) {
            return this.getDoubleArrayKlassObj();
        }
        if (!VM.getVM().isCore()) {
            if (handle.equals(this.compiledICHolderKlassHandle)) {
                return this.getCompiledICHolderKlassObj();
            }
            if (handle.equals(this.methodDataKlassHandle)) {
                return this.getMethodDataKlassObj();
            }
        }
        if ((klass = Oop.getKlassForOopHandle(handle)) != null) {
            if (klass.equals(this.methodKlassHandle)) {
                return new Method(handle, this);
            }
            if (klass.equals(this.constMethodKlassHandle)) {
                return new ConstMethod(handle, this);
            }
            if (klass.equals(this.symbolKlassHandle)) {
                return new Symbol(handle, this);
            }
            if (klass.equals(this.constantPoolKlassHandle)) {
                return new ConstantPool(handle, this);
            }
            if (klass.equals(this.constantPoolCacheKlassHandle)) {
                return new ConstantPoolCache(handle, this);
            }
            if (!VM.getVM().isCore()) {
                if (klass.equals(this.compiledICHolderKlassHandle)) {
                    return new CompiledICHolder(handle, this);
                }
                if (klass.equals(this.methodDataKlassHandle)) {
                    return new MethodData(handle, this);
                }
            }
            if (klass.equals(this.instanceKlassKlassHandle)) {
                return new InstanceKlass(handle, this);
            }
            if (klass.equals(this.objArrayKlassKlassHandle)) {
                return new ObjArrayKlass(handle, this);
            }
            if (klass.equals(this.typeArrayKlassKlassHandle)) {
                return new TypeArrayKlass(handle, this);
            }
            OopHandle klassKlass = Oop.getKlassForOopHandle(klass);
            if (klassKlass != null) {
                if (klassKlass.equals(this.instanceKlassKlassHandle)) {
                    return new Instance(handle, this);
                }
                if (klassKlass.equals(this.objArrayKlassKlassHandle)) {
                    return new ObjArray(handle, this);
                }
                if (klassKlass.equals(this.typeArrayKlassKlassHandle)) {
                    return new TypeArray(handle, this);
                }
            }
        }
        System.err.println("Unknown oop at " + handle);
        System.err.println("Oop's klass is " + klass);
        throw new UnknownOopException();
    }

    public void print() {
        HeapPrinter printer = new HeapPrinter(System.out);
        this.iterate(printer);
    }

    private void iterateExact(HeapVisitor visitor, final Klass k) {
        this.iterateLiveRegions(this.collectLiveRegions(), visitor, new ObjectFilter(){

            public boolean canInclude(Oop obj) {
                Klass tk = obj.getKlass();
                return tk != null && tk.equals(k);
            }
        });
    }

    private void iterateSubtypes(HeapVisitor visitor, final Klass k) {
        this.iterateLiveRegions(this.collectLiveRegions(), visitor, new ObjectFilter(){

            public boolean canInclude(Oop obj) {
                Klass tk = obj.getKlass();
                return tk != null && tk.isSubtypeOf(k);
            }
        });
    }

    private void iterateLiveRegions(List liveRegions, HeapVisitor visitor, ObjectFilter of) {
        Address top;
        Address bottom;
        int i;
        long totalSize = 0L;
        for (i = 0; i < liveRegions.size(); i += 2) {
            bottom = (Address)liveRegions.get(i);
            top = (Address)liveRegions.get(i + 1);
            totalSize += top.minus(bottom);
        }
        visitor.prologue(totalSize);
        for (i = 0; i < liveRegions.size(); i += 2) {
            bottom = (Address)liveRegions.get(i);
            top = (Address)liveRegions.get(i + 1);
            try {
                OopHandle handle = bottom.addOffsetToAsOopHandle(0L);
                while (handle.lessThan(top)) {
                    Oop obj = this.newOop(handle);
                    if (of == null || of.canInclude(obj)) {
                        visitor.doObj(obj);
                    }
                    handle = handle.addOffsetToAsOopHandle(obj.getObjectSize());
                }
                continue;
            }
            catch (AddressException e) {
                continue;
            }
            catch (UnknownOopException e) {
                // empty catch block
            }
        }
        visitor.epilogue();
    }

    private void addPermGenLiveRegions(List output, CollectedHeap heap) {
        LiveRegionsCollector lrc = new LiveRegionsCollector(output);
        if (heap instanceof GenCollectedHeap) {
            GenCollectedHeap genHeap = (GenCollectedHeap)heap;
            Generation gen = genHeap.permGen();
            gen.spaceIterate(lrc, true);
        } else if (heap instanceof ParallelScavengeHeap) {
            ParallelScavengeHeap psh = (ParallelScavengeHeap)heap;
            PSPermGen permGen = psh.permGen();
            this.addLiveRegions(permGen.objectSpace().getLiveRegions(), output);
        } else {
            Assert.that(false, "Expecting GenCollectedHeap or ParallelScavengeHeap, but got " + heap.getClass().getName());
        }
    }

    private void addLiveRegions(List input, List output) {
        Iterator itr = input.iterator();
        while (itr.hasNext()) {
            MemRegion reg = (MemRegion)itr.next();
            Address top = reg.end();
            Address bottom = reg.start();
            Assert.that(top != null, "top address in a live region should not be null");
            Assert.that(bottom != null, "bottom address in a live region should not be null");
            output.add(top);
            output.add(bottom);
        }
    }

    private List collectLiveRegions() {
        ArrayList<Address> liveRegions = new ArrayList<Address>();
        LiveRegionsCollector lrc = new LiveRegionsCollector(liveRegions);
        CollectedHeap heap = VM.getVM().getUniverse().heap();
        if (heap instanceof GenCollectedHeap) {
            GenCollectedHeap genHeap = (GenCollectedHeap)heap;
            for (int i = 0; i < genHeap.nGens(); ++i) {
                Generation gen = genHeap.getGen(i);
                gen.spaceIterate(lrc, true);
            }
        } else if (heap instanceof ParallelScavengeHeap) {
            ParallelScavengeHeap psh = (ParallelScavengeHeap)heap;
            PSYoungGen youngGen = psh.youngGen();
            this.addLiveRegions(youngGen.edenSpace().getLiveRegions(), liveRegions);
            this.addLiveRegions(youngGen.fromSpace().getLiveRegions(), liveRegions);
            PSOldGen oldGen = psh.oldGen();
            this.addLiveRegions(oldGen.objectSpace().getLiveRegions(), liveRegions);
        } else {
            Assert.that(false, "Expecting GenCollectedHeap or ParallelScavengeHeap, but got " + heap.getClass().getName());
        }
        this.addPermGenLiveRegions(liveRegions, heap);
        if (VM.getVM().getUseTLAB()) {
            for (JavaThread thread = VM.getVM().getThreads().first(); thread != null; thread = thread.next()) {
                ThreadLocalAllocBuffer tlab;
                if (!thread.isJavaThread() || (tlab = thread.tlab()).start() == null) continue;
                if (tlab.top() == null || tlab.end() == null) {
                    System.err.print("Warning: skipping invalid TLAB for thread ");
                    thread.printThreadIDOn(System.err);
                    System.err.println();
                    continue;
                }
                liveRegions.add(tlab.start());
                liveRegions.add(tlab.start());
                liveRegions.add(tlab.top());
                liveRegions.add(tlab.end());
            }
        }
        Collections.sort(liveRegions, new Comparator(){

            public int compare(Object o1, Object o2) {
                Address a1 = (Address)o1;
                Address a2 = (Address)o2;
                if (AddressOps.lt(a1, a2)) {
                    return -1;
                }
                if (AddressOps.gt(a1, a2)) {
                    return 1;
                }
                return 0;
            }
        });
        Assert.that(liveRegions.size() % 2 == 0, "Must have even number of region boundaries");
        return liveRegions;
    }

    private class LiveRegionsCollector
    implements SpaceClosure {
        private List liveRegions;

        LiveRegionsCollector(List l) {
            this.liveRegions = l;
        }

        public void doSpace(Space s) {
            ObjectHeap.this.addLiveRegions(s.getLiveRegions(), this.liveRegions);
        }
    }

    public static interface ObjectFilter {
        public boolean canInclude(Oop var1);
    }
}

