/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.OopVisitor;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class ArrayKlass
extends Klass {
    private static CIntField dimension;
    private static OopField higherDimension;
    private static OopField lowerDimension;
    private static CIntField vtableLen;
    private static CIntField allocSize;
    private static CIntField arrayHeaderInBytes;
    private static Symbol javaLangCloneableName;
    private static Symbol javaLangObjectName;
    private static Symbol javaIoSerializableName;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("arrayKlass");
        dimension = new CIntField(type.getCIntegerField("_dimension"), Oop.getHeaderSize());
        higherDimension = new OopField(type.getOopField("_higher_dimension"), Oop.getHeaderSize());
        lowerDimension = new OopField(type.getOopField("_lower_dimension"), Oop.getHeaderSize());
        vtableLen = new CIntField(type.getCIntegerField("_vtable_len"), Oop.getHeaderSize());
        allocSize = new CIntField(type.getCIntegerField("_alloc_size"), Oop.getHeaderSize());
        arrayHeaderInBytes = new CIntField(type.getCIntegerField("_array_header_in_bytes"), Oop.getHeaderSize());
        javaLangCloneableName = null;
        javaLangObjectName = null;
        javaIoSerializableName = null;
    }

    ArrayKlass(OopHandle handle, ObjectHeap heap) {
        super(handle, heap);
    }

    public long getDimension() {
        return dimension.getValue(this);
    }

    public Klass getHigherDimension() {
        return (Klass)higherDimension.getValue(this);
    }

    public Klass getLowerDimension() {
        return (Klass)lowerDimension.getValue(this);
    }

    public long getVtableLen() {
        return vtableLen.getValue(this);
    }

    public long getAllocSize() {
        return allocSize.getValue(this);
    }

    public long getArrayHeaderInBytes() {
        return arrayHeaderInBytes.getValue(this);
    }

    private static Symbol javaLangCloneableName() {
        if (javaLangCloneableName == null) {
            javaLangCloneableName = VM.getVM().getSymbolTable().probe("java/lang/Cloneable");
        }
        return javaLangCloneableName;
    }

    private static Symbol javaLangObjectName() {
        if (javaLangObjectName == null) {
            javaLangObjectName = VM.getVM().getSymbolTable().probe("java/lang/Object");
        }
        return javaLangObjectName;
    }

    private static Symbol javaIoSerializableName() {
        if (javaIoSerializableName == null) {
            javaIoSerializableName = VM.getVM().getSymbolTable().probe("java/io/Serializable");
        }
        return javaIoSerializableName;
    }

    public int getClassStatus() {
        return 7;
    }

    public long computeModifierFlags() {
        return 1041L;
    }

    boolean computeSubtypeOf(Klass k) {
        Symbol name = k.getName();
        return name != null && (name.equals(ArrayKlass.javaIoSerializableName()) || name.equals(ArrayKlass.javaLangCloneableName()) || name.equals(ArrayKlass.javaLangObjectName()));
    }

    public void printValueOn(PrintStream tty) {
        tty.print("ArrayKlass");
    }

    public long getObjectSize() {
        return ArrayKlass.alignObjectSize(InstanceKlass.getHeaderSize() + this.getVtableLen() * this.getHeap().getOopSize());
    }

    public void iterateFields(OopVisitor visitor, boolean doVMFields) {
        super.iterateFields(visitor, doVMFields);
        if (doVMFields) {
            visitor.doCInt(dimension, true);
            visitor.doOop(higherDimension, true);
            visitor.doOop(lowerDimension, true);
            visitor.doCInt(vtableLen, true);
            visitor.doCInt(allocSize, true);
            visitor.doCInt(arrayHeaderInBytes, true);
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                ArrayKlass.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

