/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.jdi;

import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import java.util.LinkedList;
import sun.jvm.hotspot.jdi.EventSetImpl;
import sun.jvm.hotspot.jdi.MirrorImpl;

public class EventQueueImpl
extends MirrorImpl
implements EventQueue {
    LinkedList eventSets = new LinkedList();
    Object target = null;
    boolean closed = false;

    EventQueueImpl(VirtualMachine vm) {
        super(vm);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    synchronized void enqueue(EventSet eventSet) {
        this.eventSets.add(eventSet);
        this.notifyAll();
    }

    synchronized int size() {
        return this.eventSets.size();
    }

    synchronized void close() {
        if (!this.closed) {
            this.closed = true;
        }
    }

    public EventSet remove() throws InterruptedException {
        return this.remove(0L);
    }

    public EventSet remove(long timeout) throws InterruptedException {
        EventSetImpl fullEventSet;
        EventSet eventSet;
        if (timeout < 0L) {
            throw new IllegalArgumentException("Timeout cannot be negative");
        }
        do {
            if ((fullEventSet = this.removeUnfiltered(timeout)) != null) continue;
            eventSet = null;
            break;
        } while ((eventSet = fullEventSet.userFilter()) == null || eventSet.isEmpty());
        return eventSet;
    }

    EventSet removeInternal() throws InterruptedException {
        EventSet eventSet;
        while ((eventSet = this.removeUnfiltered(0L).internalFilter()) == null || eventSet.isEmpty()) {
        }
        return eventSet;
    }

    private TimerThread startTimerThread(long timeout) {
        TimerThread thread = new TimerThread(timeout);
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    private boolean shouldWait(TimerThread timerThread) {
        return !this.closed && this.eventSets.isEmpty() && (timerThread == null || !timerThread.timedOut());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private EventSetImpl removeUnfiltered(long timeout) throws InterruptedException {
        EventSetImpl eventSet = null;
        EventQueueImpl eventQueueImpl = this;
        // MONITORENTER : eventQueueImpl
        if (!this.eventSets.isEmpty()) {
            eventSet = (EventSetImpl)this.eventSets.removeFirst();
        } else {
            TimerThread timerThread = null;
            try {
                if (timeout > 0L) {
                    timerThread = this.startTimerThread(timeout);
                }
                while (this.shouldWait(timerThread)) {
                    this.wait();
                }
                Object var7_5 = null;
                if (timerThread != null && !timerThread.timedOut()) {
                    timerThread.interrupt();
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (timerThread == null) throw throwable;
                if (timerThread.timedOut()) throw throwable;
                timerThread.interrupt();
                throw throwable;
            }
            if (this.eventSets.isEmpty()) {
                if (this.closed) {
                    throw new VMDisconnectedException();
                }
            } else {
                eventSet = (EventSetImpl)this.eventSets.removeFirst();
            }
        }
        // MONITOREXIT : eventQueueImpl
        if (eventSet == null) return eventSet;
        eventSet.build();
        return eventSet;
    }

    private class TimerThread
    extends Thread {
        private boolean timedOut;
        private long timeout;

        TimerThread(long timeout) {
            super(EventQueueImpl.this.vm.threadGroupForJDI(), "JDI Event Queue Timer");
            this.timedOut = false;
            this.timeout = timeout;
        }

        boolean timedOut() {
            return this.timedOut;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                EventQueueImpl queue;
                Thread.sleep(this.timeout);
                EventQueueImpl eventQueueImpl = queue = EventQueueImpl.this;
                synchronized (eventQueueImpl) {
                    this.timedOut = true;
                    queue.notifyAll();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

