/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.BytecodeStream;
import sun.jvm.hotspot.interpreter.BytecodeWideable;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.utilities.Assert;

public class BytecodeRet
extends BytecodeWideable {
    BytecodeRet(Method method, int bci) {
        super(method, bci);
    }

    public void verify() {
        Assert.that(this.isValid(), "check ret");
    }

    public boolean isValid() {
        return this.javaCode() == 169;
    }

    public static BytecodeRet at(Method method, int bci) {
        BytecodeRet b = new BytecodeRet(method, bci);
        b.verify();
        return b;
    }

    public static BytecodeRet atCheck(Method method, int bci) {
        BytecodeRet b = new BytecodeRet(method, bci);
        return b.isValid() ? b : null;
    }

    public static BytecodeRet at(BytecodeStream bcs) {
        return new BytecodeRet(bcs.method(), bcs.bci());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ret");
        buf.append(" ");
        buf.append('#');
        buf.append(Integer.toString(this.getLocalVarIndex()));
        return buf.toString();
    }
}

