/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.interpreter;

import sun.jvm.hotspot.interpreter.BytecodeJmp;
import sun.jvm.hotspot.interpreter.BytecodeStream;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.utilities.Assert;

public class BytecodeGotoW
extends BytecodeJmp {
    BytecodeGotoW(Method method, int bci) {
        super(method, bci);
    }

    public int getTargetBCI() {
        return this.bci() + this.javaSignedWordAt(1);
    }

    public void verify() {
        Assert.that(this.isValid(), "check goto_w");
    }

    public boolean isValid() {
        return this.javaCode() == 200;
    }

    public static BytecodeGotoW at(Method method, int bci) {
        BytecodeGotoW b = new BytecodeGotoW(method, bci);
        b.verify();
        return b;
    }

    public static BytecodeGotoW atCheck(Method method, int bci) {
        BytecodeGotoW b = new BytecodeGotoW(method, bci);
        return b.isValid() ? b : null;
    }

    public static BytecodeGotoW at(BytecodeStream bcs) {
        return new BytecodeGotoW(bcs.method(), bcs.bci());
    }
}

