/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.win32;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.AddressException;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.ThreadContext;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.win32.Win32Debugger;
import sun.jvm.hotspot.debugger.win32.Win32LDTEntry;
import sun.jvm.hotspot.debugger.win32.Win32ThreadContext;
import sun.jvm.hotspot.debugger.x86.X86ThreadContext;

class Win32Thread
implements ThreadProxy {
    private Win32Debugger debugger;
    private int handle;
    private boolean mustDuplicate;
    private boolean gotID;
    private int id;

    Win32Thread(Win32Debugger debugger, Address addr) {
        this.debugger = debugger;
        this.handle = (int)addr.getCIntegerAt(0L, 4L, true);
        this.mustDuplicate = true;
        this.gotID = false;
    }

    Win32Thread(Win32Debugger debugger, long handle) {
        this.debugger = debugger;
        this.handle = (int)handle;
        this.mustDuplicate = false;
        this.gotID = false;
    }

    public ThreadContext getContext() throws IllegalThreadStateException {
        if (!this.debugger.isSuspended()) {
            throw new IllegalThreadStateException("Target process must be suspended");
        }
        long[] data = this.debugger.getThreadIntegerRegisterSet(this.handle, this.mustDuplicate);
        Win32ThreadContext context = new Win32ThreadContext(this.debugger);
        for (int i = 0; i < data.length; ++i) {
            context.setRegister(i, data[i]);
        }
        return context;
    }

    public boolean canSetContext() throws DebuggerException {
        return true;
    }

    public void setContext(ThreadContext thrCtx) throws IllegalThreadStateException, DebuggerException {
        if (!this.debugger.isSuspended()) {
            throw new IllegalThreadStateException("Target process must be suspended");
        }
        X86ThreadContext context = (X86ThreadContext)thrCtx;
        long[] data = new long[25];
        for (int i = 0; i < data.length; ++i) {
            data[i] = context.getRegister(i);
        }
        this.debugger.setThreadIntegerRegisterSet(this.handle, this.mustDuplicate, data);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Win32Thread)) {
            return false;
        }
        return ((Win32Thread)obj).getThreadID() == this.getThreadID();
    }

    public int hashCode() {
        return this.getThreadID();
    }

    public String toString() {
        return Integer.toString(this.getThreadID());
    }

    private int getThreadID() {
        if (!this.gotID) {
            try {
                X86ThreadContext context = (X86ThreadContext)this.getContext();
                Win32LDTEntry ldt = this.debugger.getThreadSelectorEntry(this.handle, this.mustDuplicate, (int)context.getRegister(1));
                Address teb = this.debugger.newAddress(ldt.getBase());
                this.id = (int)teb.getCIntegerAt(36L, 4L, true);
                this.gotID = true;
            }
            catch (AddressException e) {
                throw new DebuggerException(e);
            }
        }
        return this.id;
    }
}

