/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.cdbg.basic;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.cdbg.FieldIdentifier;
import sun.jvm.hotspot.debugger.cdbg.ObjectVisitor;
import sun.jvm.hotspot.debugger.cdbg.PointerType;
import sun.jvm.hotspot.debugger.cdbg.Type;
import sun.jvm.hotspot.debugger.cdbg.TypeVisitor;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCDebugInfoDataBase;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicType;
import sun.jvm.hotspot.debugger.cdbg.basic.ResolveListener;

public class BasicPointerType
extends BasicType
implements PointerType {
    private Type targetType;

    public BasicPointerType(int size, Type targetType) {
        this(null, size, targetType, 0);
    }

    private BasicPointerType(String name, int size, Type targetType, int cvAttributes) {
        super(name, size, cvAttributes);
        this.targetType = targetType;
        if (!((BasicType)targetType).isLazy()) {
            this.computeName();
        }
    }

    public PointerType asPointer() {
        return this;
    }

    public Type getTargetType() {
        return this.targetType;
    }

    Type resolveTypes(BasicCDebugInfoDataBase db, ResolveListener listener) {
        super.resolveTypes(db, listener);
        this.targetType = db.resolveType(this, this.targetType, listener, "resolving pointer type");
        this.computeName();
        return this;
    }

    public void iterateObject(Address a, ObjectVisitor v, FieldIdentifier f) {
        v.doPointer(f, a.getAddressAt(0L));
    }

    protected Type createCVVariant(int cvAttributes) {
        return new BasicPointerType(this.getName(), this.getSize(), this.getTargetType(), cvAttributes);
    }

    public void visit(TypeVisitor v) {
        v.doPointerType(this);
    }

    private void computeName() {
        this.setName(this.targetType.getName() + " *");
    }
}

