/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.code;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import sun.jvm.hotspot.code.DebugInfoReadStream;
import sun.jvm.hotspot.code.MonitorValue;
import sun.jvm.hotspot.code.NMethod;
import sun.jvm.hotspot.code.ScopeValue;
import sun.jvm.hotspot.oops.Method;
import sun.jvm.hotspot.runtime.VM;

public class ScopeDesc {
    private NMethod code;
    private Method method;
    private int bci;
    private int decodeOffset;
    private int senderDecodeOffset;
    private int localsDecodeOffset;
    private int expressionsDecodeOffset;
    private int monitorsDecodeOffset;

    public ScopeDesc(NMethod code, int decodeOffset) {
        this.code = code;
        this.decodeOffset = decodeOffset;
        DebugInfoReadStream stream = this.streamAt(decodeOffset);
        this.senderDecodeOffset = stream.readInt();
        this.method = (Method)VM.getVM().getObjectHeap().newOop(stream.readOopHandle());
        this.bci = stream.readInt();
        this.localsDecodeOffset = stream.readInt();
        this.expressionsDecodeOffset = stream.readInt();
        this.monitorsDecodeOffset = stream.readInt();
    }

    public NMethod getNMethod() {
        return this.code;
    }

    public Method getMethod() {
        return this.method;
    }

    public int getBCI() {
        return this.bci;
    }

    public List getLocals() {
        return this.decodeScopeValues(this.localsDecodeOffset);
    }

    public List getExpressions() {
        return this.decodeScopeValues(this.expressionsDecodeOffset);
    }

    public List getMonitors() {
        return this.decodeMonitorValues(this.monitorsDecodeOffset);
    }

    public ScopeDesc sender() {
        if (this.isTop()) {
            return null;
        }
        return new ScopeDesc(this.code, this.senderDecodeOffset);
    }

    public int getDecodeOffset() {
        return this.decodeOffset;
    }

    public boolean isTop() {
        return this.senderDecodeOffset == -1;
    }

    public boolean equals(Object arg) {
        if (arg == null) {
            return false;
        }
        if (!(arg instanceof ScopeDesc)) {
            return false;
        }
        ScopeDesc sd = (ScopeDesc)arg;
        return sd.method.equals(this.method) && sd.bci == this.bci;
    }

    public void printValue() {
        this.printValueOn(System.out);
    }

    public void printValueOn(PrintStream tty) {
        tty.print("ScopeDesc for ");
        this.method.printValueOn(tty);
        tty.println(" @bci " + this.bci);
    }

    private DebugInfoReadStream streamAt(int decodeOffset) {
        return new DebugInfoReadStream(this.code, decodeOffset);
    }

    private List decodeScopeValues(int decodeOffset) {
        if (decodeOffset == -1) {
            return null;
        }
        DebugInfoReadStream stream = this.streamAt(decodeOffset);
        int length = stream.readInt();
        ArrayList<ScopeValue> res = new ArrayList<ScopeValue>(length);
        for (int i = 0; i < length; ++i) {
            res.add(ScopeValue.readFrom(stream));
        }
        return res;
    }

    private List decodeMonitorValues(int decodeOffset) {
        if (decodeOffset == -1) {
            return null;
        }
        DebugInfoReadStream stream = this.streamAt(decodeOffset);
        int length = stream.readInt();
        ArrayList<MonitorValue> res = new ArrayList<MonitorValue>(length);
        for (int i = 0; i < length; ++i) {
            res.add(new MonitorValue(stream));
        }
        return res;
    }
}

