/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Alerts;
import com.sun.net.ssl.internal.ssl.CipherSuite;
import com.sun.net.ssl.internal.ssl.CipherSuiteConstants;
import com.sun.net.ssl.internal.ssl.ClientDiffieHellmanPublic;
import com.sun.net.ssl.internal.ssl.DHKeyExchange;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.HandshakeMessage;
import com.sun.net.ssl.internal.ssl.Handshaker;
import com.sun.net.ssl.internal.ssl.JsseJce;
import com.sun.net.ssl.internal.ssl.KerberosWrapper;
import com.sun.net.ssl.internal.ssl.PreMasterSecret;
import com.sun.net.ssl.internal.ssl.ProtocolList;
import com.sun.net.ssl.internal.ssl.ProtocolVersion;
import com.sun.net.ssl.internal.ssl.RandomCookie;
import com.sun.net.ssl.internal.ssl.SSLContextImpl;
import com.sun.net.ssl.internal.ssl.SSLEngineImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketImpl;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.ServicePermission;
import sun.security.jgss.krb5.Krb5Util;

final class ServerHandshaker
extends Handshaker {
    private byte doClientAuth;
    private X509Certificate[] certs;
    private PrivateKey privateKey;
    private KerberosKey[] kerberosKeys;
    private boolean needClientVerify = false;
    private PrivateKey tempPrivateKey;
    private PublicKey tempPublicKey;
    private DHKeyExchange dh;
    private ProtocolVersion clientRequestedVersion;

    ServerHandshaker(SSLSocketImpl sSLSocketImpl, SSLContextImpl sSLContextImpl, ProtocolList protocolList, byte by) {
        super(sSLSocketImpl, sSLContextImpl, protocolList, by != 0, false);
        this.doClientAuth = by;
    }

    ServerHandshaker(SSLEngineImpl sSLEngineImpl, SSLContextImpl sSLContextImpl, ProtocolList protocolList, byte by) {
        super(sSLEngineImpl, sSLContextImpl, protocolList, by != 0, false);
        this.doClientAuth = by;
    }

    void setClientAuth(byte by) {
        this.doClientAuth = by;
    }

    private boolean getEphemeralRSAKeys(boolean bl) {
        KeyPair keyPair = this.sslContext.getEphemeralKeyManager().getRSAKeyPair(bl, this.sslContext.getSecureRandom());
        if (keyPair == null) {
            return false;
        }
        this.tempPublicKey = keyPair.getPublic();
        this.tempPrivateKey = keyPair.getPrivate();
        return true;
    }

    private void getEphemeralDHKeys(boolean bl) {
        boolean bl2 = !bl;
        this.dh = new DHKeyExchange(bl2);
        this.dh.generateKeyPair(this.sslContext.getSecureRandom(), bl2 ? 768 : 512);
    }

    void processMessage(byte by, int n) throws IOException {
        if (this.state > by && this.state != 16 && by != 15) {
            throw new SSLProtocolException("Handshake message sequence violation, state = " + this.state + ", type = " + by);
        }
        switch (by) {
            case 1: {
                this.input.mark(n);
                HandshakeMessage.ClientHello clientHello = new HandshakeMessage.ClientHello(this.input);
                this.input.reset();
                this.input.skip(n);
                this.clientHello(clientHello);
                break;
            }
            case 11: {
                if (this.doClientAuth == 0) {
                    this.fatalSE((byte)10, "client sent unsolicited cert chain");
                }
                this.clientCertificate(new HandshakeMessage.CertificateMsg(this.input));
                break;
            }
            case 16: {
                byte[] byArray;
                if (this.keyExchange == K_RSA || this.keyExchange == K_RSA_EXPORT) {
                    PreMasterSecret preMasterSecret = new PreMasterSecret(this.protocolVersion, this.clientRequestedVersion, this.sslContext.getSecureRandom(), this.input, n, this.privateKey);
                    byArray = this.clientKeyExchange(preMasterSecret);
                } else {
                    byArray = this.keyExchange == K_KRB5 || this.keyExchange == K_KRB5_EXPORT ? this.clientKeyExchange(new KerberosWrapper(this.protocolVersion, this.clientRequestedVersion, this.sslContext.getSecureRandom(), this.input, this.kerberosKeys)) : this.clientKeyExchange(new ClientDiffieHellmanPublic(this.input));
                }
                this.calculateKeys(byArray);
                Arrays.fill(byArray, (byte)0);
                break;
            }
            case 15: {
                this.clientCertificateVerify(new HandshakeMessage.CertificateVerify(this.input));
                break;
            }
            case 20: {
                this.clientFinished(new HandshakeMessage.Finished(this.protocolVersion, this.input));
                break;
            }
            default: {
                throw new SSLProtocolException("Illegal server handshake msg, " + by);
            }
        }
        if (this.state < by && by != 15) {
            this.state = by;
        }
    }

    private void clientHello(HandshakeMessage.ClientHello clientHello) throws IOException {
        X509Certificate[] x509CertificateArray;
        Object object;
        CipherSuiteConstants cipherSuiteConstants;
        if (debug != null && Debug.isOn("handshake")) {
            clientHello.print(System.out);
        }
        this.input.digestNow();
        HandshakeMessage.ServerHello serverHello = new HandshakeMessage.ServerHello();
        this.clientRequestedVersion = clientHello.protocolVersion;
        if (this.clientRequestedVersion.v < this.enabledProtocols.min.v) {
            this.fatalSE((byte)40, "Client requested protocol " + this.clientRequestedVersion + " not enabled or not supported");
        }
        ProtocolVersion protocolVersion = this.clientRequestedVersion.v <= this.enabledProtocols.max.v ? this.clientRequestedVersion : this.enabledProtocols.max;
        this.setVersion(protocolVersion);
        serverHello.protocolVersion = this.protocolVersion;
        this.clnt_random = clientHello.clnt_random;
        serverHello.svr_random = this.svr_random = new RandomCookie(this.sslContext.getSecureRandom());
        this.session = null;
        if (clientHello.sessionId.length() != 0 && (cipherSuiteConstants = ((SSLSessionContextImpl)this.sslContext.engineGetServerSessionContext()).get(clientHello.sessionId.getId())) != null) {
            this.resumingSession = ((SSLSessionImpl)cipherSuiteConstants).isRejoinable();
            if (this.resumingSession && (object = ((SSLSessionImpl)cipherSuiteConstants).getProtocolVersion()) != this.protocolVersion) {
                this.resumingSession = false;
            }
            if (this.resumingSession && this.doClientAuth == 2) {
                try {
                    ((SSLSessionImpl)cipherSuiteConstants).getPeerPrincipal();
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    this.resumingSession = false;
                }
            }
            if (this.resumingSession) {
                object = ((SSLSessionImpl)cipherSuiteConstants).getSuite();
                if (((CipherSuite)object).keyExchange == K_KRB5 || ((CipherSuite)object).keyExchange == K_KRB5_EXPORT) {
                    Subject subject;
                    block54: {
                        x509CertificateArray = ((SSLSessionImpl)cipherSuiteConstants).getLocalPrincipal();
                        subject = null;
                        try {
                            subject = (Subject)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    return Krb5Util.getSubject((String)"com.sun.net.ssl.server", (AccessControlContext)ServerHandshaker.this.getAccSE());
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            subject = null;
                            if (debug == null || !Debug.isOn("session")) break block54;
                            System.out.println("Attempt to obtain subject failed!");
                        }
                    }
                    if (subject != null) {
                        Set<KerberosPrincipal> set = subject.getPrincipals(KerberosPrincipal.class);
                        if (!set.contains(x509CertificateArray)) {
                            this.resumingSession = false;
                            if (debug != null && Debug.isOn("session")) {
                                System.out.println("Subject identity is not the same");
                            }
                        } else if (debug != null && Debug.isOn("session")) {
                            System.out.println("Subject identity is same");
                        }
                    } else {
                        this.resumingSession = false;
                        if (debug != null && Debug.isOn("session")) {
                            System.out.println("Kerberos credentials are not present in the current Subject; check if  javax.security.auth.useSubjectAsCreds system property has been set to false");
                        }
                    }
                }
            }
            if (this.resumingSession) {
                object = ((SSLSessionImpl)cipherSuiteConstants).getSuite();
                if (!this.isEnabled((CipherSuite)object) || !clientHello.cipherSuites.contains((CipherSuite)object)) {
                    this.resumingSession = false;
                } else {
                    this.setCipherSuite((CipherSuite)object);
                }
            }
            if (this.resumingSession) {
                this.session = cipherSuiteConstants;
                if (debug != null && (Debug.isOn("handshake") || Debug.isOn("session"))) {
                    System.out.println("%% Resuming " + this.session);
                }
            }
        }
        if (this.session == null) {
            if (!this.enableNewSession) {
                throw new SSLException("Client did not resume a session");
            }
            this.chooseCipherSuite(clientHello);
            this.session = new SSLSessionImpl(this.protocolVersion, this.cipherSuite, this.sslContext.getSecureRandom(), this.getHostAddressSE(), this.getPortSE());
            this.session.setLocalPrivateKey(this.privateKey);
        }
        serverHello.cipherSuite = this.cipherSuite;
        serverHello.sessionId = this.session.getSessionId();
        serverHello.compression_method = this.session.getCompression();
        if (debug != null && Debug.isOn("handshake")) {
            serverHello.print(System.out);
            System.out.println("Cipher suite:  " + this.session.getSuite());
        }
        serverHello.write(this.output);
        if (this.resumingSession) {
            this.calculateConnectionKeys(this.session.getMasterSecret());
            this.sendChangeCipherAndFinish(false);
            return;
        }
        if (this.keyExchange != K_KRB5 && this.keyExchange != K_KRB5_EXPORT) {
            if (this.keyExchange != K_DH_ANON) {
                if (this.certs == null) {
                    throw new RuntimeException("no certificates");
                }
                cipherSuiteConstants = new HandshakeMessage.CertificateMsg(this.certs);
                this.session.setLocalCertificates(this.certs);
                if (debug != null && Debug.isOn("handshake")) {
                    ((HandshakeMessage.CertificateMsg)cipherSuiteConstants).print(System.out);
                }
                ((HandshakeMessage)cipherSuiteConstants).write(this.output);
            } else if (this.certs != null) {
                throw new RuntimeException("anonymous keyexchange with certs");
            }
        }
        if (this.keyExchange == K_RSA) {
            cipherSuiteConstants = null;
        } else if (this.keyExchange == K_RSA_EXPORT) {
            if (JsseJce.getRSAKeyLength(this.certs[0].getPublicKey()) > 512) {
                try {
                    cipherSuiteConstants = new HandshakeMessage.RSA_ServerKeyExchange(this.tempPublicKey, this.privateKey, this.clnt_random, this.svr_random, this.sslContext.getSecureRandom());
                    this.privateKey = this.tempPrivateKey;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    ServerHandshaker.throwSSLException("Error generating RSA server key exchange", generalSecurityException);
                    cipherSuiteConstants = null;
                }
            } else {
                cipherSuiteConstants = null;
            }
        } else if (this.keyExchange == K_DHE_DSS || this.keyExchange == K_DHE_RSA) {
            try {
                cipherSuiteConstants = new HandshakeMessage.DH_ServerKeyExchange(this.dh, this.privateKey, this.clnt_random.random_bytes, this.svr_random.random_bytes, this.sslContext.getSecureRandom());
            }
            catch (GeneralSecurityException generalSecurityException) {
                ServerHandshaker.throwSSLException("Error generating DH server key exchange", generalSecurityException);
                cipherSuiteConstants = null;
            }
        } else if (this.keyExchange == K_DH_ANON) {
            cipherSuiteConstants = new HandshakeMessage.DH_ServerKeyExchange(this.dh);
        } else if (this.keyExchange == K_KRB5 || this.keyExchange == K_KRB5_EXPORT) {
            cipherSuiteConstants = null;
        } else {
            throw new RuntimeException("internal error: " + this.keyExchange);
        }
        if (cipherSuiteConstants != null) {
            if (debug != null && Debug.isOn("handshake")) {
                ((HandshakeMessage)cipherSuiteConstants).print(System.out);
            }
            ((HandshakeMessage)cipherSuiteConstants).write(this.output);
        }
        if (this.keyExchange != K_KRB5 && this.keyExchange != K_KRB5_EXPORT && this.doClientAuth != 0 && this.keyExchange != K_DH_ANON) {
            x509CertificateArray = this.sslContext.getX509TrustManager().getAcceptedIssuers();
            object = new HandshakeMessage.CertificateRequest(x509CertificateArray, this.keyExchange);
            if (debug != null && Debug.isOn("handshake")) {
                ((HandshakeMessage.CertificateRequest)object).print(System.out);
            }
            ((HandshakeMessage)object).write(this.output);
        }
        object = new HandshakeMessage.ServerHelloDone();
        if (debug != null && Debug.isOn("handshake")) {
            ((HandshakeMessage.ServerHelloDone)object).print(System.out);
        }
        ((HandshakeMessage)object).write(this.output);
        this.output.flush();
    }

    private void chooseCipherSuite(HandshakeMessage.ClientHello clientHello) throws IOException {
        Iterator iterator = clientHello.cipherSuites.iterator();
        while (iterator.hasNext()) {
            CipherSuite cipherSuite = (CipherSuite)iterator.next();
            if (!this.isEnabled(cipherSuite) || this.doClientAuth == 2 && cipherSuite.keyExchange == K_DH_ANON || !this.trySetCipherSuite(cipherSuite)) continue;
            return;
        }
        this.fatalSE((byte)40, "no cipher suites in common");
    }

    boolean trySetCipherSuite(CipherSuite cipherSuite) {
        block18: {
            if (this.resumingSession) {
                return true;
            }
            if (!cipherSuite.isAvailable()) {
                return false;
            }
            CipherSuite.KeyExchange keyExchange = cipherSuite.keyExchange;
            this.privateKey = null;
            this.certs = null;
            this.dh = null;
            this.tempPrivateKey = null;
            this.tempPublicKey = null;
            if (keyExchange == K_RSA || keyExchange == K_RSA_EXPORT || keyExchange == K_DHE_RSA) {
                if (!this.getPrivateKeyAndChain("RSA")) {
                    return false;
                }
                if (keyExchange == K_RSA_EXPORT) {
                    try {
                        if (JsseJce.getRSAKeyLength(this.certs[0].getPublicKey()) > 512 && !this.getEphemeralRSAKeys(cipherSuite.exportable)) {
                            return false;
                        }
                        break block18;
                    }
                    catch (RuntimeException runtimeException) {
                        return false;
                    }
                }
                if (keyExchange == K_DHE_RSA) {
                    this.getEphemeralDHKeys(cipherSuite.exportable);
                }
            } else if (keyExchange == K_DHE_DSS) {
                if (!this.getPrivateKeyAndChain("DSA")) {
                    return false;
                }
                this.getEphemeralDHKeys(cipherSuite.exportable);
            } else if (keyExchange == K_KRB5 || keyExchange == K_KRB5_EXPORT) {
                if (!this.getKerberosKeys()) {
                    return false;
                }
            } else if (keyExchange == K_DH_ANON) {
                this.getEphemeralDHKeys(cipherSuite.exportable);
            } else {
                throw new RuntimeException("CipherSuite: " + cipherSuite);
            }
        }
        this.setCipherSuite(cipherSuite);
        return true;
    }

    private boolean getPrivateKeyAndChain(String string) {
        X509ExtendedKeyManager x509ExtendedKeyManager = this.sslContext.getX509KeyManager();
        String string2 = this.conn != null ? x509ExtendedKeyManager.chooseServerAlias(string, null, this.conn) : x509ExtendedKeyManager.chooseEngineServerAlias(string, null, this.engine);
        if (string2 == null) {
            return false;
        }
        PrivateKey privateKey = x509ExtendedKeyManager.getPrivateKey(string2);
        if (privateKey == null) {
            return false;
        }
        X509Certificate[] x509CertificateArray = x509ExtendedKeyManager.getCertificateChain(string2);
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            return false;
        }
        PublicKey publicKey = x509CertificateArray[0].getPublicKey();
        if (!privateKey.getAlgorithm().equals(string) || !publicKey.getAlgorithm().equals(string)) {
            return false;
        }
        this.privateKey = privateKey;
        this.certs = x509CertificateArray;
        return true;
    }

    private boolean getKerberosKeys() {
        if (this.kerberosKeys != null) {
            return true;
        }
        try {
            final AccessControlContext accessControlContext = this.getAccSE();
            this.kerberosKeys = (KerberosKey[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Krb5Util.getKeysFromSubject((String)"com.sun.net.ssl.server", null, (AccessControlContext)accessControlContext);
                }
            });
            if (this.kerberosKeys != null) {
                if (debug != null && Debug.isOn("handshake")) {
                    System.out.println("Using Kerberos key: " + this.kerberosKeys[0]);
                }
                String string = this.kerberosKeys[0].getPrincipal().getName();
                SecurityManager securityManager = System.getSecurityManager();
                try {
                    if (securityManager != null) {
                        securityManager.checkPermission(new ServicePermission(string, "accept"), accessControlContext);
                    }
                }
                catch (SecurityException securityException) {
                    this.kerberosKeys = null;
                    if (debug != null && Debug.isOn("handshake")) {
                        System.out.println("Permission to access Kerberos secret key denied");
                    }
                    return false;
                }
            }
            return this.kerberosKeys != null;
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("Attempt to obtain Kerberos key failed: " + privilegedActionException.toString());
            }
            return false;
        }
    }

    private byte[] clientKeyExchange(KerberosWrapper kerberosWrapper) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            kerberosWrapper.print(System.out);
        }
        this.session.setPeerPrincipal(kerberosWrapper.getPeerPrincipal());
        this.session.setLocalPrincipal(kerberosWrapper.getLocalPrincipal());
        return kerberosWrapper.getPreMasterSecret().getUnencrypted();
    }

    private byte[] clientKeyExchange(ClientDiffieHellmanPublic clientDiffieHellmanPublic) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            clientDiffieHellmanPublic.print(System.out);
        }
        return this.dh.getAgreedSecret(clientDiffieHellmanPublic.getClientPublicKey());
    }

    private void clientCertificateVerify(HandshakeMessage.CertificateVerify certificateVerify) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            certificateVerify.print(System.out);
        }
        try {
            PublicKey publicKey = this.session.getPeerCertificates()[0].getPublicKey();
            boolean bl = certificateVerify.verify(this.protocolVersion, this.handshakeHash, publicKey, this.session.getMasterSecret());
            if (!bl) {
                this.fatalSE((byte)42, "certificate verify message signature error");
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            this.fatalSE((byte)42, "certificate verify format error", generalSecurityException);
        }
        this.needClientVerify = false;
    }

    private void clientFinished(HandshakeMessage.Finished finished) throws IOException {
        boolean bl;
        if (debug != null && Debug.isOn("handshake")) {
            finished.print(System.out);
        }
        if (this.doClientAuth == 2) {
            this.session.getPeerPrincipal();
        }
        if (this.needClientVerify) {
            this.fatalSE((byte)40, "client did not send certificate verify message");
        }
        if (!(bl = finished.verify(this.protocolVersion, this.handshakeHash, 1, this.session.getMasterSecret()))) {
            this.fatalSE((byte)40, "client 'finished' message doesn't verify");
        }
        if (!this.resumingSession) {
            this.input.digestNow();
            this.sendChangeCipherAndFinish(true);
        }
        this.session.setLastAccessedTime(System.currentTimeMillis());
        if (!this.resumingSession && this.session.isRejoinable()) {
            ((SSLSessionContextImpl)this.sslContext.engineGetServerSessionContext()).put(this.session);
            if (debug != null && Debug.isOn("session")) {
                System.out.println("%% Cached server session: " + this.session);
            }
        } else if (!this.resumingSession && debug != null && Debug.isOn("session")) {
            System.out.println("%% Didn't cache non-resumable server session: " + this.session);
        }
    }

    private void sendChangeCipherAndFinish(boolean bl) throws IOException {
        this.output.flush();
        HandshakeMessage.Finished finished = new HandshakeMessage.Finished(this.protocolVersion, this.handshakeHash, 2, this.session.getMasterSecret());
        this.sendChangeCipherSpec(finished, bl);
        if (bl) {
            this.state = 20;
        }
    }

    HandshakeMessage getKickstartMessage() {
        return new HandshakeMessage.HelloRequest();
    }

    void handshakeAlert(byte by) throws SSLProtocolException {
        String string = Alerts.alertDescription(by);
        if (debug != null && Debug.isOn("handshake")) {
            System.out.println("SSL -- handshake alert:  " + string);
        }
        if (by == 41 && this.doClientAuth == 1) {
            return;
        }
        throw new SSLProtocolException("handshake alert: " + string);
    }

    private byte[] clientKeyExchange(PreMasterSecret preMasterSecret) throws IOException {
        if (debug != null && Debug.isOn("handshake")) {
            preMasterSecret.print(System.out);
        }
        return preMasterSecret.preMaster;
    }

    private void clientCertificate(HandshakeMessage.CertificateMsg certificateMsg) throws IOException {
        X509Certificate[] x509CertificateArray;
        if (debug != null && Debug.isOn("handshake")) {
            certificateMsg.print(System.out);
        }
        if ((x509CertificateArray = certificateMsg.getCertificateChain()).length == 0) {
            if (this.doClientAuth == 1) {
                return;
            }
            this.fatalSE((byte)42, "null cert chain");
        }
        X509TrustManager x509TrustManager = this.sslContext.getX509TrustManager();
        try {
            PublicKey publicKey = x509CertificateArray[0].getPublicKey();
            String string = publicKey.getAlgorithm();
            String string2 = string.equals("RSA") ? "RSA" : (string.equals("DSA") ? "DSA" : "UNKNOWN");
            x509TrustManager.checkClientTrusted(x509CertificateArray != null ? (X509Certificate[])x509CertificateArray.clone() : x509CertificateArray, string2);
        }
        catch (CertificateException certificateException) {
            this.fatalSE((byte)46, certificateException);
        }
        this.needClientVerify = true;
        this.session.setPeerCertificates(x509CertificateArray);
    }
}

