/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.io.IOException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.openmbean.OpenMBeanInfo;
import javax.swing.Icon;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.inspector.IconManager;
import sun.tools.jconsole.inspector.Utils;

public class XMBean {
    private ObjectName objectName;
    private Icon icon;
    private String text;
    private boolean broadcaster;
    private MBeansTab mbeansTab;

    public XMBean(ObjectName objectName, MBeansTab mBeansTab) {
        this.mbeansTab = mBeansTab;
        this.setObjectName(objectName);
        try {
            this.icon = this.selectIcon();
        }
        catch (Exception exception) {
            System.out.println("Error creating XMBean :" + exception.getMessage());
        }
    }

    private Icon selectIcon() {
        String string;
        try {
            string = this.getClassName().toLowerCase();
        }
        catch (Exception exception) {
            string = this.getClass().getName().toLowerCase();
        }
        try {
            if (string.equals("javax.management.mbeanserverdelegate")) {
                return IconManager.MBEANSERVERDELEGATE;
            }
            MBeanInfo mBeanInfo = this.getMBeanInfo();
            if (mBeanInfo instanceof OpenMBeanInfo) {
                return IconManager.OPENMBEAN;
            }
            if (mBeanInfo instanceof ModelMBeanInfo) {
                return IconManager.MODELMBEAN;
            }
            return IconManager.STANDARDMBEAN;
        }
        catch (Throwable throwable) {
            return IconManager.STANDARDMBEAN;
        }
    }

    MBeanServerConnection getMBeanServerConnection() {
        return this.mbeansTab.getMBeanServerConnection();
    }

    protected XMBean(Object object) {
        try {
            ObjectName objectName = new ObjectName("DefaultDomain", "name", Utils.generateName(object.getClass().toString()));
            this.setObjectName(objectName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isBroadcaster() {
        try {
            return this.getMBeanServerConnection().isInstanceOf(this.getObjectName(), "javax.management.NotificationBroadcaster");
        }
        catch (Exception exception) {
            System.out.println("Error calling isBroadcaster :" + exception.getMessage());
            return false;
        }
    }

    public String getClassName() throws InstanceNotFoundException, IOException {
        return this.getObjectInstance().getClassName();
    }

    public Object invoke(String string) throws Exception {
        Object object = this.getMBeanServerConnection().invoke(this.getObjectName(), string, new Object[0], new String[0]);
        return object;
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws Exception {
        Object object = this.getMBeanServerConnection().invoke(this.getObjectName(), string, objectArray, stringArray);
        return object;
    }

    public void setAttribute(Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        this.getMBeanServerConnection().setAttribute(this.getObjectName(), attribute);
    }

    public Object getAttribute(String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        return this.getMBeanServerConnection().getAttribute(this.getObjectName(), string);
    }

    public AttributeList getAttributes(String[] stringArray) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        return this.getMBeanServerConnection().getAttributes(this.getObjectName(), stringArray);
    }

    public AttributeList getAttributes(MBeanAttributeInfo[] mBeanAttributeInfoArray) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
        String[] stringArray = new String[mBeanAttributeInfoArray.length];
        for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
            stringArray[i] = mBeanAttributeInfoArray[i].getName();
        }
        return this.getAttributes(stringArray);
    }

    public ObjectInstance getObjectInstance() throws InstanceNotFoundException, IOException {
        return this.getMBeanServerConnection().getObjectInstance(this.getObjectName());
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    private void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
        String string = this.getObjectName().getKeyProperty("name");
        if (string == null) {
            this.setText(this.getObjectName().getDomain());
        } else {
            this.setText(string);
        }
    }

    public MBeanInfo getMBeanInfo() throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
        return this.getMBeanServerConnection().getMBeanInfo(this.getObjectName());
    }

    public boolean equals(Object object) {
        if (object instanceof XMBean) {
            XMBean xMBean = (XMBean)object;
            return this.getObjectName().equals(xMBean.getObjectName());
        }
        return false;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public String toString() {
        return this.getText();
    }
}

