/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import com.sun.management.OperatingSystemMXBean;
import java.awt.BorderLayout;
import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.DefaultCaret;
import sun.tools.jconsole.Formatter;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Tab;
import sun.tools.jconsole.VMPanel;

class SummaryTab
extends Tab
implements HyperlinkListener {
    JEditorPane info;

    public static String getTabName() {
        return Resources.getText("Summary", new Object[0]);
    }

    public SummaryTab(VMPanel vMPanel) {
        super(vMPanel, SummaryTab.getTabName());
        this.setLayout(new BorderLayout());
        this.info = new JEditorPane();
        this.info.setContentType("text/html");
        this.info.setEditable(false);
        this.info.addHyperlinkListener(this);
        ((DefaultCaret)this.info.getCaret()).setUpdatePolicy(1);
        this.add(new JScrollPane(this.info));
    }

    public void update() {
        final String string = this.formatSummary();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    SummaryTab.this.info.setText(string);
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    String formatSummary() {
        ProxyClient proxyClient = this.vmPanel.getProxyClient();
        if (proxyClient.isDead()) {
            return "";
        }
        String string = "<html><table cellpadding=1>";
        try {
            RuntimeMXBean runtimeMXBean = proxyClient.getRuntimeMXBean();
            CompilationMXBean compilationMXBean = proxyClient.getCompilationMXBean();
            ThreadMXBean threadMXBean = proxyClient.getThreadMXBean();
            MemoryMXBean memoryMXBean = proxyClient.getMemoryMXBean();
            ClassLoadingMXBean classLoadingMXBean = proxyClient.getClassLoadingMXBean();
            java.lang.management.OperatingSystemMXBean operatingSystemMXBean = proxyClient.getOperatingSystemMXBean();
            String string2 = "<tr><td colspan=4><font size =-1><hr><tr><td colspan=4><font size =-1>";
            long l = runtimeMXBean.getUptime();
            string = string + "<tr><td colspan=4><center><b>" + Resources.getText("Summary", new Object[0]) + "</b></center>";
            OperatingSystemMXBean operatingSystemMXBean2 = proxyClient.getSunOperatingSystemMXBean();
            string = operatingSystemMXBean2 != null ? string + Formatter.newRow(Resources.getText("Uptime", new Object[0]), Formatter.formatTime(l), Resources.getText("Process CPU time", new Object[0]), Formatter.formatNanoTime(operatingSystemMXBean2.getProcessCpuTime())) : string + Formatter.newRowWith4Columns(Resources.getText("Uptime", new Object[0]), Formatter.formatTime(l));
            if (compilationMXBean.isCompilationTimeMonitoringSupported()) {
                string = string + Formatter.newRowWith4Columns(Resources.getText("Total compile time", new Object[0]), Formatter.formatTime(compilationMXBean.getTotalCompilationTime()));
            }
            string = string + string2;
            string = string + "<center><b><a href=Threads>" + Resources.getText("Threads", new Object[0]) + "</a></b></center>";
            int n = threadMXBean.getThreadCount();
            int n2 = threadMXBean.getDaemonThreadCount();
            int n3 = threadMXBean.getPeakThreadCount();
            long l2 = threadMXBean.getTotalStartedThreadCount();
            string = string + Formatter.newRow(Resources.getText("Live Threads", new Object[0]), Formatter.justify(n, 5), Resources.getText("Peak", new Object[0]), Formatter.justify(n3, 5));
            string = string + Formatter.newRow(Resources.getText("Daemon threads", new Object[0]), Formatter.justify(n2, 5), Resources.getText("Total started", new Object[0]), Formatter.justify(l2, 5));
            string = string + string2;
            string = string + "<center><b><a href=Memory>" + Resources.getText("Memory", new Object[0]) + "</a></b></center>";
            MemoryUsage memoryUsage = memoryMXBean.getHeapMemoryUsage();
            long l3 = memoryMXBean.getObjectPendingFinalizationCount();
            string = string + Formatter.newRow(Resources.getText("Current heap size", new Object[0]), Formatter.formatKBytes(memoryUsage.getUsed()), Resources.getText("Committed memory", new Object[0]), Formatter.formatKBytes(memoryUsage.getCommitted()));
            string = string + Formatter.newRowWith4Columns(Resources.getText("Maximum heap size", new Object[0]), Formatter.formatKBytes(memoryUsage.getMax()));
            string = string + Formatter.newRowWith4Columns(Resources.getText("Objects pending for finalization", new Object[0]), Formatter.justify(l3, 6));
            Collection<GarbageCollectorMXBean> collection = proxyClient.getGarbageCollectorMXBeans();
            for (GarbageCollectorMXBean garbageCollectorMXBean : collection) {
                String string3 = garbageCollectorMXBean.getName();
                long l4 = garbageCollectorMXBean.getCollectionCount();
                long l5 = garbageCollectorMXBean.getCollectionTime();
                string = string + Formatter.newRowWith4Columns(Resources.getText("Garbage collector", new Object[0]), Resources.getText("GcInfo", string3, l4, l5 < 0L ? Resources.getText("Unavailable", new Object[0]) : Formatter.formatTime(l5)));
            }
            string = string + string2;
            string = string + "<center><b><a href=Classes>" + Resources.getText("Classes", new Object[0]) + "</a></b></center>";
            long l6 = classLoadingMXBean.getLoadedClassCount();
            long l7 = classLoadingMXBean.getUnloadedClassCount();
            long l8 = classLoadingMXBean.getTotalLoadedClassCount();
            string = string + Formatter.newRow(Resources.getText("Current classes loaded", new Object[0]), Formatter.justify(l6, 5), Resources.getText("Total classes unloaded", new Object[0]), Formatter.justify(l7, 5));
            string = string + Formatter.newRowWith4Columns(Resources.getText("Total classes loaded", new Object[0]), Formatter.justify(l8, 5));
            string = string + string2;
            string = string + "<center><b>" + Resources.getText("Operating System", new Object[0]) + "</b></center>";
            if (operatingSystemMXBean2 != null) {
                string = string + Formatter.newRow(Resources.getText("Total physical memory", new Object[0]), Formatter.formatKBytes(operatingSystemMXBean2.getTotalPhysicalMemorySize()), Resources.getText("Free physical memory", new Object[0]), Formatter.formatKBytes(operatingSystemMXBean2.getFreePhysicalMemorySize()));
                string = string + Formatter.newRowWith4Columns(Resources.getText("Committed virtual memory", new Object[0]), Formatter.formatKBytes(operatingSystemMXBean2.getCommittedVirtualMemorySize()));
            }
        }
        catch (IOException iOException) {
            string = string + "\n" + iOException + "\n";
        }
        catch (UndeclaredThrowableException undeclaredThrowableException) {
            string = string + "\n" + undeclaredThrowableException + "\n";
            proxyClient.markAsDead();
        }
        return string;
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String string = hyperlinkEvent.getDescription();
            this.vmPanel.setSelectedIndex(this.vmPanel.indexOfTab(string));
        }
    }
}

