/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import sun.tools.jconsole.Resources;

class Formatter {
    static final long SECOND = 1000L;
    static final long MINUTE = 60000L;
    static final long HOUR = 3600000L;
    static final long DAY = 86400000L;
    static final String cr = System.getProperty("line.separator");
    static final DateFormat timeDF = new SimpleDateFormat("HH:mm");
    private static final DateFormat timeWithSecondsDF = new SimpleDateFormat("HH:mm:ss");
    private static final DateFormat dateDF = new SimpleDateFormat("yyyy-MM-dd");

    Formatter() {
    }

    static String formatTime(long l) {
        String string;
        if (l < 60000L) {
            String string2 = String.format("%.3f", (double)l / 1000.0);
            string = Resources.getText("DurationSeconds", string2);
        } else {
            long l2 = l;
            long l3 = l2 / 86400000L;
            long l4 = (l2 %= 86400000L) / 3600000L;
            long l5 = (l2 %= 3600000L) / 60000L;
            string = l >= 86400000L ? Resources.getText("DurationDaysHoursMinutes", l3, l4, l5) : (l >= 3600000L ? Resources.getText("DurationHoursMinutes", l4, l5) : Resources.getText("DurationMinutes", l5));
        }
        return string;
    }

    static String formatNanoTime(long l) {
        long l2 = l / 1000000L;
        return Formatter.formatTime(l2);
    }

    static String formatClockTime(long l) {
        return timeDF.format(l);
    }

    static String formatDate(long l) {
        return dateDF.format(l);
    }

    static String formatDateTime(long l) {
        return dateDF.format(l) + " " + timeWithSecondsDF.format(l);
    }

    static String formatKBytes(long l) {
        if (l == -1L) {
            return "-1" + Resources.getText(" kbytes", new Object[0]);
        }
        long l2 = l / 1024L;
        return Formatter.justify(l2, 10) + Resources.getText(" kbytes", new Object[0]);
    }

    static String justify(long l, int n) {
        String string = String.format("%,d", l);
        return Formatter.justify(string, n);
    }

    static String justify(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<TT>");
        int n2 = n - string.length();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append("&nbsp;");
        }
        stringBuffer.append(string);
        stringBuffer.append("</TT>");
        return stringBuffer.toString();
    }

    static String newRow(String string, String string2) {
        return Formatter.newRow(string, string2, 2);
    }

    static String newRowWith4Columns(String string, String string2) {
        return Formatter.newRow(string, string2, 4);
    }

    private static String newRow(String string, String string2, int n) {
        string = string == null ? "<td nowrap align=right>" : "<td nowrap align=right><b>" + string + ": </b>";
        string2 = "<td colspan=" + (n - 1) + "> <font size =-1>" + string2;
        return "<tr>" + string + string2 + "</tr>";
    }

    static String newRow(String string, String string2, String string3, String string4) {
        string = "<td align=right><b>" + string + ": </b>";
        string2 = "<td><font size =-1>" + string2;
        string3 = "<td align=right><b>" + string3 + ": </b>";
        string4 = "<td><font size =-1>" + string4;
        return "<tr>" + string + string2 + string3 + string4;
    }
}

