/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProviderException;
import java.security.SecureRandomSpi;
import sun.security.provider.SecureRandom;

public final class NativePRNG
extends SecureRandomSpi {
    private static final long serialVersionUID = -6599091113397072932L;
    private static final String NAME_RANDOM = "/dev/random";
    private static final String NAME_URANDOM = "/dev/urandom";
    private static final RandomIO INSTANCE = NativePRNG.initIO();

    private static RandomIO initIO() {
        Object t2 = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                File file = new File(NativePRNG.NAME_RANDOM);
                if (!file.exists()) {
                    return null;
                }
                File file2 = new File(NativePRNG.NAME_URANDOM);
                if (!file2.exists()) {
                    return null;
                }
                try {
                    return new RandomIO(file, file2);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
        return (RandomIO)t2;
    }

    static boolean isAvailable() {
        return INSTANCE != null;
    }

    public NativePRNG() {
        if (INSTANCE == null) {
            throw new AssertionError((Object)"NativePRNG not available");
        }
    }

    protected void engineSetSeed(byte[] byArray) {
        NativePRNG.INSTANCE.implSetSeed(byArray);
    }

    protected void engineNextBytes(byte[] byArray) {
        NativePRNG.INSTANCE.implNextBytes(byArray);
    }

    protected byte[] engineGenerateSeed(int n2) {
        return NativePRNG.INSTANCE.implGenerateSeed(n2);
    }

    private static class RandomIO {
        private static final long MAX_BUFFER_TIME = 100L;
        private static final int BUFFER_SIZE = 32;
        private final InputStream randomIn;
        private final InputStream urandomIn;
        private OutputStream randomOut;
        private boolean randomOutInitialized;
        private volatile SecureRandom mixRandom;
        private final byte[] urandomBuffer;
        private int buffered;
        private long lastRead;
        private final Object LOCK_GET_BYTES = new Object();
        private final Object LOCK_GET_SEED = new Object();
        private final Object LOCK_SET_SEED = new Object();

        private RandomIO(File file, File file2) throws IOException {
            this.randomIn = new FileInputStream(file);
            this.urandomIn = new FileInputStream(file2);
            this.urandomBuffer = new byte[32];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SecureRandom getMixRandom() {
            SecureRandom secureRandom = this.mixRandom;
            if (secureRandom == null) {
                Object object = this.LOCK_GET_BYTES;
                synchronized (object) {
                    secureRandom = this.mixRandom;
                    if (secureRandom == null) {
                        secureRandom = new SecureRandom();
                        try {
                            byte[] byArray = new byte[20];
                            RandomIO.readFully(this.urandomIn, byArray);
                            secureRandom.engineSetSeed(byArray);
                        }
                        catch (IOException iOException) {
                            throw new ProviderException("init failed", iOException);
                        }
                        this.mixRandom = secureRandom;
                    }
                }
            }
            return secureRandom;
        }

        private static void readFully(InputStream inputStream, byte[] byArray) throws IOException {
            int n2;
            int n3;
            int n4 = 0;
            for (n2 = byArray.length; n2 > 0; n2 -= n3) {
                n3 = inputStream.read(byArray, n4, n2);
                if (n3 <= 0) {
                    throw new EOFException("/dev/[u]random closed?");
                }
                n4 += n3;
            }
            if (n2 > 0) {
                throw new IOException("Could not read from /dev/[u]random");
            }
        }

        private byte[] implGenerateSeed(int n2) {
            Object object = this.LOCK_GET_SEED;
            synchronized (object) {
                try {
                    byte[] byArray = new byte[n2];
                    RandomIO.readFully(this.randomIn, byArray);
                    return byArray;
                }
                catch (IOException iOException) {
                    throw new ProviderException("generateSeed() failed", iOException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void implSetSeed(byte[] byArray) {
            Object object = this.LOCK_SET_SEED;
            synchronized (object) {
                if (!this.randomOutInitialized) {
                    this.randomOutInitialized = true;
                    this.randomOut = AccessController.doPrivileged(new PrivilegedAction<OutputStream>(){

                        @Override
                        public OutputStream run() {
                            try {
                                return new FileOutputStream(NativePRNG.NAME_RANDOM, true);
                            }
                            catch (Exception exception) {
                                return null;
                            }
                        }
                    });
                }
                if (this.randomOut != null) {
                    try {
                        this.randomOut.write(byArray);
                    }
                    catch (IOException iOException) {
                        throw new ProviderException("setSeed() failed", iOException);
                    }
                }
                this.getMixRandom().engineSetSeed(byArray);
            }
        }

        private void ensureBufferValid() throws IOException {
            long l2 = System.currentTimeMillis();
            if (this.buffered > 0 && l2 - this.lastRead < 100L) {
                return;
            }
            this.lastRead = l2;
            RandomIO.readFully(this.urandomIn, this.urandomBuffer);
            this.buffered = this.urandomBuffer.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void implNextBytes(byte[] byArray) {
            Object object = this.LOCK_GET_BYTES;
            synchronized (object) {
                try {
                    this.getMixRandom().engineNextBytes(byArray);
                    int n2 = byArray.length;
                    int n3 = 0;
                    while (n2 > 0) {
                        this.ensureBufferValid();
                        int n4 = this.urandomBuffer.length - this.buffered;
                        while (n2 > 0 && this.buffered > 0) {
                            int n5 = n3++;
                            byArray[n5] = (byte)(byArray[n5] ^ this.urandomBuffer[n4++]);
                            --n2;
                            --this.buffered;
                        }
                    }
                }
                catch (IOException iOException) {
                    throw new ProviderException("nextBytes() failed", iOException);
                }
            }
        }
    }
}

