/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.utils;

import com.sun.org.apache.xml.internal.utils.StringToStringTable;

public class StringToStringTableVector {
    private int m_blocksize;
    private StringToStringTable[] m_map;
    private int m_firstFree = 0;
    private int m_mapSize;

    public StringToStringTableVector() {
        this.m_mapSize = this.m_blocksize = 8;
        this.m_map = new StringToStringTable[this.m_blocksize];
    }

    public StringToStringTableVector(int n2) {
        this.m_blocksize = n2;
        this.m_mapSize = n2;
        this.m_map = new StringToStringTable[n2];
    }

    public final int getLength() {
        return this.m_firstFree;
    }

    public final int size() {
        return this.m_firstFree;
    }

    public final void addElement(StringToStringTable stringToStringTable) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            StringToStringTable[] stringToStringTableArray = new StringToStringTable[this.m_mapSize];
            System.arraycopy(this.m_map, 0, stringToStringTableArray, 0, this.m_firstFree + 1);
            this.m_map = stringToStringTableArray;
        }
        this.m_map[this.m_firstFree] = stringToStringTable;
        ++this.m_firstFree;
    }

    public final String get(String string) {
        for (int i2 = this.m_firstFree - 1; i2 >= 0; --i2) {
            String string2 = this.m_map[i2].get(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    public final boolean containsKey(String string) {
        for (int i2 = this.m_firstFree - 1; i2 >= 0; --i2) {
            if (this.m_map[i2].get(string) == null) continue;
            return true;
        }
        return false;
    }

    public final void removeLastElem() {
        if (this.m_firstFree > 0) {
            this.m_map[this.m_firstFree] = null;
            --this.m_firstFree;
        }
    }

    public final StringToStringTable elementAt(int n2) {
        return this.m_map[n2];
    }

    public final boolean contains(StringToStringTable stringToStringTable) {
        for (int i2 = 0; i2 < this.m_firstFree; ++i2) {
            if (!this.m_map[i2].equals(stringToStringTable)) continue;
            return true;
        }
        return false;
    }
}

