/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.verifier.structurals;

import com.sun.org.apache.bcel.internal.generic.ObjectType;
import com.sun.org.apache.bcel.internal.generic.ReferenceType;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.verifier.exc.AssertionViolatedException;
import com.sun.org.apache.bcel.internal.verifier.exc.StructuralCodeConstraintException;
import com.sun.org.apache.bcel.internal.verifier.structurals.UninitializedObjectType;
import java.util.ArrayList;

public class OperandStack {
    private ArrayList stack = new ArrayList();
    private int maxStack;

    public OperandStack(int n2) {
        this.maxStack = n2;
    }

    public OperandStack(int n2, ObjectType objectType) {
        this.maxStack = n2;
        this.push(objectType);
    }

    protected Object clone() {
        OperandStack operandStack = new OperandStack(this.maxStack);
        operandStack.stack = (ArrayList)this.stack.clone();
        return operandStack;
    }

    public void clear() {
        this.stack = new ArrayList();
    }

    public boolean equals(Object object) {
        if (!(object instanceof OperandStack)) {
            return false;
        }
        OperandStack operandStack = (OperandStack)object;
        return this.stack.equals(operandStack.stack);
    }

    public OperandStack getClone() {
        return (OperandStack)this.clone();
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public int maxStack() {
        return this.maxStack;
    }

    public Type peek() {
        return this.peek(0);
    }

    public Type peek(int n2) {
        return (Type)this.stack.get(this.size() - n2 - 1);
    }

    public Type pop() {
        Type type = (Type)this.stack.remove(this.size() - 1);
        return type;
    }

    public Type pop(int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            this.pop();
        }
        return null;
    }

    public void push(Type type) {
        if (type == null) {
            throw new AssertionViolatedException("Cannot push NULL onto OperandStack.");
        }
        if (type == Type.BOOLEAN || type == Type.CHAR || type == Type.BYTE || type == Type.SHORT) {
            throw new AssertionViolatedException("The OperandStack does not know about '" + type + "'; use Type.INT instead.");
        }
        if (this.slotsUsed() >= this.maxStack) {
            throw new AssertionViolatedException("OperandStack too small, should have thrown proper Exception elsewhere. Stack: " + this);
        }
        this.stack.add(type);
    }

    int size() {
        return this.stack.size();
    }

    public int slotsUsed() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.stack.size(); ++i2) {
            n2 += this.peek(i2).getSize();
        }
        return n2;
    }

    public String toString() {
        String string = "Slots used: " + this.slotsUsed() + " MaxStack: " + this.maxStack + ".\n";
        for (int i2 = 0; i2 < this.size(); ++i2) {
            string = string + this.peek(i2) + " (Size: " + this.peek(i2).getSize() + ")\n";
        }
        return string;
    }

    public void merge(OperandStack operandStack) {
        if (this.slotsUsed() != operandStack.slotsUsed() || this.size() != operandStack.size()) {
            throw new StructuralCodeConstraintException("Cannot merge stacks of different size:\nOperandStack A:\n" + this + "\nOperandStack B:\n" + operandStack);
        }
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (!(this.stack.get(i2) instanceof UninitializedObjectType) && operandStack.stack.get(i2) instanceof UninitializedObjectType) {
                throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object on the stack detected.");
            }
            if (!this.stack.get(i2).equals(operandStack.stack.get(i2)) && this.stack.get(i2) instanceof UninitializedObjectType && !(operandStack.stack.get(i2) instanceof UninitializedObjectType)) {
                throw new StructuralCodeConstraintException("Backwards branch with an uninitialized object on the stack detected.");
            }
            if (this.stack.get(i2) instanceof UninitializedObjectType && !(operandStack.stack.get(i2) instanceof UninitializedObjectType)) {
                this.stack.set(i2, ((UninitializedObjectType)this.stack.get(i2)).getInitialized());
            }
            if (this.stack.get(i2).equals(operandStack.stack.get(i2))) continue;
            if (this.stack.get(i2) instanceof ReferenceType && operandStack.stack.get(i2) instanceof ReferenceType) {
                this.stack.set(i2, ((ReferenceType)this.stack.get(i2)).firstCommonSuperclass((ReferenceType)operandStack.stack.get(i2)));
                continue;
            }
            throw new StructuralCodeConstraintException("Cannot merge stacks of different types:\nStack A:\n" + this + "\nStack B:\n" + operandStack);
        }
    }

    public void initializeObject(UninitializedObjectType uninitializedObjectType) {
        for (int i2 = 0; i2 < this.stack.size(); ++i2) {
            if (this.stack.get(i2) != uninitializedObjectType) continue;
            this.stack.set(i2, uninitializedObjectType.getInitialized());
        }
    }
}

