/*
 * Decompiled with CFR 0.152.
 */
package java2d;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import java2d.DemoImages;
import java2d.DemoPanel;
import java2d.GlobalControls;
import java2d.Java2Demo;
import java2d.Tools;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DemoGroup
extends JPanel
implements MouseListener,
ChangeListener,
ActionListener {
    static int columns = 2;
    private static Font font = new Font("serif", 0, 10);
    private static EmptyBorder emptyB = new EmptyBorder(5, 5, 5, 5);
    private static BevelBorder bevelB = new BevelBorder(1);
    private String groupName;
    public JPanel[] clonePanels;
    public JTabbedPane tabbedPane;
    private int index;

    public DemoGroup(String string) {
        int n;
        int n2;
        this.groupName = string;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(0, 2));
        jPanel.setBorder(new CompoundBorder(emptyB, bevelB));
        Vector<String> vector = new Vector<String>(40);
        for (n2 = 0; n2 < Java2Demo.demos.length && string.compareTo(Java2Demo.demos[n2][0]) != 0; ++n2) {
        }
        String[] stringArray = Java2Demo.demos[n2];
        for (n = 1; n < stringArray.length; ++n) {
            vector.add("java2d.demos." + string + "." + stringArray[n]);
        }
        if (vector.size() % 2 == 1) {
            jPanel.setLayout(new GridBagLayout());
        }
        for (n = 0; n < vector.size(); ++n) {
            DemoPanel demoPanel = new DemoPanel((String)vector.elementAt(n));
            demoPanel.setDemoBorder(jPanel);
            if (demoPanel.surface != null) {
                demoPanel.surface.addMouseListener(this);
                demoPanel.surface.setMonitor(Java2Demo.performancemonitor != null);
            }
            if (jPanel.getLayout() instanceof GridBagLayout) {
                int n3 = jPanel.getComponentCount() % 2;
                int n4 = jPanel.getComponentCount() / 2;
                int n5 = n == vector.size() - 1 ? 2 : 1;
                Java2Demo.addToGridBag(jPanel, demoPanel, n3, n4, n5, 1, 1.0, 1.0);
                continue;
            }
            jPanel.add(demoPanel);
        }
        this.add(jPanel);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Object object;
        if (this.tabbedPane == null) {
            this.shutDown(this.getPanel());
            object = new JPanel(new BorderLayout());
            ((JComponent)object).setBorder(new CompoundBorder(emptyB, bevelB));
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.setFont(font);
            JPanel jPanel = (JPanel)this.getComponent(0);
            this.tabbedPane.addTab(this.groupName, jPanel);
            this.clonePanels = new JPanel[jPanel.getComponentCount()];
            for (int i = 0; i < this.clonePanels.length; ++i) {
                Object object2;
                this.clonePanels[i] = new JPanel(new BorderLayout());
                DemoPanel demoPanel = (DemoPanel)jPanel.getComponent(i);
                DemoPanel demoPanel2 = new DemoPanel(demoPanel.className);
                demoPanel2.setDemoBorder(this.clonePanels[i]);
                if (demoPanel2.surface != null) {
                    demoPanel2.surface.setMonitor(Java2Demo.performancemonitor != null);
                    object2 = DemoImages.getImage("clone.gif", this);
                    demoPanel2.tools.cloneB = demoPanel2.tools.addTool((Image)object2, "Clone the Surface", (ActionListener)this);
                    Dimension dimension = demoPanel2.tools.toolbar.getPreferredSize();
                    demoPanel2.tools.toolbar.setPreferredSize(new Dimension(dimension.width + 27, dimension.height));
                    if (Java2Demo.backgroundColor != null) {
                        demoPanel2.surface.setBackground(Java2Demo.backgroundColor);
                    }
                }
                this.clonePanels[i].add(demoPanel2);
                object2 = demoPanel.className.substring(demoPanel.className.indexOf(46) + 1);
                this.tabbedPane.addTab((String)object2, this.clonePanels[i]);
            }
            ((Container)object).add(this.tabbedPane);
            this.remove(jPanel);
            this.add((Component)object);
            this.tabbedPane.addChangeListener(this);
            this.validate();
        }
        object = mouseEvent.getComponent().toString();
        object = ((String)object).substring(0, ((String)object).indexOf(91));
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            String string = ((String)object).substring(((String)object).indexOf(46) + 1);
            if (!this.tabbedPane.getTitleAt(i).equals(string)) continue;
            this.tabbedPane.setSelectedIndex(i);
            break;
        }
        this.validate();
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        if (jButton.getToolTipText().startsWith("Clone")) {
            this.cloneDemo();
        } else {
            this.removeClone(jButton.getParent().getParent().getParent().getParent());
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.shutDown((JPanel)this.tabbedPane.getComponentAt(this.index));
        this.index = this.tabbedPane.getSelectedIndex();
        this.setup(false);
    }

    public JPanel getPanel() {
        if (this.tabbedPane != null) {
            return (JPanel)this.tabbedPane.getSelectedComponent();
        }
        return (JPanel)this.getComponent(0);
    }

    public void setup(boolean bl) {
        JPanel jPanel = this.getPanel();
        if (Java2Demo.performancemonitor != null) {
            Java2Demo.performancemonitor.surf.setPanel(jPanel);
            Java2Demo.performancemonitor.surf.setSurfaceState();
        }
        GlobalControls globalControls = Java2Demo.controls;
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            DemoPanel demoPanel = (DemoPanel)jPanel.getComponent(i);
            if (demoPanel.surface != null && globalControls != null) {
                Tools tools = demoPanel.tools;
                tools.setVisible(this.isValid());
                tools.issueRepaint = bl;
                JToggleButton[] jToggleButtonArray = new JToggleButton[]{tools.toggleB, tools.aliasB, tools.renderB, tools.textureB, tools.compositeB};
                JCheckBox[] jCheckBoxArray = new JCheckBox[]{globalControls.toolBarCB, globalControls.aliasCB, globalControls.renderCB, globalControls.textureCB, globalControls.compositeCB};
                for (int j = 0; j < jToggleButtonArray.length; ++j) {
                    if (globalControls.obj != null && globalControls.obj.equals(jCheckBoxArray[j])) {
                        if (jToggleButtonArray[j].isSelected() == jCheckBoxArray[j].isSelected()) continue;
                        jToggleButtonArray[j].doClick();
                        continue;
                    }
                    if (globalControls.obj != null || jToggleButtonArray[j].isSelected() == jCheckBoxArray[j].isSelected()) continue;
                    jToggleButtonArray[j].doClick();
                }
                tools.setVisible(true);
                if (GlobalControls.screenCombo.getSelectedIndex() != tools.screenCombo.getSelectedIndex()) {
                    tools.screenCombo.setSelectedIndex(GlobalControls.screenCombo.getSelectedIndex());
                }
                if (Java2Demo.verboseCB.isSelected()) {
                    demoPanel.surface.verbose();
                }
                demoPanel.surface.setSleepAmount(globalControls.slider.getValue());
                if (Java2Demo.backgroundColor != null) {
                    demoPanel.surface.setBackground(Java2Demo.backgroundColor);
                }
                tools.issueRepaint = true;
            }
            demoPanel.start();
        }
        this.validate();
    }

    public void shutDown(JPanel jPanel) {
        this.invalidate();
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            ((DemoPanel)jPanel.getComponent(i)).stop();
        }
        System.gc();
    }

    public void cloneDemo() {
        int n = this.tabbedPane.getSelectedIndex() - 1;
        if (this.clonePanels[n].getComponentCount() == 1) {
            this.clonePanels[n].invalidate();
            this.clonePanels[n].setLayout(new GridLayout(0, columns, 5, 5));
            this.clonePanels[n].validate();
        }
        DemoPanel demoPanel = (DemoPanel)this.getPanel().getComponent(0);
        DemoPanel demoPanel2 = new DemoPanel(demoPanel.className);
        if (columns == 2) {
            demoPanel2.setDemoBorder(this.clonePanels[n]);
        }
        Image image = DemoImages.getImage("remove.gif", this);
        demoPanel2.tools.cloneB = demoPanel2.tools.addTool(image, "Remove the Surface", (ActionListener)this);
        Dimension dimension = demoPanel2.tools.toolbar.getPreferredSize();
        demoPanel2.tools.toolbar.setPreferredSize(new Dimension(dimension.width + 27, dimension.height));
        if (Java2Demo.backgroundColor != null) {
            demoPanel2.surface.setBackground(Java2Demo.backgroundColor);
        }
        if (Java2Demo.controls != null && demoPanel2.tools.isExpanded != Java2Demo.controls.toolBarCB.isSelected()) {
            demoPanel2.tools.toggleB.doClick();
        }
        demoPanel2.start();
        demoPanel2.surface.setMonitor(Java2Demo.performancemonitor != null);
        this.clonePanels[n].add(demoPanel2);
        this.clonePanels[n].repaint();
        this.clonePanels[n].validate();
    }

    public void removeClone(Component component) {
        int n = this.tabbedPane.getSelectedIndex() - 1;
        if (this.clonePanels[n].getComponentCount() == 2) {
            Component component2 = this.clonePanels[n].getComponent(0);
            this.clonePanels[n].removeAll();
            this.clonePanels[n].setLayout(new BorderLayout());
            this.clonePanels[n].validate();
            this.clonePanels[n].add(component2);
        } else {
            this.clonePanels[n].remove(component);
            int n2 = this.clonePanels[n].getComponentCount();
            for (int i = 1; i < n2; ++i) {
                int n3 = i + 1 >= 3 ? 0 : 5;
                int n4 = (i + 1) % 2 == 0 ? 0 : 5;
                EmptyBorder emptyBorder = new EmptyBorder(n3, n4, 5, 5);
                SoftBevelBorder softBevelBorder = new SoftBevelBorder(0);
                JPanel jPanel = (JPanel)this.clonePanels[n].getComponent(i);
                jPanel.setBorder(new CompoundBorder(emptyBorder, softBevelBorder));
            }
        }
        this.clonePanels[n].repaint();
        this.clonePanels[n].validate();
    }

    public static void main(String[] stringArray) {
        final DemoGroup demoGroup = new DemoGroup(stringArray[0]);
        JFrame jFrame = new JFrame("Java2D Demo - DemoGroup");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }

            public void windowDeiconified(WindowEvent windowEvent) {
                demoGroup.setup(false);
            }

            public void windowIconified(WindowEvent windowEvent) {
                demoGroup.shutDown(demoGroup.getPanel());
            }
        });
        jFrame.getContentPane().add("Center", demoGroup);
        jFrame.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = 620;
        int n2 = 530;
        jFrame.setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
        jFrame.setSize(n, n2);
        jFrame.setVisible(true);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith("-ccthread")) continue;
            Java2Demo.ccthreadCB = new JCheckBoxMenuItem("CCThread", true);
        }
        demoGroup.setup(false);
    }
}

