/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Flow;
import com.sun.tools.javac.comp.Lower;
import com.sun.tools.javac.comp.Todo;
import com.sun.tools.javac.comp.TransTypes;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.jvm.ClassWriter;
import com.sun.tools.javac.jvm.Gen;
import com.sun.tools.javac.parser.Parser;
import com.sun.tools.javac.parser.Scanner;
import com.sun.tools.javac.tree.Pretty;
import com.sun.tools.javac.tree.Tree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringBufferInputStream;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCompiler
implements ClassReader.SourceCompleter {
    protected static final Context.Key<JavaCompiler> compilerKey = new Context.Key();
    Log log;
    TreeMaker make;
    ClassReader reader;
    ClassWriter writer;
    Enter enter;
    Symtab syms;
    Source source;
    Gen gen;
    Name.Table names;
    Attr attr;
    Check chk;
    Flow flow;
    TransTypes transTypes;
    Lower lower;
    Annotate annotate;
    final Name completionFailureName;
    Types types;
    Scanner.Factory scannerFactory;
    Parser.Factory parserFactory;
    public boolean verbose;
    public boolean sourceOutput;
    public boolean stubOutput;
    public boolean attrParseOnly;
    boolean relax;
    public boolean printFlat;
    public boolean deprecation;
    public boolean warnunchecked;
    public String encoding;
    private Todo todo;
    Set<File> inputFiles = new HashSet<File>();
    private boolean hasBeenUsed = false;

    public static JavaCompiler instance(Context context) {
        JavaCompiler javaCompiler = context.get(compilerKey);
        if (javaCompiler == null) {
            javaCompiler = new JavaCompiler(context);
        }
        return javaCompiler;
    }

    public static String version() {
        return System.getProperty("java.version");
    }

    public JavaCompiler(Context context) {
        context.put(compilerKey, this);
        this.names = Name.Table.instance(context);
        this.log = Log.instance(context);
        this.reader = ClassReader.instance(context);
        this.make = TreeMaker.instance(context);
        this.writer = ClassWriter.instance(context);
        this.enter = Enter.instance(context);
        this.todo = Todo.instance(context);
        this.parserFactory = Parser.Factory.instance(context);
        this.scannerFactory = Scanner.Factory.instance(context);
        try {
            this.syms = Symtab.instance(context);
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.log.error(0, completionFailure.getMessage(), new Object[0]);
        }
        this.source = Source.instance(context);
        this.attr = Attr.instance(context);
        this.chk = Check.instance(context);
        this.gen = Gen.instance(context);
        this.flow = Flow.instance(context);
        this.transTypes = TransTypes.instance(context);
        this.lower = Lower.instance(context);
        this.annotate = Annotate.instance(context);
        this.types = Types.instance(context);
        this.reader.sourceCompleter = this;
        Options options = Options.instance(context);
        this.verbose = options.get("-verbose") != null;
        this.sourceOutput = options.get("-s") != null;
        this.stubOutput = options.get("-stubs") != null;
        this.relax = options.get("-relax") != null;
        this.printFlat = options.get("-printflat") != null;
        this.deprecation = options.lint("deprecation");
        this.warnunchecked = options.lint("unchecked");
        this.attrParseOnly = options.get("-attrparseonly") != null;
        this.encoding = (String)options.get("-encoding");
        this.completionFailureName = options.get("failcomplete") != null ? this.names.fromString((String)options.get("failcomplete")) : null;
    }

    public int errorCount() {
        return this.log.nerrors;
    }

    public int warningCount() {
        return this.log.nwarnings;
    }

    public InputStream openSource(String string) {
        try {
            File file = new File(string);
            this.inputFiles.add(file);
            return new FileInputStream(file);
        }
        catch (IOException iOException) {
            this.log.error(0, "cant.read.file", string);
            return null;
        }
    }

    public Tree.TopLevel parse(String string, InputStream inputStream) {
        long l = System.currentTimeMillis();
        Name name = this.log.useSource(this.names.fromString(string));
        Tree.TopLevel topLevel = this.make.TopLevel(Tree.Annotation.emptyList, null, Tree.emptyList);
        if (inputStream != null) {
            if (this.verbose) {
                this.printVerbose("parsing.started", string);
            }
            try {
                Scanner scanner = this.scannerFactory.newScanner(inputStream, this.encoding);
                inputStream.close();
                Parser parser = this.parserFactory.newParser(scanner, this.keepComments());
                topLevel = parser.compilationUnit();
                if (this.verbose) {
                    this.printVerbose("parsing.done", Long.toString(System.currentTimeMillis() - l));
                }
            }
            catch (IOException iOException) {
                this.log.error(0, "error.reading.file", string, iOException);
            }
        }
        this.log.useSource(name);
        topLevel.sourcefile = this.names.fromString(string);
        return topLevel;
    }

    protected boolean keepComments() {
        return this.sourceOutput || this.stubOutput;
    }

    public Tree.TopLevel parse(String string) {
        return this.parse(string, this.openSource(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Symbol resolveIdent(String string) {
        if (string == null || string.equals("")) {
            return this.syms.errSymbol;
        }
        Name name = this.log.useSource(null);
        try {
            Scanner scanner;
            Tree.TopLevel topLevel = this.make.TopLevel(Tree.Annotation.emptyList, null, Tree.emptyList);
            topLevel.packge = this.syms.emptyPackage;
            this.reader.complete(topLevel.packge);
            StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(string);
            try {
                scanner = this.scannerFactory.newScanner(stringBufferInputStream, this.encoding);
                stringBufferInputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            Parser parser = this.parserFactory.newParser(scanner, this.keepComments());
            Tree tree = parser.qualident();
            if (tree != null && (tree instanceof Tree.Select || tree instanceof Tree.Ident)) {
                Symbol.TypeSymbol typeSymbol = this.attr.attribIdent((Tree)tree, (Tree.TopLevel)topLevel).tsym;
                return typeSymbol;
            }
        }
        finally {
            this.log.useSource(name);
        }
        return this.syms.errSymbol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printSource(Env<AttrContext> env, Tree.ClassDef classDef) throws IOException {
        File file = this.writer.outputFile(classDef.sym, ".java");
        if (this.inputFiles.contains(file)) {
            this.log.error(classDef.pos, "source.cant.overwrite.input.file", file);
        } else {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file))));
            try {
                new Pretty(printWriter, true).printUnit(env.toplevel, classDef);
                if (this.verbose) {
                    this.printVerbose("wrote.file", file.getPath());
                }
            }
            finally {
                printWriter.close();
            }
        }
    }

    void genCode(Env<AttrContext> env, Tree.ClassDef classDef) throws IOException {
        try {
            if (this.gen.genClass(env, classDef)) {
                this.writer.writeClass(classDef.sym);
            }
        }
        catch (ClassWriter.PoolOverflow poolOverflow) {
            this.log.error(classDef.pos, "limit.pool", new Object[0]);
        }
        catch (ClassWriter.StringOverflow stringOverflow) {
            this.log.error(classDef.pos, "limit.string.overflow", stringOverflow.value.substring(0, 20));
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.log.error(0, completionFailure.getMessage(), new Object[0]);
        }
    }

    @Override
    public void complete(Symbol.ClassSymbol classSymbol, String string, InputStream inputStream) throws Symbol.CompletionFailure {
        if (this.completionFailureName == classSymbol.fullname) {
            throw new Symbol.CompletionFailure(classSymbol, "user-selected completion failure by class name");
        }
        Tree.TopLevel topLevel = this.parse(string, inputStream);
        this.enter.complete(List.make(topLevel), classSymbol);
        if (this.enter.getEnv(classSymbol) == null) {
            throw new ClassReader.BadClassFile(classSymbol, string, Log.getLocalizedString("file.doesnt.contain.class", classSymbol.fullname));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Symbol.ClassSymbol> compile(List<String> list) throws Throwable {
        int n;
        assert (!this.hasBeenUsed) : "attempt to reuse JavaCompiler";
        this.hasBeenUsed = true;
        long l = System.currentTimeMillis();
        ListBuffer<Symbol.ClassSymbol> listBuffer = new ListBuffer<Symbol.ClassSymbol>();
        try {
            Object object;
            List list2;
            Object object2;
            ListBuffer<Tree.TopLevel> listBuffer2 = new ListBuffer<Tree.TopLevel>();
            List<String> list3 = list;
            while (list3.nonEmpty()) {
                listBuffer2.append(this.parse((String)list3.head));
                list3 = list3.tail;
            }
            list3 = listBuffer2.toList();
            if (this.errorCount() == 0) {
                this.enter.main(list3);
            }
            List list4 = null;
            if (this.sourceOutput || this.stubOutput) {
                object2 = new ListBuffer();
                list2 = list3;
                while (list2.nonEmpty()) {
                    object = ((Tree.TopLevel)list2.head).defs;
                    while (((List)object).nonEmpty()) {
                        if (((List)object).head instanceof Tree.ClassDef) {
                            ((ListBuffer)object2).append((Tree.ClassDef)((List)object).head);
                        }
                        object = ((List)object).tail;
                    }
                    list2 = list2.tail;
                }
                list4 = ((ListBuffer)object2).toList();
            }
            while (this.todo.nonEmpty()) {
                object2 = (Env)this.todo.next();
                list2 = ((Env)object2).tree;
                if (this.verbose) {
                    this.printVerbose("checking.attribution", ((Env)object2).enclClass.sym);
                }
                object = this.log.useSource(((Env)object2).enclClass.sym.sourcefile != null ? ((Env)object2).enclClass.sym.sourcefile : ((Env)object2).toplevel.sourcefile);
                this.attr.attribClass(((Env)object2).tree.pos, ((Env)object2).enclClass.sym);
                if (this.attrParseOnly) continue;
                this.make.at(1025);
                TreeMaker treeMaker = this.make.forToplevel(((Env)object2).toplevel);
                if (this.errorCount() == 0 && !this.relax) {
                    this.flow.analyzeTree(((Env)object2).tree, treeMaker);
                }
                Tree.ClassDef classDef = null;
                try {
                    List<Tree> list5;
                    if (this.errorCount() != 0) continue;
                    if (((Env)object2).tree instanceof Tree.TopLevel) {
                        list5 = this.lower.translateTopLevelClass((Env<AttrContext>)object2, ((Env)object2).tree, treeMaker);
                        if (list5.head == null) continue;
                        assert (list5.tail.isEmpty());
                        classDef = (Tree.ClassDef)list5.head;
                        this.genCode((Env<AttrContext>)object2, classDef);
                        continue;
                    }
                    if (this.stubOutput) {
                        classDef = (Tree.ClassDef)((Env)object2).tree;
                        if (!(list2 instanceof Tree.ClassDef) || !list4.contains((Tree.ClassDef)((Object)list2)) || (classDef.mods.flags & 5L) == 0L && classDef.sym.packge().fullName() != this.names.java_lang) continue;
                        this.printSource((Env<AttrContext>)object2, this.removeMethodBodies(classDef));
                        continue;
                    }
                    ((Env)object2).tree = this.transTypes.translateTopLevelClass(((Env)object2).tree, treeMaker);
                    if (this.errorCount() != 0) continue;
                    if (this.sourceOutput) {
                        classDef = (Tree.ClassDef)((Env)object2).tree;
                        if (!(list2 instanceof Tree.ClassDef) || !list4.contains((Tree.ClassDef)((Object)list2))) continue;
                        this.printSource((Env<AttrContext>)object2, classDef);
                        continue;
                    }
                    list5 = this.lower.translateTopLevelClass((Env<AttrContext>)object2, ((Env)object2).tree, treeMaker);
                    if (this.errorCount() != 0) continue;
                    List<Tree> list6 = list5;
                    while (this.errorCount() == 0 && list6.nonEmpty()) {
                        classDef = (Tree.ClassDef)list6.head;
                        if (this.printFlat) {
                            this.printSource((Env<AttrContext>)object2, classDef);
                        } else {
                            this.genCode((Env<AttrContext>)object2, classDef);
                        }
                        listBuffer.append(classDef.sym);
                        list6 = list6.tail;
                    }
                }
                catch (IOException iOException) {
                    this.log.error(classDef.pos, "class.cant.write", classDef.sym, iOException.getMessage());
                }
                finally {
                    this.log.useSource((Name)object);
                }
            }
        }
        catch (Abort abort) {
            // empty catch block
        }
        if (this.verbose) {
            this.printVerbose("total", Long.toString(System.currentTimeMillis() - l));
        }
        if (this.chk.deprecatedSource != null && !this.deprecation) {
            this.noteDeprecated(this.chk.deprecatedSource);
        }
        if (this.chk.uncheckedSource != null && !this.warnunchecked) {
            this.makeNotes(this.chk.uncheckedSource.toString());
        }
        if ((n = this.errorCount()) == 1) {
            this.printCount("error", n);
        } else {
            this.printCount("error.plural", n);
        }
        if (this.log.nwarnings == 1) {
            this.printCount("warn", this.log.nwarnings);
        } else {
            this.printCount("warn.plural", this.log.nwarnings);
        }
        return listBuffer.toList();
    }

    Tree.ClassDef removeMethodBodies(Tree.ClassDef classDef) {
        final boolean bl = (classDef.mods.flags & 0x200L) != 0L;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MethodBodyRemover
        extends TreeTranslator {
            MethodBodyRemover() {
            }

            @Override
            public void visitMethodDef(Tree.MethodDef methodDef) {
                methodDef.mods.flags &= 0xFFFFFFFFFFFFFFDFL;
                for (Tree.VarDef varDef : methodDef.params) {
                    varDef.mods.flags &= 0xFFFFFFFFFFFFFFEFL;
                }
                methodDef.body = null;
                super.visitMethodDef(methodDef);
            }

            @Override
            public void visitVarDef(Tree.VarDef varDef) {
                if (varDef.init != null && varDef.init.type.constValue == null) {
                    varDef.init = null;
                }
                super.visitVarDef(varDef);
            }

            @Override
            public void visitClassDef(Tree.ClassDef classDef) {
                ListBuffer<Tree> listBuffer = new ListBuffer<Tree>();
                List<Tree> list = classDef.defs;
                while (list.tail != null) {
                    Tree tree = (Tree)list.head;
                    switch (tree.tag) {
                        case 3: {
                            if (!bl && (((Tree.ClassDef)tree).mods.flags & 5L) == 0L && ((((Tree.ClassDef)tree).mods.flags & 2L) != 0L || ((Tree.ClassDef)tree).sym.packge().fullName() != JavaCompiler.this.names.java_lang)) break;
                            listBuffer.append(tree);
                            break;
                        }
                        case 4: {
                            if (!bl && (((Tree.MethodDef)tree).mods.flags & 5L) == 0L && ((Tree.MethodDef)tree).sym.name != JavaCompiler.this.names.init && ((((Tree.MethodDef)tree).mods.flags & 2L) != 0L || ((Tree.MethodDef)tree).sym.packge().fullName() != JavaCompiler.this.names.java_lang)) break;
                            listBuffer.append(tree);
                            break;
                        }
                        case 5: {
                            if (!bl && (((Tree.VarDef)tree).mods.flags & 5L) == 0L && ((((Tree.VarDef)tree).mods.flags & 2L) != 0L || ((Tree.VarDef)tree).sym.packge().fullName() != JavaCompiler.this.names.java_lang)) break;
                            listBuffer.append(tree);
                            break;
                        }
                    }
                    list = list.tail;
                }
                classDef.defs = listBuffer.toList();
                super.visitClassDef(classDef);
            }
        }
        MethodBodyRemover methodBodyRemover = new MethodBodyRemover();
        return (Tree.ClassDef)methodBodyRemover.translate(classDef);
    }

    public void close() {
        this.log.flush();
        this.reader.close();
        this.names.dispose();
    }

    private void printVerbose(String string, Object object) {
        Log.printLines(this.log.noticeWriter, Log.getLocalizedString("verbose." + string, object));
    }

    private void noteDeprecated(Object object) {
        if (object.equals("*")) {
            this.log.note("deprecated.plural", new Object[0]);
        } else {
            this.log.note("deprecated.filename", object);
        }
        this.log.note("deprecated.recompile", new Object[0]);
    }

    void makeNotes(Object object) {
        if (object.toString().equals("*")) {
            this.log.note("unchecked.plural", new Object[0]);
        } else {
            this.log.note("unchecked.filename", object);
        }
        this.log.note("unchecked.recompile", new Object[0]);
    }

    void printCount(String string, int n) {
        if (n != 0) {
            Log.printLines(this.log.errWriter, Log.getLocalizedString("count." + string, Integer.toString(n)));
            this.log.errWriter.flush();
        }
    }
}

