/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.ConstructorWriterImpl;
import com.sun.tools.doclets.formats.html.FieldWriterImpl;
import com.sun.tools.doclets.formats.html.LinkInfoImpl;
import com.sun.tools.doclets.formats.html.MethodWriterImpl;
import com.sun.tools.doclets.formats.html.NestedClassWriterImpl;
import com.sun.tools.doclets.formats.html.PackageUseWriter;
import com.sun.tools.doclets.formats.html.SubWriterHolderWriter;
import com.sun.tools.doclets.internal.toolkit.util.ClassTree;
import com.sun.tools.doclets.internal.toolkit.util.ClassUseMapper;
import com.sun.tools.doclets.internal.toolkit.util.DirectoryManager;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ClassUseWriter
extends SubWriterHolderWriter {
    final ClassDoc classdoc;
    Set pkgToPackageAnnotations = null;
    final Map pkgToClassTypeParameter;
    final Map pkgToClassAnnotations;
    final Map pkgToMethodTypeParameter;
    final Map pkgToMethodArgTypeParameter;
    final Map pkgToMethodReturnTypeParameter;
    final Map pkgToMethodAnnotations;
    final Map pkgToMethodParameterAnnotations;
    final Map pkgToFieldTypeParameter;
    final Map pkgToFieldAnnotations;
    final Map pkgToSubclass;
    final Map pkgToSubinterface;
    final Map pkgToImplementingClass;
    final Map pkgToField;
    final Map pkgToMethodReturn;
    final Map pkgToMethodArgs;
    final Map pkgToMethodThrows;
    final Map pkgToConstructorAnnotations;
    final Map pkgToConstructorParameterAnnotations;
    final Map pkgToConstructorArgs;
    final Map pkgToConstructorArgTypeParameter;
    final Map pkgToConstructorThrows;
    final SortedSet pkgSet;
    final MethodWriterImpl methodSubWriter;
    final ConstructorWriterImpl constrSubWriter;
    final FieldWriterImpl fieldSubWriter;
    final NestedClassWriterImpl classSubWriter;

    public ClassUseWriter(ConfigurationImpl configurationImpl, ClassUseMapper classUseMapper, String string, String string2, String string3, ClassDoc classDoc) throws IOException {
        super(configurationImpl, string, string2, string3);
        this.classdoc = classDoc;
        if (classUseMapper.classToPackageAnnotations.containsKey(classDoc.qualifiedName())) {
            this.pkgToPackageAnnotations = new HashSet((List)classUseMapper.classToPackageAnnotations.get(classDoc.qualifiedName()));
        }
        configurationImpl.currentcd = classDoc;
        this.pkgSet = new TreeSet();
        this.pkgToClassTypeParameter = this.pkgDivide(classUseMapper.classToClassTypeParam);
        this.pkgToClassAnnotations = this.pkgDivide(classUseMapper.classToClassAnnotations);
        this.pkgToMethodTypeParameter = this.pkgDivide(classUseMapper.classToExecMemberDocTypeParam);
        this.pkgToMethodArgTypeParameter = this.pkgDivide(classUseMapper.classToExecMemberDocArgTypeParam);
        this.pkgToFieldTypeParameter = this.pkgDivide(classUseMapper.classToFieldDocTypeParam);
        this.pkgToFieldAnnotations = this.pkgDivide(classUseMapper.annotationToFieldDoc);
        this.pkgToMethodReturnTypeParameter = this.pkgDivide(classUseMapper.classToExecMemberDocReturnTypeParam);
        this.pkgToMethodAnnotations = this.pkgDivide(classUseMapper.classToExecMemberDocAnnotations);
        this.pkgToMethodParameterAnnotations = this.pkgDivide(classUseMapper.classToExecMemberDocParamAnnotation);
        this.pkgToSubclass = this.pkgDivide(classUseMapper.classToSubclass);
        this.pkgToSubinterface = this.pkgDivide(classUseMapper.classToSubinterface);
        this.pkgToImplementingClass = this.pkgDivide(classUseMapper.classToImplementingClass);
        this.pkgToField = this.pkgDivide(classUseMapper.classToField);
        this.pkgToMethodReturn = this.pkgDivide(classUseMapper.classToMethodReturn);
        this.pkgToMethodArgs = this.pkgDivide(classUseMapper.classToMethodArgs);
        this.pkgToMethodThrows = this.pkgDivide(classUseMapper.classToMethodThrows);
        this.pkgToConstructorAnnotations = this.pkgDivide(classUseMapper.classToConstructorAnnotations);
        this.pkgToConstructorParameterAnnotations = this.pkgDivide(classUseMapper.classToConstructorParamAnnotation);
        this.pkgToConstructorArgs = this.pkgDivide(classUseMapper.classToConstructorArgs);
        this.pkgToConstructorArgTypeParameter = this.pkgDivide(classUseMapper.classToConstructorDocArgTypeParam);
        this.pkgToConstructorThrows = this.pkgDivide(classUseMapper.classToConstructorThrows);
        if (this.pkgSet.size() > 0 && classUseMapper.classToPackage.containsKey(classDoc.qualifiedName()) && !this.pkgSet.equals(classUseMapper.classToPackage.get(classDoc.qualifiedName()))) {
            configurationImpl.root.printWarning("Internal error: package sets don't match: " + this.pkgSet + " with: " + classUseMapper.classToPackage.get(classDoc.qualifiedName()));
        }
        this.methodSubWriter = new MethodWriterImpl(this);
        this.constrSubWriter = new ConstructorWriterImpl(this);
        this.fieldSubWriter = new FieldWriterImpl(this);
        this.classSubWriter = new NestedClassWriterImpl(this);
    }

    public static void generate(ConfigurationImpl configurationImpl, ClassTree classTree) {
        ClassUseMapper classUseMapper = new ClassUseMapper(configurationImpl.root, classTree);
        ClassDoc[] classDocArray = configurationImpl.root.classes();
        for (int i = 0; i < classDocArray.length; ++i) {
            ClassUseWriter.generate(configurationImpl, classUseMapper, classDocArray[i]);
        }
        PackageDoc[] packageDocArray = configurationImpl.packages;
        for (int i = 0; i < packageDocArray.length; ++i) {
            PackageUseWriter.generate(configurationImpl, classUseMapper, packageDocArray[i]);
        }
    }

    private Map pkgDivide(Map map) {
        HashMap<String, ArrayList<ProgramElementDoc>> hashMap = new HashMap<String, ArrayList<ProgramElementDoc>>();
        List list = (List)map.get(this.classdoc.qualifiedName());
        if (list != null) {
            Collections.sort(list);
            for (ProgramElementDoc programElementDoc : list) {
                PackageDoc packageDoc = programElementDoc.containingPackage();
                this.pkgSet.add(packageDoc);
                ArrayList<ProgramElementDoc> arrayList = (ArrayList<ProgramElementDoc>)hashMap.get(packageDoc.name());
                if (arrayList == null) {
                    arrayList = new ArrayList<ProgramElementDoc>();
                    hashMap.put(packageDoc.name(), arrayList);
                }
                arrayList.add(programElementDoc);
            }
        }
        return hashMap;
    }

    public static void generate(ConfigurationImpl configurationImpl, ClassUseMapper classUseMapper, ClassDoc classDoc) {
        String string = DirectoryManager.getDirectoryPath(classDoc.containingPackage());
        if (string.length() > 0) {
            string = string + File.separator;
        }
        string = string + "class-use";
        String string2 = classDoc.name() + ".html";
        String string3 = classDoc.containingPackage().name();
        string3 = string3 + (string3.length() > 0 ? ".class-use" : "class-use");
        String string4 = DirectoryManager.getRelativePath(string3);
        try {
            ClassUseWriter classUseWriter = new ClassUseWriter(configurationImpl, classUseMapper, string, string2, string4, classDoc);
            classUseWriter.generateClassUseFile();
            classUseWriter.close();
        }
        catch (IOException iOException) {
            configurationImpl.standardmessage.error("doclet.exception_encountered", iOException.toString(), string2);
            throw new DocletAbortException();
        }
    }

    protected void generateClassUseFile() throws IOException {
        this.printClassUseHeader();
        if (this.pkgSet.size() > 0) {
            this.generateClassUse();
        } else {
            this.printText("doclet.ClassUse_No.usage.of.0", this.classdoc.qualifiedName());
            this.p();
        }
        this.printClassUseFooter();
    }

    protected void generateClassUse() throws IOException {
        if (this.configuration.packages.length > 1) {
            this.generatePackageList();
            this.generatePackageAnnotationList();
        }
        this.generateClassList();
    }

    protected void generatePackageList() throws IOException {
        this.tableIndexSummary();
        this.tableHeaderStart("#CCCCFF");
        this.printText("doclet.ClassUse_Packages.that.use.0", this.getLink(new LinkInfoImpl(33, this.classdoc, false)));
        this.tableHeaderEnd();
        for (PackageDoc packageDoc : this.pkgSet) {
            this.generatePackageUse(packageDoc);
        }
        this.tableEnd();
        this.space();
        this.p();
    }

    protected void generatePackageAnnotationList() throws IOException {
        if (!this.classdoc.isAnnotationType() || this.pkgToPackageAnnotations == null || this.pkgToPackageAnnotations.size() == 0) {
            return;
        }
        this.tableIndexSummary();
        this.tableHeaderStart("#CCCCFF");
        this.printText("doclet.ClassUse_PackageAnnotation", this.getLink(new LinkInfoImpl(33, this.classdoc, false)));
        this.tableHeaderEnd();
        for (PackageDoc packageDoc : this.pkgToPackageAnnotations) {
            this.trBgcolorStyle("white", "TableRowColor");
            this.summaryRow(0);
            this.printPackageLink(packageDoc, packageDoc.name(), true);
            this.summaryRowEnd();
            this.summaryRow(0);
            this.printSummaryComment(packageDoc);
            this.space();
            this.summaryRowEnd();
            this.trEnd();
        }
        this.tableEnd();
        this.space();
        this.p();
    }

    protected void generateClassList() throws IOException {
        for (PackageDoc packageDoc : this.pkgSet) {
            this.anchor(packageDoc.name());
            this.tableIndexSummary();
            this.tableHeaderStart("#CCCCFF");
            this.printText("doclet.ClassUse_Uses.of.0.in.1", this.getLink(new LinkInfoImpl(33, this.classdoc, false)), this.getPackageLink(packageDoc, Util.getPackageName(packageDoc), false));
            this.tableHeaderEnd();
            this.tableEnd();
            this.space();
            this.p();
            this.generateClassUse(packageDoc);
        }
    }

    protected void generatePackageUse(PackageDoc packageDoc) throws IOException {
        this.trBgcolorStyle("white", "TableRowColor");
        this.summaryRow(0);
        this.printHyperLink("", packageDoc.name(), Util.getPackageName(packageDoc), true);
        this.summaryRowEnd();
        this.summaryRow(0);
        this.printSummaryComment(packageDoc);
        this.space();
        this.summaryRowEnd();
        this.trEnd();
    }

    protected void generateClassUse(PackageDoc packageDoc) throws IOException {
        String string = this.getLink(new LinkInfoImpl(33, this.classdoc, false));
        String string2 = this.getPackageLink(packageDoc, Util.getPackageName(packageDoc), false);
        this.classSubWriter.printUseInfo(this.pkgToClassAnnotations.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_Annotation", string, string2));
        this.classSubWriter.printUseInfo(this.pkgToClassTypeParameter.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_TypeParameter", string, string2));
        this.classSubWriter.printUseInfo(this.pkgToSubclass.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_Subclass", string, string2));
        this.classSubWriter.printUseInfo(this.pkgToSubinterface.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_Subinterface", string, string2));
        this.classSubWriter.printUseInfo(this.pkgToImplementingClass.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_ImplementingClass", string, string2));
        this.fieldSubWriter.printUseInfo(this.pkgToField.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_Field", string, string2));
        this.fieldSubWriter.printUseInfo(this.pkgToFieldAnnotations.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_FieldAnnotations", string, string2));
        this.fieldSubWriter.printUseInfo(this.pkgToFieldTypeParameter.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_FieldTypeParameter", string, string2));
        this.methodSubWriter.printUseInfo(this.pkgToMethodAnnotations.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_MethodAnnotations", string, string2));
        this.methodSubWriter.printUseInfo(this.pkgToMethodParameterAnnotations.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_MethodParameterAnnotations", string, string2));
        this.methodSubWriter.printUseInfo(this.pkgToMethodTypeParameter.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_MethodTypeParameter", string, string2));
        this.methodSubWriter.printUseInfo(this.pkgToMethodReturn.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_MethodReturn", string, string2));
        this.methodSubWriter.printUseInfo(this.pkgToMethodReturnTypeParameter.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_MethodReturnTypeParameter", string, string2));
        this.methodSubWriter.printUseInfo(this.pkgToMethodArgs.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_MethodArgs", string, string2));
        this.methodSubWriter.printUseInfo(this.pkgToMethodArgTypeParameter.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_MethodArgsTypeParameters", string, string2));
        this.methodSubWriter.printUseInfo(this.pkgToMethodThrows.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_MethodThrows", string, string2));
        this.constrSubWriter.printUseInfo(this.pkgToConstructorAnnotations.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_ConstructorAnnotations", string, string2));
        this.constrSubWriter.printUseInfo(this.pkgToConstructorParameterAnnotations.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_ConstructorParameterAnnotations", string, string2));
        this.constrSubWriter.printUseInfo(this.pkgToConstructorArgs.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_ConstructorArgs", string, string2));
        this.constrSubWriter.printUseInfo(this.pkgToConstructorArgTypeParameter.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_ConstructorArgsTypeParameters", string, string2));
        this.constrSubWriter.printUseInfo(this.pkgToConstructorThrows.get(packageDoc.name()), this.configuration.getText("doclet.ClassUse_ConstructorThrows", string, string2));
    }

    protected void printClassUseHeader() {
        String string = this.configuration.getText(this.classdoc.isInterface() ? "doclet.Interface" : "doclet.Class");
        String string2 = this.classdoc.qualifiedName();
        this.printHtmlHeader(this.configuration.getText("doclet.Window_ClassUse_Header", string, string2), null, true);
        this.navLinks(true);
        this.hr();
        this.center();
        this.h2();
        this.boldText("doclet.ClassUse_Title", string, string2);
        this.h2End();
        this.centerEnd();
    }

    protected void printClassUseFooter() {
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void navLinkPackage() {
        this.navCellStart();
        this.printHyperLink("../package-summary.html", "", this.configuration.getText("doclet.Package"), true, "NavBarFont1");
        this.navCellEnd();
    }

    protected void navLinkClass() {
        this.navCellStart();
        this.printLink(new LinkInfoImpl(33, this.classdoc, "", this.configuration.getText("doclet.Class"), true, "NavBarFont1"));
        this.navCellEnd();
    }

    protected void navLinkClassUse() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.navClassUse");
        this.fontEnd();
        this.navCellEnd();
    }

    protected void navLinkTree() {
        this.navCellStart();
        if (this.classdoc.containingPackage().isIncluded()) {
            this.printHyperLink("../package-tree.html", "", this.configuration.getText("doclet.Tree"), true, "NavBarFont1");
        } else {
            this.printHyperLink(this.relativePath + "overview-tree.html", "", this.configuration.getText("doclet.Tree"), true, "NavBarFont1");
        }
        this.navCellEnd();
    }
}

