<%--
  /**
   * ident    "@(#)VolumeDetails.jsp    1.1    03/05/20     SMI"
   * 
   * Copyright (c) 2003 by Sun Microsystems, Inc. All rights reserved.
   * Use is subject to license terms.
   */
--%>
<%@ page info="Index" language="java" %> 
<%@taglib uri="/WEB-INF/tld/com_iplanet_jato/jato.tld" prefix="jato"%>
<%@taglib uri="/WEB-INF/tld/com_sun_web_ui/cc.tld" prefix="cc"%>

<script language="javascript">
    function button1Click() {
        if (!confirm(document.VolumeDetailsForm["VolumeDetails.BClickPrompt"].value)) {
            return false;
        }
        else {
           return true;
        }
    }

    function DeleteSnapPoolButtonClick() {
        if (!confirm(document.VolumeDetailsForm["VolumeDetails.B2ClickPrompt"].value)) {
            return false;
        }
        else {
           return true;
        }
    }

    /**
     * Check for valid save criteria...
     */
    function checkSave() {
    
        var promptStr = "";
        var valStr = "";
        
        /* Check name... */
        var nameStr = document.VolumeDetailsForm["VolumeDetails.nameValue"].value;
        
        if (nameStr.length == 0)
            promptStr = document.VolumeDetailsForm["VolumeDetails.BlankNamePrompt"].value;

        if (promptStr=="") {

            valStr = new RegExp("^" + document.VolumeDetailsForm["VolumeDetails.VolumeNameValidation"].value + "$");
            if (!valStr.test(nameStr))
                promptStr = document.VolumeDetailsForm["VolumeDetails.InvalidCharInNamePrompt"].value;

            if (promptStr=="") {
            
                /* Check description... */
                var descStr = document.VolumeDetailsForm["VolumeDetails.descriptionValue"].value;

                if (descStr.length > 0) {
                    valStr = new RegExp("^" + document.VolumeDetailsForm["VolumeDetails.VolumeDescriptionValidation"].value + "$");
                    if (!valStr.test(descStr))
                        promptStr = document.VolumeDetailsForm["VolumeDetails.InvalidCharInDescriptionPrompt"].value;
                }

                if (promptStr=="") {

                    /* Check for (and don't allow) a reduction in snapshot reserve size */
                    var curNumAlloc      = document.VolumeDetailsForm["VolumeDetails.VolumeSnapNumAllocatedHidden"].value;
                    var curExpectedWrite = document.VolumeDetailsForm["VolumeDetails.VolumeSnapExpectedWriteHidden"].value;

                    var newNumAlloc      = document.VolumeDetailsForm["VolumeDetails.snapshotpoolnumsnapsValue"].value;
                    var newExpectedWrite = document.VolumeDetailsForm["VolumeDetails.snapshotpoolwriteactivityValue"].value;
                    
                    var newSize = newNumAlloc*newExpectedWrite;
                    var curSize = curNumAlloc*curExpectedWrite;

                    if ( newSize < curSize )
                    {
                        /* Reduction not allowed */
                        promptStr = document.VolumeDetailsForm["VolumeDetails.NoShrinkSnapSpacePrompt"].value;
                    }
                    
                    if (promptStr=="") {
                    
                        /* Catch the case where only ONE of the 2 required params to 
                           create a new snap reserve space is specified:
                             - specify pool but N*M==0
                             - specify non-zero N*M but don't specify a pool
                        */
                        var newSnapPool = document.VolumeDetailsForm["VolumeDetails.snapshotpoolstoragepoolValue"].value;
                    
                        if (curSize==0 && ((newSnapPool!="" && newSize==0) || (newSnapPool=="" && newSize>0))) {
                            promptStr = document.VolumeDetailsForm["VolumeDetails.InvalidCreateSnapResPrompt"].value;
                        }
                    }
                }
            }
        }

        /** 
         *  If we set a promptStr display it and return false to 
         *  terminate save process otherwise return true.
         */
        if (promptStr!="") {
            alert(promptStr);
            return false; 
        } else {
            return true;
        }
    }
</script>


<jato:useViewBean className="com.sun.netstorage.array.mgmt.cfg.bui.reports.VolumeDetailsViewBean">

 <!-- Define the resource bundle, html, head, meta, stylesheet and body tags -->
 <cc:header pageTitle="se6920ui.title" 
            copyrightYear="2003"
            baseName="com.sun.netstorage.array.mgmt.cfg.bui.resources.Resources" 
            bundleID="se6920uiBundle">

  <!-- Masthead -->
  <cc:primarymasthead name="Masthead" bundleID="se6920uiBundle" />

  <!-- Form -->
  <jato:form  name="VolumeDetailsForm" method="post">

    <!-- JavaScript Prompts -->
    <cc:hidden name="BClickPrompt" defaultValue="" />
    <cc:hidden name="B2ClickPrompt" defaultValue="" />
    <cc:hidden name="NoShrinkSnapSpacePrompt" defaultValue="" />
    <cc:hidden name="BlankNamePrompt" defaultValue="" />
    <cc:hidden name="InvalidCharInNamePrompt" defaultValue="" />
    <cc:hidden name="InvalidCharInDescriptionPrompt" defaultValue="" />
    <cc:hidden name="InvalidCreateSnapResPrompt" defaultValue="" />

  <!-- Navigation Tabs -->
  <jato:content name="LocalTabs">
   <cc:tabs    name="Tabs" 
               bundleID="se6920uiBundle" />

  </jato:content>

  <!-- Bread Crumb component--> 
  <cc:breadcrumbs name="BreadCrumb" bundleID="se6920uiBundle" /> 
  
  <!-- Alert --> 
  <div class="ConMgn">
    <cc:alertinline name="Alert" bundleID="se6920uiBundle" />
  </div>
  
  <!-- Page title -->
  <cc:pagetitle    name="PageTitle" 
                   bundleID="se6920uiBundle"
                   pageTitleText="se6920ui.reports.volumeDetails.pageTitle"
                   showPageTitleSeparator="true"
                   showPageButtonsTop="true"
                   showPageButtonsBottom="true">
    <!-- PropertySheet -->
    <cc:propertysheet name="PropertySheet" 
                      bundleID="se6920uiBundle" 
                      showJumpLinks="true"/>
  </cc:pagetitle>


<cc:hidden name="VolumeCapacityHidden" />

<cc:hidden name="VolumeSnapNumAllocatedHidden" />
<cc:hidden name="VolumeSnapExpectedWriteHidden" />
<cc:hidden name="VolumeNameValidation" />
<cc:hidden name="VolumeDescriptionValidation" />

 <!-- VolumeExtendHidden -->
<cc:hidden name="VolumeValueHidden" />
<cc:hidden name="VolumeUnitHidden" />



  </jato:form> 
 </cc:header>
</jato:useViewBean> 

