<%--
  /**
   * ident "@(#)General.jsp     1.6 09/04/03 SMI"
   *
   * Copyright (c) 2003 by Sun Microsystems, Inc. All rights reserved.
   * Use is subject to license terms.
   */
--%>
<%@ page info="Index" language="java" %>
<%@taglib uri="/WEB-INF/tld/com_iplanet_jato/jato.tld" prefix="jato"%>
<%@taglib uri="/WEB-INF/tld/com_sun_web_ui/cc.tld" prefix="cc"%>

<script language="javascript">

function handleMonthYearChanged()
{
    // Days in month: Jan Feb Mar Apr May Jun Jly Aug Sep Oct Nov Dec
    var daysInMonth = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
    
    var year  = document.generalsettingsForm["General.DropDownMenuYear"].value;
    var month = document.generalsettingsForm["General.DropDownMenuMonth"].value;
    
    // Handle leap years...
    // No need for complicated century calculation. Won't encounter that till 2100. 
    // Product has 95 year life expectancy... NOT! Code puts 2003 to 2023 in the list
    if (year % 4 == 0)
        daysInMonth[1] = 29;
    
    // Get current day then clear the current list
    var dayCtrl = document.generalsettingsForm["General.DropDownMenuDay"];
    var dayToSel = dayCtrl.value;
    dayCtrl.options.length = 0;

    // Add the days for this month
    var days = daysInMonth[month];
    for (var day=1; day <=days; day++) {
        var opt = new Option(day, day, false, false);
        dayCtrl.options[day-1] = opt;
    }
    
    // Reselect the current day, adjust if current day not in new list
    if (dayToSel>days)
        dayToSel = days;

    dayCtrl.value = dayToSel;
}

function validRequired(formField,fieldLabel)
{

        var result = true;

        if (formField.value == "")
        {
                alert(
                    document.generalsettingsForm["General.validationPromptString1"].value
                    + fieldLabel +
                    document.generalsettingsForm["General.validationPromptString2"].value);
                formField.focus();
                result = false;
        }

        return result;
}

function ipDigits(formField, fieldLabel)
{
   if (!inValidCharSet(formField.value,"0123456789.")){
                alert(document.generalsettingsForm["General.validationPromptString3"].value
                    + fieldLabel +
                    document.generalsettingsForm["General.validationPromptString4"].value);
                formField.focus();
                return false;
    }
    return true;
}

function inValidCharSet(str,charset)
{
        var result = true;
        // Note: doesn't use regular expressions to avoid early Mac browser bugs

        for (var i=0;i<str.length;i++)
                if (charset.indexOf(str.substr(i,1))<0)
                {
                        result = false;
                        break;
                }
        return result;
}
//
// validate an IP address field
//
function validateIpAddress(field, str){
  if (!validRequired(field, str))
    return false;

  if (!ipDigits(field, str)){
        return false;
        }
  return true;
}
function checkDhcp() {

    if (document.generalsettingsForm.hiddenDhcpButton.value == "static"){
      if (document.generalsettingsForm.ipAssignmentElement.checked){  // false means static
        return confirm(document.generalsettingsForm["General.ipAddressChangedPromptString"].value);
      }
    }
    else { // was dhcp
      if (!document.generalsettingsForm.ipAssignmentElement.checked){  // false means static
        return confirm(document.generalsettingsForm["General.ipAddressChangedPromptString"].value);
      }
    }
  return true;
}

//
// verify the password field
//
function validatePassword() {
    var PasswordString = document.generalsettingsForm["General.passwordValue"].value;

    if (PasswordString.length == 0)
        return false;

    var pattern = new RegExp("^" + document.generalsettingsForm["General.passwordValidation"].value + "$");
       if (!pattern.test(document.generalsettingsForm["General.passwordValue"].value)) {
          alert (document.generalsettingsForm["General.passwordCheckPrompt"].value);
          return false;
       }
    return true;
}

//
// Validate all fields in the form
//  Note: No description validation as Unicode chars allowed.
//
function validateForm()
{

        if (document.generalsettingsForm.ipAssignmentElement2.checked){
            if (!validateIpAddress(document.generalsettingsForm.IPAddress,
                        document.generalsettingsForm["General.ipAddressPromptString"].value))
                    return false;
            if (!validateIpAddress(document.generalsettingsForm.gatewayIP,
                        document.generalsettingsForm["General.gatewayIPPromptString"].value))
                    return false;
            if (!validateIpAddress(document.generalsettingsForm.netMask,
                        document.generalsettingsForm["General.networkMaskPromptString"].value))
                    return false;
            if (!validateIpAddress(document.generalsettingsForm.nameServer,
                        document.generalsettingsForm["General.nameServerPromptString"].value))
                    return false;
        }

        if (document.generalsettingsForm.ntpIpElement.checked){
            if (!validateIpAddress(document.generalsettingsForm.ntpIp,
                    document.generalsettingsForm["General.ntpIPAddressPromptString"].value))
                return false;
        }

        if (!checkDhcp()) {
            return false;
        }

        // Check for a valid timezone, null string if none is selected
        if (document.generalsettingsForm["General.timeZoneValue"].value == "") {
            alert(document.generalsettingsForm["General.timezonePrompt"].value);
            return false;
        }

        return true;
}


function setTimeFieldState() {
        if (!document.generalsettingsForm.ntpIpElement.checked){
          document.generalsettingsForm.ntpIp.disabled=true;
          document.generalsettingsForm.DropDownMenuHourId.disabled=false;
          document.generalsettingsForm.DropDownMenuMinuteId.disabled=false;
          document.generalsettingsForm.DropDownMenuMonthId.disabled=false;
          document.generalsettingsForm.DropDownMenuDayId.disabled=false;
          document.generalsettingsForm.DropDownMenuYearId.disabled=false;

        }
        else {
          document.generalsettingsForm.ntpIp.disabled=false;
          document.generalsettingsForm.DropDownMenuHourId.disabled=true;
          document.generalsettingsForm.DropDownMenuMinuteId.disabled=true;
          document.generalsettingsForm.DropDownMenuMonthId.disabled=true;
          document.generalsettingsForm.DropDownMenuDayId.disabled=true;
          document.generalsettingsForm.DropDownMenuYearId.disabled=true;
        }
    }

    function ShutdownButtonClick() {

        szPrompt = document.generalsettingsForm["General.shutdownPromptString"].value;

        if (!confirm(szPrompt))
            return false;
        return true;
    }

    function StandbyButtonClick() {
        szPowerFlag = document.generalsettingsForm["General.powerFlag"].value;

        if (szPowerFlag.toUpperCase().indexOf("FULL") != -1) {
            szPrompt = document.generalsettingsForm["General.fullPowerPromptString"].value;
        }
        else {
            szPrompt = document.generalsettingsForm["General.partialPowerPromptString"].value;
        }

        if (!confirm(szPrompt))
            return false;
        return true;
    }
</script>

<jato:useViewBean className="com.sun.netstorage.array.mgmt.cfg.bui.admin.GeneralViewBean">

 <!-- Define the resource bundle, html, head, meta, stylesheet and body tags -->
 <cc:header pageTitle="se6920ui.title"
            copyrightYear="2003"
            baseName="com.sun.netstorage.array.mgmt.cfg.bui.resources.Resources"

            bundleID="se6920uiBundle"
        onLoad="setTimeFieldState()">

  <!-- Form -->
  <jato:form  name="generalsettingsForm"
              method="post">

  <!-- JavaScript Prompts -->
  <cc:hidden name="validationPromptString1" defaultValue="" />
  <cc:hidden name="validationPromptString2" defaultValue="" />
  <cc:hidden name="validationPromptString3" defaultValue="" />
  <cc:hidden name="validationPromptString4" defaultValue="" />
  <cc:hidden name="ipAddressPromptString" defaultValue="" />
  <cc:hidden name="gatewayIPPromptString" defaultValue="" />
  <cc:hidden name="networkMaskPromptString" defaultValue="" />
  <cc:hidden name="nameServerPromptString" defaultValue="" />
  <cc:hidden name="ntpIPAddressPromptString" defaultValue="" />
  <cc:hidden name="ipAddressChangedPromptString" defaultValue="" />
  <cc:hidden name="partialPowerPromptString" defaultValue="" />
  <cc:hidden name="shutdownPromptString" defaultValue="" />
  <cc:hidden name="fullPowerPromptString" defaultValue="" />
  <cc:hidden name="powerFlag" defaultValue="" />
  <cc:hidden name="passwordValidation" defaultValue="" />
  <cc:hidden name="passwordCheckPrompt" defaultValue="" />
  <cc:hidden name="timezonePrompt" defaultValue="" />

  <!-- Masthead -->
  <cc:primarymasthead name="Masthead" bundleID="se6920uiBundle" />

  <!-- Bread Crumb component-->

  <!-- Navigation Tabs -->
  <jato:content name="LocalTabs">
   <cc:tabs    name="Tabs"
               bundleID="se6920uiBundle" />

  </jato:content>

  <!-- Alert -->
    <div class="ConMgn">
        <cc:alertinline name="Alert" bundleID="se6920uiBundle" />
    </div>

  <!-- Page title -->
  <cc:pagetitle    name="PageTitle"
                   bundleID="se6920uiBundle"
                   pageTitleText="se6920ui.admin.general.pageTitle"
                   showPageTitleSeparator="true"
                   showPageButtonsTop="true"
                   showPageButtonsBottom="true">

    <!-- PropertySheet -->
    <cc:propertysheet name="PropertySheet"
                      bundleID="se6920uiBundle"
                      showJumpLinks="true"/>
  </cc:pagetitle>

  </jato:form>
 </cc:header>
</jato:useViewBean>
