//<!--
//
// ident "@(#)progressBar.js	1.2	05/05/10	 SMI"
// 
// Copyright 2005 by Sun Microsystems, Inc. All rights reserved.
// Use is subject to license terms.
//
// This Javascript code will provide methods to show progress bar.
// The only method of interest is drawProgressBar.
//
var progressBarAtStep = 0;
var numberOfSteps = 10;
var stepInterval = 1000;
var singleIterationProgress = 0;
var progressBarTimer;
var continous = false;
var alreadyDrawn = false;
//clear progress bar
function progress_clear() {
	progressBarAtStep = 0;
	document.getElementById('progress').style.width = 0;
}

//update progress bar
function progress_update() {
	progressBarAtStep++;
	if (progressBarAtStep > numberOfSteps){
	    if(continous){
		progress_clear();
                document.getElementById('prcntComplete').innerHTML='0';
	    } else {
	        return;
	    }
	} else {
		document.getElementById('progress').style.width=singleIterationProgress*progressBarAtStep;
		var pc = Math.round(progressBarAtStep*100/numberOfSteps);
		if(pc == 100) pc = 99;
		document.getElementById('prcntComplete').innerHTML=pc;
	}
	progressTimer = setTimeout('progress_update()',stepInterval);
}
//stop progress
function progress_stop() {
	clearTimeout(progressTimer);
	progress_clear();
}

//
// This method dynamically draws progress bar in the place where it is invoked.
// @param numOfSteps number of steps in the progress
// @param stepInt  what is the delay between each step
// @cont if false, once progress reaches 99% it will stop (default)
// @hide if false, progress bar is visible right away (default)
// @locCmpl localized string for word "Complete"
function drawProgressBar(numOfSteps, stepInt, cont, hide, locCmpl) {
    //document.write('<table align="center"><tr><td >\n');
    if(!alreadyDrawn) {
      if(locCmpl == null) {
        locCmpl = 'Complete';
      }
    document.write('<div id="progressFrame" class="PrgOutBar">\n');
    document.write('<span id="progress" class="PrgInBar" >&nbsp; &nbsp;</span>\n');
    document.write('</div>\n');
    document.write('<div id="progressText">\n');
    document.write('<span id="prcntComplete">0</span>');
    document.write('<span id="prcntCompleteText">% ');
    document.write(locCmpl);
    document.write('</span>\n');
    document.write('</div>\n');
    document.getElementById('progressFrame').style.width=190;
    }
    alreadyDrawn = true;
    if(hide != null && hide == true) {
    	 document.getElementById('progressFrame').style.visibility='hidden';
    	 document.getElementById('progress').style.visibility='hidden';
    	 document.getElementById('progressText').style.visibility='hidden';
    document.getElementById('progressFrame').style.width=190;
	 return;
    } else {
    	 document.getElementById('progressFrame').style.visibility='visible';
    	 document.getElementById('progress').style.visibility='visible';
    	 document.getElementById('progressText').style.visibility='visible';
    document.getElementById('progressFrame').style.width=190;
    document.getElementById('progress').style.width=10;
    }
    //document.write('</td></tr></table>\n');
    if(numOfSteps == null) {
        numberOfSteps = 10;
    } else {
    	numberOfSteps = numOfSteps;
    }
    if(cont != null && cont == true) {
    	continous = cont;
    }
    if(stepInt == null) {
        stepInterval = 1000;
    } else {
        stepInterval = stepInt;
    }
    progressBarAtStep = 0;
    singleIterationProgress = 188 / numberOfSteps;
    
    progress_update();
}


