<?xml version="1.0"?>
<!--
  Author: Brian Ruff
  File: permreport.xsl	
  Date: 
  Purpose: transform lunMapData.xml into form for UI
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output encoding="UTF-8" indent="yes" method="xml"></xsl:output>
  <xsl:template match="//data">
    <xsl:copy>
      <xsl:apply-templates select="volSlice|@*"></xsl:apply-templates>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="volSlice|@*">
    <xsl:copy>
      <xsl:apply-templates select="@*"></xsl:apply-templates>
      <default>
        <xsl:value-of select="perm"></xsl:value-of>
      </default>
      <xsl:variable name="lunid" select="@id"></xsl:variable>
      <xsl:variable name="index" select="@index"></xsl:variable>
      <xsl:variable name="volwwn" select="wwn"></xsl:variable>
      <xsl:for-each select="//volGroup/volGroupMemberLUN">
        <xsl:if test="@volWWN = $volwwn">
          <volGroupName><xsl:value-of select="../@name"/></volGroupName>
        </xsl:if>
      </xsl:for-each>
      <xsl:for-each select="//lunMap[@id=$lunid]/initiator">
        <xsl:variable name="wwn" select="wwn"></xsl:variable>
        <xsl:if test="normalize-space(effective)!='none'">
          <initiator>
            <effective>
              <xsl:value-of select="effective"></xsl:value-of>
            </effective>
            <wwn>
              <xsl:value-of select="wwn"></xsl:value-of>
            </wwn>
            <xsl:for-each select="//lunGroup/wwn">
              <xsl:if test=". = $wwn">
                  <group name="{@name}">
                    <perm>
                      <xsl:value-of select="following-sibling::perm[@index=$index]"></xsl:value-of>
                    </perm>
                  </group>
              </xsl:if>
            </xsl:for-each>
          </initiator>
        </xsl:if>
      </xsl:for-each>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="*|@*|comment()|processing-instruction()|text()">
    <xsl:copy>
      <xsl:apply-templates select="*|@*|comment()|processing-instruction()|text()"></xsl:apply-templates>
    </xsl:copy>
  </xsl:template>
</xsl:stylesheet>
