/*
 * IndicationHandler.java
 *
 * Copyright (c) 2002 - 2004 WBEM Solutions, Inc. All rights reserved.
 * WBEM SOLUTIONS PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package org.wbemservices.wbem.cimom.ih;

import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.client.CIMEvent;
import javax.wbem.provider.CIMProvider;

import org.wbemservices.wbem.cimom.CommonServerSecurityContext;

/**
 * 
 * @author  jdd
 */
public interface IndicationHandler {

	/**
	 * @param event The Event to be delivered
	 * @param handler The handler to deliver the event
	 */
	public void deliverEvent(CIMEvent event, CIMInstance handler)
		throws CIMException;

	/**
	 * @param handler  The indicationHandler
	 */
	void ping(CIMInstance handler) throws CIMException;

	/**
	 * @param handler  The indicationHandler
	 */
	CommonServerSecurityContext getSecurityContext(CIMInstance handler);

	/**
	 * Get the Name of the CIM Class that 
	 */
	String getClassName();

	/**
	 * Get the CIM Provider that handles the instances for indicationhandler instances
	 *
	 */
	CIMProvider getCIMProvider();
}
