/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.taglib;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.util.MessageResources;

public class VolumeSizeDisplay
extends TagSupport {
    private String size = "";
    private MessageResources messages = null;
    private StringBuffer returnBuffer;

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public int doEndTag() throws JspTagException {
        Locale locale = Locale.getDefault();
        try {
            this.returnBuffer = new StringBuffer(1024);
            locale = this.pageContext.getRequest().getLocale();
            this.messages = (MessageResources)this.pageContext.getServletContext().getAttribute("org.apache.struts.action.MESSAGE");
            NumberFormat nf = NumberFormat.getInstance(locale);
            nf.setMinimumFractionDigits(2);
            String convertedSize = nf.format(nf.parse(Convert.bytesStringToMBOrGB((String)this.getSize())));
            String unit = this.messages.getMessage(locale, "size." + Convert.getMBOrGBString((String)this.getSize()));
            this.returnBuffer.append(convertedSize);
            this.returnBuffer.append("&nbsp;" + unit);
            this.pageContext.getOut().write(this.returnBuffer.toString());
        }
        catch (IOException ioe) {
            throw new JspTagException("Error when getting volume size " + this.getSize());
        }
        catch (ParseException pe) {
            Trace.verbose((Object)((Object)this), (String)"Parse exception trying to get volume size", (Throwable)pe);
            try {
                this.returnBuffer.append(this.messages.getMessage(locale, "storage.mgmt.volumes.unknown"));
                this.pageContext.getOut().write(this.returnBuffer.toString());
            }
            catch (IOException ioe) {
                throw new JspTagException("Error when getting volume size " + this.getSize());
            }
        }
        return 6;
    }

    public void release() {
        this.size = "";
        this.messages = null;
    }
}

