/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.taglib;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.NoSuchRaidLevelException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.TooManyCIMInstanceException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ZeroCIMInstanceReturnedException;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.DiskInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.RaidGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.util.MessageResources;

public class ArrayOverviewDisplay
extends TagSupport {
    private MessageResources messages = null;
    private static final String OUT_TABLE_START = "<table class=\"back-table\" border=\"0\" cellspacing=\"0\" cellpadding=\"1\">\n\t<tr>\n\t\t<td>\n\t\t<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"front-table\" >\n\t\t<TR>\n\t\t <TD> \t\t<div class=\"content-layout\">";
    private static final String OUT_TABLE_END = "\t\t</div>\n\t\t</TD>\n\t</TR>\n\t</TABLE>\n\t</TD>\t</TR>\t</TABLE>\n&nbsp;";
    private static final String TRAY_TABLE_START = "<TABLE BORDER=\"0\" cellpadding=\"0\" CELLSPACING=\"2\" bgcolor=\"white\" width=\"390\">\n  <tr><!--this is a row for discs-->\n";
    private static String TRAY_TABLE_END = "  </tr>\n</table>\n\n";
    private static final String TRAY_SEPARATOR = "   <table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpading=\"0\">\n       <tr>\n<td ><img src=\"images/general/dot.gif\" border=\"0\" width=\"1\" height=\"10\" alt=\"\" /></td>\n        </tr>\n       </table>\n";
    private static final String GROUPING_TABLE_START = "<td>\n <!-- cell for group --><table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n<!-- row for disk images -->\n";
    private static final String ROW_FOR_DISKS_START = "<tr>\n<td>\n   <table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\n   <tr>";
    private static final String ROW_FOR_DISKS_END = "</tr>\n</table>\n</td>\n</tr>";
    private static final String ROW_FOR_GROUP_NAME_START = "\n<!-- row for group name -->\n<tr><td>\n   <table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\n   <tr>\n";
    private static final String ROW_FOR_GROUP_NAME_END = "</tr>\n</table>\n</td>\n</tr>\n";
    private static final String GROUPING_TABLE_END = "</table>\n</td><!-- end cell for group-->";
    private static final String GROUP_NAME_LINE_START = "<td valign=\"bottom\" align=\"right\" width=\"1\" height=\"12\"><img src=\"images/vline1.jpg\"  border=\"0\" width=\"1\" height=\"12\"/></td>\n<td valign=\"bottom\" align=\"left\" width=\"50%\"><img src=\"images/line1.jpg\" width=\"100%\"  height=\"1\" border=\"0\"/></td>\n";
    private static final String GROUP_NAME_LINE_END = "<td valign=\"bottom\"  align=\"right\" width=\"50%\"><img src=\"images/line1.jpg\"  height=\"1\" width=\"100%\" border=\"0\"/></td>\n<td valign=\"bottom\" align=\"left\" width=\"1\" height=\"12\"><img src=\"images/vline1.jpg\"  border=\"0\" width=\"1\" height=\"12\"/></td>\n";
    boolean isEnabled = true;

    public boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public int doEndTag() throws JspTagException {
        String methodName = "doEndTag";
        Trace.methodBegin((Object)((Object)this), (String)"doEndTag");
        StringBuffer returnBuffer = new StringBuffer(1024);
        try {
            Locale locale = this.pageContext.getRequest().getLocale();
            this.messages = (MessageResources)this.pageContext.getServletContext().getAttribute("org.apache.struts.action.MESSAGE");
            List trayList = (List)this.pageContext.getAttribute("_TRAY_LIST", 2);
            if (trayList != null) {
                returnBuffer.append(OUT_TABLE_START);
                for (int ti = 0; ti < trayList.size(); ++ti) {
                    TrayInterface tray = (TrayInterface)trayList.get(ti);
                    Trace.verbose((Object)((Object)this), (String)"doEndTag", (String)("Iterate on Trays:" + tray.getId()));
                    this.processOneTray(returnBuffer, locale, tray, ti == trayList.size() - 1);
                }
                returnBuffer.append(OUT_TABLE_END);
            }
            this.pageContext.getOut().write(returnBuffer.toString());
        }
        catch (IOException ioe) {
            throw new JspTagException("Error when creating array overview display:" + ioe);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)((Object)this), (ConfigMgmtException)cme);
            throw new JspTagException("Error when creating array overview display:" + (Object)((Object)cme));
        }
        Trace.verbose((Object)((Object)this), (String)"doEndTag", (String)"ALL DONE CREATING ARRAY OVERVIEW!");
        return 6;
    }

    private void processOneTray(StringBuffer returnBuffer, Locale locale, TrayInterface tray, boolean lastTray) throws ConfigMgmtException, TooManyCIMInstanceException, ZeroCIMInstanceReturnedException {
        List diskList = tray.getDiskList();
        DiskInterface[] diskMap = this.createDiskMap(diskList);
        List raidSetList = tray.getRaidGroups();
        int numberOfRaidSets = 0;
        int[] raidSetDiskStart = null;
        int[] raidSetDiskEnd = null;
        if (raidSetList != null) {
            numberOfRaidSets = raidSetList.size();
            raidSetDiskStart = new int[numberOfRaidSets];
            raidSetDiskEnd = new int[numberOfRaidSets];
            for (int i = 0; i < numberOfRaidSets; ++i) {
                RaidGroupInterface rg = (RaidGroupInterface)raidSetList.get(i);
                raidSetDiskStart[i] = rg.getBeginDiskNumber();
                raidSetDiskEnd[i] = rg.getEndDiskNumber();
            }
        }
        int numberOfDrives = tray.getNumberOfDrives();
        returnBuffer.append(TRAY_TABLE_START);
        this.createHTMLForTray(returnBuffer, locale, tray.getT4Name(), diskMap, raidSetList, numberOfRaidSets, raidSetDiskStart, raidSetDiskEnd);
        this.createTrayIcon(returnBuffer, tray, locale);
        returnBuffer.append(TRAY_TABLE_END);
        returnBuffer.append(TRAY_SEPARATOR);
    }

    private DiskInterface[] createDiskMap(List diskList) {
        DiskInterface[] diskMap = new DiskInterface[14];
        Iterator di = diskList.iterator();
        while (di.hasNext()) {
            DiskInterface disk = (DiskInterface)di.next();
            Trace.verbose((Object)((Object)this), (String)"createDiskMap", (String)("Slot number for disk is:" + disk.getSlotNumber()));
            diskMap[disk.getSlotNumber() - 1] = disk;
        }
        return diskMap;
    }

    private void createHTMLForTray(StringBuffer returnBuffer, Locale locale, String t4name, DiskInterface[] diskMap, List raidSetList, int numberOfRaidSets, int[] raidSetDiskStart, int[] raidSetDiskEnd) throws ConfigMgmtException {
        String methodName = "createHTMLForTray";
        RaidGroupInterface currentRS = null;
        boolean groupTableStarted = false;
        int groupTableStartIndex = 0;
        int groupTableEndIndex = 0;
        for (int i = 0; i < 14; ++i) {
            if (diskMap[i] != null) {
                DiskInterface cd = diskMap[i];
                if (cd.getRole() != null && ("globalStandbyDisk".equals(cd.getRole()) || "standbyDisk".equals(cd.getRole()) || "standbyDiskShared".equals(cd.getRole()))) {
                    if (currentRS != null || i > 0 && diskMap[i - 1] != null && "unassigned".equals(diskMap[i - 1].getRole())) {
                        groupTableEndIndex = i - 1;
                        this.endGroupTable(returnBuffer, t4name, currentRS, diskMap[i - 1], locale, groupTableEndIndex - groupTableStartIndex);
                        groupTableStarted = false;
                        currentRS = null;
                    }
                } else if ("dataDisk".equals(cd.getRole())) {
                    if (currentRS == null || !currentRS.getName().equals(cd.getRaidGroupName())) {
                        if (groupTableStarted) {
                            groupTableEndIndex = i - 1;
                            this.endGroupTable(returnBuffer, t4name, currentRS, diskMap[i - 1], locale, groupTableEndIndex - groupTableStartIndex);
                            groupTableStarted = false;
                        }
                        if ((currentRS = this.findCurrentRS(raidSetList, cd.getRaidGroupName(), numberOfRaidSets)) != null) {
                            groupTableStartIndex = i;
                            returnBuffer.append(GROUPING_TABLE_START);
                            returnBuffer.append(ROW_FOR_DISKS_START);
                            groupTableStarted = true;
                        }
                    }
                } else if ("unassigned".equals(cd.getRole())) {
                    if (currentRS != null) {
                        groupTableEndIndex = i - 1;
                        this.endGroupTable(returnBuffer, t4name, currentRS, diskMap[i - 1], locale, groupTableEndIndex - groupTableStartIndex);
                        currentRS = null;
                        groupTableStarted = false;
                    }
                    if (!groupTableStarted) {
                        returnBuffer.append(GROUPING_TABLE_START);
                        returnBuffer.append(ROW_FOR_DISKS_START);
                        groupTableStarted = true;
                        groupTableStartIndex = i;
                    }
                }
                returnBuffer.append("       <td bgcolor=\"white\" align=\"center\" valign=\"top\" nowrap>\n");
                this.createDiskIcon(returnBuffer, locale, raidSetList, currentRS, diskMap[i], t4name);
                returnBuffer.append("       </td>");
                continue;
            }
            if (groupTableStarted) {
                groupTableEndIndex = i - 1;
                this.endGroupTable(returnBuffer, t4name, currentRS, diskMap[i - 1], locale, groupTableEndIndex - groupTableStartIndex);
                groupTableStarted = false;
                currentRS = null;
            }
            returnBuffer.append("<td width=\"21\" bgcolor=\"white\" valign=\"top\"><img src=\"images/icons/no_disk.jpg\" border=\"0\" width=\"21\" height=\"79\" alt=\"");
            returnBuffer.append(this.messages.getMessage(locale, "storage.mgmt.array.overview.no.disk"));
            returnBuffer.append("\" title=\"");
            returnBuffer.append(this.messages.getMessage(locale, "storage.mgmt.array.overview.no.disk"));
            returnBuffer.append("\"/></td>");
        }
        if (groupTableStarted) {
            groupTableEndIndex = 13;
            this.endGroupTable(returnBuffer, t4name, currentRS, diskMap[13], locale, groupTableEndIndex - groupTableStartIndex);
            currentRS = null;
        }
    }

    private RaidGroupInterface findCurrentRS(List raidSetList, String rsToFind, int listSize) {
        RaidGroupInterface rs = null;
        if (rsToFind != null && raidSetList != null) {
            boolean found = false;
            for (int i = 0; i < listSize && !found; ++i) {
                rs = (RaidGroupInterface)raidSetList.get(i);
                if (!rsToFind.equals(rs.getName())) continue;
                found = true;
            }
            if (!found) {
                rs = null;
            }
        }
        return rs;
    }

    private void endGroupTable(StringBuffer returnBuffer, String t4name, RaidGroupInterface currentRS, DiskInterface disk, Locale locale, int numOfDisksInGroup) throws ConfigMgmtException {
        returnBuffer.append(ROW_FOR_DISKS_END);
        returnBuffer.append(ROW_FOR_GROUP_NAME_START);
        returnBuffer.append(GROUP_NAME_LINE_START);
        returnBuffer.append("<td align=\"center\" valign=\"bottom\">");
        if (disk != null) {
            if (disk.getRole().equals("unassigned") && numOfDisksInGroup >= 1) {
                if (disk.getStatus() == 2 && this.isEnabled) {
                    returnBuffer.append("<a href=\"javascript:createPoolOnTray(");
                    returnBuffer.append(disk.getTrayId());
                    returnBuffer.append(");\" title=\"");
                    returnBuffer.append(this.messages.getMessage("button.create", (Object)locale));
                    returnBuffer.append("\">");
                }
                if (numOfDisksInGroup > 2) {
                    returnBuffer.append(this.messages.getMessage("storage.mgmt.array.overview.unassigned", (Object)locale));
                } else {
                    returnBuffer.append("U...");
                }
                if (disk.getStatus() == 2 && this.isEnabled) {
                    returnBuffer.append("</a>");
                }
            } else if (disk.getRole().equals("unassigned") && numOfDisksInGroup <= 2) {
                returnBuffer.append("U..");
            } else if (disk.getRole().equals("dataDisk")) {
                this.createPoolLink(returnBuffer, t4name, currentRS, disk, locale);
            } else {
                returnBuffer.append("&nbsp;");
            }
        } else {
            returnBuffer.append("&nbsp;");
        }
        returnBuffer.append("</td>\n");
        returnBuffer.append(GROUP_NAME_LINE_END);
        returnBuffer.append(ROW_FOR_GROUP_NAME_END);
        returnBuffer.append(GROUPING_TABLE_END);
    }

    private void createPoolLink(StringBuffer returnBuffer, String t4name, RaidGroupInterface currentRS, DiskInterface disk, Locale locale) throws ConfigMgmtException, NoSuchRaidLevelException, ZeroCIMInstanceReturnedException {
        returnBuffer.append("<script>\nvar ").append(disk.getName());
        returnBuffer.append("_p=").append("'").append(currentRS.getName());
        returnBuffer.append("';\n</script>");
        returnBuffer.append("<a href=\"javascript:void(0);\" onClick=\"return overlib(' ");
        returnBuffer.append(this.messages.getMessage(locale, "pools.table.name"));
        returnBuffer.append(": ");
        returnBuffer.append("<a href=\\'root.menu.item0.item2pooldetails.do?name=");
        returnBuffer.append(currentRS.getName());
        returnBuffer.append("&t4Name=");
        returnBuffer.append(t4name);
        returnBuffer.append("\\'>");
        returnBuffer.append(currentRS.getName());
        returnBuffer.append("</a>");
        returnBuffer.append("<br>");
        returnBuffer.append(this.messages.getMessage(locale, "pools.table.raid"));
        returnBuffer.append(": ");
        returnBuffer.append(currentRS.getRaidLevel());
        returnBuffer.append("<br>");
        returnBuffer.append(this.messages.getMessage(locale, "pools.table.profile"));
        returnBuffer.append(": ");
        returnBuffer.append(currentRS.getProfileName());
        returnBuffer.append("<br>");
        returnBuffer.append(this.messages.getMessage(locale, "pools.table.available"));
        returnBuffer.append(": ");
        returnBuffer.append("<br>");
        returnBuffer.append(this.messages.getMessage(locale, "pools.table.total"));
        returnBuffer.append(": ");
        returnBuffer.append("<br>");
        returnBuffer.append(this.messages.getMessage(locale, "pools.table.status"));
        returnBuffer.append(": ");
        returnBuffer.append(this.messages.getMessage(locale, "storage.mgmt.pool.status." + currentRS.getStatus()));
        returnBuffer.append("<br>");
        returnBuffer.append(this.messages.getMessage(locale, "pools.table.state"));
        returnBuffer.append(": ");
        returnBuffer.append(this.messages.getMessage(locale, "storage.mgmt.pool.state." + currentRS.getState()));
        returnBuffer.append("<br>");
        if (this.isEnabled) {
            returnBuffer.append(this.messages.getMessage(locale, "storage.mgmt.array.overview.action"));
            returnBuffer.append(":<BR>&nbsp;&nbsp;");
            returnBuffer.append("<a href=\\'root.menu.item0.item2poolsdelete.do?name=");
            returnBuffer.append(disk.getRaidGroupName());
            returnBuffer.append("&t4Name=");
            returnBuffer.append(t4name);
            returnBuffer.append("&comingFrom=arrayoverview");
            returnBuffer.append("\\'>");
            returnBuffer.append(this.messages.getMessage(locale, "storage.mgmt.array.overview.action.delpool"));
            returnBuffer.append("</a>");
            returnBuffer.append("<BR>&nbsp;&nbsp;");
            returnBuffer.append("<a href=\\'javascript:void(0)\\' onClick=\\'createVolumeOnPool(");
            returnBuffer.append(disk.getName());
            returnBuffer.append("_p)\\'>");
            returnBuffer.append(this.messages.getMessage(locale, "storage.mgmt.array.overview.action.newvol"));
            returnBuffer.append("</a>");
        }
        returnBuffer.append("', STICKY, CAPTION, ");
        returnBuffer.append("'");
        returnBuffer.append(this.messages.getMessage(locale, "pool.details.crumb"));
        returnBuffer.append("', RIGHT, CLOSECLICK);\" >");
        returnBuffer.append(disk.getRaidGroupName());
        returnBuffer.append("</a>");
    }

    private void createTrayIcon(StringBuffer returnBuffer, TrayInterface tray, Locale locale) throws ConfigMgmtException {
        returnBuffer.append("<td align=\"right\" valign=\"top\" bgcolor=\"white\" nowrap>\n");
        this.createTrayLinkForOverLib(returnBuffer, locale, tray);
        String trayType = "controller";
        if (tray.getTrayType() == 18) {
            trayType = "expansion";
        }
        this.createTrayIconImg(returnBuffer, locale, trayType);
        returnBuffer.append("</a>\n");
        returnBuffer.append("</td>\n");
    }

    private void createTrayIconImg(StringBuffer returnBuffer, Locale locale, String trayType) {
        returnBuffer.append("<img src=\"images/icons/");
        returnBuffer.append(trayType);
        returnBuffer.append(".gif\" border=\"0\" alt=\"");
        returnBuffer.append(this.messages.getMessage(locale, "storage.mgmt.array.overview." + trayType));
        returnBuffer.append("; ");
        returnBuffer.append(this.messages.getMessage(locale, "storage.mgmt.array.overview.ClickToSeeDetails"));
        returnBuffer.append("\" title=\"");
        returnBuffer.append(this.messages.getMessage(locale, "storage.mgmt.array.overview." + trayType));
        returnBuffer.append("; ");
        returnBuffer.append(this.messages.getMessage(locale, "storage.mgmt.array.overview.ClickToSeeDetails"));
        returnBuffer.append("\" width=\"51\" height=\"79\">\n");
    }

    private void createTrayLinkForOverLib(StringBuffer returnBuffer, Locale locale, TrayInterface tray) throws ConfigMgmtException {
        returnBuffer.append("<a href=\"javascript:void(0);\" onClick=\"return overlib(' ");
        returnBuffer.append(this.messages.getMessage(locale, "tray.table.id"));
        returnBuffer.append(": <a href=\\'root.menu.item0.item0trayedit.do?");
        returnBuffer.append("t4Name");
        returnBuffer.append("=").append(tray.getT4Name());
        returnBuffer.append("&");
        returnBuffer.append("name");
        returnBuffer.append("=");
        returnBuffer.append(tray.getId()).append("\\'>");
        returnBuffer.append(tray.getId()).append("</a><br> ");
        returnBuffer.append(this.messages.getMessage(locale, "tray.table.type"));
        returnBuffer.append(": ");
        String trayType = "tray.type." + tray.getTrayType();
        returnBuffer.append(this.messages.getMessage(locale, trayType)).append("<br>");
        returnBuffer.append(this.messages.getMessage(locale, "tray.table.role")).append(": ");
        returnBuffer.append(this.messages.getMessage(locale, "tray.role." + tray.getRole())).append("<br> ");
        returnBuffer.append(this.messages.getMessage(locale, "tray.table.state")).append(": ");
        returnBuffer.append(this.messages.getMessage(locale, "tray.state." + tray.getState())).append("<br> ");
        returnBuffer.append(this.messages.getMessage(locale, "tray.table.status")).append(": ");
        returnBuffer.append(this.messages.getMessage(locale, "tray.status." + tray.getStatus()));
        if (tray.getStatus() != "offline") {
            this.linkToStorADE(returnBuffer, locale);
        }
        returnBuffer.append("', STICKY, CAPTION, ");
        returnBuffer.append("'");
        returnBuffer.append(this.messages.getMessage(locale, "storage.mgmt.system.tray.details.section"));
        returnBuffer.append("', RIGHT, CLOSECLICK);\" >");
    }

    private void createDiskIcon(StringBuffer returnBuffer, Locale locale, List raidSetList, RaidGroupInterface currentRS, DiskInterface disk, String t4name) throws ConfigMgmtException {
        returnBuffer.append("<a href=\"javascript:void(0);\" onClick=\"");
        this.createLinkForOverLib(returnBuffer, locale, currentRS, disk, t4name, raidSetList);
        returnBuffer.append("<img src=\"images/icons/");
        String key = "";
        if (disk.getState().equals("substituted")) {
            returnBuffer.append("d_substituted.gif\" ");
            key = "disk.state.substituted";
        } else if (disk.getState().equals("disabled")) {
            returnBuffer.append("d_offline.gif\" ");
            key = "disk.status." + disk.getStatus();
        } else if (disk.getRole().equals("dataDisk")) {
            returnBuffer.append("d_pool.gif\" ");
            key = "disk.role.dataDisk";
        } else if (disk.getRole().equals("unassigned")) {
            returnBuffer.append("d_unassigned.gif\" ");
            key = "disk.role.unassigned";
        } else if (disk.getRole().equals("globalStandbyDisk")) {
            returnBuffer.append("d_arrayhs.gif\" ");
            key = "disk.role.arrayspare";
        } else if (disk.getRole().equals("standbyDisk")) {
            returnBuffer.append("d_dedicatedhs.gif\" ");
            key = "disk.role.dedicatedspare";
        } else if (disk.getRole().equals("standbyDiskShared")) {
            returnBuffer.append("d_hs.gif\" ");
            key = "disk.role.standbyDiskShared";
        } else {
            returnBuffer.append("x");
        }
        returnBuffer.append(" title=\"");
        returnBuffer.append(this.messages.getMessage(locale, key)).append(" ");
        returnBuffer.append(this.messages.getMessage(locale, "storage.mgmt.array.overview.ClickToSeeDetails"));
        returnBuffer.append("\" border=\"1\" alt=\"");
        returnBuffer.append(this.messages.getMessage(locale, key));
        returnBuffer.append("\"  width=\"20\" height=\"79\" >");
        returnBuffer.append("</a>\n");
    }

    private void createLinkForOverLib(StringBuffer returnBuffer, Locale locale, RaidGroupInterface currentRS, DiskInterface disk, String t4name, List raidSetList) throws ConfigMgmtException {
        returnBuffer.append("return overlib(' ");
        returnBuffer.append(this.messages.getMessage(locale, "report.disk.title"));
        returnBuffer.append(": ");
        returnBuffer.append(disk.getName());
        returnBuffer.append("<br> ");
        returnBuffer.append(this.messages.getMessage(locale, "report.disk.capacity.label"));
        returnBuffer.append(": ");
        if (disk.getRole().equals("unassigned") && disk.getStatus() == 2) {
            returnBuffer.append("<br> ");
            returnBuffer.append(this.messages.getMessage(locale, "storage.mgmt.volumes.pool"));
            returnBuffer.append(": ");
            if (this.isEnabled) {
                returnBuffer.append("<a href=\\'javascript:createPoolOnTray(");
                returnBuffer.append(disk.getTrayId()).append(")\\'>");
                returnBuffer.append(this.messages.getMessage(locale, "storage.mgmt.array.overview.nopoolcreate"));
                returnBuffer.append("</a>");
            } else {
                returnBuffer.append(this.messages.getMessage(locale, "storage.mgmt.array.overview.nopool"));
            }
        } else if (disk.getRole().equals("dataDisk") || disk.getRole().equals("standbyDisk") || disk.getRole().equals("standbyDiskShared")) {
            returnBuffer.append("<br> ");
            returnBuffer.append(this.messages.getMessage(locale, "storage.mgmt.volumes.pool"));
            String rsName = disk.getRaidGroupName();
            if (disk.getRole().equals("standbyDiskShared")) {
                rsName = "";
                for (int rsi = 0; raidSetList != null && rsi < raidSetList.size(); ++rsi) {
                    rsName = ((RaidGroupInterface)raidSetList.get(rsi)).getName();
                    this.diskPoolLink(returnBuffer, t4name, rsName);
                }
            } else {
                this.diskPoolLink(returnBuffer, t4name, rsName);
            }
        }
        returnBuffer.append("<br> ");
        returnBuffer.append(this.messages.getMessage(locale, "report.disk.role.label"));
        returnBuffer.append(": ");
        returnBuffer.append(this.messages.getMessage(locale, "disk.role." + disk.getRole()));
        returnBuffer.append("<br> ");
        returnBuffer.append(this.messages.getMessage(locale, "report.disk.status.label")).append(": ");
        returnBuffer.append(this.messages.getMessage(locale, "disk.status." + disk.getStatus()));
        returnBuffer.append("<br> ");
        returnBuffer.append(this.messages.getMessage(locale, "report.disk.state.label")).append(": ");
        returnBuffer.append(this.messages.getMessage(locale, "disk.state." + disk.getState()));
        if (disk.getState().equals("substituted") && disk.getSubstitutedBy() != null && !disk.getSubstitutedBy().trim().equals("")) {
            returnBuffer.append("<br>");
            returnBuffer.append(this.messages.getMessage(locale, "disk.substitutedby"));
            returnBuffer.append(disk.getSubstitutedBy());
        }
        if (disk.getStatus() != 2) {
            this.linkToStorADE(returnBuffer, locale);
        }
        returnBuffer.append("', STICKY, CAPTION, ");
        returnBuffer.append("'");
        returnBuffer.append(this.messages.getMessage(locale, "storage.mgmt.array.overview.diskdetails"));
        returnBuffer.append("', ");
        returnBuffer.append(" RIGHT, CLOSECLICK );\">");
    }

    private void diskPoolLink(StringBuffer returnBuffer, String t4name, String rsName) {
        returnBuffer.append(": <a href=\\'root.menu.item0.item2pooldetails.do?name=");
        returnBuffer.append(rsName);
        returnBuffer.append("&t4Name=");
        returnBuffer.append(t4name);
        returnBuffer.append("\\'>");
        returnBuffer.append(rsName);
        returnBuffer.append("</a>");
    }

    private void linkToStorADE(StringBuffer returnBuffer, Locale locale) {
        if (Repository.getRepository().getConfigInteger() == 3) {
            returnBuffer.append("<br>");
            returnBuffer.append("<a href=\\'");
            HttpSession session = this.pageContext.getSession();
            returnBuffer.append(session.getAttribute("SADE"));
            returnBuffer.append("\\' target=\\'_blank\\'>");
            returnBuffer.append(this.messages.getMessage(locale, "storage.mgmt.array.overview.diagnose"));
            returnBuffer.append("</a>");
        }
    }
}

