/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.forms;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.ui.forms.Pageable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Pager
implements Pageable {
    private static final int UNSET = -1;
    ArrayList page;
    List list;
    int pageCount = -1;
    int currentPage = -1;
    int offset = 0;
    int limit = -1;
    int pageLastEntry = -1;

    public Pager(List list, int limit) {
        this.list = list;
        this.limit = limit;
        if (list.size() > 0) {
            this.offset = 1;
        }
    }

    public int getCurrentPage() {
        if (-1 == this.currentPage) {
            this.currentPage = this.offset / this.getLimit() + 1;
        }
        return this.currentPage;
    }

    public int getPageCount() {
        if (-1 == this.pageCount) {
            this.pageCount = this.list.size() / this.limit;
            if (this.list.size() % this.limit > 0) {
                ++this.pageCount;
            }
        }
        return this.pageCount;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
        this.pageCount = -1;
    }

    public Collection getCollection() {
        if (null == this.page) {
            this.page = new ArrayList();
            for (int i = this.offset - 1; i < this.getPageLastEntry(); ++i) {
                this.page.add(this.list.get(i));
            }
        }
        return this.page;
    }

    public int getPageLastEntry() {
        if (-1 == this.pageLastEntry) {
            this.pageLastEntry = this.getOffset() + this.getLimit() - 1;
            if (this.pageLastEntry > this.list.size()) {
                this.pageLastEntry = this.list.size();
            }
        }
        return this.pageLastEntry;
    }

    public void advance() {
        if (this.getCanAdvance()) {
            this.offset += this.limit;
            this.clearCalculatedValues();
        }
    }

    public void clearCalculatedValues() {
        this.pageLastEntry = -1;
        this.page = null;
        this.currentPage = -1;
    }

    public boolean getCanAdvance() {
        return this.list.size() > this.getPageLastEntry();
    }

    public void setPageNumber(int pageNumber) {
        Trace.methodBegin((Object)this, (String)"setPageNumber");
        Trace.verbose((Object)this, (String)"setPageNumber", (String)("pageNumber=" + pageNumber));
        Trace.verbose((Object)this, (String)"setPageNumber", (String)("pageCount=" + this.getPageCount()));
        if (pageNumber > this.getPageCount()) {
            pageNumber = this.pageCount;
        }
        if (pageNumber < 0) {
            pageNumber = 0;
        }
        this.offset = (pageNumber - 1) * this.getLimit() + 1;
        Trace.verbose((Object)this, (String)"setPageNumber", (String)("offset=" + this.getOffset()));
        this.clearCalculatedValues();
    }

    public int getNextPageNumber() {
        if (this.getCurrentPage() == this.getPageCount()) {
            return this.getPageCount();
        }
        return this.getCurrentPage() + 1;
    }

    public int getPreviousPageNumber() {
        if (this.getCurrentPage() == 1) {
            return 1;
        }
        return this.getCurrentPage() - 1;
    }

    public int getSize() {
        return this.list.size();
    }
}

