/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.forms;

import com.sun.netstorage.array.mgmt.cfg.bui.utilities.Validate;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.ui.core.data.OptionsData;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.cfg.util.TimeZoneUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class AdminSystemTimeForm
extends ActionForm {
    private static final int MILLIS_PER_HOUR = 3600000;
    private TimeZone currentTimeZone;
    private List timeZones;
    private String timeZoneOffset;
    private String timeZoneOffsetString;
    private String currentTimeZoneName;
    private String timeZoneID;
    private String ntpServerIp;
    private String time;
    private String currentTime;
    private Boolean useNTPServer;
    private String month;
    private String day;
    private String year;
    private Date dateTime;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$ui$forms$AdminSystemTimeForm;

    public TimeZone getCurrentTimeZone() {
        return this.currentTimeZone;
    }

    public String getNtpServerIp() {
        return this.ntpServerIp;
    }

    public String getTime() {
        return this.time;
    }

    public void setCurrentTimeZone(TimeZone currentTimeZone) {
        this.currentTimeZone = currentTimeZone;
    }

    public void setCurrentTimeZone(TimeZone currentTimeZone, HttpServletRequest request, Locale userLocale) {
        Trace.methodBegin((Class)(class$com$sun$netstorage$array$mgmt$cfg$ui$forms$AdminSystemTimeForm == null ? (class$com$sun$netstorage$array$mgmt$cfg$ui$forms$AdminSystemTimeForm = AdminSystemTimeForm.class$("com.sun.netstorage.array.mgmt.cfg.ui.forms.AdminSystemTimeForm")) : class$com$sun$netstorage$array$mgmt$cfg$ui$forms$AdminSystemTimeForm), (String)"setCurrentTimeZone");
        ResourceBundle rb = this.getTimezoneResourceBundle(userLocale);
        this.currentTimeZone = currentTimeZone;
        this.timeZoneID = currentTimeZone.getID();
        try {
            this.setCurrentTimeZoneName(rb.getString(currentTimeZone.getID()));
        }
        catch (Exception ex) {
            Trace.verbose((Object)((Object)this), (String)"setCurrentTimeZone", (String)"Unable to get localized current timezone string");
        }
        this.setTimeZoneOffset(request, TimeZoneUtil.getGMTOffsetFromRawOffset((int)currentTimeZone.getRawOffset()));
        Trace.verbose((Object)((Object)this), (String)"setCurrentTimeZone", (String)("Offset:" + currentTimeZone.getRawOffset()));
    }

    public void setNtpServerIp(String ntpServerIp) {
        this.ntpServerIp = ntpServerIp;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public Boolean getUseNTPServer() {
        return this.useNTPServer;
    }

    public void setUseNTPServer(Boolean useNTPServer) {
        this.useNTPServer = useNTPServer;
    }

    public String getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(String currentTime) {
        this.currentTime = currentTime;
    }

    public String getDay() {
        return this.day;
    }

    public String getMonth() {
        return this.month;
    }

    public String getYear() {
        return this.year;
    }

    public void setDay(String day) {
        this.day = day;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public Date getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(Date dateTime, TimeZone zone, Locale userLocale) {
        this.dateTime = dateTime;
        Trace.verbose((Object)((Object)this), (String)"setDateTime", (String)("datetime is " + dateTime));
        Trace.verbose((Object)((Object)this), (String)"setDateTime", (String)("timezone is " + zone));
        Trace.verbose((Object)((Object)this), (String)"setDateTime", (String)("default timezone is " + TimeZone.getDefault()));
        Trace.verbose((Object)((Object)this), (String)"setDateTime", (String)("formated datetime is " + Convert.timeToString((Date)dateTime, (TimeZone)TimeZone.getDefault(), (int)3, (Locale)userLocale)));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateTime);
        calendar.setTimeZone(zone);
        this.setYear(Integer.toString(calendar.get(1)));
        this.setDay(Integer.toString(calendar.get(5)));
        this.setMonth(Integer.toString(calendar.get(2) + 1));
        this.setTime(Convert.timeToString((Date)dateTime, (TimeZone)zone, (int)3, (Locale)userLocale));
        this.setCurrentTime(Convert.dateTimeToString((Date)dateTime, (TimeZone)zone, (int)2, (Locale)userLocale));
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        String action = request.getParameter("action");
        if ("save".equals(action)) {
            ActionErrors errors = new ActionErrors();
            if (this.useNTPServer.booleanValue() && (this.ntpServerIp == null || this.ntpServerIp.length() == 0)) {
                errors.add("ntpServerIp", new ActionError("error.admin.systemtime.ntpserverrequired"));
            } else if (!this.useNTPServer.booleanValue()) {
                try {
                    int intYear = Integer.parseInt(this.year);
                    if (intYear < 1970) {
                        errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.admin.systemtime.yearBefore1970"));
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (!Validate.dateFields((String)this.year, (String)this.month, (String)this.day)) {
                    errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.admin.systemtime.dateformat"));
                }
                if (!Validate.timeString((String)this.time, (int)3, (Locale)request.getLocale())) {
                    errors.add("time", new ActionError("error.admin.systemtime.timeformat"));
                }
            }
            return errors;
        }
        return null;
    }

    public String getCurrentTimeZoneName() {
        return this.currentTimeZoneName;
    }

    public void setCurrentTimeZoneName(String currentTimeZoneName) {
        this.currentTimeZoneName = currentTimeZoneName;
    }

    public String getTimeZoneOffset() {
        return this.timeZoneOffset;
    }

    public String getLocalizedTimeZoneOffsetKey() {
        String offset = this.getTimeZoneOffset();
        if (offset != null) {
            return "timezone.offset." + offset.toLowerCase();
        }
        return "timezone.offset." + offset;
    }

    public void setTimeZoneOffset(String timeZoneOffset) {
        this.timeZoneOffset = timeZoneOffset;
    }

    public void setTimeZoneOffset(HttpServletRequest request, String timeZoneOffset) {
        this.timeZoneOffset = timeZoneOffset;
        String[] newZones = "all".equals(timeZoneOffset) ? TimeZone.getAvailableIDs() : TimeZoneUtil.getTimeZoneIDsForOffset((int)TimeZoneUtil.getRawOffsetFromGMTOffset((String)timeZoneOffset));
        Locale userLocale = request.getLocale();
        ResourceBundle rb = this.getTimezoneResourceBundle(userLocale);
        Vector<String> newZonesVector = new Vector<String>();
        Vector<String> zoneVector = new Vector<String>();
        for (int i = 0; i < newZones.length; ++i) {
            try {
                zoneVector.add(rb.getString(newZones[i]));
                newZonesVector.add(newZones[i]);
                continue;
            }
            catch (Exception ex) {
                Trace.verbose((Object)((Object)this), (String)"setTimeZoneOffset", (String)("Unable to get localized timezone string - " + newZones[i] + "; don't add to list"));
            }
        }
        String[] newZonesDisplayStrings = new String[zoneVector.size()];
        newZones = new String[newZonesVector.size()];
        zoneVector.toArray(newZonesDisplayStrings);
        newZonesVector.toArray(newZones);
        List timeZones = OptionsData.createSortedOptionsDataCollection((String[])newZones, (String[])newZonesDisplayStrings);
        request.setAttribute("CurrentTimeZones", (Object)timeZones);
    }

    public String getTimeZoneOffsetString() {
        return this.timeZoneOffsetString;
    }

    public void setTimeZoneOffsetString(String timeZoneOffsetString) {
        this.timeZoneOffsetString = timeZoneOffsetString;
    }

    public String getTimeZoneID() {
        return this.timeZoneID;
    }

    public void setTimeZoneID(String timeZoneID) {
        this.timeZoneID = timeZoneID;
        this.currentTimeZone = TimeZone.getTimeZone(timeZoneID);
    }

    public List getTimeZones() {
        return this.timeZones;
    }

    public void setTimeZones(List timeZones) {
        this.timeZones = timeZones;
    }

    private ResourceBundle getTimezoneResourceBundle(Locale locale) {
        if (locale != null && locale.toString().indexOf("zh") != -1) {
            locale = new Locale("zh", "CN");
        }
        String resourceFileName = "TimeZoneDisplayStrings";
        if (Repository.getRepository().getConfigInteger() != 3) {
            resourceFileName = "TimeZoneDisplayStrings_m1m2";
        }
        ResourceBundle rb = ResourceBundle.getBundle(resourceFileName, locale);
        return rb;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("FORM DUMP: AdminSystemTimeForm\n\t");
        result.append("currentTimeZone:");
        result.append(this.currentTimeZone);
        result.append("\n\t");
        result.append("timeZones:");
        result.append(this.timeZones);
        result.append("\n\t");
        result.append("timeZoneOffset:");
        result.append(this.timeZoneOffset);
        result.append("\n\t");
        result.append("timeZoneOffsetString:");
        result.append(this.timeZoneOffsetString);
        result.append("\n\t");
        result.append("currentTimeZoneName:");
        result.append(this.currentTimeZoneName);
        result.append("\n\t");
        result.append("timeZoneID:");
        result.append(this.timeZoneID);
        result.append("\n\t");
        result.append("ntpServerIp:");
        result.append(this.ntpServerIp);
        result.append("\n\t");
        result.append("time:");
        result.append(this.time);
        result.append("\n\t");
        result.append("currentTime:");
        result.append(this.currentTime);
        result.append("\n\t");
        result.append("useNTPServer:");
        result.append(this.useNTPServer);
        result.append("\n\t");
        result.append("month:");
        result.append(this.month);
        result.append("\n\t");
        result.append("day:");
        result.append(this.day);
        result.append("\n\t");
        result.append("year:");
        result.append(this.year);
        result.append("\n\t");
        result.append("dateTime:");
        result.append(this.dateTime);
        result.append("\nFORM DUMP COMPLETE!\n");
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

