/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.ui.core.ini;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ConfigServlet
extends HttpServlet {
    private static final String CIM_NAMESPACE = "cim-namespace";
    private static final String CIM_HOST = "cim-host";
    private static final String CONFIG_TYPE = "config-type";
    private static final String ENVIRONMENT = "environment";
    private static final String USERS_PATH = "user-properties-path";
    private static Vector fixedProperties = new Vector();

    public void init() throws ServletException {
        Trace.methodBegin((Object)((Object)this), (String)"init");
        this.fillFixedProp();
        Repository rep = Repository.getRepository();
        Enumeration en = this.getServletConfig().getInitParameterNames();
        String prop = "";
        String key = "";
        while (en.hasMoreElements()) {
            key = (String)en.nextElement();
            prop = this.getServletConfig().getInitParameter(key);
            if (fixedProperties.contains(key)) {
                this.setFixedPropToRepository(key, prop, rep);
                continue;
            }
            rep.setProperty((Object)key, (Object)prop);
        }
        rep.setProperty((Object)"ActiveUsersListProperty", new ArrayList());
    }

    private void fillFixedProp() {
        fixedProperties.add(CIM_NAMESPACE);
        fixedProperties.add(CIM_HOST);
        fixedProperties.add(CONFIG_TYPE);
        fixedProperties.add(ENVIRONMENT);
        fixedProperties.add(USERS_PATH);
    }

    private void setFixedPropToRepository(String key, String prop, Repository rep) {
        if (key.equals(CIM_NAMESPACE)) {
            Trace.verbose((Object)((Object)this), (String)"init", (String)("Set cim namespace to:" + prop));
            rep.setNameSpace(prop);
        } else if (key.equals(CIM_HOST)) {
            Trace.verbose((Object)((Object)this), (String)"init", (String)("Set cim host to:" + prop));
            rep.setHostName(prop);
        } else if (key.equals(CONFIG_TYPE)) {
            Trace.verbose((Object)((Object)this), (String)"init", (String)("Set config-type to:" + prop));
            rep.setConfigValue(prop);
        } else if (key.equals(USERS_PATH)) {
            Trace.verbose((Object)((Object)this), (String)"init", (String)("Set user-properties-path to:" + prop));
            rep.setUsersPath(prop);
        } else if (key.equals(ENVIRONMENT)) {
            Trace.verbose((Object)((Object)this), (String)"init", (String)("Set environment to:" + prop));
            if (prop.equals("test")) {
                rep.setTestEnvironment(true);
            } else {
                rep.setTestEnvironment(false);
            }
        }
    }

    private boolean isLocal(String clientAddress) {
        InetAddress localhost = null;
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            Trace.verbose((Object)((Object)this), (String)"isLocal", (String)"Exception while trying to get localhost address");
            return false;
        }
        Trace.verbose((Object)((Object)this), (String)"isLocal", (String)("Client: " + clientAddress));
        if (localhost.getHostAddress().equals(clientAddress) || "127.0.0.1".equals(clientAddress)) {
            Trace.verbose((Object)((Object)this), (String)"isLocal", (String)"client is local");
            return true;
        }
        Trace.verbose((Object)((Object)this), (String)"isLocal", (String)"client is NOT local");
        return false;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) {
        String logLevel = req.getParameter("loglevel");
        Trace.verbose((Object)((Object)this), (String)"doGet", (String)("Set log level to:" + logLevel));
        try {
            if (!this.isLocal(req.getRemoteAddr())) {
                String str = "Client not on local host!";
                int rc = 403;
                res.sendError(rc, str);
                return;
            }
            if (Trace.setLogLevel((String)logLevel) != null) {
                res.setContentType("text/html");
                PrintWriter out = res.getWriter();
                out.println("<html>");
                out.println("<head>");
                out.println("<title>Change Log Level</title>");
                out.println("</head>");
                out.println("<body bgcolor=\"white\">");
                out.println("<h1> Log level changed to " + logLevel.toUpperCase() + " </h1>");
                out.println("</body>");
                out.println("</html>");
            } else {
                String str = "Invalid loglevel parameter value, loglevel = " + logLevel;
                int rc = 400;
                res.sendError(rc, str);
                Trace.verbose((Object)((Object)this), (String)"doGet", (String)str);
            }
        }
        catch (Exception e) {
            Trace.verbose((Object)((Object)this), (String)"doGet", (String)"Failed to send http response for log level change");
            Trace.verbose((Object)((Object)this), (String)"doGet", (Throwable)e);
        }
    }
}

